// import 'package:flutter/material.dart';
// import 'dart:math';

// class PetalBeanShape extends StatelessWidget {
//   final double size;
//   final Color color;
//   final bool isStroked;
//   final Color? strokeColor;
//   final double strokeWidth;
//   final ImageProvider? image;
//   final BoxFit imageFit;
//   final Alignment imageAlignment;
//   final double imageScale;
//   final Color? overlayColor;
//   final Gradient? gradient;
//   final BoxShadow? shadow;
//   final VoidCallback? onTap;

//   const PetalBeanShape({
//     super.key,
//     required this.size,
//     required this.color,
//     this.isStroked = false,
//     this.strokeColor,
//     this.strokeWidth = 2.0,
//     this.image,
//     this.imageFit = BoxFit.cover,
//     this.imageAlignment = Alignment.center,
//     this.imageScale = 1.0,
//     this.overlayColor,
//     this.gradient,
//     this.shadow,
//     this.onTap,
//   });

//   @override
//   Widget build(BuildContext context) {
//     final shape = Stack(
//       alignment: Alignment.center,
//       children: [
//         if (shadow != null)
//           CustomPaint(
//             size: Size(size, size),
//             painter: _PetalBeanShadowPainter(shadow!),
//           ),
//         CustomPaint(
//           size: Size(size, size),
//           painter: _PetalBeanPainter(
//             color: color,
//             isStroked: isStroked,
//             strokeColor: strokeColor ?? Colors.black,
//             strokeWidth: strokeWidth,
//             gradient: gradient,
//           ),
//         ),
//         if (image != null)
//           ClipPath(
//             clipper: _PetalBeanClipper(),
//             child: Stack(
//               children: [
//                 Transform.scale(
//                   scale: imageScale,
//                   child: Image(
//                     image: image!,
//                     width: size,
//                     height: size,
//                     fit: imageFit,
//                     alignment: imageAlignment,
//                   ),
//                 ),
//                 if (overlayColor != null)
//                   Container(width: size, height: size, color: overlayColor),
//               ],
//             ),
//           ),
//       ],
//     );

//     return GestureDetector(
//       onTap: onTap,
//       child: SizedBox(width: size, height: size, child: shape),
//     );
//   }
// }

// class _PetalBeanPainter extends CustomPainter {
//   final Color color;
//   final bool isStroked;
//   final Color strokeColor;
//   final double strokeWidth;
//   final Gradient? gradient;

//   const _PetalBeanPainter({
//     required this.color,
//     required this.isStroked,
//     required this.strokeColor,
//     required this.strokeWidth,
//     this.gradient,
//   });

//   @override
//   void paint(Canvas canvas, Size size) {
//     final path = _buildPetalBeanPath(size);

//     final paint = Paint()
//       ..style = PaintingStyle.fill
//       ..color = color;

//     if (gradient != null) {
//       paint.shader = gradient!.createShader(
//         Rect.fromLTWH(0, 0, size.width, size.height),
//       );
//     }

//     canvas.drawPath(path, paint);

//     if (isStroked) {
//       final strokePaint = Paint()
//         ..style = PaintingStyle.stroke
//         ..color = strokeColor
//         ..strokeWidth = strokeWidth;
//       canvas.drawPath(path, strokePaint);
//     }
//   }

//   @override
//   bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
// }

// class _PetalBeanShadowPainter extends CustomPainter {
//   final BoxShadow shadow;

//   const _PetalBeanShadowPainter(this.shadow);

//   @override
//   void paint(Canvas canvas, Size size) {
//     final path = _buildPetalBeanPath(size);
//     final paint = shadow.toPaint();
//     canvas.drawPath(path.shift(shadow.offset), paint);
//   }

//   @override
//   bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
// }

// class _PetalBeanClipper extends CustomClipper<Path> {
//   @override
//   Path getClip(Size size) => _buildPetalBeanPath(size);

//   @override
//   bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
// }

// Path _buildPetalBeanPath(Size size) {
//   final path = Path();
//   path.moveTo(size.width * 0.43, size.height * 0.1);
//   path.cubicTo(
//     size.width * 0.51,
//     size.height * 0.04,
//     size.width * 0.62,
//     size.height * 0.04,
//     size.width * 0.7,
//     size.height * 0.1,
//   );
//   path.cubicTo(
//     size.width * 0.97,
//     size.height * 0.3,
//     size.width * 1.05,
//     size.height * 0.36,
//     size.width * 1.06,
//     size.height * 0.56,
//   );
//   path.cubicTo(
//     size.width * 0.95,
//     size.height * 0.89,
//     size.width * 0.92,
//     size.height, //this
//     size.width * 0.83,
//     size.height * 1.06,
//   );
//   path.cubicTo(
//     size.width * 0.4,
//     size.height * 1.06,
//     size.width * 0.3,
//     size.height * 1.06,
//     size.width / 5,
//     size.height, //this
//   );
//   path.cubicTo(
//     size.width * 0.18,
//     size.height * 0.89,
//     size.width * 0.08,
//     size.height * 0.56,
//     size.width * 0.08,
//     size.height * 0.56,
//   );
//   path.cubicTo(
//     size.width * 0.05,
//     size.height * 0.47,
//     size.width * 0.08,
//     size.height * 0.36,
//     size.width * 0.16,
//     size.height * 0.3,
//   );
//   path.cubicTo(
//     size.width * 0.43,
//     size.height * 0.1,
//     size.width * 0.43,
//     size.height * 0.1,
//     size.width * 0.43,
//     size.height * 0.1,
//   );
//   path.close();
//   return path;
// }

import 'dart:math';
import 'package:flutter/material.dart';

class RoundedCornerPentagonShape extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;
  final double cornerRadius;

  const RoundedCornerPentagonShape({
    super.key,
    required this.size,
    required this.color,
    this.cornerRadius = 24,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(size, size),
            painter: _PentagonShadowPainter(shadow!, cornerRadius),
          ),
        CustomPaint(
          size: Size(size, size),
          painter: _PentagonPainter(
            color: color,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
            gradient: gradient,
            cornerRadius: cornerRadius,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _PentagonClipper(cornerRadius),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: size,
                    height: size,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: size, height: size, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size, child: shape),
    );
  }
}

class _PentagonPainter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;
  final double cornerRadius;

  _PentagonPainter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
    required this.cornerRadius,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildRoundedPentagonPath(size, cornerRadius);

    final paint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      paint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, paint);

    if (isStroked) {
      final strokePaint = Paint()
        ..style = PaintingStyle.stroke
        ..color = strokeColor
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) => true;
}

class _PentagonShadowPainter extends CustomPainter {
  final BoxShadow shadow;
  final double cornerRadius;

  const _PentagonShadowPainter(this.shadow, this.cornerRadius);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildRoundedPentagonPath(size, cornerRadius);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}

class _PentagonClipper extends CustomClipper<Path> {
  final double cornerRadius;

  _PentagonClipper(this.cornerRadius);

  @override
  Path getClip(Size size) => _buildRoundedPentagonPath(size, cornerRadius);

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}

Path _buildRoundedPentagonPath(Size size, double cornerRadius) {
  final int sides = 5;
  final double angleStep = 2 * pi / sides;
  final double radius = size.width / 2;
  final Offset center = Offset(size.width / 2, size.height / 2);

  final List<Offset> points = List.generate(sides, (i) {
    final double angle = angleStep * i - pi / 2;
    return Offset(
      center.dx + radius * cos(angle),
      center.dy + radius * sin(angle),
    );
  });

  final path = Path();

  for (int i = 0; i < sides; i++) {
    final prev = points[(i - 1 + sides) % sides];
    final curr = points[i];
    final next = points[(i + 1) % sides];

    final Offset fromPrev = (curr - prev).normalize();
    final Offset toNext = (next - curr).normalize();

    final Offset start = curr - fromPrev * cornerRadius;
    final Offset end = curr + toNext * cornerRadius;

    if (i == 0) {
      path.moveTo(start.dx, start.dy);
    } else {
      path.lineTo(start.dx, start.dy);
    }

    path.quadraticBezierTo(curr.dx, curr.dy, end.dx, end.dy);
  }

  path.close();
  return path;
}

extension on Offset {
  Offset normalize() {
    final len = distance;
    return len == 0 ? this : this / len;
  }
}
