import 'package:flutter/material.dart';

class CustomShape6 extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const CustomShape6({
    super.key,
    required this.size,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(size, size),
            painter: _CustomShape6ShadowPainter(shadow!),
          ),
        CustomPaint(
          size: Size(size, size),
          painter: _CustomShape6Painter(
            color: color,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
            gradient: gradient,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _CustomShape6Clipper(),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: size,
                    height: size,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: size, height: size, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size, child: shape),
    );
  }
}

class _CustomShape6Painter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _CustomShape6Painter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildShape6Path(size);

    final paint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      paint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, paint);

    if (isStroked) {
      final strokePaint = Paint()
        ..color = strokeColor
        ..style = PaintingStyle.stroke
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
}

class _CustomShape6ShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _CustomShape6ShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildShape6Path(size);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}

class _CustomShape6Clipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) => _buildShape6Path(size);

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}

Path _buildShape6Path(Size size) {
  Path path = Path();

  path.moveTo(size.width * 0.48, size.height * 0.12);
  path.cubicTo(
    size.width * 0.53,
    size.height * 0.05,
    size.width * 0.62,
    size.height * 0.05,
    size.width * 0.67,
    size.height * 0.12,
  );
  path.cubicTo(
    size.width * 0.7,
    size.height * 0.15,
    size.width * 0.75,
    size.height * 0.17,
    size.width * 0.79,
    size.height * 0.16,
  );
  path.cubicTo(
    size.width * 0.87,
    size.height * 0.15,
    size.width * 0.95,
    size.height / 5,
    size.width * 0.95,
    size.height * 0.29,
  );
  path.cubicTo(
    size.width * 0.95,
    size.height * 0.34,
    size.width * 0.97,
    size.height * 0.38,
    size.width,
    size.height * 0.4,
  );
  path.cubicTo(
    size.width * 1.08,
    size.height * 0.44,
    size.width * 1.1,
    size.height * 0.54,
    size.width * 1.05,
    size.height * 0.6,
  );
  path.cubicTo(
    size.width * 1.02,
    size.height * 0.64,
    size.width,
    size.height * 0.68,
    size.width * 1.02,
    size.height * 0.73,
  );
  path.cubicTo(
    size.width * 1.05,
    size.height * 0.8,
    size.width,
    size.height * 0.89,
    size.width * 0.92,
    size.height * 0.9,
  );
  path.cubicTo(
    size.width * 0.88,
    size.height * 0.91,
    size.width * 0.84,
    size.height * 0.94,
    size.width * 0.83,
    size.height * 0.98,
  );
  path.cubicTo(
    size.width * 0.8,
    size.height * 1.06,
    size.width * 0.71,
    size.height * 1.09,
    size.width * 0.64,
    size.height * 1.05,
  );
  path.cubicTo(
    size.width * 0.6,
    size.height * 1.03,
    size.width * 0.55,
    size.height * 1.03,
    size.width * 0.51,
    size.height * 1.05,
  );
  path.cubicTo(
    size.width * 0.44,
    size.height * 1.09,
    size.width * 0.35,
    size.height * 1.06,
    size.width * 0.32,
    size.height * 0.98,
  );
  path.cubicTo(
    size.width * 0.31,
    size.height * 0.94,
    size.width * 0.27,
    size.height * 0.91,
    size.width * 0.23,
    size.height * 0.9,
  );
  path.cubicTo(
    size.width * 0.15,
    size.height * 0.89,
    size.width * 0.1,
    size.height * 0.8,
    size.width * 0.13,
    size.height * 0.73,
  );
  path.cubicTo(
    size.width * 0.14,
    size.height * 0.68,
    size.width * 0.13,
    size.height * 0.64,
    size.width * 0.1,
    size.height * 0.6,
  );
  path.cubicTo(
    size.width * 0.05,
    size.height * 0.54,
    size.width * 0.07,
    size.height * 0.44,
    size.width * 0.14,
    size.height * 0.4,
  );
  path.cubicTo(
    size.width * 0.18,
    size.height * 0.38,
    size.width / 5,
    size.height * 0.34,
    size.width / 5,
    size.height * 0.29,
  );
  path.cubicTo(
    size.width / 5,
    size.height / 5,
    size.width * 0.28,
    size.height * 0.15,
    size.width * 0.36,
    size.height * 0.16,
  );
  path.cubicTo(
    size.width * 0.4,
    size.height * 0.17,
    size.width * 0.45,
    size.height * 0.15,
    size.width * 0.48,
    size.height * 0.12,
  );
  path.close();

  return path;
}
