import 'package:flutter/material.dart';

class FourSidedCookieShape extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const FourSidedCookieShape({
    super.key,
    required this.size,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(size, size),
            painter: _FourSidedCookieShadowPainter(shadow!),
          ),
        CustomPaint(
          size: Size(size, size),
          painter: _FourSidedCookiePainter(
            color: color,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
            gradient: gradient,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _FourSidedCookieClipper(),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: size,
                    height: size,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: size, height: size, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size, child: shape),
    );
  }
}

class _FourSidedCookiePainter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _FourSidedCookiePainter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildFourSidedCookiePath(size);

    final paint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      paint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, paint);

    if (isStroked) {
      final strokePaint = Paint()
        ..style = PaintingStyle.stroke
        ..color = strokeColor
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
}

class _FourSidedCookieShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _FourSidedCookieShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildFourSidedCookiePath(size);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}

class _FourSidedCookieClipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) => _buildFourSidedCookiePath(size);

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}

Path _buildFourSidedCookiePath(Size size) {
  final path = Path();
  path.moveTo(size.width * 0.02, size.height * 0.34);
  path.cubicTo(
    -0.07,
    size.height * 0.14,
    size.width * 0.14,
    -0.07,
    size.width * 0.34,
    size.height * 0.02,
  );
  path.cubicTo(
    size.width * 0.4,
    size.height * 0.05,
    size.width * 0.47,
    size.height * 0.08,
    size.width * 0.54,
    size.height * 0.08,
  );
  path.cubicTo(
    size.width * 0.6,
    size.height * 0.05,
    size.width * 0.66,
    size.height * 0.02,
    size.width * 0.66,
    size.height * 0.02,
  );
  path.cubicTo(
    size.width * 0.86,
    -0.07,
    size.width * 1.07,
    size.height * 0.14,
    size.width * 0.98,
    size.height * 0.34,
  );
  path.cubicTo(
    size.width * 0.95,
    size.height * 0.4,
    size.width * 0.92,
    size.height * 0.47,
    size.width * 0.92,
    size.height * 0.54,
  );
  path.cubicTo(
    size.width * 0.95,
    size.height * 0.6,
    size.width * 0.98,
    size.height * 0.66,
    size.width * 0.98,
    size.height * 0.66,
  );
  path.cubicTo(
    size.width * 1.07,
    size.height * 0.86,
    size.width * 0.86,
    size.height * 1.07,
    size.width * 0.66,
    size.height * 0.98,
  );
  path.cubicTo(
    size.width * 0.6,
    size.height * 0.95,
    size.width * 0.54,
    size.height * 0.92,
    size.width * 0.47,
    size.height * 0.92,
  );
  path.cubicTo(
    size.width * 0.4,
    size.height * 0.95,
    size.width * 0.34,
    size.height * 0.98,
    size.width * 0.34,
    size.height * 0.98,
  );
  path.cubicTo(
    size.width * 0.14,
    size.height * 1.07,
    -0.07,
    size.height * 0.86,
    size.width * 0.02,
    size.height * 0.66,
  );
  path.cubicTo(
    size.width * 0.05,
    size.height * 0.6,
    size.width * 0.08,
    size.height * 0.54,
    size.width * 0.08,
    size.height * 0.47,
  );
  path.cubicTo(
    size.width * 0.05,
    size.height * 0.4,
    size.width * 0.02,
    size.height * 0.34,
    size.width * 0.02,
    size.height * 0.34,
  );
  path.close();
  return path;
}
