import 'package:flutter/material.dart';

class CustomShape3 extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const CustomShape3({
    super.key,
    required this.size,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(size, size),
            painter: _CustomShape3ShadowPainter(shadow!),
          ),
        CustomPaint(
          size: Size(size, size),
          painter: _CustomShape3Painter(
            color: color,
            gradient: gradient,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _CustomShape3Clipper(),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: size,
                    height: size,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: size, height: size, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size, child: shape),
    );
  }
}

class _CustomShape3Painter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _CustomShape3Painter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildCustomShape3Path(size);
    final fillPaint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      fillPaint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, fillPaint);

    if (isStroked) {
      final strokePaint = Paint()
        ..color = strokeColor
        ..style = PaintingStyle.stroke
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
}

class _CustomShape3ShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _CustomShape3ShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildCustomShape3Path(size);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}

class _CustomShape3Clipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) => _buildCustomShape3Path(size);

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}

Path _buildCustomShape3Path(Size size) {
  Path path = Path();

  path.moveTo(size.width * 0.61, 0);
  path.cubicTo(
    size.width * 0.71,
    0,
    size.width * 0.8,
    size.height * 0.07,
    size.width * 0.83,
    size.height * 0.16,
  );
  path.cubicTo(
    size.width * 0.93,
    size.height * 0.18,
    size.width,
    size.height * 0.27,
    size.width,
    size.height * 0.38,
  );
  path.cubicTo(
    size.width,
    size.height * 0.42,
    size.width,
    size.height * 0.47,
    size.width * 0.96,
    size.height / 2,
  );
  path.cubicTo(
    size.width,
    size.height * 0.54,
    size.width,
    size.height * 0.58,
    size.width,
    size.height * 0.62,
  );
  path.cubicTo(
    size.width,
    size.height * 0.73,
    size.width * 0.93,
    size.height * 0.82,
    size.width * 0.83,
    size.height * 0.84,
  );
  path.cubicTo(
    size.width * 0.8,
    size.height * 0.93,
    size.width * 0.71,
    size.height,
    size.width * 0.61,
    size.height,
  );
  path.cubicTo(
    size.width * 0.57,
    size.height,
    size.width * 0.53,
    size.height,
    size.width / 2,
    size.height * 0.98,
  );
  path.cubicTo(
    size.width * 0.47,
    size.height,
    size.width * 0.43,
    size.height,
    size.width * 0.39,
    size.height,
  );
  path.cubicTo(
    size.width * 0.29,
    size.height,
    size.width / 5,
    size.height * 0.93,
    size.width * 0.17,
    size.height * 0.84,
  );
  path.cubicTo(
    size.width * 0.07,
    size.height * 0.82,
    0,
    size.height * 0.73,
    0,
    size.height * 0.62,
  );
  path.cubicTo(
    0,
    size.height * 0.58,
    size.width * 0.01,
    size.height * 0.54,
    size.width * 0.04,
    size.height / 2,
  );
  path.cubicTo(
    size.width * 0.01,
    size.height * 0.47,
    0,
    size.height * 0.42,
    0,
    size.height * 0.38,
  );
  path.cubicTo(
    0,
    size.height * 0.27,
    size.width * 0.07,
    size.height * 0.18,
    size.width * 0.17,
    size.height * 0.16,
  );
  path.cubicTo(
    size.width / 5,
    size.height * 0.07,
    size.width * 0.29,
    0,
    size.width * 0.39,
    0,
  );
  path.cubicTo(
    size.width * 0.43,
    0,
    size.width * 0.47,
    size.height * 0.01,
    size.width / 2,
    size.height * 0.02,
  );
  path.cubicTo(
    size.width * 0.53,
    size.height * 0.01,
    size.width * 0.57,
    0,
    size.width * 0.61,
    0,
  );
  path.close();

  return path;
}
