import 'package:flutter/material.dart';

class CustomShape2 extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const CustomShape2({
    super.key,
    required this.size,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(size, size),
            painter: _CustomShape2ShadowPainter(shadow!),
          ),
        CustomPaint(
          size: Size(size, size),
          painter: _CustomShape2Painter(
            color: color,
            gradient: gradient,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _CustomShape2Clipper(),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: size,
                    height: size,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: size, height: size, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size, child: shape),
    );
  }
}

class _CustomShape2Painter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _CustomShape2Painter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildCustomShape2Path(size);
    final fillPaint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      fillPaint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, fillPaint);

    if (isStroked) {
      final strokePaint = Paint()
        ..color = strokeColor
        ..style = PaintingStyle.stroke
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
}

class _CustomShape2ShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _CustomShape2ShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildCustomShape2Path(size);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}

class _CustomShape2Clipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) => _buildCustomShape2Path(size);

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}

Path _buildCustomShape2Path(Size size) {
  Path path = Path();

  path.moveTo(size.width / 2, 0);
  path.cubicTo(
    size.width / 2,
    0,
    size.width * 0.6,
    size.height * 0.13,
    size.width * 0.6,
    size.height * 0.13,
  );
  path.cubicTo(
    size.width * 0.6,
    size.height * 0.13,
    size.width * 0.75,
    size.height * 0.07,
    size.width * 0.75,
    size.height * 0.07,
  );
  path.cubicTo(
    size.width * 0.75,
    size.height * 0.07,
    size.width * 0.77,
    size.height * 0.23,
    size.width * 0.77,
    size.height * 0.23,
  );
  path.cubicTo(
    size.width * 0.77,
    size.height * 0.23,
    size.width * 0.93,
    size.height / 4,
    size.width * 0.93,
    size.height / 4,
  );
  path.cubicTo(
    size.width * 0.93,
    size.height / 4,
    size.width * 0.87,
    size.height * 0.4,
    size.width * 0.87,
    size.height * 0.4,
  );
  path.cubicTo(
    size.width * 0.87,
    size.height * 0.4,
    size.width,
    size.height / 2,
    size.width,
    size.height / 2,
  );
  path.cubicTo(
    size.width,
    size.height / 2,
    size.width * 0.87,
    size.height * 0.6,
    size.width * 0.87,
    size.height * 0.6,
  );
  path.cubicTo(
    size.width * 0.87,
    size.height * 0.6,
    size.width * 0.93,
    size.height * 0.75,
    size.width * 0.93,
    size.height * 0.75,
  );
  path.cubicTo(
    size.width * 0.93,
    size.height * 0.75,
    size.width * 0.77,
    size.height * 0.77,
    size.width * 0.77,
    size.height * 0.77,
  );
  path.cubicTo(
    size.width * 0.77,
    size.height * 0.77,
    size.width * 0.75,
    size.height * 0.93,
    size.width * 0.75,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width * 0.75,
    size.height * 0.93,
    size.width * 0.6,
    size.height * 0.87,
    size.width * 0.6,
    size.height * 0.87,
  );
  path.cubicTo(
    size.width * 0.6,
    size.height * 0.87,
    size.width / 2,
    size.height,
    size.width / 2,
    size.height,
  );
  path.cubicTo(
    size.width / 2,
    size.height,
    size.width * 0.4,
    size.height * 0.87,
    size.width * 0.4,
    size.height * 0.87,
  );
  path.cubicTo(
    size.width * 0.4,
    size.height * 0.87,
    size.width / 4,
    size.height * 0.93,
    size.width / 4,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width / 4,
    size.height * 0.93,
    size.width * 0.23,
    size.height * 0.77,
    size.width * 0.23,
    size.height * 0.77,
  );
  path.cubicTo(
    size.width * 0.23,
    size.height * 0.77,
    size.width * 0.07,
    size.height * 0.75,
    size.width * 0.07,
    size.height * 0.75,
  );
  path.cubicTo(
    size.width * 0.07,
    size.height * 0.75,
    size.width * 0.13,
    size.height * 0.6,
    size.width * 0.13,
    size.height * 0.6,
  );
  path.cubicTo(
    size.width * 0.13,
    size.height * 0.6,
    0,
    size.height / 2,
    0,
    size.height / 2,
  );
  path.cubicTo(
    0,
    size.height / 2,
    size.width * 0.13,
    size.height * 0.4,
    size.width * 0.13,
    size.height * 0.4,
  );
  path.cubicTo(
    size.width * 0.13,
    size.height * 0.4,
    size.width * 0.07,
    size.height / 4,
    size.width * 0.07,
    size.height / 4,
  );
  path.cubicTo(
    size.width * 0.07,
    size.height / 4,
    size.width * 0.23,
    size.height * 0.23,
    size.width * 0.23,
    size.height * 0.23,
  );
  path.cubicTo(
    size.width * 0.23,
    size.height * 0.23,
    size.width / 4,
    size.height * 0.07,
    size.width / 4,
    size.height * 0.07,
  );
  path.cubicTo(
    size.width / 4,
    size.height * 0.07,
    size.width * 0.4,
    size.height * 0.13,
    size.width * 0.4,
    size.height * 0.13,
  );
  path.cubicTo(
    size.width * 0.4,
    size.height * 0.13,
    size.width / 2,
    0,
    size.width / 2,
    0,
  );
  path.close();

  return path;
}
