import 'package:flutter/material.dart';
import 'package:material_shapes/material_shapes.dart';

void main() {
  runApp(MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(home: HomeScreen());
  }
}

class HomeScreen extends StatelessWidget {
  HomeScreen({super.key});

  List<Widget> materialShapesView = [
    MaterialShapes.arrow(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.arch(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.bloom(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.bun(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.burst(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.circle(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.clampShell(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.diamond(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.eightLeafClover(
      size: 100,
      color: Colors.blue,
      isStroked: true,
    ),
    MaterialShapes.fan(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.flower(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.fourLeafClover(
      size: 100,
      color: Colors.blue,
      isStroked: true,
    ),
    // MaterialShapes.fourSidedCookie(
    //   size: 100,
    //   color: Colors.blue,
    //   isStroked: true,
    // ),
    MaterialShapes.gem(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.ghostish(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.heart(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.nineSidedCookie(
      size: 100,
      color: Colors.blue,
      isStroked: true,
    ),
    MaterialShapes.oval(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.pentagon(size: 100, color: Colors.blue, isStroked: true),

    MaterialShapes.pill(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.pixelCircle(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.pixelTriangle(
      size: 100,
      color: Colors.blue,
      isStroked: true,
    ),
    MaterialShapes.puffy(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.puffyDiamond(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.semicircle(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.sevenSidedCookie(
      size: 100,
      color: Colors.blue,
      isStroked: true,
    ),
    MaterialShapes.sixSidedCookie(
      size: 100,
      color: Colors.blue,
      isStroked: true,
    ),
    MaterialShapes.slanted(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.softBloom(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.softBurst(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.square(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.sunny(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.triangle(size: 100, color: Colors.blue, isStroked: true),
    MaterialShapes.twelveSidedCookie(
      size: 100,
      color: Colors.blue,
      isStroked: true,
    ),
    MaterialShapes.verySunny(size: 100, color: Colors.blue, isStroked: true),
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: GridView.builder(
        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 5,
        ),
        itemBuilder: (a, b) {
          return SizedBox.square(child: materialShapesView[b], dimension: 100);
        },
        itemCount: materialShapesView.length,
      ),
    );
  }
}
