// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'W'.
class PartW {
  /// Applies the Waiting for the Sunrise font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Waiting+for+the+Sunrise
  static TextStyle waitingForTheSunrise({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6deb7c8add2991efb92b567a02210a32276681a0b5096332e10db1c2ce94a82',
        41060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WaitingfortheSunrise',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Waiting for the Sunrise font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Waiting+for+the+Sunrise
  static TextTheme waitingForTheSunriseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: waitingForTheSunrise(textStyle: textTheme.displayLarge),
      displayMedium: waitingForTheSunrise(textStyle: textTheme.displayMedium),
      displaySmall: waitingForTheSunrise(textStyle: textTheme.displaySmall),
      headlineLarge: waitingForTheSunrise(textStyle: textTheme.headlineLarge),
      headlineMedium: waitingForTheSunrise(textStyle: textTheme.headlineMedium),
      headlineSmall: waitingForTheSunrise(textStyle: textTheme.headlineSmall),
      titleLarge: waitingForTheSunrise(textStyle: textTheme.titleLarge),
      titleMedium: waitingForTheSunrise(textStyle: textTheme.titleMedium),
      titleSmall: waitingForTheSunrise(textStyle: textTheme.titleSmall),
      bodyLarge: waitingForTheSunrise(textStyle: textTheme.bodyLarge),
      bodyMedium: waitingForTheSunrise(textStyle: textTheme.bodyMedium),
      bodySmall: waitingForTheSunrise(textStyle: textTheme.bodySmall),
      labelLarge: waitingForTheSunrise(textStyle: textTheme.labelLarge),
      labelMedium: waitingForTheSunrise(textStyle: textTheme.labelMedium),
      labelSmall: waitingForTheSunrise(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wallpoet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wallpoet
  static TextStyle wallpoet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1176ac005f40018b7e49da74c93a4edfc69b9c18b4b835313ea101cc15b59885',
        20836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Wallpoet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wallpoet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wallpoet
  static TextTheme wallpoetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wallpoet(textStyle: textTheme.displayLarge),
      displayMedium: wallpoet(textStyle: textTheme.displayMedium),
      displaySmall: wallpoet(textStyle: textTheme.displaySmall),
      headlineLarge: wallpoet(textStyle: textTheme.headlineLarge),
      headlineMedium: wallpoet(textStyle: textTheme.headlineMedium),
      headlineSmall: wallpoet(textStyle: textTheme.headlineSmall),
      titleLarge: wallpoet(textStyle: textTheme.titleLarge),
      titleMedium: wallpoet(textStyle: textTheme.titleMedium),
      titleSmall: wallpoet(textStyle: textTheme.titleSmall),
      bodyLarge: wallpoet(textStyle: textTheme.bodyLarge),
      bodyMedium: wallpoet(textStyle: textTheme.bodyMedium),
      bodySmall: wallpoet(textStyle: textTheme.bodySmall),
      labelLarge: wallpoet(textStyle: textTheme.labelLarge),
      labelMedium: wallpoet(textStyle: textTheme.labelMedium),
      labelSmall: wallpoet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Walter Turncoat font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Walter+Turncoat
  static TextStyle walterTurncoat({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f994e4cc7bcc900c5e0b1451e3b7bce6a7e58f0e8ed10f5938e8916a42608acd',
        151768,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WalterTurncoat',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Walter Turncoat font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Walter+Turncoat
  static TextTheme walterTurncoatTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: walterTurncoat(textStyle: textTheme.displayLarge),
      displayMedium: walterTurncoat(textStyle: textTheme.displayMedium),
      displaySmall: walterTurncoat(textStyle: textTheme.displaySmall),
      headlineLarge: walterTurncoat(textStyle: textTheme.headlineLarge),
      headlineMedium: walterTurncoat(textStyle: textTheme.headlineMedium),
      headlineSmall: walterTurncoat(textStyle: textTheme.headlineSmall),
      titleLarge: walterTurncoat(textStyle: textTheme.titleLarge),
      titleMedium: walterTurncoat(textStyle: textTheme.titleMedium),
      titleSmall: walterTurncoat(textStyle: textTheme.titleSmall),
      bodyLarge: walterTurncoat(textStyle: textTheme.bodyLarge),
      bodyMedium: walterTurncoat(textStyle: textTheme.bodyMedium),
      bodySmall: walterTurncoat(textStyle: textTheme.bodySmall),
      labelLarge: walterTurncoat(textStyle: textTheme.labelLarge),
      labelMedium: walterTurncoat(textStyle: textTheme.labelMedium),
      labelSmall: walterTurncoat(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Warnes font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Warnes
  static TextStyle warnes({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1e2b0440a70a23a81be9d81f13b64884876d3fd72a6225e58480e49e0e79129',
        45216,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Warnes',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Warnes font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Warnes
  static TextTheme warnesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: warnes(textStyle: textTheme.displayLarge),
      displayMedium: warnes(textStyle: textTheme.displayMedium),
      displaySmall: warnes(textStyle: textTheme.displaySmall),
      headlineLarge: warnes(textStyle: textTheme.headlineLarge),
      headlineMedium: warnes(textStyle: textTheme.headlineMedium),
      headlineSmall: warnes(textStyle: textTheme.headlineSmall),
      titleLarge: warnes(textStyle: textTheme.titleLarge),
      titleMedium: warnes(textStyle: textTheme.titleMedium),
      titleSmall: warnes(textStyle: textTheme.titleSmall),
      bodyLarge: warnes(textStyle: textTheme.bodyLarge),
      bodyMedium: warnes(textStyle: textTheme.bodyMedium),
      bodySmall: warnes(textStyle: textTheme.bodySmall),
      labelLarge: warnes(textStyle: textTheme.labelLarge),
      labelMedium: warnes(textStyle: textTheme.labelMedium),
      labelSmall: warnes(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Water Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Water+Brush
  static TextStyle waterBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '549c589ffe4dc4065a20d92cea7f7ceffe11c630f4f469aee96ad97cee0fc07f',
        237016,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WaterBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Water Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Water+Brush
  static TextTheme waterBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: waterBrush(textStyle: textTheme.displayLarge),
      displayMedium: waterBrush(textStyle: textTheme.displayMedium),
      displaySmall: waterBrush(textStyle: textTheme.displaySmall),
      headlineLarge: waterBrush(textStyle: textTheme.headlineLarge),
      headlineMedium: waterBrush(textStyle: textTheme.headlineMedium),
      headlineSmall: waterBrush(textStyle: textTheme.headlineSmall),
      titleLarge: waterBrush(textStyle: textTheme.titleLarge),
      titleMedium: waterBrush(textStyle: textTheme.titleMedium),
      titleSmall: waterBrush(textStyle: textTheme.titleSmall),
      bodyLarge: waterBrush(textStyle: textTheme.bodyLarge),
      bodyMedium: waterBrush(textStyle: textTheme.bodyMedium),
      bodySmall: waterBrush(textStyle: textTheme.bodySmall),
      labelLarge: waterBrush(textStyle: textTheme.labelLarge),
      labelMedium: waterBrush(textStyle: textTheme.labelMedium),
      labelSmall: waterBrush(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Waterfall font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Waterfall
  static TextStyle waterfall({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4795938e9619ba759a9f32f5d941d652732c7cc848ca6128159a0ae84619107b',
        138024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Waterfall',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Waterfall font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Waterfall
  static TextTheme waterfallTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: waterfall(textStyle: textTheme.displayLarge),
      displayMedium: waterfall(textStyle: textTheme.displayMedium),
      displaySmall: waterfall(textStyle: textTheme.displaySmall),
      headlineLarge: waterfall(textStyle: textTheme.headlineLarge),
      headlineMedium: waterfall(textStyle: textTheme.headlineMedium),
      headlineSmall: waterfall(textStyle: textTheme.headlineSmall),
      titleLarge: waterfall(textStyle: textTheme.titleLarge),
      titleMedium: waterfall(textStyle: textTheme.titleMedium),
      titleSmall: waterfall(textStyle: textTheme.titleSmall),
      bodyLarge: waterfall(textStyle: textTheme.bodyLarge),
      bodyMedium: waterfall(textStyle: textTheme.bodyMedium),
      bodySmall: waterfall(textStyle: textTheme.bodySmall),
      labelLarge: waterfall(textStyle: textTheme.labelLarge),
      labelMedium: waterfall(textStyle: textTheme.labelMedium),
      labelSmall: waterfall(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wavefont font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wavefont
  static TextStyle wavefont({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd120465f3799254a0b328cba565b7f2abee0be5a61e119b7b4353aab34919ae5',
        30080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c5d2f43401f9c58ee6bb2c24e5c7b8a766d9261240a188400a3dcf6d65d752b',
        30384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f33f1746c2afae4d5ce92f8189bef29deffac84c688f8e0c32df6aa21fb9fcb3',
        30516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e4293f332f83f117a5ee096471e76305e1b285d8e11e02de18d8ae58dc1bf9e',
        30756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '585e0d23afcabb8e99cd4bddccb43f809556635465bc7c8ecd8d32d201f8510c',
        30956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '613637c67d3ee6fca30eef8eb0fb532dc52bc82e6a507cd339798bb25eb9ec25',
        31236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a888d6e23718dd9bfe003ce01d715e3c6817cf533bc262f362336d9aeb8ed5f',
        31340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2661f50e8b552ab5ef94a8363b2563432b5796cce6e7c0d8514a4dc7eb2d82e',
        31672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '084214a45acee35f7d0288f57e83f347d721952f08724e87fbb5b86b1b152936',
        31832,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Wavefont',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wavefont font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wavefont
  static TextTheme wavefontTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wavefont(textStyle: textTheme.displayLarge),
      displayMedium: wavefont(textStyle: textTheme.displayMedium),
      displaySmall: wavefont(textStyle: textTheme.displaySmall),
      headlineLarge: wavefont(textStyle: textTheme.headlineLarge),
      headlineMedium: wavefont(textStyle: textTheme.headlineMedium),
      headlineSmall: wavefont(textStyle: textTheme.headlineSmall),
      titleLarge: wavefont(textStyle: textTheme.titleLarge),
      titleMedium: wavefont(textStyle: textTheme.titleMedium),
      titleSmall: wavefont(textStyle: textTheme.titleSmall),
      bodyLarge: wavefont(textStyle: textTheme.bodyLarge),
      bodyMedium: wavefont(textStyle: textTheme.bodyMedium),
      bodySmall: wavefont(textStyle: textTheme.bodySmall),
      labelLarge: wavefont(textStyle: textTheme.labelLarge),
      labelMedium: wavefont(textStyle: textTheme.labelMedium),
      labelSmall: wavefont(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wellfleet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wellfleet
  static TextStyle wellfleet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f946bb26765cf986cbeb53e945fe051c63bb44ba8b1f3cbfab4e0e85f0f1e2d3',
        77544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Wellfleet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wellfleet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wellfleet
  static TextTheme wellfleetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wellfleet(textStyle: textTheme.displayLarge),
      displayMedium: wellfleet(textStyle: textTheme.displayMedium),
      displaySmall: wellfleet(textStyle: textTheme.displaySmall),
      headlineLarge: wellfleet(textStyle: textTheme.headlineLarge),
      headlineMedium: wellfleet(textStyle: textTheme.headlineMedium),
      headlineSmall: wellfleet(textStyle: textTheme.headlineSmall),
      titleLarge: wellfleet(textStyle: textTheme.titleLarge),
      titleMedium: wellfleet(textStyle: textTheme.titleMedium),
      titleSmall: wellfleet(textStyle: textTheme.titleSmall),
      bodyLarge: wellfleet(textStyle: textTheme.bodyLarge),
      bodyMedium: wellfleet(textStyle: textTheme.bodyMedium),
      bodySmall: wellfleet(textStyle: textTheme.bodySmall),
      labelLarge: wellfleet(textStyle: textTheme.labelLarge),
      labelMedium: wellfleet(textStyle: textTheme.labelMedium),
      labelSmall: wellfleet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wendy One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wendy+One
  static TextStyle wendyOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8060a04d16597d47480194de94a665dc025abbd8dbf8eb82280b474884d7259a',
        21064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WendyOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wendy One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wendy+One
  static TextTheme wendyOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wendyOne(textStyle: textTheme.displayLarge),
      displayMedium: wendyOne(textStyle: textTheme.displayMedium),
      displaySmall: wendyOne(textStyle: textTheme.displaySmall),
      headlineLarge: wendyOne(textStyle: textTheme.headlineLarge),
      headlineMedium: wendyOne(textStyle: textTheme.headlineMedium),
      headlineSmall: wendyOne(textStyle: textTheme.headlineSmall),
      titleLarge: wendyOne(textStyle: textTheme.titleLarge),
      titleMedium: wendyOne(textStyle: textTheme.titleMedium),
      titleSmall: wendyOne(textStyle: textTheme.titleSmall),
      bodyLarge: wendyOne(textStyle: textTheme.bodyLarge),
      bodyMedium: wendyOne(textStyle: textTheme.bodyMedium),
      bodySmall: wendyOne(textStyle: textTheme.bodySmall),
      labelLarge: wendyOne(textStyle: textTheme.labelLarge),
      labelMedium: wendyOne(textStyle: textTheme.labelMedium),
      labelSmall: wendyOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Whisper font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Whisper
  static TextStyle whisper({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6189f3f04a5104117c97b107afc997747f520f90b8cc526ff7203713954e7b09',
        85764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Whisper',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Whisper font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Whisper
  static TextTheme whisperTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: whisper(textStyle: textTheme.displayLarge),
      displayMedium: whisper(textStyle: textTheme.displayMedium),
      displaySmall: whisper(textStyle: textTheme.displaySmall),
      headlineLarge: whisper(textStyle: textTheme.headlineLarge),
      headlineMedium: whisper(textStyle: textTheme.headlineMedium),
      headlineSmall: whisper(textStyle: textTheme.headlineSmall),
      titleLarge: whisper(textStyle: textTheme.titleLarge),
      titleMedium: whisper(textStyle: textTheme.titleMedium),
      titleSmall: whisper(textStyle: textTheme.titleSmall),
      bodyLarge: whisper(textStyle: textTheme.bodyLarge),
      bodyMedium: whisper(textStyle: textTheme.bodyMedium),
      bodySmall: whisper(textStyle: textTheme.bodySmall),
      labelLarge: whisper(textStyle: textTheme.labelLarge),
      labelMedium: whisper(textStyle: textTheme.labelMedium),
      labelSmall: whisper(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the WindSong font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/WindSong
  static TextStyle windSong({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdda975ccb09915cb2f76bdb7fdb3c360c84bda543041149cf77bc8130b0ad70',
        102256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b1b28c604ffda10da35548449eb24d78def6927efe58e279e9b8b835a9d1a74',
        109364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WindSong',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the WindSong font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/WindSong
  static TextTheme windSongTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: windSong(textStyle: textTheme.displayLarge),
      displayMedium: windSong(textStyle: textTheme.displayMedium),
      displaySmall: windSong(textStyle: textTheme.displaySmall),
      headlineLarge: windSong(textStyle: textTheme.headlineLarge),
      headlineMedium: windSong(textStyle: textTheme.headlineMedium),
      headlineSmall: windSong(textStyle: textTheme.headlineSmall),
      titleLarge: windSong(textStyle: textTheme.titleLarge),
      titleMedium: windSong(textStyle: textTheme.titleMedium),
      titleSmall: windSong(textStyle: textTheme.titleSmall),
      bodyLarge: windSong(textStyle: textTheme.bodyLarge),
      bodyMedium: windSong(textStyle: textTheme.bodyMedium),
      bodySmall: windSong(textStyle: textTheme.bodySmall),
      labelLarge: windSong(textStyle: textTheme.labelLarge),
      labelMedium: windSong(textStyle: textTheme.labelMedium),
      labelSmall: windSong(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wire One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wire+One
  static TextStyle wireOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e5ae3f6da3031a2c4c124c9a743d75a08b3dfccb4aaca3e57793927efc448dde',
        31832,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WireOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wire One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wire+One
  static TextTheme wireOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wireOne(textStyle: textTheme.displayLarge),
      displayMedium: wireOne(textStyle: textTheme.displayMedium),
      displaySmall: wireOne(textStyle: textTheme.displaySmall),
      headlineLarge: wireOne(textStyle: textTheme.headlineLarge),
      headlineMedium: wireOne(textStyle: textTheme.headlineMedium),
      headlineSmall: wireOne(textStyle: textTheme.headlineSmall),
      titleLarge: wireOne(textStyle: textTheme.titleLarge),
      titleMedium: wireOne(textStyle: textTheme.titleMedium),
      titleSmall: wireOne(textStyle: textTheme.titleSmall),
      bodyLarge: wireOne(textStyle: textTheme.bodyLarge),
      bodyMedium: wireOne(textStyle: textTheme.bodyMedium),
      bodySmall: wireOne(textStyle: textTheme.bodySmall),
      labelLarge: wireOne(textStyle: textTheme.labelLarge),
      labelMedium: wireOne(textStyle: textTheme.labelMedium),
      labelSmall: wireOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wittgenstein font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wittgenstein
  static TextStyle wittgenstein({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e809181bda250bddf271f7555cacc57f437e7644b48b0d975587952a5d70ee0',
        68196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd449db2cf9ee537944146ed2755bcda8a8b8a688026839e80fab2c1550c25a3c',
        68384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23a1bdeeffde6bd9cf519c2746728d530a161d3faa314929ab14c069e625c7cb',
        68368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea85b308046bd65b0d7ca6f976a862e749d9dcb7b46a6782d5a58bc191767739',
        68296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3436a7ea7704850e0dd477f204425e227fefbdb811d75800ca877e4da9fcd01',
        68344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ac645c23d410e97b8500e4b431bff288c38c4a7f26f97edda922f259ad94d0d',
        68024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd336202665297bbcd04dc55547aaceda72ef7ddd786cfe24d105ab47f1fd82e9',
        61436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0a5d264f1d1d6e8b800d5f50b142ef98e92944a2633519d395b8ee82f900f592',
        61692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c9f9ac7c497db3a5205ed350ba460135cfac7f20467eff826b8f54e800681f3b',
        61672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3af0d3f356a515be037f48cc4474a9f55d6fc6f02b4e2f7771f651174290e77c',
        61540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cc2a9615e6652c241ebcb261b6f2b0f26bce5c2bc7df4c1e538ddb751e7e0d2b',
        61660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '70f6ae9854685b5e10aa2e9e41e6ac9fb5e2987cf0e3a86b67ebedca1ce3c602',
        61536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Wittgenstein',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wittgenstein font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wittgenstein
  static TextTheme wittgensteinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wittgenstein(textStyle: textTheme.displayLarge),
      displayMedium: wittgenstein(textStyle: textTheme.displayMedium),
      displaySmall: wittgenstein(textStyle: textTheme.displaySmall),
      headlineLarge: wittgenstein(textStyle: textTheme.headlineLarge),
      headlineMedium: wittgenstein(textStyle: textTheme.headlineMedium),
      headlineSmall: wittgenstein(textStyle: textTheme.headlineSmall),
      titleLarge: wittgenstein(textStyle: textTheme.titleLarge),
      titleMedium: wittgenstein(textStyle: textTheme.titleMedium),
      titleSmall: wittgenstein(textStyle: textTheme.titleSmall),
      bodyLarge: wittgenstein(textStyle: textTheme.bodyLarge),
      bodyMedium: wittgenstein(textStyle: textTheme.bodyMedium),
      bodySmall: wittgenstein(textStyle: textTheme.bodySmall),
      labelLarge: wittgenstein(textStyle: textTheme.labelLarge),
      labelMedium: wittgenstein(textStyle: textTheme.labelMedium),
      labelSmall: wittgenstein(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wix Madefor Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wix+Madefor+Display
  static TextStyle wixMadeforDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c94be2684a65ca858233f7cfd85c2e80891217de98e9817401994dab034898e',
        83700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d56936c7ef90d585f49369f61435ce708a6cd35f62629e34abfe52e4c7340d9',
        83812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45d3f65407e7b154b1d72a747fe5e97a396d4e7c1075ade899b3fad7593437b9',
        83808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f4ec63c7579c0b9ff13a212b8a7ab02b2c5a3d229e396d97990d920991714ed',
        83756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '58d8d6ca939736eb2a1e64cf8b8efe7dc5a9c16060d7d3fe33cc454b481ed93c',
        83840,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WixMadeforDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wix Madefor Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wix+Madefor+Display
  static TextTheme wixMadeforDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wixMadeforDisplay(textStyle: textTheme.displayLarge),
      displayMedium: wixMadeforDisplay(textStyle: textTheme.displayMedium),
      displaySmall: wixMadeforDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: wixMadeforDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: wixMadeforDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: wixMadeforDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: wixMadeforDisplay(textStyle: textTheme.titleLarge),
      titleMedium: wixMadeforDisplay(textStyle: textTheme.titleMedium),
      titleSmall: wixMadeforDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: wixMadeforDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: wixMadeforDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: wixMadeforDisplay(textStyle: textTheme.bodySmall),
      labelLarge: wixMadeforDisplay(textStyle: textTheme.labelLarge),
      labelMedium: wixMadeforDisplay(textStyle: textTheme.labelMedium),
      labelSmall: wixMadeforDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wix Madefor Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wix+Madefor+Text
  static TextStyle wixMadeforText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e726d247085080a8560b48a2ac49b2a5fa2127fee27f210116bdfa2bff463386',
        79648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '87f89879a15cc3efedb65629cd5f068e76b2608d89c65d69b3ee97d63406b156',
        45304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ebbb040a157f9b1196d0f675785dc91e1872b59128bb2459d38ed3d5b56f0b4',
        80372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0c7348146f9eb5b7c04bb197f6aedc6c5f9502791c702b663bf438a30a793eae',
        46932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eadde558928822ccfdea82c4d1445499b4b89287d0875917a9db62e967d769d5',
        80452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8ff7f40fb2fd1752cf39af66cd91bef597ff0a7d3de69ce6ee695acecfee790e',
        46948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '642aee75e0a9a2b97d9f9a480c6491ee9179beb2409936cda031c9cbc1661bd4',
        80416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4ea0e531a0f316e3af6dd8a6cbe7a98f28410a1d16a3c8c1e08502252c4e1924',
        46448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f1218069e7b676a2fe5ff758b46225e502f2aa2b28bf1c54ced8744a488053d',
        80300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '27f53d4997685680b7c1919e0d2e9e79d8a778ee7a7ebb8b7616b6e6dd4f59bb',
        46364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WixMadeforText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wix Madefor Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wix+Madefor+Text
  static TextTheme wixMadeforTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wixMadeforText(textStyle: textTheme.displayLarge),
      displayMedium: wixMadeforText(textStyle: textTheme.displayMedium),
      displaySmall: wixMadeforText(textStyle: textTheme.displaySmall),
      headlineLarge: wixMadeforText(textStyle: textTheme.headlineLarge),
      headlineMedium: wixMadeforText(textStyle: textTheme.headlineMedium),
      headlineSmall: wixMadeforText(textStyle: textTheme.headlineSmall),
      titleLarge: wixMadeforText(textStyle: textTheme.titleLarge),
      titleMedium: wixMadeforText(textStyle: textTheme.titleMedium),
      titleSmall: wixMadeforText(textStyle: textTheme.titleSmall),
      bodyLarge: wixMadeforText(textStyle: textTheme.bodyLarge),
      bodyMedium: wixMadeforText(textStyle: textTheme.bodyMedium),
      bodySmall: wixMadeforText(textStyle: textTheme.bodySmall),
      labelLarge: wixMadeforText(textStyle: textTheme.labelLarge),
      labelMedium: wixMadeforText(textStyle: textTheme.labelMedium),
      labelSmall: wixMadeforText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Work Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Work+Sans
  static TextStyle workSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e8008add26fbbb78990c241687039ef03586c18b8eef8dfeac0717df046f35b',
        113352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '76484d928768788e6318fe51e2de6fab88420b2a65cd15ee70a7600ac0ee33cb',
        113700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95184c5e97699f2021e5191a9a08c9f47cf1f299d3b9fd80b998c78424acf553',
        114040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f1a98b9ddfd9976f03ea399cbd3cd6384e0465a0561e8a4b7af86fe7d553720',
        114120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4445f602093eeb4b019dd5cfc97c06d4d142a90c35b0a4c6be494794f1471c9',
        114588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2374e0bc5fcbc0ffa692195ee90c82bacb960886f00a2c80c28d187cd568a67',
        115352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9c07691832882bb05df33b67aa6e85e3a96d3635cb9281b155e026ca34d5351',
        115608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11ccabd865112ee6178789b3733ba82ca719f0a54c47dadf3765926b7462b103',
        116948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16a1d51230a49d1d0420c92a9b199365fde485e7740d473f21d096e263cda318',
        116580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c805d1d3191c7a84bd6ad03f43bf938eb78c74ecd96ba98eab78a9d19c9db278',
        108992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '49e10e0c24c47fcde71aff62622e5dfc9dbd8526af30af85bc0e104ca2f724bd',
        109236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '201fe18bbe449e9fb125e3831e460965a80dfede6a01b1ceaf0989fa6f9b067b',
        109148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0080aef708d72bd24cc56cbdb32e286ca094cbec0b2f0e2a848f7e6b4a1c212d',
        109064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '639b766151ce0f69e878f5ca44f6f49173635e3a1d53e9c658775b90cf2d7318',
        109740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '989a73cc28fbf127ae1b8e1088134c1d3136d9b739fd2e0a34ee20357952a957',
        110120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '703d9eed217d6755e87c2de7b1594696013dbca0451e0ca52cce8d312eef042a',
        110344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6e4ecc28ba60b5c62975af7ab0c31fb4865e6287613716611313797246ae94ba',
        111772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3abef6d9cea741431f98ce82599c81da2d4a6fa2f87df9919b51c5ee3755b718',
        111624,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WorkSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Work Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Work+Sans
  static TextTheme workSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: workSans(textStyle: textTheme.displayLarge),
      displayMedium: workSans(textStyle: textTheme.displayMedium),
      displaySmall: workSans(textStyle: textTheme.displaySmall),
      headlineLarge: workSans(textStyle: textTheme.headlineLarge),
      headlineMedium: workSans(textStyle: textTheme.headlineMedium),
      headlineSmall: workSans(textStyle: textTheme.headlineSmall),
      titleLarge: workSans(textStyle: textTheme.titleLarge),
      titleMedium: workSans(textStyle: textTheme.titleMedium),
      titleSmall: workSans(textStyle: textTheme.titleSmall),
      bodyLarge: workSans(textStyle: textTheme.bodyLarge),
      bodyMedium: workSans(textStyle: textTheme.bodyMedium),
      bodySmall: workSans(textStyle: textTheme.bodySmall),
      labelLarge: workSans(textStyle: textTheme.labelLarge),
      labelMedium: workSans(textStyle: textTheme.labelMedium),
      labelSmall: workSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Workbench font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Workbench
  static TextStyle workbench({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f233936199d83bc05cbe9713630c83e225dbe81f1315b6343ef79b7d8daf7ab',
        19884,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Workbench',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Workbench font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Workbench
  static TextTheme workbenchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: workbench(textStyle: textTheme.displayLarge),
      displayMedium: workbench(textStyle: textTheme.displayMedium),
      displaySmall: workbench(textStyle: textTheme.displaySmall),
      headlineLarge: workbench(textStyle: textTheme.headlineLarge),
      headlineMedium: workbench(textStyle: textTheme.headlineMedium),
      headlineSmall: workbench(textStyle: textTheme.headlineSmall),
      titleLarge: workbench(textStyle: textTheme.titleLarge),
      titleMedium: workbench(textStyle: textTheme.titleMedium),
      titleSmall: workbench(textStyle: textTheme.titleSmall),
      bodyLarge: workbench(textStyle: textTheme.bodyLarge),
      bodyMedium: workbench(textStyle: textTheme.bodyMedium),
      bodySmall: workbench(textStyle: textTheme.bodySmall),
      labelLarge: workbench(textStyle: textTheme.labelLarge),
      labelMedium: workbench(textStyle: textTheme.labelMedium),
      labelSmall: workbench(textStyle: textTheme.labelSmall),
    );
  }
}
