// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'B'.
class PartB {
  /// Applies the B612 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612
  static TextStyle b612({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d0347457a725a93a2de2b562174a4b53958bc94347bce5dadf7c220d4d18742',
        89040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'aec7755bb68cd9fe7939fe6a51bb5a19fb8328a23038e03476d09e62c1acc917',
        92724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2585f7be03fe5213564bf53b9cafc085be0080aead7fc2c19224098f7b595309',
        88692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '23dc0ce0dd72a74b7beda1106ffd47f011134d17ef56a5009c64005c7d81c90d',
        91732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'B612',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the B612 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612
  static TextTheme b612TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: b612(textStyle: textTheme.displayLarge),
      displayMedium: b612(textStyle: textTheme.displayMedium),
      displaySmall: b612(textStyle: textTheme.displaySmall),
      headlineLarge: b612(textStyle: textTheme.headlineLarge),
      headlineMedium: b612(textStyle: textTheme.headlineMedium),
      headlineSmall: b612(textStyle: textTheme.headlineSmall),
      titleLarge: b612(textStyle: textTheme.titleLarge),
      titleMedium: b612(textStyle: textTheme.titleMedium),
      titleSmall: b612(textStyle: textTheme.titleSmall),
      bodyLarge: b612(textStyle: textTheme.bodyLarge),
      bodyMedium: b612(textStyle: textTheme.bodyMedium),
      bodySmall: b612(textStyle: textTheme.bodySmall),
      labelLarge: b612(textStyle: textTheme.labelLarge),
      labelMedium: b612(textStyle: textTheme.labelMedium),
      labelSmall: b612(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the B612 Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612+Mono
  static TextStyle b612Mono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd000dd45e5f0e911da0c815fb88b9a195fc02d82c2d945cae0e7f26b173bbbd0',
        86192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '36d5da0f6b9d0caa1cb8780d010841c69cb5ed99206d9ee06258fd78505709dc',
        88680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'afd0152ccca934a068576ec911f7f5f4b2b8272c728b92eed29061703d1e8d1f',
        85168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2701019977dcbb5e05e9ffaaca93b1a26b7e04980d41dcd28675f55f8f886f81',
        87484,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'B612Mono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the B612 Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612+Mono
  static TextTheme b612MonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: b612Mono(textStyle: textTheme.displayLarge),
      displayMedium: b612Mono(textStyle: textTheme.displayMedium),
      displaySmall: b612Mono(textStyle: textTheme.displaySmall),
      headlineLarge: b612Mono(textStyle: textTheme.headlineLarge),
      headlineMedium: b612Mono(textStyle: textTheme.headlineMedium),
      headlineSmall: b612Mono(textStyle: textTheme.headlineSmall),
      titleLarge: b612Mono(textStyle: textTheme.titleLarge),
      titleMedium: b612Mono(textStyle: textTheme.titleMedium),
      titleSmall: b612Mono(textStyle: textTheme.titleSmall),
      bodyLarge: b612Mono(textStyle: textTheme.bodyLarge),
      bodyMedium: b612Mono(textStyle: textTheme.bodyMedium),
      bodySmall: b612Mono(textStyle: textTheme.bodySmall),
      labelLarge: b612Mono(textStyle: textTheme.labelLarge),
      labelMedium: b612Mono(textStyle: textTheme.labelMedium),
      labelSmall: b612Mono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BIZ UDGothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDGothic
  static TextStyle bizUDGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0e93ce9e3edfc58d2874908e14b36b77a6f6dde51e7e1d919b99b27018b1621',
        3462768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aa66342f3412d3890b66d95543e0d0fa9fac466c227e596b9a36cf3ec1267387',
        3447448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BIZUDGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BIZ UDGothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDGothic
  static TextTheme bizUDGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bizUDGothic(textStyle: textTheme.displayLarge),
      displayMedium: bizUDGothic(textStyle: textTheme.displayMedium),
      displaySmall: bizUDGothic(textStyle: textTheme.displaySmall),
      headlineLarge: bizUDGothic(textStyle: textTheme.headlineLarge),
      headlineMedium: bizUDGothic(textStyle: textTheme.headlineMedium),
      headlineSmall: bizUDGothic(textStyle: textTheme.headlineSmall),
      titleLarge: bizUDGothic(textStyle: textTheme.titleLarge),
      titleMedium: bizUDGothic(textStyle: textTheme.titleMedium),
      titleSmall: bizUDGothic(textStyle: textTheme.titleSmall),
      bodyLarge: bizUDGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: bizUDGothic(textStyle: textTheme.bodyMedium),
      bodySmall: bizUDGothic(textStyle: textTheme.bodySmall),
      labelLarge: bizUDGothic(textStyle: textTheme.labelLarge),
      labelMedium: bizUDGothic(textStyle: textTheme.labelMedium),
      labelSmall: bizUDGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BIZ UDMincho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDMincho
  static TextStyle bizUDMincho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21d82615f77606049eedc67b0fcd7f77e577205149a7ee760ce72b3c754bcb5f',
        4846784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '381c0870df44c7afdca590c94c24a747aa561dfe1200836120d677b7053a95a0',
        5793964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BIZUDMincho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BIZ UDMincho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDMincho
  static TextTheme bizUDMinchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bizUDMincho(textStyle: textTheme.displayLarge),
      displayMedium: bizUDMincho(textStyle: textTheme.displayMedium),
      displaySmall: bizUDMincho(textStyle: textTheme.displaySmall),
      headlineLarge: bizUDMincho(textStyle: textTheme.headlineLarge),
      headlineMedium: bizUDMincho(textStyle: textTheme.headlineMedium),
      headlineSmall: bizUDMincho(textStyle: textTheme.headlineSmall),
      titleLarge: bizUDMincho(textStyle: textTheme.titleLarge),
      titleMedium: bizUDMincho(textStyle: textTheme.titleMedium),
      titleSmall: bizUDMincho(textStyle: textTheme.titleSmall),
      bodyLarge: bizUDMincho(textStyle: textTheme.bodyLarge),
      bodyMedium: bizUDMincho(textStyle: textTheme.bodyMedium),
      bodySmall: bizUDMincho(textStyle: textTheme.bodySmall),
      labelLarge: bizUDMincho(textStyle: textTheme.labelLarge),
      labelMedium: bizUDMincho(textStyle: textTheme.labelMedium),
      labelSmall: bizUDMincho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BIZ UDPGothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDPGothic
  static TextStyle bizUDPGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f75c513d0053f607ee43cb26659e5d637697b2a8875761af3063e5cdffc77ae9',
        3508468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46e2ca270030de3c0f0ea6694f39878f257189e4d58a0dd5ca4d9ab5247dd549',
        3492688,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BIZUDPGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BIZ UDPGothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDPGothic
  static TextTheme bizUDPGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bizUDPGothic(textStyle: textTheme.displayLarge),
      displayMedium: bizUDPGothic(textStyle: textTheme.displayMedium),
      displaySmall: bizUDPGothic(textStyle: textTheme.displaySmall),
      headlineLarge: bizUDPGothic(textStyle: textTheme.headlineLarge),
      headlineMedium: bizUDPGothic(textStyle: textTheme.headlineMedium),
      headlineSmall: bizUDPGothic(textStyle: textTheme.headlineSmall),
      titleLarge: bizUDPGothic(textStyle: textTheme.titleLarge),
      titleMedium: bizUDPGothic(textStyle: textTheme.titleMedium),
      titleSmall: bizUDPGothic(textStyle: textTheme.titleSmall),
      bodyLarge: bizUDPGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: bizUDPGothic(textStyle: textTheme.bodyMedium),
      bodySmall: bizUDPGothic(textStyle: textTheme.bodySmall),
      labelLarge: bizUDPGothic(textStyle: textTheme.labelLarge),
      labelMedium: bizUDPGothic(textStyle: textTheme.labelMedium),
      labelSmall: bizUDPGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BIZ UDPMincho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDPMincho
  static TextStyle bizUDPMincho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64122b93abc388b67fb2884647d5e4af73218977ee45f967803028d11d960f1f',
        4919472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c2ab6a5e06df519617abeb26e0f249d54a68f22dc145947cdc38dfc233cb6b6',
        5880052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BIZUDPMincho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BIZ UDPMincho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDPMincho
  static TextTheme bizUDPMinchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bizUDPMincho(textStyle: textTheme.displayLarge),
      displayMedium: bizUDPMincho(textStyle: textTheme.displayMedium),
      displaySmall: bizUDPMincho(textStyle: textTheme.displaySmall),
      headlineLarge: bizUDPMincho(textStyle: textTheme.headlineLarge),
      headlineMedium: bizUDPMincho(textStyle: textTheme.headlineMedium),
      headlineSmall: bizUDPMincho(textStyle: textTheme.headlineSmall),
      titleLarge: bizUDPMincho(textStyle: textTheme.titleLarge),
      titleMedium: bizUDPMincho(textStyle: textTheme.titleMedium),
      titleSmall: bizUDPMincho(textStyle: textTheme.titleSmall),
      bodyLarge: bizUDPMincho(textStyle: textTheme.bodyLarge),
      bodyMedium: bizUDPMincho(textStyle: textTheme.bodyMedium),
      bodySmall: bizUDPMincho(textStyle: textTheme.bodySmall),
      labelLarge: bizUDPMincho(textStyle: textTheme.labelLarge),
      labelMedium: bizUDPMincho(textStyle: textTheme.labelMedium),
      labelSmall: bizUDPMincho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Babylonica font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Babylonica
  static TextStyle babylonica({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59d132f0c16ab2f3c76b4eb6e4d043292f3c895e2c2e84a80933c38b93678681',
        333872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Babylonica',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Babylonica font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Babylonica
  static TextTheme babylonicaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: babylonica(textStyle: textTheme.displayLarge),
      displayMedium: babylonica(textStyle: textTheme.displayMedium),
      displaySmall: babylonica(textStyle: textTheme.displaySmall),
      headlineLarge: babylonica(textStyle: textTheme.headlineLarge),
      headlineMedium: babylonica(textStyle: textTheme.headlineMedium),
      headlineSmall: babylonica(textStyle: textTheme.headlineSmall),
      titleLarge: babylonica(textStyle: textTheme.titleLarge),
      titleMedium: babylonica(textStyle: textTheme.titleMedium),
      titleSmall: babylonica(textStyle: textTheme.titleSmall),
      bodyLarge: babylonica(textStyle: textTheme.bodyLarge),
      bodyMedium: babylonica(textStyle: textTheme.bodyMedium),
      bodySmall: babylonica(textStyle: textTheme.bodySmall),
      labelLarge: babylonica(textStyle: textTheme.labelLarge),
      labelMedium: babylonica(textStyle: textTheme.labelMedium),
      labelSmall: babylonica(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bacasime Antique font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bacasime+Antique
  static TextStyle bacasimeAntique({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c8e7593a98f8c8773c59e63c9e37c01e5c60f99da330fe6f64d43da067810d1',
        29552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BacasimeAntique',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bacasime Antique font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bacasime+Antique
  static TextTheme bacasimeAntiqueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bacasimeAntique(textStyle: textTheme.displayLarge),
      displayMedium: bacasimeAntique(textStyle: textTheme.displayMedium),
      displaySmall: bacasimeAntique(textStyle: textTheme.displaySmall),
      headlineLarge: bacasimeAntique(textStyle: textTheme.headlineLarge),
      headlineMedium: bacasimeAntique(textStyle: textTheme.headlineMedium),
      headlineSmall: bacasimeAntique(textStyle: textTheme.headlineSmall),
      titleLarge: bacasimeAntique(textStyle: textTheme.titleLarge),
      titleMedium: bacasimeAntique(textStyle: textTheme.titleMedium),
      titleSmall: bacasimeAntique(textStyle: textTheme.titleSmall),
      bodyLarge: bacasimeAntique(textStyle: textTheme.bodyLarge),
      bodyMedium: bacasimeAntique(textStyle: textTheme.bodyMedium),
      bodySmall: bacasimeAntique(textStyle: textTheme.bodySmall),
      labelLarge: bacasimeAntique(textStyle: textTheme.labelLarge),
      labelMedium: bacasimeAntique(textStyle: textTheme.labelMedium),
      labelSmall: bacasimeAntique(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bad Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bad+Script
  static TextStyle badScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c62d8477f536f5e0939e0a67dae8aab90bcc8d72c5fc36642a8cc668250c761b',
        50028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BadScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bad Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bad+Script
  static TextTheme badScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: badScript(textStyle: textTheme.displayLarge),
      displayMedium: badScript(textStyle: textTheme.displayMedium),
      displaySmall: badScript(textStyle: textTheme.displaySmall),
      headlineLarge: badScript(textStyle: textTheme.headlineLarge),
      headlineMedium: badScript(textStyle: textTheme.headlineMedium),
      headlineSmall: badScript(textStyle: textTheme.headlineSmall),
      titleLarge: badScript(textStyle: textTheme.titleLarge),
      titleMedium: badScript(textStyle: textTheme.titleMedium),
      titleSmall: badScript(textStyle: textTheme.titleSmall),
      bodyLarge: badScript(textStyle: textTheme.bodyLarge),
      bodyMedium: badScript(textStyle: textTheme.bodyMedium),
      bodySmall: badScript(textStyle: textTheme.bodySmall),
      labelLarge: badScript(textStyle: textTheme.labelLarge),
      labelMedium: badScript(textStyle: textTheme.labelMedium),
      labelSmall: badScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bagel Fat One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bagel+Fat+One
  static TextStyle bagelFatOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '49922f5bb01d7850836cc4d1def1381e80eb8119793e576c1ebdd1cf3c6a8f59',
        971976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BagelFatOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bagel Fat One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bagel+Fat+One
  static TextTheme bagelFatOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bagelFatOne(textStyle: textTheme.displayLarge),
      displayMedium: bagelFatOne(textStyle: textTheme.displayMedium),
      displaySmall: bagelFatOne(textStyle: textTheme.displaySmall),
      headlineLarge: bagelFatOne(textStyle: textTheme.headlineLarge),
      headlineMedium: bagelFatOne(textStyle: textTheme.headlineMedium),
      headlineSmall: bagelFatOne(textStyle: textTheme.headlineSmall),
      titleLarge: bagelFatOne(textStyle: textTheme.titleLarge),
      titleMedium: bagelFatOne(textStyle: textTheme.titleMedium),
      titleSmall: bagelFatOne(textStyle: textTheme.titleSmall),
      bodyLarge: bagelFatOne(textStyle: textTheme.bodyLarge),
      bodyMedium: bagelFatOne(textStyle: textTheme.bodyMedium),
      bodySmall: bagelFatOne(textStyle: textTheme.bodySmall),
      labelLarge: bagelFatOne(textStyle: textTheme.labelLarge),
      labelMedium: bagelFatOne(textStyle: textTheme.labelMedium),
      labelSmall: bagelFatOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bahiana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahiana
  static TextStyle bahiana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e814f4c2e3a67c9343b2c2533a7ec6ba3074beb09700c3338e10187a3a98b4c1',
        46648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bahiana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bahiana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahiana
  static TextTheme bahianaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bahiana(textStyle: textTheme.displayLarge),
      displayMedium: bahiana(textStyle: textTheme.displayMedium),
      displaySmall: bahiana(textStyle: textTheme.displaySmall),
      headlineLarge: bahiana(textStyle: textTheme.headlineLarge),
      headlineMedium: bahiana(textStyle: textTheme.headlineMedium),
      headlineSmall: bahiana(textStyle: textTheme.headlineSmall),
      titleLarge: bahiana(textStyle: textTheme.titleLarge),
      titleMedium: bahiana(textStyle: textTheme.titleMedium),
      titleSmall: bahiana(textStyle: textTheme.titleSmall),
      bodyLarge: bahiana(textStyle: textTheme.bodyLarge),
      bodyMedium: bahiana(textStyle: textTheme.bodyMedium),
      bodySmall: bahiana(textStyle: textTheme.bodySmall),
      labelLarge: bahiana(textStyle: textTheme.labelLarge),
      labelMedium: bahiana(textStyle: textTheme.labelMedium),
      labelSmall: bahiana(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bahianita font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahianita
  static TextStyle bahianita({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72554c00db8338dfcea172622a0db9f2db2c772327aebbcc776d8a0eb2ad04b2',
        92180,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bahianita',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bahianita font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahianita
  static TextTheme bahianitaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bahianita(textStyle: textTheme.displayLarge),
      displayMedium: bahianita(textStyle: textTheme.displayMedium),
      displaySmall: bahianita(textStyle: textTheme.displaySmall),
      headlineLarge: bahianita(textStyle: textTheme.headlineLarge),
      headlineMedium: bahianita(textStyle: textTheme.headlineMedium),
      headlineSmall: bahianita(textStyle: textTheme.headlineSmall),
      titleLarge: bahianita(textStyle: textTheme.titleLarge),
      titleMedium: bahianita(textStyle: textTheme.titleMedium),
      titleSmall: bahianita(textStyle: textTheme.titleSmall),
      bodyLarge: bahianita(textStyle: textTheme.bodyLarge),
      bodyMedium: bahianita(textStyle: textTheme.bodyMedium),
      bodySmall: bahianita(textStyle: textTheme.bodySmall),
      labelLarge: bahianita(textStyle: textTheme.labelLarge),
      labelMedium: bahianita(textStyle: textTheme.labelMedium),
      labelSmall: bahianita(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bai Jamjuree font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bai+Jamjuree
  static TextStyle baiJamjuree({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45ef472a0bd6f81b528804dc98f3ba4b56e789d55d793ab3b6a88a638646b28c',
        78044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '17f2cce743e3276c95ff6383c235328f5e97b8889c4d1e93a2073edcad336f82',
        83600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '134cfc83d825085fb79694e5b4a0791a44d50367d6bfbaa0aff3cd3ea735330e',
        78384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3e459a85b71ea5fe1a2a7779a731cb5f137f710ee70d565935001f6fbcee666a',
        83780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '477ceaa5c1f1bbdfc31023cad25ab089ed1689737e4078f64b88141dde2874dc',
        78416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fcc54ca860ceb502e5a24cf34c84d1f4ed451c3a60c56206115af44be3998af0',
        83856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d1630b17316408ccb87e59aa817256f20270197833d9fce7dc84f8fdaffe519',
        78428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '254fc13896c665383d6192c9a5cb1efe824a2d28b0511698edb6f2befad1df31',
        83944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c0fd790fb689c4ce76399c8f4edda636d9ecf05aafe376bdb33923444917cdd',
        78412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3fbdadddca86a1635e36cc7bce48f51f4fbbd72c5d0c1b8e425ad2322cc14614',
        83776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '949fc9581d9010403dfffcd8e1f13ff58ddf3a32eb5390b060081045fc31059a',
        78104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8709e86b66d84a0be9bcb6b71d5512d832c861ba549b3678f2dca36d699d9e22',
        83360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BaiJamjuree',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bai Jamjuree font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bai+Jamjuree
  static TextTheme baiJamjureeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: baiJamjuree(textStyle: textTheme.displayLarge),
      displayMedium: baiJamjuree(textStyle: textTheme.displayMedium),
      displaySmall: baiJamjuree(textStyle: textTheme.displaySmall),
      headlineLarge: baiJamjuree(textStyle: textTheme.headlineLarge),
      headlineMedium: baiJamjuree(textStyle: textTheme.headlineMedium),
      headlineSmall: baiJamjuree(textStyle: textTheme.headlineSmall),
      titleLarge: baiJamjuree(textStyle: textTheme.titleLarge),
      titleMedium: baiJamjuree(textStyle: textTheme.titleMedium),
      titleSmall: baiJamjuree(textStyle: textTheme.titleSmall),
      bodyLarge: baiJamjuree(textStyle: textTheme.bodyLarge),
      bodyMedium: baiJamjuree(textStyle: textTheme.bodyMedium),
      bodySmall: baiJamjuree(textStyle: textTheme.bodySmall),
      labelLarge: baiJamjuree(textStyle: textTheme.labelLarge),
      labelMedium: baiJamjuree(textStyle: textTheme.labelMedium),
      labelSmall: baiJamjuree(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bakbak One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bakbak+One
  static TextStyle bakbakOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24d48558ea930ddf1ad6fe410cccbf9a12ef01e16246987f5c3c9eae03093957',
        146496,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BakbakOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bakbak One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bakbak+One
  static TextTheme bakbakOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bakbakOne(textStyle: textTheme.displayLarge),
      displayMedium: bakbakOne(textStyle: textTheme.displayMedium),
      displaySmall: bakbakOne(textStyle: textTheme.displaySmall),
      headlineLarge: bakbakOne(textStyle: textTheme.headlineLarge),
      headlineMedium: bakbakOne(textStyle: textTheme.headlineMedium),
      headlineSmall: bakbakOne(textStyle: textTheme.headlineSmall),
      titleLarge: bakbakOne(textStyle: textTheme.titleLarge),
      titleMedium: bakbakOne(textStyle: textTheme.titleMedium),
      titleSmall: bakbakOne(textStyle: textTheme.titleSmall),
      bodyLarge: bakbakOne(textStyle: textTheme.bodyLarge),
      bodyMedium: bakbakOne(textStyle: textTheme.bodyMedium),
      bodySmall: bakbakOne(textStyle: textTheme.bodySmall),
      labelLarge: bakbakOne(textStyle: textTheme.labelLarge),
      labelMedium: bakbakOne(textStyle: textTheme.labelMedium),
      labelSmall: bakbakOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ballet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ballet
  static TextStyle ballet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87f0ea4972b584ca3d1332a774e0ec310711a3948ce047ed82d65fe544d7ec4b',
        74396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ballet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ballet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ballet
  static TextTheme balletTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ballet(textStyle: textTheme.displayLarge),
      displayMedium: ballet(textStyle: textTheme.displayMedium),
      displaySmall: ballet(textStyle: textTheme.displaySmall),
      headlineLarge: ballet(textStyle: textTheme.headlineLarge),
      headlineMedium: ballet(textStyle: textTheme.headlineMedium),
      headlineSmall: ballet(textStyle: textTheme.headlineSmall),
      titleLarge: ballet(textStyle: textTheme.titleLarge),
      titleMedium: ballet(textStyle: textTheme.titleMedium),
      titleSmall: ballet(textStyle: textTheme.titleSmall),
      bodyLarge: ballet(textStyle: textTheme.bodyLarge),
      bodyMedium: ballet(textStyle: textTheme.bodyMedium),
      bodySmall: ballet(textStyle: textTheme.bodySmall),
      labelLarge: ballet(textStyle: textTheme.labelLarge),
      labelMedium: ballet(textStyle: textTheme.labelMedium),
      labelSmall: ballet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+2
  static TextStyle baloo2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fea39bbc0034c9d19bbe216022ff35f730f708d2f6c8b2460160b6e92a4a3e0e',
        417824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a61c6e6a2a4dbf5661ab84af2f04cd94bb23a55deddadd14df22e0b7658d63ed',
        418140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e183273b09ace60f0265257f3a2f015fc46d5226fd729b724ce17648ff1010a',
        418064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '291dcfb1305552ec2a8b0bcff09b55a2fcd6d554b7c6f04cb06c733e1ba86780',
        417936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c09ea368c8ca30d51aab28b64beba3a49fb0632e2cd8a978b7c84f500d5445b',
        417540,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baloo2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+2
  static TextTheme baloo2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: baloo2(textStyle: textTheme.displayLarge),
      displayMedium: baloo2(textStyle: textTheme.displayMedium),
      displaySmall: baloo2(textStyle: textTheme.displaySmall),
      headlineLarge: baloo2(textStyle: textTheme.headlineLarge),
      headlineMedium: baloo2(textStyle: textTheme.headlineMedium),
      headlineSmall: baloo2(textStyle: textTheme.headlineSmall),
      titleLarge: baloo2(textStyle: textTheme.titleLarge),
      titleMedium: baloo2(textStyle: textTheme.titleMedium),
      titleSmall: baloo2(textStyle: textTheme.titleSmall),
      bodyLarge: baloo2(textStyle: textTheme.bodyLarge),
      bodyMedium: baloo2(textStyle: textTheme.bodyMedium),
      bodySmall: baloo2(textStyle: textTheme.bodySmall),
      labelLarge: baloo2(textStyle: textTheme.labelLarge),
      labelMedium: baloo2(textStyle: textTheme.labelMedium),
      labelSmall: baloo2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhai 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai+2
  static TextStyle balooBhai2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e45ae2a6eca066862596bf6c29ea728b74e78dae82ed0f87912eebeee9b45b6d',
        419804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '405b99625a014e9405ef1969de757dbbba054508047b2c240870ddf2856c7c59',
        419928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9efecef2987f91d88548539742a446f93809617a7328c5409072b3829f86b14',
        420176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '15eb67ffb090874c980452b58131ecef72323fa3f6c59d9e124e7f155cca8c23',
        420052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e799286f24e30b5f2dc567b9c5a4be9c1c7792b9c5f794ad0521f1bf77565acf',
        419568,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhai2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhai 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai+2
  static TextTheme balooBhai2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balooBhai2(textStyle: textTheme.displayLarge),
      displayMedium: balooBhai2(textStyle: textTheme.displayMedium),
      displaySmall: balooBhai2(textStyle: textTheme.displaySmall),
      headlineLarge: balooBhai2(textStyle: textTheme.headlineLarge),
      headlineMedium: balooBhai2(textStyle: textTheme.headlineMedium),
      headlineSmall: balooBhai2(textStyle: textTheme.headlineSmall),
      titleLarge: balooBhai2(textStyle: textTheme.titleLarge),
      titleMedium: balooBhai2(textStyle: textTheme.titleMedium),
      titleSmall: balooBhai2(textStyle: textTheme.titleSmall),
      bodyLarge: balooBhai2(textStyle: textTheme.bodyLarge),
      bodyMedium: balooBhai2(textStyle: textTheme.bodyMedium),
      bodySmall: balooBhai2(textStyle: textTheme.bodySmall),
      labelLarge: balooBhai2(textStyle: textTheme.labelLarge),
      labelMedium: balooBhai2(textStyle: textTheme.labelMedium),
      labelSmall: balooBhai2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhaijaan 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan+2
  static TextStyle balooBhaijaan2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc8cf7a4efe2fdf6c009714792c2f1b35e308e34201c56ef8c0e09f3db22522a',
        172680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20c6b6da2209d80121a965839a3e5552d92d277a37864323dfc09eb5d7f23092',
        172960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43fc2942f103434a16851a2cfa61c544942b09982fb8591c202c05d5eecdc792',
        173000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bea22a3e9aac34b354507c8b4bd7bccf2a3808096f3464eb92b632c90f96da20',
        173044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60a3eb9894a8776505aa4ce9c43f25efb5a5d6a6c19d04b6b3af0a36589b7521',
        172924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaijaan2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaijaan 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan+2
  static TextTheme balooBhaijaan2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balooBhaijaan2(textStyle: textTheme.displayLarge),
      displayMedium: balooBhaijaan2(textStyle: textTheme.displayMedium),
      displaySmall: balooBhaijaan2(textStyle: textTheme.displaySmall),
      headlineLarge: balooBhaijaan2(textStyle: textTheme.headlineLarge),
      headlineMedium: balooBhaijaan2(textStyle: textTheme.headlineMedium),
      headlineSmall: balooBhaijaan2(textStyle: textTheme.headlineSmall),
      titleLarge: balooBhaijaan2(textStyle: textTheme.titleLarge),
      titleMedium: balooBhaijaan2(textStyle: textTheme.titleMedium),
      titleSmall: balooBhaijaan2(textStyle: textTheme.titleSmall),
      bodyLarge: balooBhaijaan2(textStyle: textTheme.bodyLarge),
      bodyMedium: balooBhaijaan2(textStyle: textTheme.bodyMedium),
      bodySmall: balooBhaijaan2(textStyle: textTheme.bodySmall),
      labelLarge: balooBhaijaan2(textStyle: textTheme.labelLarge),
      labelMedium: balooBhaijaan2(textStyle: textTheme.labelMedium),
      labelSmall: balooBhaijaan2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhaina 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina+2
  static TextStyle balooBhaina2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b244fc4680ebe3aec8d5976d8ee664cd06c7fe9f46aae73c74091d2d48021752',
        273844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '302a2ceff3c58ddc69b4c360394fd165d06fd0733f37833a6b6b37e4144d4a0f',
        274896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b868c02e656998ffb9f6967f6d079b14ac54a77bd3ba26c50b8366e54a6ab9f8',
        274944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3aa0a368f8e7e199b35a29aebe7cc18d030616f0ef7452f7d27c1c19fbc2852b',
        274784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0480cce304e4ad758de2e6f72ca3cb25d3659fdf846c5d8806fd5259471ea428',
        273264,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaina2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaina 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina+2
  static TextTheme balooBhaina2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balooBhaina2(textStyle: textTheme.displayLarge),
      displayMedium: balooBhaina2(textStyle: textTheme.displayMedium),
      displaySmall: balooBhaina2(textStyle: textTheme.displaySmall),
      headlineLarge: balooBhaina2(textStyle: textTheme.headlineLarge),
      headlineMedium: balooBhaina2(textStyle: textTheme.headlineMedium),
      headlineSmall: balooBhaina2(textStyle: textTheme.headlineSmall),
      titleLarge: balooBhaina2(textStyle: textTheme.titleLarge),
      titleMedium: balooBhaina2(textStyle: textTheme.titleMedium),
      titleSmall: balooBhaina2(textStyle: textTheme.titleSmall),
      bodyLarge: balooBhaina2(textStyle: textTheme.bodyLarge),
      bodyMedium: balooBhaina2(textStyle: textTheme.bodyMedium),
      bodySmall: balooBhaina2(textStyle: textTheme.bodySmall),
      labelLarge: balooBhaina2(textStyle: textTheme.labelLarge),
      labelMedium: balooBhaina2(textStyle: textTheme.labelMedium),
      labelSmall: balooBhaina2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Chettan 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan+2
  static TextStyle balooChettan2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39e949d1cd18387bc6f1402427857be33344bedd51c3bbc050e5336b9fc3c8f9',
        191128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2a3cda63b2b198d8f517d386728871dfc0a0f58183fe60ca38ac65ae0039b6a',
        191728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dfdcefab2bc604f04454868e8b1f9cba8b7bdbeaf8de68e6ca2595a1e82e285b',
        191740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07ed7667fad6bbbce17b87a2d9d8e243046ed83bed8a76da69544515ec1f4c33',
        191648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4284fe34837e25c791c38e1cbde8cf2776b757a7a1382bbebd05909cd558eb21',
        191496,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooChettan2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Chettan 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan+2
  static TextTheme balooChettan2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balooChettan2(textStyle: textTheme.displayLarge),
      displayMedium: balooChettan2(textStyle: textTheme.displayMedium),
      displaySmall: balooChettan2(textStyle: textTheme.displaySmall),
      headlineLarge: balooChettan2(textStyle: textTheme.headlineLarge),
      headlineMedium: balooChettan2(textStyle: textTheme.headlineMedium),
      headlineSmall: balooChettan2(textStyle: textTheme.headlineSmall),
      titleLarge: balooChettan2(textStyle: textTheme.titleLarge),
      titleMedium: balooChettan2(textStyle: textTheme.titleMedium),
      titleSmall: balooChettan2(textStyle: textTheme.titleSmall),
      bodyLarge: balooChettan2(textStyle: textTheme.bodyLarge),
      bodyMedium: balooChettan2(textStyle: textTheme.bodyMedium),
      bodySmall: balooChettan2(textStyle: textTheme.bodySmall),
      labelLarge: balooChettan2(textStyle: textTheme.labelLarge),
      labelMedium: balooChettan2(textStyle: textTheme.labelMedium),
      labelSmall: balooChettan2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Da 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da+2
  static TextStyle balooDa2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab0638e4332ca0dbccd60d93a1c5fd9db87cad3549c2c0c148291c8d73d7e142',
        269996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf40df6f4e7c2eb445a8fc21520cc7340b62f2a38a176edd6cb414ea57217cd2',
        270528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b65d1b3074efc7bbb9db5c5fe08d59d37656e48f0a4e7a5892568805f37ba28',
        270676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe4edd178c895a7f91bf72deb4d17fb5f754499ddb6e7e96639b41477ad339e5',
        270356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04f8bca02b0d43ab51f699948239901b6a2b2849b0d5845847c9c5b5a3b68b1f',
        269480,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooDa2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Da 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da+2
  static TextTheme balooDa2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balooDa2(textStyle: textTheme.displayLarge),
      displayMedium: balooDa2(textStyle: textTheme.displayMedium),
      displaySmall: balooDa2(textStyle: textTheme.displaySmall),
      headlineLarge: balooDa2(textStyle: textTheme.headlineLarge),
      headlineMedium: balooDa2(textStyle: textTheme.headlineMedium),
      headlineSmall: balooDa2(textStyle: textTheme.headlineSmall),
      titleLarge: balooDa2(textStyle: textTheme.titleLarge),
      titleMedium: balooDa2(textStyle: textTheme.titleMedium),
      titleSmall: balooDa2(textStyle: textTheme.titleSmall),
      bodyLarge: balooDa2(textStyle: textTheme.bodyLarge),
      bodyMedium: balooDa2(textStyle: textTheme.bodyMedium),
      bodySmall: balooDa2(textStyle: textTheme.bodySmall),
      labelLarge: balooDa2(textStyle: textTheme.labelLarge),
      labelMedium: balooDa2(textStyle: textTheme.labelMedium),
      labelSmall: balooDa2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Paaji 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji+2
  static TextStyle balooPaaji2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e2ad2c3ed8ad4e0333dbca1d322db0bc1d9c6f5d477efe6b5140b21fca90ff4',
        148100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2479387357c7cf8280cc59f29d21eb7fb53129003c460bed7d4ae7b55806641',
        148348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82bfbb7d331425b9adfa309b7d3366fd956240c52fcc7324ad7914890b062083',
        148352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04ce8b049e724dc9e4a7800357987d0a06ac61e5a0fad06c8730c8978d920ce0',
        148228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5928eb0727f207e37a2533ae5f9f00b03a6c4c38fd5ac64519b300fcd7f6883',
        148156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooPaaji2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Paaji 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji+2
  static TextTheme balooPaaji2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balooPaaji2(textStyle: textTheme.displayLarge),
      displayMedium: balooPaaji2(textStyle: textTheme.displayMedium),
      displaySmall: balooPaaji2(textStyle: textTheme.displaySmall),
      headlineLarge: balooPaaji2(textStyle: textTheme.headlineLarge),
      headlineMedium: balooPaaji2(textStyle: textTheme.headlineMedium),
      headlineSmall: balooPaaji2(textStyle: textTheme.headlineSmall),
      titleLarge: balooPaaji2(textStyle: textTheme.titleLarge),
      titleMedium: balooPaaji2(textStyle: textTheme.titleMedium),
      titleSmall: balooPaaji2(textStyle: textTheme.titleSmall),
      bodyLarge: balooPaaji2(textStyle: textTheme.bodyLarge),
      bodyMedium: balooPaaji2(textStyle: textTheme.bodyMedium),
      bodySmall: balooPaaji2(textStyle: textTheme.bodySmall),
      labelLarge: balooPaaji2(textStyle: textTheme.labelLarge),
      labelMedium: balooPaaji2(textStyle: textTheme.labelMedium),
      labelSmall: balooPaaji2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Tamma 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma+2
  static TextStyle balooTamma2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd69946a8908f1e9446c7793da68f97b774e1619016792f5089ff594dd25e531b',
        280456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dde860627c3078cfad1bc2b99713038885e2aa00b4b4e6a21dce2eeab00082e5',
        281552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '790cba7f482c5eb60784592519d5d0f444941e792feb1582f346bed5e8a1fd12',
        281708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69b381733e82d0832e04327baff7c18b67f1cf90be227504e81976748e2544b5',
        281636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f575f04d6932b4b6a8cfc89a997b877247a99332cefd3f666a5258385f4352cd',
        281028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTamma2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tamma 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma+2
  static TextTheme balooTamma2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balooTamma2(textStyle: textTheme.displayLarge),
      displayMedium: balooTamma2(textStyle: textTheme.displayMedium),
      displaySmall: balooTamma2(textStyle: textTheme.displaySmall),
      headlineLarge: balooTamma2(textStyle: textTheme.headlineLarge),
      headlineMedium: balooTamma2(textStyle: textTheme.headlineMedium),
      headlineSmall: balooTamma2(textStyle: textTheme.headlineSmall),
      titleLarge: balooTamma2(textStyle: textTheme.titleLarge),
      titleMedium: balooTamma2(textStyle: textTheme.titleMedium),
      titleSmall: balooTamma2(textStyle: textTheme.titleSmall),
      bodyLarge: balooTamma2(textStyle: textTheme.bodyLarge),
      bodyMedium: balooTamma2(textStyle: textTheme.bodyMedium),
      bodySmall: balooTamma2(textStyle: textTheme.bodySmall),
      labelLarge: balooTamma2(textStyle: textTheme.labelLarge),
      labelMedium: balooTamma2(textStyle: textTheme.labelMedium),
      labelSmall: balooTamma2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Tammudu 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu+2
  static TextStyle balooTammudu2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2e2527757aa1de0f7bc5e987ef02c9e21f8909d38fd0669c45fb6e761547153',
        388520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6de6eb13b343b8aa505e52d080c096cabf947679be553f1679ee222ddb25d4d0',
        389988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a335130d0b6bec26da3a4b14b13da38c6db5138f0d8ca81a5153adb0187120c5',
        389980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de4c10fc46394cab93a0c8255c8713f6b8586724120e33193279e5d1272a4034',
        389924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c108b454ffd9efae289153704388a2f258d61abf2bda408e83ee905e6b1aa8c5',
        388224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTammudu2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tammudu 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu+2
  static TextTheme balooTammudu2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balooTammudu2(textStyle: textTheme.displayLarge),
      displayMedium: balooTammudu2(textStyle: textTheme.displayMedium),
      displaySmall: balooTammudu2(textStyle: textTheme.displaySmall),
      headlineLarge: balooTammudu2(textStyle: textTheme.headlineLarge),
      headlineMedium: balooTammudu2(textStyle: textTheme.headlineMedium),
      headlineSmall: balooTammudu2(textStyle: textTheme.headlineSmall),
      titleLarge: balooTammudu2(textStyle: textTheme.titleLarge),
      titleMedium: balooTammudu2(textStyle: textTheme.titleMedium),
      titleSmall: balooTammudu2(textStyle: textTheme.titleSmall),
      bodyLarge: balooTammudu2(textStyle: textTheme.bodyLarge),
      bodyMedium: balooTammudu2(textStyle: textTheme.bodyMedium),
      bodySmall: balooTammudu2(textStyle: textTheme.bodySmall),
      labelLarge: balooTammudu2(textStyle: textTheme.labelLarge),
      labelMedium: balooTammudu2(textStyle: textTheme.labelMedium),
      labelSmall: balooTammudu2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Thambi 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi+2
  static TextStyle balooThambi2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7212890e01e3107463d5f8b941f6154e938e389a4ad2651871672f684bc85be0',
        171256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d637f705bbff57788ae9caad5e69a790e4abf48b9d1c24f85a36d65d4a209a3',
        171496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7871cbce96ef53d5b64a5e4c81ec94445b0d410087973cc8e1d7c32e03dffde9',
        171580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad31011a8bcf1eaa38e45687154c8cc77dd8795d0bd55a9cc5b3029cf5284a64',
        171224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39a38b750c09ffa008f59ed186743b1f8530dba5367ca955050b3e60e6b2bce0',
        171224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooThambi2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Thambi 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi+2
  static TextTheme balooThambi2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balooThambi2(textStyle: textTheme.displayLarge),
      displayMedium: balooThambi2(textStyle: textTheme.displayMedium),
      displaySmall: balooThambi2(textStyle: textTheme.displaySmall),
      headlineLarge: balooThambi2(textStyle: textTheme.headlineLarge),
      headlineMedium: balooThambi2(textStyle: textTheme.headlineMedium),
      headlineSmall: balooThambi2(textStyle: textTheme.headlineSmall),
      titleLarge: balooThambi2(textStyle: textTheme.titleLarge),
      titleMedium: balooThambi2(textStyle: textTheme.titleMedium),
      titleSmall: balooThambi2(textStyle: textTheme.titleSmall),
      bodyLarge: balooThambi2(textStyle: textTheme.bodyLarge),
      bodyMedium: balooThambi2(textStyle: textTheme.bodyMedium),
      bodySmall: balooThambi2(textStyle: textTheme.bodySmall),
      labelLarge: balooThambi2(textStyle: textTheme.labelLarge),
      labelMedium: balooThambi2(textStyle: textTheme.labelMedium),
      labelSmall: balooThambi2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Balsamiq Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balsamiq+Sans
  static TextStyle balsamiqSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '73a272f7d41c56750ac9929fefe3d0d4cf3216957cf84c4d832e3f6857259f83',
        323364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0e4d6f51f352fd8c094354cedde78231171d0b7724b3725e67b3882dc369e335',
        301404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f38c1836479a6af3ac8dab49ab20e362cadef21dff6c7f69a72b57f6858cadb',
        291260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2d25960146fbb15534c158dcd2bbc3a8ae7bddd7a51f58a8b5ce319a18efaf49',
        273576,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalsamiqSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Balsamiq Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balsamiq+Sans
  static TextTheme balsamiqSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balsamiqSans(textStyle: textTheme.displayLarge),
      displayMedium: balsamiqSans(textStyle: textTheme.displayMedium),
      displaySmall: balsamiqSans(textStyle: textTheme.displaySmall),
      headlineLarge: balsamiqSans(textStyle: textTheme.headlineLarge),
      headlineMedium: balsamiqSans(textStyle: textTheme.headlineMedium),
      headlineSmall: balsamiqSans(textStyle: textTheme.headlineSmall),
      titleLarge: balsamiqSans(textStyle: textTheme.titleLarge),
      titleMedium: balsamiqSans(textStyle: textTheme.titleMedium),
      titleSmall: balsamiqSans(textStyle: textTheme.titleSmall),
      bodyLarge: balsamiqSans(textStyle: textTheme.bodyLarge),
      bodyMedium: balsamiqSans(textStyle: textTheme.bodyMedium),
      bodySmall: balsamiqSans(textStyle: textTheme.bodySmall),
      labelLarge: balsamiqSans(textStyle: textTheme.labelLarge),
      labelMedium: balsamiqSans(textStyle: textTheme.labelMedium),
      labelSmall: balsamiqSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Balthazar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balthazar
  static TextStyle balthazar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1cd0347fd14d420937d59e562bbaf7728e58f405b7ab633dc27d3d0df5abc46a',
        26212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Balthazar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Balthazar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balthazar
  static TextTheme balthazarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: balthazar(textStyle: textTheme.displayLarge),
      displayMedium: balthazar(textStyle: textTheme.displayMedium),
      displaySmall: balthazar(textStyle: textTheme.displaySmall),
      headlineLarge: balthazar(textStyle: textTheme.headlineLarge),
      headlineMedium: balthazar(textStyle: textTheme.headlineMedium),
      headlineSmall: balthazar(textStyle: textTheme.headlineSmall),
      titleLarge: balthazar(textStyle: textTheme.titleLarge),
      titleMedium: balthazar(textStyle: textTheme.titleMedium),
      titleSmall: balthazar(textStyle: textTheme.titleSmall),
      bodyLarge: balthazar(textStyle: textTheme.bodyLarge),
      bodyMedium: balthazar(textStyle: textTheme.bodyMedium),
      bodySmall: balthazar(textStyle: textTheme.bodySmall),
      labelLarge: balthazar(textStyle: textTheme.labelLarge),
      labelMedium: balthazar(textStyle: textTheme.labelMedium),
      labelSmall: balthazar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bangers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bangers
  static TextStyle bangers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a00055f83a5ff74e6d71928101b6f38266dd28cc7972edd315b3758cad8b746',
        66284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bangers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bangers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bangers
  static TextTheme bangersTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bangers(textStyle: textTheme.displayLarge),
      displayMedium: bangers(textStyle: textTheme.displayMedium),
      displaySmall: bangers(textStyle: textTheme.displaySmall),
      headlineLarge: bangers(textStyle: textTheme.headlineLarge),
      headlineMedium: bangers(textStyle: textTheme.headlineMedium),
      headlineSmall: bangers(textStyle: textTheme.headlineSmall),
      titleLarge: bangers(textStyle: textTheme.titleLarge),
      titleMedium: bangers(textStyle: textTheme.titleMedium),
      titleSmall: bangers(textStyle: textTheme.titleSmall),
      bodyLarge: bangers(textStyle: textTheme.bodyLarge),
      bodyMedium: bangers(textStyle: textTheme.bodyMedium),
      bodySmall: bangers(textStyle: textTheme.bodySmall),
      labelLarge: bangers(textStyle: textTheme.labelLarge),
      labelMedium: bangers(textStyle: textTheme.labelMedium),
      labelSmall: bangers(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barlow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow
  static TextStyle barlow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bbc16834974bcc4e4f9db973c37e0cf4fc0f6ddac524fe984b7ad06cfd71a72',
        60968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '14ce45a1495d15909f8bb25df6cdc1138abe3e164503c344d9f980c2cbece06b',
        65044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0b7f7aa2d67a8c0202bf067a5bd032555506852f3417ca94aadc16700e64e20',
        61172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d2e410b5be890aa411650d1887b2b3cf4ad9f64ce2a75d88084aa9009f1f349',
        65156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '881e00245da07ebe51751aa48d551d8c06322b0b9e3f27d81d4274c414b9c397',
        61108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d31c8922e328b7a504216718a2657373a0b560b6a3695d5c567500fe162813a',
        65384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfd8787b4714f9c02f53da1b24bf172f95c01a9d0c685ad57ed129c3fcdae407',
        61220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd10c46da72515f099bcd89f43f335141ffa754c6022509fbc5c247b139862841',
        65404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72a094cf0a618a5dfdef5e4577be76a733457eae3ab4bebab26cfa72d56d6061',
        61192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0233802dc86c8576f52854ee4c856a709d9a72578aad65b1832bfdc817337f4a',
        65236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '73a13e2e61ce8da6ecb02864f6a560ce358ed01067e64872d318d71d51e23979',
        63624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '09d36dbb4ca7e1fba56fa9317aa27b899dbc9ab19eb81e414a332096345164b9',
        66716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5333515554675f6137f66c245fa199a4e917d03178b7605b8f54a87010b5c18',
        63432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '478ee598ade213bd6dffcfeb5063f62ae2bdb7ae5cac8640301396b78ca93785',
        66428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc5d3129f605f97c96b56a641f50a40ed4b595e315131b462391b0b38f4b8638',
        63352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd2fe8d712bf086745e5263df81b7800701aa1d50c8d41fb62263acc12d6b94d6',
        66300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '136bfaeda32a19ef87e4fcfa5b9abe08ff61e2d6caf241d1bc0f0c596acf4b55',
        62648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6e8ccc4cc688b301539e9fbc1b245a4e8adac7e27457312667b4cf30eaec1f89',
        65820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barlow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow
  static TextTheme barlowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: barlow(textStyle: textTheme.displayLarge),
      displayMedium: barlow(textStyle: textTheme.displayMedium),
      displaySmall: barlow(textStyle: textTheme.displaySmall),
      headlineLarge: barlow(textStyle: textTheme.headlineLarge),
      headlineMedium: barlow(textStyle: textTheme.headlineMedium),
      headlineSmall: barlow(textStyle: textTheme.headlineSmall),
      titleLarge: barlow(textStyle: textTheme.titleLarge),
      titleMedium: barlow(textStyle: textTheme.titleMedium),
      titleSmall: barlow(textStyle: textTheme.titleSmall),
      bodyLarge: barlow(textStyle: textTheme.bodyLarge),
      bodyMedium: barlow(textStyle: textTheme.bodyMedium),
      bodySmall: barlow(textStyle: textTheme.bodySmall),
      labelLarge: barlow(textStyle: textTheme.labelLarge),
      labelMedium: barlow(textStyle: textTheme.labelMedium),
      labelSmall: barlow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barlow Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Condensed
  static TextStyle barlowCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1dee1e0b2a0e92f8c159c64be477d5ce921ab414875dd2b27fddbd3225145e59',
        59116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d8a3427ca351ad43d44ebf56065be6dff6c6b8ca07e84f23fa6530382bdaf5a',
        64192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '653ee54fee2f8f7bb3767619199f793bb1535213047ec3f9692d9ede7a32b29f',
        59404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '58c71ddcda8a2e87b56af7f0330cc38ed1fbcd2ad44e046e5e06fe0bc14fe38c',
        64148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b32c0a732bbc6b8548600c07f0613cbd907fc9e5a612172b769773a0f9a105f3',
        59368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '727434e82ca27aa74575ac071aa22dee19e53ef5fb9989d33afd8da08daea5b3',
        64076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55945685c8354c029c443b9cb6ecede593e2b1d39b06af4252d539c4086153ea',
        59388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ddfaa73e1fa79e3ca93f652e782cd76ef2258c173e9c9ce4b00866846ef99629',
        64216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50f9954bab84f7ccea0afe7cf13823533027b5efd0417a1387141e977b4efbe0',
        59296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1c6f759c51923225d37d188e0cfc338654bfea90558ebeb414a0902243db59f6',
        63936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad2be76c190d3802305d220324830b70a75f10048dc13ec3586aabfc2a3fe9e7',
        61748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '818f7627df56558c6af408c51cc3006542b5b3345d95bd68b00165106cdf57cc',
        65044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b49c74d0e2ab43e60c2d626f3d773b479503b5b3ecc93dd53214ccef6fb96d8',
        61656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a9dab89ddf5e643d6ddeabbb4cee0529dd18d3765df25598494f0600b8bfd38a',
        64824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '541bda3b787018f37ad1188cb6a3ce1dec84e698b16b5e42f558ba31b684bacb',
        61744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '87a22408de0b27c113ae7d6b5e5df3e32d15ba1a3144ad54825b602df6c6edfd',
        64692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8c8ee9c3537ef2e0630589f34fb63c05ca0709941d83c65ca3a9afe765017d0',
        60364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0011fea9ffaffb7d88568511ebfcb6fe446dbafd0b0461289db897e01fa5b5fc',
        63364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BarlowCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Condensed
  static TextTheme barlowCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: barlowCondensed(textStyle: textTheme.displayLarge),
      displayMedium: barlowCondensed(textStyle: textTheme.displayMedium),
      displaySmall: barlowCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: barlowCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: barlowCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: barlowCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: barlowCondensed(textStyle: textTheme.titleLarge),
      titleMedium: barlowCondensed(textStyle: textTheme.titleMedium),
      titleSmall: barlowCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: barlowCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: barlowCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: barlowCondensed(textStyle: textTheme.bodySmall),
      labelLarge: barlowCondensed(textStyle: textTheme.labelLarge),
      labelMedium: barlowCondensed(textStyle: textTheme.labelMedium),
      labelSmall: barlowCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barlow Semi Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Semi+Condensed
  static TextStyle barlowSemiCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '89818a86f326cb1fa15b2706043de6f2c999ed16e70e72ba25d3e690ee4c4d33',
        61528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '19ed019b658c781ec627f351b00eeb535ea908d1ede6f2b7c3ac6e50ce19fbcb',
        66004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9d0c8ff49d5e765dce34246ecd4a3156391db071cda5ab2c047509c2408b571',
        61716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '80ebfc9722b4b6b42b2285d7e46a7edd903b81c011d9121de8544804246a1119',
        66012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52b690571a0704facf69aa1b54078acc0343ced70027a6480413969da16e992a',
        61812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '395b671ebf4a7b7198fb4416508b3fdfd6d288dffdb8b82bffea7a40e4507bf9',
        65936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd6c806ca535d0ce1180ba8c0f0d07d51597be4f148af673c7c3b39e6614d391',
        61888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0763857ec6ff64573e7d61797c40e519f7b76a0e2b739a95dd9738dc75465af5',
        65864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4bfd63bc5e79e3a04ba6ddbefb2ce1d9f62a955ad41e3119cdb4cbf5eaceb994',
        61784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '60ac397706683f7bc0ee75a2f75236b42a87ed2c4d8b3c67b76d5c24520a0926',
        65760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '244e8a9cd7d8a5fe1e0ce2a19d07bce2028c2c92ca8eff380977827b8738b648',
        64216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0aa25b8c8d300f88fecf503e1d1b8cadd69254330d89690084bba4a08c4d0b9f',
        67292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03322f9a9edf8031532ed962b7172f14dba9d318ae0c90a9bb5f718c92c232a1',
        64196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f8b0bb8a92f7123de02f2c7cf49621754789843775cb8c318848502b934ab8f4',
        67032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ce5e171b6822bb2b7b7f1d017d94791a71443deadc32e49cfb6bb4415edb4db',
        64224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dcbde2ed7553bd05e71b64af8d8b87f6e0098879781604da0269c2394817f246',
        67024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8578b062ec4b7e229bef1eab8834e2458b2536bc776306a7ed6327493b587a52',
        63252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'baeb5ff8b88a49d4dd171bdee7541101b805e263699ddcdfd9738c760c44107c',
        66268,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BarlowSemiCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow Semi Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Semi+Condensed
  static TextTheme barlowSemiCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: barlowSemiCondensed(textStyle: textTheme.displayLarge),
      displayMedium: barlowSemiCondensed(textStyle: textTheme.displayMedium),
      displaySmall: barlowSemiCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: barlowSemiCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: barlowSemiCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: barlowSemiCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: barlowSemiCondensed(textStyle: textTheme.titleLarge),
      titleMedium: barlowSemiCondensed(textStyle: textTheme.titleMedium),
      titleSmall: barlowSemiCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: barlowSemiCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: barlowSemiCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: barlowSemiCondensed(textStyle: textTheme.bodySmall),
      labelLarge: barlowSemiCondensed(textStyle: textTheme.labelLarge),
      labelMedium: barlowSemiCondensed(textStyle: textTheme.labelMedium),
      labelSmall: barlowSemiCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barriecito font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barriecito
  static TextStyle barriecito({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a5f70fd22056cbcd57b1d4921971a147653d249e82c95012bb6546692bc1b35',
        168228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barriecito',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barriecito font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barriecito
  static TextTheme barriecitoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: barriecito(textStyle: textTheme.displayLarge),
      displayMedium: barriecito(textStyle: textTheme.displayMedium),
      displaySmall: barriecito(textStyle: textTheme.displaySmall),
      headlineLarge: barriecito(textStyle: textTheme.headlineLarge),
      headlineMedium: barriecito(textStyle: textTheme.headlineMedium),
      headlineSmall: barriecito(textStyle: textTheme.headlineSmall),
      titleLarge: barriecito(textStyle: textTheme.titleLarge),
      titleMedium: barriecito(textStyle: textTheme.titleMedium),
      titleSmall: barriecito(textStyle: textTheme.titleSmall),
      bodyLarge: barriecito(textStyle: textTheme.bodyLarge),
      bodyMedium: barriecito(textStyle: textTheme.bodyMedium),
      bodySmall: barriecito(textStyle: textTheme.bodySmall),
      labelLarge: barriecito(textStyle: textTheme.labelLarge),
      labelMedium: barriecito(textStyle: textTheme.labelMedium),
      labelSmall: barriecito(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barrio font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barrio
  static TextStyle barrio({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6e639586ec1a9532c089c61020e3d092aeefbf3c496b2c1104acb3904f5ec2e',
        141000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barrio',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barrio font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barrio
  static TextTheme barrioTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: barrio(textStyle: textTheme.displayLarge),
      displayMedium: barrio(textStyle: textTheme.displayMedium),
      displaySmall: barrio(textStyle: textTheme.displaySmall),
      headlineLarge: barrio(textStyle: textTheme.headlineLarge),
      headlineMedium: barrio(textStyle: textTheme.headlineMedium),
      headlineSmall: barrio(textStyle: textTheme.headlineSmall),
      titleLarge: barrio(textStyle: textTheme.titleLarge),
      titleMedium: barrio(textStyle: textTheme.titleMedium),
      titleSmall: barrio(textStyle: textTheme.titleSmall),
      bodyLarge: barrio(textStyle: textTheme.bodyLarge),
      bodyMedium: barrio(textStyle: textTheme.bodyMedium),
      bodySmall: barrio(textStyle: textTheme.bodySmall),
      labelLarge: barrio(textStyle: textTheme.labelLarge),
      labelMedium: barrio(textStyle: textTheme.labelMedium),
      labelSmall: barrio(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Basic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Basic
  static TextStyle basic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3b02abd4d2201f0462807909df410bb7ce384e02bb619853d0397f687ed2777',
        42096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Basic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Basic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Basic
  static TextTheme basicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: basic(textStyle: textTheme.displayLarge),
      displayMedium: basic(textStyle: textTheme.displayMedium),
      displaySmall: basic(textStyle: textTheme.displaySmall),
      headlineLarge: basic(textStyle: textTheme.headlineLarge),
      headlineMedium: basic(textStyle: textTheme.headlineMedium),
      headlineSmall: basic(textStyle: textTheme.headlineSmall),
      titleLarge: basic(textStyle: textTheme.titleLarge),
      titleMedium: basic(textStyle: textTheme.titleMedium),
      titleSmall: basic(textStyle: textTheme.titleSmall),
      bodyLarge: basic(textStyle: textTheme.bodyLarge),
      bodyMedium: basic(textStyle: textTheme.bodyMedium),
      bodySmall: basic(textStyle: textTheme.bodySmall),
      labelLarge: basic(textStyle: textTheme.labelLarge),
      labelMedium: basic(textStyle: textTheme.labelMedium),
      labelSmall: basic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baskervville font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville
  static TextStyle baskervville({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77fb1d99a5c6b1cffe23d1e4699768dc4eb1ca359b4361dd946841d859f12d2a',
        52060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6f49acfdd9aa2c8e2fef687adfd145e1596ba01f04d7131c06cd09ffee66e2a0',
        54148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baskervville',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baskervville font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville
  static TextTheme baskervvilleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: baskervville(textStyle: textTheme.displayLarge),
      displayMedium: baskervville(textStyle: textTheme.displayMedium),
      displaySmall: baskervville(textStyle: textTheme.displaySmall),
      headlineLarge: baskervville(textStyle: textTheme.headlineLarge),
      headlineMedium: baskervville(textStyle: textTheme.headlineMedium),
      headlineSmall: baskervville(textStyle: textTheme.headlineSmall),
      titleLarge: baskervville(textStyle: textTheme.titleLarge),
      titleMedium: baskervville(textStyle: textTheme.titleMedium),
      titleSmall: baskervville(textStyle: textTheme.titleSmall),
      bodyLarge: baskervville(textStyle: textTheme.bodyLarge),
      bodyMedium: baskervville(textStyle: textTheme.bodyMedium),
      bodySmall: baskervville(textStyle: textTheme.bodySmall),
      labelLarge: baskervville(textStyle: textTheme.labelLarge),
      labelMedium: baskervville(textStyle: textTheme.labelMedium),
      labelSmall: baskervville(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baskervville SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville+SC
  static TextStyle baskervvilleSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b11dc20131b1be756f27c9c0d40a8fe115da6ddeda66278c23e330e96962ff9d',
        66076,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BaskervvilleSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baskervville SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville+SC
  static TextTheme baskervvilleScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: baskervvilleSc(textStyle: textTheme.displayLarge),
      displayMedium: baskervvilleSc(textStyle: textTheme.displayMedium),
      displaySmall: baskervvilleSc(textStyle: textTheme.displaySmall),
      headlineLarge: baskervvilleSc(textStyle: textTheme.headlineLarge),
      headlineMedium: baskervvilleSc(textStyle: textTheme.headlineMedium),
      headlineSmall: baskervvilleSc(textStyle: textTheme.headlineSmall),
      titleLarge: baskervvilleSc(textStyle: textTheme.titleLarge),
      titleMedium: baskervvilleSc(textStyle: textTheme.titleMedium),
      titleSmall: baskervvilleSc(textStyle: textTheme.titleSmall),
      bodyLarge: baskervvilleSc(textStyle: textTheme.bodyLarge),
      bodyMedium: baskervvilleSc(textStyle: textTheme.bodyMedium),
      bodySmall: baskervvilleSc(textStyle: textTheme.bodySmall),
      labelLarge: baskervvilleSc(textStyle: textTheme.labelLarge),
      labelMedium: baskervvilleSc(textStyle: textTheme.labelMedium),
      labelSmall: baskervvilleSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Battambang font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Battambang
  static TextStyle battambang({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8dfb3df55c4d870b04583a168df47ae7877c0ea2f9c336d21066033c88bed45d',
        59292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ca7aeb911833408ae168a627d3083c87bdc38868b0b8ba1320696006e40f59b',
        58724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e05fe4fcc6f87bf09c6db7eda1420c9d92af3e9f0e6f09e0364dfd2ac00b77ae',
        63732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a0d66e43fea8fb305efcd3afec4f9f08664026126669b5ac3dade4439653f66',
        62124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '404868ce8f69e04f2fb5cc302059c4910d9e4bf2576f1c41c450a54c92d46ff2',
        59948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Battambang',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Battambang font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Battambang
  static TextTheme battambangTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: battambang(textStyle: textTheme.displayLarge),
      displayMedium: battambang(textStyle: textTheme.displayMedium),
      displaySmall: battambang(textStyle: textTheme.displaySmall),
      headlineLarge: battambang(textStyle: textTheme.headlineLarge),
      headlineMedium: battambang(textStyle: textTheme.headlineMedium),
      headlineSmall: battambang(textStyle: textTheme.headlineSmall),
      titleLarge: battambang(textStyle: textTheme.titleLarge),
      titleMedium: battambang(textStyle: textTheme.titleMedium),
      titleSmall: battambang(textStyle: textTheme.titleSmall),
      bodyLarge: battambang(textStyle: textTheme.bodyLarge),
      bodyMedium: battambang(textStyle: textTheme.bodyMedium),
      bodySmall: battambang(textStyle: textTheme.bodySmall),
      labelLarge: battambang(textStyle: textTheme.labelLarge),
      labelMedium: battambang(textStyle: textTheme.labelMedium),
      labelSmall: battambang(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baumans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baumans
  static TextStyle baumans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1de2ab6656da7508c9eff19007f47390e9eb2f1472851910525141f81fb42aad',
        16352,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baumans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baumans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baumans
  static TextTheme baumansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: baumans(textStyle: textTheme.displayLarge),
      displayMedium: baumans(textStyle: textTheme.displayMedium),
      displaySmall: baumans(textStyle: textTheme.displaySmall),
      headlineLarge: baumans(textStyle: textTheme.headlineLarge),
      headlineMedium: baumans(textStyle: textTheme.headlineMedium),
      headlineSmall: baumans(textStyle: textTheme.headlineSmall),
      titleLarge: baumans(textStyle: textTheme.titleLarge),
      titleMedium: baumans(textStyle: textTheme.titleMedium),
      titleSmall: baumans(textStyle: textTheme.titleSmall),
      bodyLarge: baumans(textStyle: textTheme.bodyLarge),
      bodyMedium: baumans(textStyle: textTheme.bodyMedium),
      bodySmall: baumans(textStyle: textTheme.bodySmall),
      labelLarge: baumans(textStyle: textTheme.labelLarge),
      labelMedium: baumans(textStyle: textTheme.labelMedium),
      labelSmall: baumans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bayon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bayon
  static TextStyle bayon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '99a813ef40d0534db52fe34c136ce7cf50917766be7780d6f7918b1b931fcf1d',
        31844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bayon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bayon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bayon
  static TextTheme bayonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bayon(textStyle: textTheme.displayLarge),
      displayMedium: bayon(textStyle: textTheme.displayMedium),
      displaySmall: bayon(textStyle: textTheme.displaySmall),
      headlineLarge: bayon(textStyle: textTheme.headlineLarge),
      headlineMedium: bayon(textStyle: textTheme.headlineMedium),
      headlineSmall: bayon(textStyle: textTheme.headlineSmall),
      titleLarge: bayon(textStyle: textTheme.titleLarge),
      titleMedium: bayon(textStyle: textTheme.titleMedium),
      titleSmall: bayon(textStyle: textTheme.titleSmall),
      bodyLarge: bayon(textStyle: textTheme.bodyLarge),
      bodyMedium: bayon(textStyle: textTheme.bodyMedium),
      bodySmall: bayon(textStyle: textTheme.bodySmall),
      labelLarge: bayon(textStyle: textTheme.labelLarge),
      labelMedium: bayon(textStyle: textTheme.labelMedium),
      labelSmall: bayon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Be Vietnam Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam+Pro
  static TextStyle beVietnamPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5490ed11e9a4948be0ee4013980ec4183a7f660599a383336e926344fe2b9dd7',
        72348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e1728c9bfc6372b7f3125ef3f456c0ec1f683dc069322401c776a6c36cf1cef5',
        73916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c48bc1803511361c828ac2a3e15a01b477d95e075599b6b10d65f6a97410db6',
        72252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1767f2438b058ed1ec0b7d96a725210c6ff9ecbc08d666b61d23afd7c2795e4b',
        74416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c19cf35695dcd055b6e62369f6896a74f518b11b413c5394dc50f1a79537ed24',
        72484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fc3fc9eea53f3dab993d7635e7d1780f32321c7d02ae547eef4dc685a59c9673',
        74252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9429918b033a0c12e2dd4091a7d7d11bed161efa7ae17c1c03c1348d31fcaaa',
        72288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '596affd710ee2cfb7f9342a34e4b558fff27193e92fa5eb6336349cdef5ab3f5',
        74040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbb96d46d021840a81fd08a7429ea2cddeed64329ae11bab0b635902f262a327',
        72424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '587e118746797793262dc48cd5a5ee4befc4dd3899d338f92020297e36e2a6e1',
        73976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00d35b55610fb4c5b0db57c07244806c807dd82dffb333846f0b970f16d2f8b4',
        72268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '42be5fafce7e6d8575f80d4db0531cae80f16f2dd597be67516cb3546714acc8',
        73448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb637e409b7022b7f6a1788cc2aae91fa93e55017cc13309620f4ae6884f6e2a',
        72172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6a686face989fdb2d4ea3e979bc15e675bf0420f337f1aa35510984c83069415',
        73308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e8fdddc5b06efd1bb411a40d91cf021ebaf526acad5e44c31eca97c8a4416f5',
        71864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '89f136b4c9270c59ab7bb1469cb11a7459f6b767f83627ac46b1277346bec5f7',
        73248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '817a4b39ed86a90c52a873b399f1c8b88954489fe9376b6685195cac99d75dea',
        70768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a2c16ef1e7f8c79d5e654c192f7bebf0d215adc1cd4dce31884521d4d2162b1e',
        72052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BeVietnamPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Be Vietnam Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam+Pro
  static TextTheme beVietnamProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: beVietnamPro(textStyle: textTheme.displayLarge),
      displayMedium: beVietnamPro(textStyle: textTheme.displayMedium),
      displaySmall: beVietnamPro(textStyle: textTheme.displaySmall),
      headlineLarge: beVietnamPro(textStyle: textTheme.headlineLarge),
      headlineMedium: beVietnamPro(textStyle: textTheme.headlineMedium),
      headlineSmall: beVietnamPro(textStyle: textTheme.headlineSmall),
      titleLarge: beVietnamPro(textStyle: textTheme.titleLarge),
      titleMedium: beVietnamPro(textStyle: textTheme.titleMedium),
      titleSmall: beVietnamPro(textStyle: textTheme.titleSmall),
      bodyLarge: beVietnamPro(textStyle: textTheme.bodyLarge),
      bodyMedium: beVietnamPro(textStyle: textTheme.bodyMedium),
      bodySmall: beVietnamPro(textStyle: textTheme.bodySmall),
      labelLarge: beVietnamPro(textStyle: textTheme.labelLarge),
      labelMedium: beVietnamPro(textStyle: textTheme.labelMedium),
      labelSmall: beVietnamPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Beau Rivage font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beau+Rivage
  static TextStyle beauRivage({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddd83eb0bdacceb749d27c2e8b767cc38b522153db450931f1ca8b682c8b423e',
        110720,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BeauRivage',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Beau Rivage font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beau+Rivage
  static TextTheme beauRivageTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: beauRivage(textStyle: textTheme.displayLarge),
      displayMedium: beauRivage(textStyle: textTheme.displayMedium),
      displaySmall: beauRivage(textStyle: textTheme.displaySmall),
      headlineLarge: beauRivage(textStyle: textTheme.headlineLarge),
      headlineMedium: beauRivage(textStyle: textTheme.headlineMedium),
      headlineSmall: beauRivage(textStyle: textTheme.headlineSmall),
      titleLarge: beauRivage(textStyle: textTheme.titleLarge),
      titleMedium: beauRivage(textStyle: textTheme.titleMedium),
      titleSmall: beauRivage(textStyle: textTheme.titleSmall),
      bodyLarge: beauRivage(textStyle: textTheme.bodyLarge),
      bodyMedium: beauRivage(textStyle: textTheme.bodyMedium),
      bodySmall: beauRivage(textStyle: textTheme.bodySmall),
      labelLarge: beauRivage(textStyle: textTheme.labelLarge),
      labelMedium: beauRivage(textStyle: textTheme.labelMedium),
      labelSmall: beauRivage(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bebas Neue font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bebas+Neue
  static TextStyle bebasNeue({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1b67d8679c6f4d301f4a05c13d1a4032cefed98bd9b61b11b2fac9689c99116',
        38232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BebasNeue',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bebas Neue font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bebas+Neue
  static TextTheme bebasNeueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bebasNeue(textStyle: textTheme.displayLarge),
      displayMedium: bebasNeue(textStyle: textTheme.displayMedium),
      displaySmall: bebasNeue(textStyle: textTheme.displaySmall),
      headlineLarge: bebasNeue(textStyle: textTheme.headlineLarge),
      headlineMedium: bebasNeue(textStyle: textTheme.headlineMedium),
      headlineSmall: bebasNeue(textStyle: textTheme.headlineSmall),
      titleLarge: bebasNeue(textStyle: textTheme.titleLarge),
      titleMedium: bebasNeue(textStyle: textTheme.titleMedium),
      titleSmall: bebasNeue(textStyle: textTheme.titleSmall),
      bodyLarge: bebasNeue(textStyle: textTheme.bodyLarge),
      bodyMedium: bebasNeue(textStyle: textTheme.bodyMedium),
      bodySmall: bebasNeue(textStyle: textTheme.bodySmall),
      labelLarge: bebasNeue(textStyle: textTheme.labelLarge),
      labelMedium: bebasNeue(textStyle: textTheme.labelMedium),
      labelSmall: bebasNeue(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Beiruti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beiruti
  static TextStyle beiruti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61ab23704522d4a4c321ad5c127b29ce75040f99f761f36fb81812ae22258895',
        287644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1e358c23a445aa5a845b8aa3070c6aa9a0cc8cf5930ec474407cda672f08a71',
        287680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8bb9495832c080b48c2c382997004f7d05e5a14063c9de8f3428fea7ad24ef55',
        287300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0949460100364e1e309dba95cf1b1a23088f3fb1255df9c1a9a164b4e3a82fb1',
        287212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3fdc9dba40b6d4d002157dc1794dbdd7cb2f1d985b4dc9baf52c61438780a6af',
        287500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '290a09f6b90fe4c957914da3427de1fddb577fdc338f18fd87863f264098de40',
        286904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45571c2c034ff257c38cde014ae73a16d37c321953c2c9c2508161d66b3df466',
        287232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3bb49035ff2ba5d1fbdd8bf3275d25c9eaf004b7e06ae1e940f0e3e0223dfb1d',
        285932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Beiruti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Beiruti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beiruti
  static TextTheme beirutiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: beiruti(textStyle: textTheme.displayLarge),
      displayMedium: beiruti(textStyle: textTheme.displayMedium),
      displaySmall: beiruti(textStyle: textTheme.displaySmall),
      headlineLarge: beiruti(textStyle: textTheme.headlineLarge),
      headlineMedium: beiruti(textStyle: textTheme.headlineMedium),
      headlineSmall: beiruti(textStyle: textTheme.headlineSmall),
      titleLarge: beiruti(textStyle: textTheme.titleLarge),
      titleMedium: beiruti(textStyle: textTheme.titleMedium),
      titleSmall: beiruti(textStyle: textTheme.titleSmall),
      bodyLarge: beiruti(textStyle: textTheme.bodyLarge),
      bodyMedium: beiruti(textStyle: textTheme.bodyMedium),
      bodySmall: beiruti(textStyle: textTheme.bodySmall),
      labelLarge: beiruti(textStyle: textTheme.labelLarge),
      labelMedium: beiruti(textStyle: textTheme.labelMedium),
      labelSmall: beiruti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Belanosima font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belanosima
  static TextStyle belanosima({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b06a9311ac4b802bfd460ddb1e1536d57e6521dca28090c224cf2aadb4c176cb',
        37264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8cd2ff42ab4f269f649a0d3d55187a59e069bc33cef3d445a651a9bbb114371d',
        37708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94ca6a4a21e701cda5f93f60560fa69c22a927b1cd418757a7c271e9f0d7d0be',
        39184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Belanosima',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Belanosima font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belanosima
  static TextTheme belanosimaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: belanosima(textStyle: textTheme.displayLarge),
      displayMedium: belanosima(textStyle: textTheme.displayMedium),
      displaySmall: belanosima(textStyle: textTheme.displaySmall),
      headlineLarge: belanosima(textStyle: textTheme.headlineLarge),
      headlineMedium: belanosima(textStyle: textTheme.headlineMedium),
      headlineSmall: belanosima(textStyle: textTheme.headlineSmall),
      titleLarge: belanosima(textStyle: textTheme.titleLarge),
      titleMedium: belanosima(textStyle: textTheme.titleMedium),
      titleSmall: belanosima(textStyle: textTheme.titleSmall),
      bodyLarge: belanosima(textStyle: textTheme.bodyLarge),
      bodyMedium: belanosima(textStyle: textTheme.bodyMedium),
      bodySmall: belanosima(textStyle: textTheme.bodySmall),
      labelLarge: belanosima(textStyle: textTheme.labelLarge),
      labelMedium: belanosima(textStyle: textTheme.labelMedium),
      labelSmall: belanosima(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Belgrano font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belgrano
  static TextStyle belgrano({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '041815a440e3d2b468ffa830185903956b5925796cfa68c5b61fa3c3b3f0f2cb',
        26620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Belgrano',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Belgrano font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belgrano
  static TextTheme belgranoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: belgrano(textStyle: textTheme.displayLarge),
      displayMedium: belgrano(textStyle: textTheme.displayMedium),
      displaySmall: belgrano(textStyle: textTheme.displaySmall),
      headlineLarge: belgrano(textStyle: textTheme.headlineLarge),
      headlineMedium: belgrano(textStyle: textTheme.headlineMedium),
      headlineSmall: belgrano(textStyle: textTheme.headlineSmall),
      titleLarge: belgrano(textStyle: textTheme.titleLarge),
      titleMedium: belgrano(textStyle: textTheme.titleMedium),
      titleSmall: belgrano(textStyle: textTheme.titleSmall),
      bodyLarge: belgrano(textStyle: textTheme.bodyLarge),
      bodyMedium: belgrano(textStyle: textTheme.bodyMedium),
      bodySmall: belgrano(textStyle: textTheme.bodySmall),
      labelLarge: belgrano(textStyle: textTheme.labelLarge),
      labelMedium: belgrano(textStyle: textTheme.labelMedium),
      labelSmall: belgrano(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bellefair font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellefair
  static TextStyle bellefair({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60d4678f2a36e34ae045ea7aead21892c2ec638cc5a5177d5323befdbd8ee4d4',
        43872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bellefair',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellefair font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellefair
  static TextTheme bellefairTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bellefair(textStyle: textTheme.displayLarge),
      displayMedium: bellefair(textStyle: textTheme.displayMedium),
      displaySmall: bellefair(textStyle: textTheme.displaySmall),
      headlineLarge: bellefair(textStyle: textTheme.headlineLarge),
      headlineMedium: bellefair(textStyle: textTheme.headlineMedium),
      headlineSmall: bellefair(textStyle: textTheme.headlineSmall),
      titleLarge: bellefair(textStyle: textTheme.titleLarge),
      titleMedium: bellefair(textStyle: textTheme.titleMedium),
      titleSmall: bellefair(textStyle: textTheme.titleSmall),
      bodyLarge: bellefair(textStyle: textTheme.bodyLarge),
      bodyMedium: bellefair(textStyle: textTheme.bodyMedium),
      bodySmall: bellefair(textStyle: textTheme.bodySmall),
      labelLarge: bellefair(textStyle: textTheme.labelLarge),
      labelMedium: bellefair(textStyle: textTheme.labelMedium),
      labelSmall: bellefair(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Belleza font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belleza
  static TextStyle belleza({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6b519014842ccfe63ad433f59de94c84cf99651595304625bf9db4d4f8a435a',
        36584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Belleza',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Belleza font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belleza
  static TextTheme bellezaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: belleza(textStyle: textTheme.displayLarge),
      displayMedium: belleza(textStyle: textTheme.displayMedium),
      displaySmall: belleza(textStyle: textTheme.displaySmall),
      headlineLarge: belleza(textStyle: textTheme.headlineLarge),
      headlineMedium: belleza(textStyle: textTheme.headlineMedium),
      headlineSmall: belleza(textStyle: textTheme.headlineSmall),
      titleLarge: belleza(textStyle: textTheme.titleLarge),
      titleMedium: belleza(textStyle: textTheme.titleMedium),
      titleSmall: belleza(textStyle: textTheme.titleSmall),
      bodyLarge: belleza(textStyle: textTheme.bodyLarge),
      bodyMedium: belleza(textStyle: textTheme.bodyMedium),
      bodySmall: belleza(textStyle: textTheme.bodySmall),
      labelLarge: belleza(textStyle: textTheme.labelLarge),
      labelMedium: belleza(textStyle: textTheme.labelMedium),
      labelSmall: belleza(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bellota font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota
  static TextStyle bellota({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f7a6cbf9af154f216b945d1ec258fb7eb1bdf1e00d778f0099bb1ea6786c2e0',
        87240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a5c833f7fcb9a2cba29e00cdbdafd29119591093254b59a86c799af6abb966a8',
        90100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f824b2ca133fa906c1450368789a3588ec9bab058ccbe4f76c8448a7d12e3236',
        86912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ac652d8c98a501302c1872a404e8f7f1d793005ccd41994a7c3e5b68facb7c85',
        89752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94282dcf76c3c3db14eeed279164c722a17043095768956c2b08d13b159ddfb8',
        87136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5f4ade05bfb3150be2cb3791738df00ce698dbf6c883cd2a2a67998081b5c8ec',
        89968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bellota',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellota font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota
  static TextTheme bellotaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bellota(textStyle: textTheme.displayLarge),
      displayMedium: bellota(textStyle: textTheme.displayMedium),
      displaySmall: bellota(textStyle: textTheme.displaySmall),
      headlineLarge: bellota(textStyle: textTheme.headlineLarge),
      headlineMedium: bellota(textStyle: textTheme.headlineMedium),
      headlineSmall: bellota(textStyle: textTheme.headlineSmall),
      titleLarge: bellota(textStyle: textTheme.titleLarge),
      titleMedium: bellota(textStyle: textTheme.titleMedium),
      titleSmall: bellota(textStyle: textTheme.titleSmall),
      bodyLarge: bellota(textStyle: textTheme.bodyLarge),
      bodyMedium: bellota(textStyle: textTheme.bodyMedium),
      bodySmall: bellota(textStyle: textTheme.bodySmall),
      labelLarge: bellota(textStyle: textTheme.labelLarge),
      labelMedium: bellota(textStyle: textTheme.labelMedium),
      labelSmall: bellota(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bellota Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota+Text
  static TextStyle bellotaText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7756b7915c35e3134d17709e4116df789d658716c6404e7573eef99e6dcb2dd9',
        85412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5cccd44fee7145fc397379dba26bc45912cc7486ac3d1d9ea8af61c3f535a827',
        88420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50accbb633e0367e969b567e84da3a965eed6dec47727c00ff100dd262926a1a',
        85292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f4b9b8096d9a74c69ab9db04d45b2eba793f11f0d2834b1b6c732107bca82cbf',
        88136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e246687d862e7d6495f15c76845424ce7013bde6547cf43d79d7d18ceb2945cd',
        85380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9da4669305c1dd1c2365b3a04bffa7220a5470ec844e97d7ba5ec936ba239877',
        88216,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BellotaText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellota Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota+Text
  static TextTheme bellotaTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bellotaText(textStyle: textTheme.displayLarge),
      displayMedium: bellotaText(textStyle: textTheme.displayMedium),
      displaySmall: bellotaText(textStyle: textTheme.displaySmall),
      headlineLarge: bellotaText(textStyle: textTheme.headlineLarge),
      headlineMedium: bellotaText(textStyle: textTheme.headlineMedium),
      headlineSmall: bellotaText(textStyle: textTheme.headlineSmall),
      titleLarge: bellotaText(textStyle: textTheme.titleLarge),
      titleMedium: bellotaText(textStyle: textTheme.titleMedium),
      titleSmall: bellotaText(textStyle: textTheme.titleSmall),
      bodyLarge: bellotaText(textStyle: textTheme.bodyLarge),
      bodyMedium: bellotaText(textStyle: textTheme.bodyMedium),
      bodySmall: bellotaText(textStyle: textTheme.bodySmall),
      labelLarge: bellotaText(textStyle: textTheme.labelLarge),
      labelMedium: bellotaText(textStyle: textTheme.labelMedium),
      labelSmall: bellotaText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BenchNine font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BenchNine
  static TextStyle benchNine({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bbf92d32cea16a7289556b36b99b6cc8b19b1b64e32604ee79b563e8eb17791a',
        36144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbad55cfa6a05a2521130d836d2b0f7f4009bbe0ec3c41feb99f246fce39ed47',
        36912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb209270d0bd7f1f9655cacccb53fc569a44b807f89c4a4d6db282d8a70e5969',
        36888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BenchNine',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BenchNine font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BenchNine
  static TextTheme benchNineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: benchNine(textStyle: textTheme.displayLarge),
      displayMedium: benchNine(textStyle: textTheme.displayMedium),
      displaySmall: benchNine(textStyle: textTheme.displaySmall),
      headlineLarge: benchNine(textStyle: textTheme.headlineLarge),
      headlineMedium: benchNine(textStyle: textTheme.headlineMedium),
      headlineSmall: benchNine(textStyle: textTheme.headlineSmall),
      titleLarge: benchNine(textStyle: textTheme.titleLarge),
      titleMedium: benchNine(textStyle: textTheme.titleMedium),
      titleSmall: benchNine(textStyle: textTheme.titleSmall),
      bodyLarge: benchNine(textStyle: textTheme.bodyLarge),
      bodyMedium: benchNine(textStyle: textTheme.bodyMedium),
      bodySmall: benchNine(textStyle: textTheme.bodySmall),
      labelLarge: benchNine(textStyle: textTheme.labelLarge),
      labelMedium: benchNine(textStyle: textTheme.labelMedium),
      labelSmall: benchNine(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Benne font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Benne
  static TextStyle benne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '65574b4e0c539d996fd10054ca151357f17e7351b0a255ac2c2daad620577842',
        208536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Benne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Benne font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Benne
  static TextTheme benneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: benne(textStyle: textTheme.displayLarge),
      displayMedium: benne(textStyle: textTheme.displayMedium),
      displaySmall: benne(textStyle: textTheme.displaySmall),
      headlineLarge: benne(textStyle: textTheme.headlineLarge),
      headlineMedium: benne(textStyle: textTheme.headlineMedium),
      headlineSmall: benne(textStyle: textTheme.headlineSmall),
      titleLarge: benne(textStyle: textTheme.titleLarge),
      titleMedium: benne(textStyle: textTheme.titleMedium),
      titleSmall: benne(textStyle: textTheme.titleSmall),
      bodyLarge: benne(textStyle: textTheme.bodyLarge),
      bodyMedium: benne(textStyle: textTheme.bodyMedium),
      bodySmall: benne(textStyle: textTheme.bodySmall),
      labelLarge: benne(textStyle: textTheme.labelLarge),
      labelMedium: benne(textStyle: textTheme.labelMedium),
      labelSmall: benne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bentham font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bentham
  static TextStyle bentham({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b68a3b96cd2207a360ccce762bd77b9494035ddd3643b1bb3b260aea85063ff5',
        25772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bentham',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bentham font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bentham
  static TextTheme benthamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bentham(textStyle: textTheme.displayLarge),
      displayMedium: bentham(textStyle: textTheme.displayMedium),
      displaySmall: bentham(textStyle: textTheme.displaySmall),
      headlineLarge: bentham(textStyle: textTheme.headlineLarge),
      headlineMedium: bentham(textStyle: textTheme.headlineMedium),
      headlineSmall: bentham(textStyle: textTheme.headlineSmall),
      titleLarge: bentham(textStyle: textTheme.titleLarge),
      titleMedium: bentham(textStyle: textTheme.titleMedium),
      titleSmall: bentham(textStyle: textTheme.titleSmall),
      bodyLarge: bentham(textStyle: textTheme.bodyLarge),
      bodyMedium: bentham(textStyle: textTheme.bodyMedium),
      bodySmall: bentham(textStyle: textTheme.bodySmall),
      labelLarge: bentham(textStyle: textTheme.labelLarge),
      labelMedium: bentham(textStyle: textTheme.labelMedium),
      labelSmall: bentham(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Berkshire Swash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Berkshire+Swash
  static TextStyle berkshireSwash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfd5e58bb57d809250fe10f8b696c58318e41c6f90127a37a106e94c0690b163',
        51908,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BerkshireSwash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Berkshire Swash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Berkshire+Swash
  static TextTheme berkshireSwashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: berkshireSwash(textStyle: textTheme.displayLarge),
      displayMedium: berkshireSwash(textStyle: textTheme.displayMedium),
      displaySmall: berkshireSwash(textStyle: textTheme.displaySmall),
      headlineLarge: berkshireSwash(textStyle: textTheme.headlineLarge),
      headlineMedium: berkshireSwash(textStyle: textTheme.headlineMedium),
      headlineSmall: berkshireSwash(textStyle: textTheme.headlineSmall),
      titleLarge: berkshireSwash(textStyle: textTheme.titleLarge),
      titleMedium: berkshireSwash(textStyle: textTheme.titleMedium),
      titleSmall: berkshireSwash(textStyle: textTheme.titleSmall),
      bodyLarge: berkshireSwash(textStyle: textTheme.bodyLarge),
      bodyMedium: berkshireSwash(textStyle: textTheme.bodyMedium),
      bodySmall: berkshireSwash(textStyle: textTheme.bodySmall),
      labelLarge: berkshireSwash(textStyle: textTheme.labelLarge),
      labelMedium: berkshireSwash(textStyle: textTheme.labelMedium),
      labelSmall: berkshireSwash(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Besley font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Besley
  static TextStyle besley({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81bb7f9f10175dcb82b97aff810d6bfd4c003958501b0c0fad98f1099cbc496b',
        55960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a289708cd2c10170f96b6c49d7f127c9b9bdd23ac4c53578d51fac4ee033b1e',
        56036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ba5770cb058c7868b2f9442a975c9b79317d0a6cdc67447304eb45eaa61e207',
        56048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c37b48ee6be608281922365601d2a0830ce402ab0d9d778781ec9ba86f65ac1',
        55996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd62148a7839ba43e3c94c86207f5ffb62276afe33dd0a4d6c581d5a903fb189b',
        56052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70e6d915891810e5489b9cbf29c3ab41a25cdbb2a4c569f12404583dfe6edba3',
        56016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a797429e8b1286e41a14c5588ee1d78785d6768dc7ccd1f741f3eafef9becdc1',
        56532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f30091178caccfbd5c3bed2f7fe28e1361005740809371d5ca2c9656b8d369f5',
        56728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '66c4ad9f1d06aeb188d9d6c996a9448451d7bfc43dfe72e850609df5546fc752',
        56768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1f622ce0533c746ce60c1dc55c33e446ebce980a9c45467369c1bc7213e11eb3',
        56692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5a08d3f6e21daa540aa55efb99a36c0feba41dd7bb40e5a33c549a196c3e9946',
        56792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a68a17f7c276ec469621ca9c3e3a4867740c4eba26ee5eb91aba0e609e70f98d',
        56736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Besley',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Besley font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Besley
  static TextTheme besleyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: besley(textStyle: textTheme.displayLarge),
      displayMedium: besley(textStyle: textTheme.displayMedium),
      displaySmall: besley(textStyle: textTheme.displaySmall),
      headlineLarge: besley(textStyle: textTheme.headlineLarge),
      headlineMedium: besley(textStyle: textTheme.headlineMedium),
      headlineSmall: besley(textStyle: textTheme.headlineSmall),
      titleLarge: besley(textStyle: textTheme.titleLarge),
      titleMedium: besley(textStyle: textTheme.titleMedium),
      titleSmall: besley(textStyle: textTheme.titleSmall),
      bodyLarge: besley(textStyle: textTheme.bodyLarge),
      bodyMedium: besley(textStyle: textTheme.bodyMedium),
      bodySmall: besley(textStyle: textTheme.bodySmall),
      labelLarge: besley(textStyle: textTheme.labelLarge),
      labelMedium: besley(textStyle: textTheme.labelMedium),
      labelSmall: besley(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Beth Ellen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beth+Ellen
  static TextStyle bethEllen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8fa596edd5e469e18ec8d90f6481be7e5d372eec2f20ccf3cb0c53e1e220ab0',
        115600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BethEllen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Beth Ellen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beth+Ellen
  static TextTheme bethEllenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bethEllen(textStyle: textTheme.displayLarge),
      displayMedium: bethEllen(textStyle: textTheme.displayMedium),
      displaySmall: bethEllen(textStyle: textTheme.displaySmall),
      headlineLarge: bethEllen(textStyle: textTheme.headlineLarge),
      headlineMedium: bethEllen(textStyle: textTheme.headlineMedium),
      headlineSmall: bethEllen(textStyle: textTheme.headlineSmall),
      titleLarge: bethEllen(textStyle: textTheme.titleLarge),
      titleMedium: bethEllen(textStyle: textTheme.titleMedium),
      titleSmall: bethEllen(textStyle: textTheme.titleSmall),
      bodyLarge: bethEllen(textStyle: textTheme.bodyLarge),
      bodyMedium: bethEllen(textStyle: textTheme.bodyMedium),
      bodySmall: bethEllen(textStyle: textTheme.bodySmall),
      labelLarge: bethEllen(textStyle: textTheme.labelLarge),
      labelMedium: bethEllen(textStyle: textTheme.labelMedium),
      labelSmall: bethEllen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bevan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bevan
  static TextStyle bevan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a8b5817e572138a68db781239b935935d9304872304202f8f47a15efc226486',
        70020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '72ddb733519138fd4081143e7573fc5558d0e7ada1549dcff637c7ceba14cdf2',
        71216,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bevan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bevan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bevan
  static TextTheme bevanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bevan(textStyle: textTheme.displayLarge),
      displayMedium: bevan(textStyle: textTheme.displayMedium),
      displaySmall: bevan(textStyle: textTheme.displaySmall),
      headlineLarge: bevan(textStyle: textTheme.headlineLarge),
      headlineMedium: bevan(textStyle: textTheme.headlineMedium),
      headlineSmall: bevan(textStyle: textTheme.headlineSmall),
      titleLarge: bevan(textStyle: textTheme.titleLarge),
      titleMedium: bevan(textStyle: textTheme.titleMedium),
      titleSmall: bevan(textStyle: textTheme.titleSmall),
      bodyLarge: bevan(textStyle: textTheme.bodyLarge),
      bodyMedium: bevan(textStyle: textTheme.bodyMedium),
      bodySmall: bevan(textStyle: textTheme.bodySmall),
      labelLarge: bevan(textStyle: textTheme.labelLarge),
      labelMedium: bevan(textStyle: textTheme.labelMedium),
      labelSmall: bevan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BhuTuka Expanded One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BhuTuka+Expanded+One
  static TextStyle bhuTukaExpandedOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2eb2824cee42683348eb122be61b4f039d0425ec84a9ee7a0fad924c35e18a05',
        63848,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BhuTukaExpandedOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BhuTuka Expanded One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BhuTuka+Expanded+One
  static TextTheme bhuTukaExpandedOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bhuTukaExpandedOne(textStyle: textTheme.displayLarge),
      displayMedium: bhuTukaExpandedOne(textStyle: textTheme.displayMedium),
      displaySmall: bhuTukaExpandedOne(textStyle: textTheme.displaySmall),
      headlineLarge: bhuTukaExpandedOne(textStyle: textTheme.headlineLarge),
      headlineMedium: bhuTukaExpandedOne(textStyle: textTheme.headlineMedium),
      headlineSmall: bhuTukaExpandedOne(textStyle: textTheme.headlineSmall),
      titleLarge: bhuTukaExpandedOne(textStyle: textTheme.titleLarge),
      titleMedium: bhuTukaExpandedOne(textStyle: textTheme.titleMedium),
      titleSmall: bhuTukaExpandedOne(textStyle: textTheme.titleSmall),
      bodyLarge: bhuTukaExpandedOne(textStyle: textTheme.bodyLarge),
      bodyMedium: bhuTukaExpandedOne(textStyle: textTheme.bodyMedium),
      bodySmall: bhuTukaExpandedOne(textStyle: textTheme.bodySmall),
      labelLarge: bhuTukaExpandedOne(textStyle: textTheme.labelLarge),
      labelMedium: bhuTukaExpandedOne(textStyle: textTheme.labelMedium),
      labelSmall: bhuTukaExpandedOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Display
  static TextStyle bigShouldersDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d1f500845defdcfe5d9210d9cdd4edcd622c775cb06b943f62eb2cc0ed49cef',
        67936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7571e63af70098798eac6b5b7c5cfd73f25c42b938e3cae0d9119daa79c36528',
        68296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a9d652d65d89eceb1bbb681b480852ba7035d44929900c31a7e807567f0832f',
        68340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a47b81cc4985dd427397158e59b429816ddc32d31144a83a2d028d0be188667',
        68452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03f5cb6a57171aee80595840172ccf3afad6ce1858b75476e7d153c58d0e1e27',
        68568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e74dd3224105ad4f368e219c8ca7f52771623c91d2dd2728be7055f8db0012aa',
        68548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ecf9174209e66e1a990a6b36628e60b6f4fe49656a867336336a3ea6b59e73a0',
        68432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af0473e278f1857be7088e2210f5dedb1bd19da805d9d7b77cc07ac5cbf1f2d4',
        68604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51edca2899c7ef894b1519ebbf41e24cf3ffca17c58f50e1ca57d880aaf1ead0',
        68696,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Display
  static TextTheme bigShouldersDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bigShouldersDisplay(textStyle: textTheme.displayLarge),
      displayMedium: bigShouldersDisplay(textStyle: textTheme.displayMedium),
      displaySmall: bigShouldersDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: bigShouldersDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: bigShouldersDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: bigShouldersDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: bigShouldersDisplay(textStyle: textTheme.titleLarge),
      titleMedium: bigShouldersDisplay(textStyle: textTheme.titleMedium),
      titleSmall: bigShouldersDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: bigShouldersDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: bigShouldersDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: bigShouldersDisplay(textStyle: textTheme.bodySmall),
      labelLarge: bigShouldersDisplay(textStyle: textTheme.labelLarge),
      labelMedium: bigShouldersDisplay(textStyle: textTheme.labelMedium),
      labelSmall: bigShouldersDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Inline Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Display
  static TextStyle bigShouldersInlineDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9feefa331e73d895ae30928b3558317f0a3e12342db3ff30fab39a6c199227ab',
        117172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c21803d33445d1e4e193f948afd45756772d7e3c18f0056b57b8426204f67c89',
        117520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '907283a98dcda2f16e4fc15ddd14e2771b278e9bf6a22bb241ab52624d0c19aa',
        117520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f823d0a6cb96d9926867233ad6c93f16297cf9ed34f9815f1058d7ff92d9e068',
        118040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd533d2e0a05b3e673b2c471adbc9a7658a2ac349eeff18f0d706ce7cdff37c2d',
        118448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1dc1a0daae89b1d644455f91f26910ac21dae91b21e5bc335140081f9b96f1b0',
        118828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3ba11847f7f0914d23d9f5bf5d1919f486ad0dd4b7edfcd37dafc7143264533',
        119472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2cc196722e187db46ea65811d04763b5b7f383935527c1a279bd73e88d0ee73',
        120256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93f139c8b8335e2c5935e7c0702dbdf9827ee04cbcaede33f446808e2912395c',
        120300,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersInlineDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Inline Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Display
  static TextTheme bigShouldersInlineDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          bigShouldersInlineDisplay(textStyle: textTheme.displayLarge),
      displayMedium:
          bigShouldersInlineDisplay(textStyle: textTheme.displayMedium),
      displaySmall:
          bigShouldersInlineDisplay(textStyle: textTheme.displaySmall),
      headlineLarge:
          bigShouldersInlineDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium:
          bigShouldersInlineDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall:
          bigShouldersInlineDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: bigShouldersInlineDisplay(textStyle: textTheme.titleLarge),
      titleMedium: bigShouldersInlineDisplay(textStyle: textTheme.titleMedium),
      titleSmall: bigShouldersInlineDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: bigShouldersInlineDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: bigShouldersInlineDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: bigShouldersInlineDisplay(textStyle: textTheme.bodySmall),
      labelLarge: bigShouldersInlineDisplay(textStyle: textTheme.labelLarge),
      labelMedium: bigShouldersInlineDisplay(textStyle: textTheme.labelMedium),
      labelSmall: bigShouldersInlineDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Inline Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Text
  static TextStyle bigShouldersInlineText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc54a8d60b34cbc4fb79818d11faef1fb41fd2548b100de3bfbb882be4874f52',
        117584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29b5f15d64fa7783bcf649229e482436a5ebc5604a30e6514316230ada2e5b32',
        117948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9033b65465bbec0ff2a56b79caef02f3743400eacc02b12fc42c016b83612fe',
        118348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06dfe7f1c9a353103dc785d4f7212c9345a93252910e0e0535c8a0c223a9e14e',
        119116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef012e9f57955cb2ae2f87394ad6aac3e4a16beaff014314f394ff20b3a098a5',
        119388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd77081bc57c0fc0319603d046b88c1f11f40f9677858d61e2119c2b1dd05942',
        119720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad2fa4b5b1fe152c196448d10cefab2342a393896f4fd03968c73e6cb7340c5d',
        120160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69b589b64e0e21182db4c6cc13edabea2c97702f28a1339bc65bdbdb5580b980',
        120896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce4226d77838b082588e9a1f060f3ea71d5c9fcb5067dedf61c2346b8ea7258c',
        120648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersInlineText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Inline Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Text
  static TextTheme bigShouldersInlineTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bigShouldersInlineText(textStyle: textTheme.displayLarge),
      displayMedium: bigShouldersInlineText(textStyle: textTheme.displayMedium),
      displaySmall: bigShouldersInlineText(textStyle: textTheme.displaySmall),
      headlineLarge: bigShouldersInlineText(textStyle: textTheme.headlineLarge),
      headlineMedium:
          bigShouldersInlineText(textStyle: textTheme.headlineMedium),
      headlineSmall: bigShouldersInlineText(textStyle: textTheme.headlineSmall),
      titleLarge: bigShouldersInlineText(textStyle: textTheme.titleLarge),
      titleMedium: bigShouldersInlineText(textStyle: textTheme.titleMedium),
      titleSmall: bigShouldersInlineText(textStyle: textTheme.titleSmall),
      bodyLarge: bigShouldersInlineText(textStyle: textTheme.bodyLarge),
      bodyMedium: bigShouldersInlineText(textStyle: textTheme.bodyMedium),
      bodySmall: bigShouldersInlineText(textStyle: textTheme.bodySmall),
      labelLarge: bigShouldersInlineText(textStyle: textTheme.labelLarge),
      labelMedium: bigShouldersInlineText(textStyle: textTheme.labelMedium),
      labelSmall: bigShouldersInlineText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Stencil Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Display
  static TextStyle bigShouldersStencilDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d6aad12f9f003c320879241ef8cf6bef8067e9681b60704b86dc4ca1b9f0606',
        69944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '418cfe6a6be8aa4a0c9216ef66f205e27b167648b76b2c30a7cd184231363734',
        70508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f2a2999dacff42dea1390b7d36ea4e5a57692608670514f1897f97120675ebf',
        70660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24eb61e6d19fb89463979d0a3eee20e32a5ab050fdfca22e250ef67ff4be91a7',
        70752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c19ed0542bce96e6f4fcbfe3a474e23a52a9388dac77292810ada6191b8d784b',
        70852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac0f59d5f64346cf8670de7a96cc52a0fa5549d97a6e85c97a2202330bde8f56',
        70876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '278e6f0e873ed0c7ea1d9bd6056b3b83928df216fcbc2c9dd3e6a8c1f21aacba',
        70804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdc9f5b5fa5191e85e0c524a70a431dc79915bd7553231aad5b5f1a1a4fd4b68',
        70992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3072e4cbc627541b8134e67390a8ecb5ebbbf92b84764ddef2df9a4c57bf66d',
        71176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersStencilDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Stencil Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Display
  static TextTheme bigShouldersStencilDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          bigShouldersStencilDisplay(textStyle: textTheme.displayLarge),
      displayMedium:
          bigShouldersStencilDisplay(textStyle: textTheme.displayMedium),
      displaySmall:
          bigShouldersStencilDisplay(textStyle: textTheme.displaySmall),
      headlineLarge:
          bigShouldersStencilDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium:
          bigShouldersStencilDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall:
          bigShouldersStencilDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: bigShouldersStencilDisplay(textStyle: textTheme.titleLarge),
      titleMedium: bigShouldersStencilDisplay(textStyle: textTheme.titleMedium),
      titleSmall: bigShouldersStencilDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: bigShouldersStencilDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: bigShouldersStencilDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: bigShouldersStencilDisplay(textStyle: textTheme.bodySmall),
      labelLarge: bigShouldersStencilDisplay(textStyle: textTheme.labelLarge),
      labelMedium: bigShouldersStencilDisplay(textStyle: textTheme.labelMedium),
      labelSmall: bigShouldersStencilDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Stencil Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Text
  static TextStyle bigShouldersStencilText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b035b27ac077443fbaed666f2797dab2f87d5a5c0dad4f415e3ded8f5c2eace',
        70580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0de7c612a403f11130ca993fece2ee7398f2ce2578fa03ff27d87bb16ccb9126',
        70800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '58d5e87c836c7706bd5b1b0674a3d899ac72d624c8abccb1dd2d6ef7881456b6',
        70920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bea137d99f4b17a68cfd9be25c48eb9e33ed2a7496629c33477db73f39b5e6b3',
        70872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0001d2fef1dd3084a0369980efc2b00081d0774b7eb23ce1d1994fd4289454f4',
        70968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe2410e6a2f38b1c847fb9619ab3ea227c0067f52b28636bf75d6ba2cb40a8bc',
        70976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd7b91239af311be99e21db182ce5ff512aeeff036ec41aa40702c78d77a5c256',
        70920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fee548c51f94dd8ff81e840b58b1e114d0b72c6f164cf73d763b0bb59be630c4',
        71216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21cfc2f35075f4d024031e381d41724c040c6e5d0ab0abaaf6392c4db8083811',
        71020,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersStencilText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Stencil Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Text
  static TextTheme bigShouldersStencilTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bigShouldersStencilText(textStyle: textTheme.displayLarge),
      displayMedium:
          bigShouldersStencilText(textStyle: textTheme.displayMedium),
      displaySmall: bigShouldersStencilText(textStyle: textTheme.displaySmall),
      headlineLarge:
          bigShouldersStencilText(textStyle: textTheme.headlineLarge),
      headlineMedium:
          bigShouldersStencilText(textStyle: textTheme.headlineMedium),
      headlineSmall:
          bigShouldersStencilText(textStyle: textTheme.headlineSmall),
      titleLarge: bigShouldersStencilText(textStyle: textTheme.titleLarge),
      titleMedium: bigShouldersStencilText(textStyle: textTheme.titleMedium),
      titleSmall: bigShouldersStencilText(textStyle: textTheme.titleSmall),
      bodyLarge: bigShouldersStencilText(textStyle: textTheme.bodyLarge),
      bodyMedium: bigShouldersStencilText(textStyle: textTheme.bodyMedium),
      bodySmall: bigShouldersStencilText(textStyle: textTheme.bodySmall),
      labelLarge: bigShouldersStencilText(textStyle: textTheme.labelLarge),
      labelMedium: bigShouldersStencilText(textStyle: textTheme.labelMedium),
      labelSmall: bigShouldersStencilText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Text
  static TextStyle bigShouldersText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e652a6cffa2f84b4ebae359e7dca2106da5c061b4b6eedcaf75ab030579ba7cb',
        68232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81aa7edcc044c8fdfa243ccc0e59dee975f82f316e51c2fb8fc337d673842f12',
        68552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21856e5f93faaa488eaa5f82b47829dfafbbfe8e11aa3f6c3f19dc6d1d61649c',
        68612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69dec529ebee00b15a789dd999c7cc2c607be7590ff9ec306eabd089bb0cc5c3',
        68652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb6030058e93f9e54eb293c71a64f280a98d1e5cd30d2ecabb0bbf0e9159d6e6',
        68652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc5cd43d945caf1a422f43dea6cc5ff62c337b85e4f501bf75d50a8acf6c0587',
        68664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d35a47d814d1d06d33e50149ce22ffaa06528fe505286a9bfdfa0fd50142a57',
        68496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e5e69b17a07d422c77869f4ebbf6b04d647a2db3bf99b820be0ada1b5482a4f1',
        68792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '495505c62abf173dd30bfc126ce9a9b932f5172350c48347b3076d6c2eeea1f3',
        68560,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Text
  static TextTheme bigShouldersTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bigShouldersText(textStyle: textTheme.displayLarge),
      displayMedium: bigShouldersText(textStyle: textTheme.displayMedium),
      displaySmall: bigShouldersText(textStyle: textTheme.displaySmall),
      headlineLarge: bigShouldersText(textStyle: textTheme.headlineLarge),
      headlineMedium: bigShouldersText(textStyle: textTheme.headlineMedium),
      headlineSmall: bigShouldersText(textStyle: textTheme.headlineSmall),
      titleLarge: bigShouldersText(textStyle: textTheme.titleLarge),
      titleMedium: bigShouldersText(textStyle: textTheme.titleMedium),
      titleSmall: bigShouldersText(textStyle: textTheme.titleSmall),
      bodyLarge: bigShouldersText(textStyle: textTheme.bodyLarge),
      bodyMedium: bigShouldersText(textStyle: textTheme.bodyMedium),
      bodySmall: bigShouldersText(textStyle: textTheme.bodySmall),
      labelLarge: bigShouldersText(textStyle: textTheme.labelLarge),
      labelMedium: bigShouldersText(textStyle: textTheme.labelMedium),
      labelSmall: bigShouldersText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bigelow Rules font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigelow+Rules
  static TextStyle bigelowRules({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a62c6e3152496d73b77afec95caaae2121da662cd31ae0171bc1187e471cf58',
        56704,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigelowRules',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bigelow Rules font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigelow+Rules
  static TextTheme bigelowRulesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bigelowRules(textStyle: textTheme.displayLarge),
      displayMedium: bigelowRules(textStyle: textTheme.displayMedium),
      displaySmall: bigelowRules(textStyle: textTheme.displaySmall),
      headlineLarge: bigelowRules(textStyle: textTheme.headlineLarge),
      headlineMedium: bigelowRules(textStyle: textTheme.headlineMedium),
      headlineSmall: bigelowRules(textStyle: textTheme.headlineSmall),
      titleLarge: bigelowRules(textStyle: textTheme.titleLarge),
      titleMedium: bigelowRules(textStyle: textTheme.titleMedium),
      titleSmall: bigelowRules(textStyle: textTheme.titleSmall),
      bodyLarge: bigelowRules(textStyle: textTheme.bodyLarge),
      bodyMedium: bigelowRules(textStyle: textTheme.bodyMedium),
      bodySmall: bigelowRules(textStyle: textTheme.bodySmall),
      labelLarge: bigelowRules(textStyle: textTheme.labelLarge),
      labelMedium: bigelowRules(textStyle: textTheme.labelMedium),
      labelSmall: bigelowRules(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bigshot One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigshot+One
  static TextStyle bigshotOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b76bb5317fd3b7b99dc5ff17dbe492388438f36e8ee8348c2ae3ab4d7e1303f',
        34916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigshotOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bigshot One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigshot+One
  static TextTheme bigshotOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bigshotOne(textStyle: textTheme.displayLarge),
      displayMedium: bigshotOne(textStyle: textTheme.displayMedium),
      displaySmall: bigshotOne(textStyle: textTheme.displaySmall),
      headlineLarge: bigshotOne(textStyle: textTheme.headlineLarge),
      headlineMedium: bigshotOne(textStyle: textTheme.headlineMedium),
      headlineSmall: bigshotOne(textStyle: textTheme.headlineSmall),
      titleLarge: bigshotOne(textStyle: textTheme.titleLarge),
      titleMedium: bigshotOne(textStyle: textTheme.titleMedium),
      titleSmall: bigshotOne(textStyle: textTheme.titleSmall),
      bodyLarge: bigshotOne(textStyle: textTheme.bodyLarge),
      bodyMedium: bigshotOne(textStyle: textTheme.bodyMedium),
      bodySmall: bigshotOne(textStyle: textTheme.bodySmall),
      labelLarge: bigshotOne(textStyle: textTheme.labelLarge),
      labelMedium: bigshotOne(textStyle: textTheme.labelMedium),
      labelSmall: bigshotOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bilbo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo
  static TextStyle bilbo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0174301b7104430b8e205fe4a1d0a4b2986563fccb28c8f9720ffd796e1504b7',
        61336,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bilbo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bilbo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo
  static TextTheme bilboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bilbo(textStyle: textTheme.displayLarge),
      displayMedium: bilbo(textStyle: textTheme.displayMedium),
      displaySmall: bilbo(textStyle: textTheme.displaySmall),
      headlineLarge: bilbo(textStyle: textTheme.headlineLarge),
      headlineMedium: bilbo(textStyle: textTheme.headlineMedium),
      headlineSmall: bilbo(textStyle: textTheme.headlineSmall),
      titleLarge: bilbo(textStyle: textTheme.titleLarge),
      titleMedium: bilbo(textStyle: textTheme.titleMedium),
      titleSmall: bilbo(textStyle: textTheme.titleSmall),
      bodyLarge: bilbo(textStyle: textTheme.bodyLarge),
      bodyMedium: bilbo(textStyle: textTheme.bodyMedium),
      bodySmall: bilbo(textStyle: textTheme.bodySmall),
      labelLarge: bilbo(textStyle: textTheme.labelLarge),
      labelMedium: bilbo(textStyle: textTheme.labelMedium),
      labelSmall: bilbo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bilbo Swash Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo+Swash+Caps
  static TextStyle bilboSwashCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '827a279b346b5d528b5720ab1c184e7234eb24ae26c68624704db247f3c2ad05',
        56284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BilboSwashCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bilbo Swash Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo+Swash+Caps
  static TextTheme bilboSwashCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bilboSwashCaps(textStyle: textTheme.displayLarge),
      displayMedium: bilboSwashCaps(textStyle: textTheme.displayMedium),
      displaySmall: bilboSwashCaps(textStyle: textTheme.displaySmall),
      headlineLarge: bilboSwashCaps(textStyle: textTheme.headlineLarge),
      headlineMedium: bilboSwashCaps(textStyle: textTheme.headlineMedium),
      headlineSmall: bilboSwashCaps(textStyle: textTheme.headlineSmall),
      titleLarge: bilboSwashCaps(textStyle: textTheme.titleLarge),
      titleMedium: bilboSwashCaps(textStyle: textTheme.titleMedium),
      titleSmall: bilboSwashCaps(textStyle: textTheme.titleSmall),
      bodyLarge: bilboSwashCaps(textStyle: textTheme.bodyLarge),
      bodyMedium: bilboSwashCaps(textStyle: textTheme.bodyMedium),
      bodySmall: bilboSwashCaps(textStyle: textTheme.bodySmall),
      labelLarge: bilboSwashCaps(textStyle: textTheme.labelLarge),
      labelMedium: bilboSwashCaps(textStyle: textTheme.labelMedium),
      labelSmall: bilboSwashCaps(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BioRhyme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme
  static TextStyle bioRhyme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81084bf464db73e007ce7b06a1cbad857fda75c19aa0947454112dcd9c98bae3',
        61072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '935a630903c3663b1c81ed5744c25adb63530e07b19dc9f0be39c0e4dce4e8dc',
        61136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34ec74b985920e61f2f53e04104dd846cd0b8a295f892efe27be4214b718bf10',
        61816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cffd283ee01e69cd12c7b3ec7337d7c2d1d812e16fe94e96e47bc97c6192a729',
        61788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9eb47f3543be8af49a838cca31e915694d038dd9b97425e3236b12ce9ca6fe1e',
        61836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4fb16a55453ea2dd810374d6f532beed8dff33bafe4ee251fda6faa7f333407f',
        61804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'abe2e2c56584f424340becfa1e91346529e38867e555e59129b1e37719fb4f2c',
        61836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BioRhyme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BioRhyme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme
  static TextTheme bioRhymeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bioRhyme(textStyle: textTheme.displayLarge),
      displayMedium: bioRhyme(textStyle: textTheme.displayMedium),
      displaySmall: bioRhyme(textStyle: textTheme.displaySmall),
      headlineLarge: bioRhyme(textStyle: textTheme.headlineLarge),
      headlineMedium: bioRhyme(textStyle: textTheme.headlineMedium),
      headlineSmall: bioRhyme(textStyle: textTheme.headlineSmall),
      titleLarge: bioRhyme(textStyle: textTheme.titleLarge),
      titleMedium: bioRhyme(textStyle: textTheme.titleMedium),
      titleSmall: bioRhyme(textStyle: textTheme.titleSmall),
      bodyLarge: bioRhyme(textStyle: textTheme.bodyLarge),
      bodyMedium: bioRhyme(textStyle: textTheme.bodyMedium),
      bodySmall: bioRhyme(textStyle: textTheme.bodySmall),
      labelLarge: bioRhyme(textStyle: textTheme.labelLarge),
      labelMedium: bioRhyme(textStyle: textTheme.labelMedium),
      labelSmall: bioRhyme(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BioRhyme Expanded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme+Expanded
  static TextStyle bioRhymeExpanded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2071cec482a9783c195d77866765d56940a190d735007e6cd8c7e536cba023fc',
        52348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd3923ba01a6590de5f4999cd73ffad4a174c0c171e960f67df8f852dd1358604',
        54200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c995926adfa020b905f55f7eae5312d137453219e53e3635ed79f8f146d4c58',
        53728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b4cd7dd9cf59404e36b9eec0b59f7f7fad19a0fa7fafb43a92b50b6dc5fa769',
        53712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eaac79ed7ba0790de324a089fbaeb119c550d7ae6b2adc2e900e636b9e51b02f',
        53068,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BioRhymeExpanded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BioRhyme Expanded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme+Expanded
  static TextTheme bioRhymeExpandedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bioRhymeExpanded(textStyle: textTheme.displayLarge),
      displayMedium: bioRhymeExpanded(textStyle: textTheme.displayMedium),
      displaySmall: bioRhymeExpanded(textStyle: textTheme.displaySmall),
      headlineLarge: bioRhymeExpanded(textStyle: textTheme.headlineLarge),
      headlineMedium: bioRhymeExpanded(textStyle: textTheme.headlineMedium),
      headlineSmall: bioRhymeExpanded(textStyle: textTheme.headlineSmall),
      titleLarge: bioRhymeExpanded(textStyle: textTheme.titleLarge),
      titleMedium: bioRhymeExpanded(textStyle: textTheme.titleMedium),
      titleSmall: bioRhymeExpanded(textStyle: textTheme.titleSmall),
      bodyLarge: bioRhymeExpanded(textStyle: textTheme.bodyLarge),
      bodyMedium: bioRhymeExpanded(textStyle: textTheme.bodyMedium),
      bodySmall: bioRhymeExpanded(textStyle: textTheme.bodySmall),
      labelLarge: bioRhymeExpanded(textStyle: textTheme.labelLarge),
      labelMedium: bioRhymeExpanded(textStyle: textTheme.labelMedium),
      labelSmall: bioRhymeExpanded(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Birthstone font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone
  static TextStyle birthstone({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1ed63fae9856976d961f366cfde87937c638a65e1788e3f334823e7fbc1ced7',
        97192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Birthstone',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Birthstone font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone
  static TextTheme birthstoneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: birthstone(textStyle: textTheme.displayLarge),
      displayMedium: birthstone(textStyle: textTheme.displayMedium),
      displaySmall: birthstone(textStyle: textTheme.displaySmall),
      headlineLarge: birthstone(textStyle: textTheme.headlineLarge),
      headlineMedium: birthstone(textStyle: textTheme.headlineMedium),
      headlineSmall: birthstone(textStyle: textTheme.headlineSmall),
      titleLarge: birthstone(textStyle: textTheme.titleLarge),
      titleMedium: birthstone(textStyle: textTheme.titleMedium),
      titleSmall: birthstone(textStyle: textTheme.titleSmall),
      bodyLarge: birthstone(textStyle: textTheme.bodyLarge),
      bodyMedium: birthstone(textStyle: textTheme.bodyMedium),
      bodySmall: birthstone(textStyle: textTheme.bodySmall),
      labelLarge: birthstone(textStyle: textTheme.labelLarge),
      labelMedium: birthstone(textStyle: textTheme.labelMedium),
      labelSmall: birthstone(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Birthstone Bounce font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone+Bounce
  static TextStyle birthstoneBounce({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '250a7a7b6807198acb102ecf9b4a87609900e9e72491da1cc5286b939ea937f0',
        131964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dcc33c2ec2003077a86bad29b8822d2f7aa527a1cc6cc5b146994f9d2ef3e64f',
        129328,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BirthstoneBounce',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Birthstone Bounce font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone+Bounce
  static TextTheme birthstoneBounceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: birthstoneBounce(textStyle: textTheme.displayLarge),
      displayMedium: birthstoneBounce(textStyle: textTheme.displayMedium),
      displaySmall: birthstoneBounce(textStyle: textTheme.displaySmall),
      headlineLarge: birthstoneBounce(textStyle: textTheme.headlineLarge),
      headlineMedium: birthstoneBounce(textStyle: textTheme.headlineMedium),
      headlineSmall: birthstoneBounce(textStyle: textTheme.headlineSmall),
      titleLarge: birthstoneBounce(textStyle: textTheme.titleLarge),
      titleMedium: birthstoneBounce(textStyle: textTheme.titleMedium),
      titleSmall: birthstoneBounce(textStyle: textTheme.titleSmall),
      bodyLarge: birthstoneBounce(textStyle: textTheme.bodyLarge),
      bodyMedium: birthstoneBounce(textStyle: textTheme.bodyMedium),
      bodySmall: birthstoneBounce(textStyle: textTheme.bodySmall),
      labelLarge: birthstoneBounce(textStyle: textTheme.labelLarge),
      labelMedium: birthstoneBounce(textStyle: textTheme.labelMedium),
      labelSmall: birthstoneBounce(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Biryani font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Biryani
  static TextStyle biryani({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e7dcec71c8253473d19a2c3d1de421262308136b9214f475718d265bd9ffc1a',
        116780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e57ece68a386e84e678522598d31f5a19d88072f68a6692998097cbea121afbb',
        117180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c55ac2d7c724034dc3579a4eeeb05d782e0eefe97cf34cdb97290ed1f10e4b6b',
        116488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37d035dd717b7dbd22491fbbda7503213a8e1ccc2133a8acdda1606fa97a58fe',
        116460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f245fc809af34283afedd64b5598a9cd97ef9ca446c6cdd76794d738c67a23da',
        116280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '540e82650fb8d83eaeaf29f6c5130af4191caefbdac343eb7961a3410d4143b9',
        116244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7bf8aab125d9bb490cb552060c2a7cae508ba90769a9071e34c1f4396319ec0e',
        115348,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Biryani',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Biryani font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Biryani
  static TextTheme biryaniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: biryani(textStyle: textTheme.displayLarge),
      displayMedium: biryani(textStyle: textTheme.displayMedium),
      displaySmall: biryani(textStyle: textTheme.displaySmall),
      headlineLarge: biryani(textStyle: textTheme.headlineLarge),
      headlineMedium: biryani(textStyle: textTheme.headlineMedium),
      headlineSmall: biryani(textStyle: textTheme.headlineSmall),
      titleLarge: biryani(textStyle: textTheme.titleLarge),
      titleMedium: biryani(textStyle: textTheme.titleMedium),
      titleSmall: biryani(textStyle: textTheme.titleSmall),
      bodyLarge: biryani(textStyle: textTheme.bodyLarge),
      bodyMedium: biryani(textStyle: textTheme.bodyMedium),
      bodySmall: biryani(textStyle: textTheme.bodySmall),
      labelLarge: biryani(textStyle: textTheme.labelLarge),
      labelMedium: biryani(textStyle: textTheme.labelMedium),
      labelSmall: biryani(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bitter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bitter
  static TextStyle bitter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7cf79904fbe25afa25837192a1369cc2ad3950ebe746cae686159e80d3ce1f12',
        145604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3452a0595c9e22ee70076d82c12302f0105d6e7c9ae89225b5e14e3581ded6d',
        146664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c30bd77a571a0143c6daafd0706a5f4cb02b0cfa9f6c8f4551a8b6e40362b357',
        146692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'afc82afd7c355389d78304edcb79ee2c689bded97006a5fb0dc5536b487b9bcd',
        146684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6729eba0a609beefec7ed9c6dc8f585f7b50e677b307d218e1edddb167857180',
        146836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9d4293c997e1b0939ebb042374b661c26128ca0303f2288a2eeb49fe30fe087',
        147116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5cc3807125a7d68a9ae06ceed003c021b9219912dafbaec22fc75c10a4d622c7',
        148120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a3aa69867503f9a24db970bbd21331f93356b18fe925118c68edeae6318e667f',
        155808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d15a412ca54e54f4bb6b31cd4976d2811be9a243d6e4c54c2a59e225eee4668',
        155560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e9bee69fe8917bc6b8b8ba082bc81c66e70ba6ee3155f13677bb75e6b5f9e9cd',
        144736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '78b4d33ab9a75aeb121887fe5e4a3be351810b732503db50ae2f66830452660d',
        145296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3e885e6ddf67aa99be9148fe357207f011f34df9eabf086ba0bd314710fc548a',
        145248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a1c05fd03ddabfca820b00eadf979529f5b14c44ad8df81988fb073cf4a7e901',
        145132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'daef71b92f9e9c433abcdceb8a01d23dc748d8f5a6b513d12281c1075287df59',
        145320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '380ec7e918714f6394037b31253ea1d0b07abc15dc3a0b483788fbfb05788489',
        145524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '008c09a95ec38fbcdd256f48aad827d9888ce7031c29c86495ab2790309f4523',
        146336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ffea3c5890caaaba78084239f5020cf1fe37dec93765d89f0fb3e9451790c93d',
        148004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cdb33fceade17bf62accb10090febc75ac99d7c9fa942ed5e7eed6dac7d038c5',
        147940,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bitter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bitter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bitter
  static TextTheme bitterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bitter(textStyle: textTheme.displayLarge),
      displayMedium: bitter(textStyle: textTheme.displayMedium),
      displaySmall: bitter(textStyle: textTheme.displaySmall),
      headlineLarge: bitter(textStyle: textTheme.headlineLarge),
      headlineMedium: bitter(textStyle: textTheme.headlineMedium),
      headlineSmall: bitter(textStyle: textTheme.headlineSmall),
      titleLarge: bitter(textStyle: textTheme.titleLarge),
      titleMedium: bitter(textStyle: textTheme.titleMedium),
      titleSmall: bitter(textStyle: textTheme.titleSmall),
      bodyLarge: bitter(textStyle: textTheme.bodyLarge),
      bodyMedium: bitter(textStyle: textTheme.bodyMedium),
      bodySmall: bitter(textStyle: textTheme.bodySmall),
      labelLarge: bitter(textStyle: textTheme.labelLarge),
      labelMedium: bitter(textStyle: textTheme.labelMedium),
      labelSmall: bitter(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Black And White Picture font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+And+White+Picture
  static TextStyle blackAndWhitePicture({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41b804166231efabea2d0dcc480c6a23353fb0dd79ca3139f66667ef061ba8b2',
        9586668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackAndWhitePicture',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black And White Picture font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+And+White+Picture
  static TextTheme blackAndWhitePictureTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: blackAndWhitePicture(textStyle: textTheme.displayLarge),
      displayMedium: blackAndWhitePicture(textStyle: textTheme.displayMedium),
      displaySmall: blackAndWhitePicture(textStyle: textTheme.displaySmall),
      headlineLarge: blackAndWhitePicture(textStyle: textTheme.headlineLarge),
      headlineMedium: blackAndWhitePicture(textStyle: textTheme.headlineMedium),
      headlineSmall: blackAndWhitePicture(textStyle: textTheme.headlineSmall),
      titleLarge: blackAndWhitePicture(textStyle: textTheme.titleLarge),
      titleMedium: blackAndWhitePicture(textStyle: textTheme.titleMedium),
      titleSmall: blackAndWhitePicture(textStyle: textTheme.titleSmall),
      bodyLarge: blackAndWhitePicture(textStyle: textTheme.bodyLarge),
      bodyMedium: blackAndWhitePicture(textStyle: textTheme.bodyMedium),
      bodySmall: blackAndWhitePicture(textStyle: textTheme.bodySmall),
      labelLarge: blackAndWhitePicture(textStyle: textTheme.labelLarge),
      labelMedium: blackAndWhitePicture(textStyle: textTheme.labelMedium),
      labelSmall: blackAndWhitePicture(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Black Han Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Han+Sans
  static TextStyle blackHanSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '026c2368de54948fd1cfcff0b321fe178f863e0206fa4bc791721cdfa2fc6a60',
        382948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackHanSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black Han Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Han+Sans
  static TextTheme blackHanSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: blackHanSans(textStyle: textTheme.displayLarge),
      displayMedium: blackHanSans(textStyle: textTheme.displayMedium),
      displaySmall: blackHanSans(textStyle: textTheme.displaySmall),
      headlineLarge: blackHanSans(textStyle: textTheme.headlineLarge),
      headlineMedium: blackHanSans(textStyle: textTheme.headlineMedium),
      headlineSmall: blackHanSans(textStyle: textTheme.headlineSmall),
      titleLarge: blackHanSans(textStyle: textTheme.titleLarge),
      titleMedium: blackHanSans(textStyle: textTheme.titleMedium),
      titleSmall: blackHanSans(textStyle: textTheme.titleSmall),
      bodyLarge: blackHanSans(textStyle: textTheme.bodyLarge),
      bodyMedium: blackHanSans(textStyle: textTheme.bodyMedium),
      bodySmall: blackHanSans(textStyle: textTheme.bodySmall),
      labelLarge: blackHanSans(textStyle: textTheme.labelLarge),
      labelMedium: blackHanSans(textStyle: textTheme.labelMedium),
      labelSmall: blackHanSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Black Ops One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Ops+One
  static TextStyle blackOpsOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd97a30390c4621a6185451bc74c97956f7fc43a0f1dea09251d8ade7d5304640',
        131076,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackOpsOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black Ops One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Ops+One
  static TextTheme blackOpsOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: blackOpsOne(textStyle: textTheme.displayLarge),
      displayMedium: blackOpsOne(textStyle: textTheme.displayMedium),
      displaySmall: blackOpsOne(textStyle: textTheme.displaySmall),
      headlineLarge: blackOpsOne(textStyle: textTheme.headlineLarge),
      headlineMedium: blackOpsOne(textStyle: textTheme.headlineMedium),
      headlineSmall: blackOpsOne(textStyle: textTheme.headlineSmall),
      titleLarge: blackOpsOne(textStyle: textTheme.titleLarge),
      titleMedium: blackOpsOne(textStyle: textTheme.titleMedium),
      titleSmall: blackOpsOne(textStyle: textTheme.titleSmall),
      bodyLarge: blackOpsOne(textStyle: textTheme.bodyLarge),
      bodyMedium: blackOpsOne(textStyle: textTheme.bodyMedium),
      bodySmall: blackOpsOne(textStyle: textTheme.bodySmall),
      labelLarge: blackOpsOne(textStyle: textTheme.labelLarge),
      labelMedium: blackOpsOne(textStyle: textTheme.labelMedium),
      labelSmall: blackOpsOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Blaka font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blaka
  static TextStyle blaka({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af21b2a6f52d22c5b152f3a7b71e2ed36a36941bf7bd843eb9cae65eb17269f7',
        41412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Blaka',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Blaka font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blaka
  static TextTheme blakaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: blaka(textStyle: textTheme.displayLarge),
      displayMedium: blaka(textStyle: textTheme.displayMedium),
      displaySmall: blaka(textStyle: textTheme.displaySmall),
      headlineLarge: blaka(textStyle: textTheme.headlineLarge),
      headlineMedium: blaka(textStyle: textTheme.headlineMedium),
      headlineSmall: blaka(textStyle: textTheme.headlineSmall),
      titleLarge: blaka(textStyle: textTheme.titleLarge),
      titleMedium: blaka(textStyle: textTheme.titleMedium),
      titleSmall: blaka(textStyle: textTheme.titleSmall),
      bodyLarge: blaka(textStyle: textTheme.bodyLarge),
      bodyMedium: blaka(textStyle: textTheme.bodyMedium),
      bodySmall: blaka(textStyle: textTheme.bodySmall),
      labelLarge: blaka(textStyle: textTheme.labelLarge),
      labelMedium: blaka(textStyle: textTheme.labelMedium),
      labelSmall: blaka(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Blaka Hollow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blaka+Hollow
  static TextStyle blakaHollow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c14889811201e30f0160c0c1d99ed80a957377f5a0c89ff04da5a77237456785',
        52952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlakaHollow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Blaka Hollow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blaka+Hollow
  static TextTheme blakaHollowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: blakaHollow(textStyle: textTheme.displayLarge),
      displayMedium: blakaHollow(textStyle: textTheme.displayMedium),
      displaySmall: blakaHollow(textStyle: textTheme.displaySmall),
      headlineLarge: blakaHollow(textStyle: textTheme.headlineLarge),
      headlineMedium: blakaHollow(textStyle: textTheme.headlineMedium),
      headlineSmall: blakaHollow(textStyle: textTheme.headlineSmall),
      titleLarge: blakaHollow(textStyle: textTheme.titleLarge),
      titleMedium: blakaHollow(textStyle: textTheme.titleMedium),
      titleSmall: blakaHollow(textStyle: textTheme.titleSmall),
      bodyLarge: blakaHollow(textStyle: textTheme.bodyLarge),
      bodyMedium: blakaHollow(textStyle: textTheme.bodyMedium),
      bodySmall: blakaHollow(textStyle: textTheme.bodySmall),
      labelLarge: blakaHollow(textStyle: textTheme.labelLarge),
      labelMedium: blakaHollow(textStyle: textTheme.labelMedium),
      labelSmall: blakaHollow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Blaka Ink font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blaka+Ink
  static TextStyle blakaInk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c86900a5af38799063c0b7b28cd169c9086a31d1961257e3723ba65205fe321',
        367116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlakaInk',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Blaka Ink font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blaka+Ink
  static TextTheme blakaInkTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: blakaInk(textStyle: textTheme.displayLarge),
      displayMedium: blakaInk(textStyle: textTheme.displayMedium),
      displaySmall: blakaInk(textStyle: textTheme.displaySmall),
      headlineLarge: blakaInk(textStyle: textTheme.headlineLarge),
      headlineMedium: blakaInk(textStyle: textTheme.headlineMedium),
      headlineSmall: blakaInk(textStyle: textTheme.headlineSmall),
      titleLarge: blakaInk(textStyle: textTheme.titleLarge),
      titleMedium: blakaInk(textStyle: textTheme.titleMedium),
      titleSmall: blakaInk(textStyle: textTheme.titleSmall),
      bodyLarge: blakaInk(textStyle: textTheme.bodyLarge),
      bodyMedium: blakaInk(textStyle: textTheme.bodyMedium),
      bodySmall: blakaInk(textStyle: textTheme.bodySmall),
      labelLarge: blakaInk(textStyle: textTheme.labelLarge),
      labelMedium: blakaInk(textStyle: textTheme.labelMedium),
      labelSmall: blakaInk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Blinker font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blinker
  static TextStyle blinker({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70cda2a3be45ad2cfc4fce3f02c9fb49fa6036674fa911da5edfd2e6ab9194ed',
        48360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68395b402c7e5dd97bef235fa3ebb781798b885a607f82097ffc21d9998a4dbc',
        49784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1ddd07308d2eafa097914827e5e560c1008d54786afe03c98baaf1a03d7a0e4',
        49632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aba089cb0cf5b2715ebc8977e04464b6e018fbde24957fc76585b33a2e50d88b',
        48848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0eaca7103ebcbbb79acfd6b4d43e9f41766441925e2e196b1d7306b79c3c4a31',
        54592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16effec8257a788af0494d72d1561370e8b71a38d30f84c93937a63a8b2c93da',
        50068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6aa48a1fc6ffffc66a2202248381c493cd9db369b885fd9bcded75829a399d2',
        54240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '675e3bf1d97194fb60db3bac63f0ff1661cb47a59bb7e976cd8d11f142258d7f',
        53496,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Blinker',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Blinker font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blinker
  static TextTheme blinkerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: blinker(textStyle: textTheme.displayLarge),
      displayMedium: blinker(textStyle: textTheme.displayMedium),
      displaySmall: blinker(textStyle: textTheme.displaySmall),
      headlineLarge: blinker(textStyle: textTheme.headlineLarge),
      headlineMedium: blinker(textStyle: textTheme.headlineMedium),
      headlineSmall: blinker(textStyle: textTheme.headlineSmall),
      titleLarge: blinker(textStyle: textTheme.titleLarge),
      titleMedium: blinker(textStyle: textTheme.titleMedium),
      titleSmall: blinker(textStyle: textTheme.titleSmall),
      bodyLarge: blinker(textStyle: textTheme.bodyLarge),
      bodyMedium: blinker(textStyle: textTheme.bodyMedium),
      bodySmall: blinker(textStyle: textTheme.bodySmall),
      labelLarge: blinker(textStyle: textTheme.labelLarge),
      labelMedium: blinker(textStyle: textTheme.labelMedium),
      labelSmall: blinker(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bodoni Moda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bodoni+Moda
  static TextStyle bodoniModa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f9687c634dd9f186df211a5f35129493f54a9f5c763db4cd9486ddbbb013664',
        44728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7bdd02e9c1050982f3d1121ef070163b85053a3a31b81a2710bde3b9839f7bcf',
        44820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa97032e0c9c9ea7da6b1d7ad21e83a427c7fb3992f132c89969df402e457356',
        44856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e693ced998c412606de6925b0d5245cad12e0f175bd8c38b6bc9a0f3260ff26',
        44816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '333022ae4df716a6ba22f819a86c84b2e0f84ec48c144c204dffa2369f450a08',
        44904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ab1fe17411714d2418bb7c91a80882839d10ea2e2e3ea2039ce796a88db6b78',
        44856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bf4e514961fb8c6fb962f83658987cb525656123e17ba94b5ca3cf72d9ce793c',
        47532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a709b8c8f2b767afbd54db3afc85757d9797f5c73f2a078cd49c60167fe4737',
        47684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3ad1966f60bd7338c6e0ddc4d470a53f851f04844f1dc243bccb3e413f1ce6f3',
        47760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '62eaac85a946bea79fa3f4c5868deb6368bb0dd1ffbc44c59a48a1774b8f0a5f',
        47700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '00001f359b9bb8f528fd74bd578163d7b30aec304e1f922db73d7c0375622ca1',
        47848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '17fbfbe4c9d1c625aa3f4ce022090c943b7dfcb1554a6d9893f1485ef22c27b6',
        47812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BodoniModa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bodoni Moda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bodoni+Moda
  static TextTheme bodoniModaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bodoniModa(textStyle: textTheme.displayLarge),
      displayMedium: bodoniModa(textStyle: textTheme.displayMedium),
      displaySmall: bodoniModa(textStyle: textTheme.displaySmall),
      headlineLarge: bodoniModa(textStyle: textTheme.headlineLarge),
      headlineMedium: bodoniModa(textStyle: textTheme.headlineMedium),
      headlineSmall: bodoniModa(textStyle: textTheme.headlineSmall),
      titleLarge: bodoniModa(textStyle: textTheme.titleLarge),
      titleMedium: bodoniModa(textStyle: textTheme.titleMedium),
      titleSmall: bodoniModa(textStyle: textTheme.titleSmall),
      bodyLarge: bodoniModa(textStyle: textTheme.bodyLarge),
      bodyMedium: bodoniModa(textStyle: textTheme.bodyMedium),
      bodySmall: bodoniModa(textStyle: textTheme.bodySmall),
      labelLarge: bodoniModa(textStyle: textTheme.labelLarge),
      labelMedium: bodoniModa(textStyle: textTheme.labelMedium),
      labelSmall: bodoniModa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bodoni Moda SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bodoni+Moda+SC
  static TextStyle bodoniModaSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a8874163f42b8ac24467bf21daf54966d02f70fc570f026d4dac6fce95a70d8',
        52328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd65d3aa9b596f22eceb118c5e34c78a8ebe42be00b2e3930be4b841502af256',
        52432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a278c6a13c9aa5ec502c30cfe86a4b7efd0bf02e68a15ab50fe47965210e0f35',
        52496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd15226f3c133ed4992ec6dbdaeeaed911511183f981f2d2f907fbca81c06a9bd',
        52476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67bbd2811b21ab45f2b014d6f89cf41695e137c99eb37d29570c5b99092a4b13',
        52572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30d0acd22d905ac7f2b714921304d5958598a6a20b1036d88cbecdad2dfadb87',
        52520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '704389a198c3b976feb1971cf3ce7ae3aa8fc98dbed3bfde45a137ce73e8c60d',
        55704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ebd645f6020e23e0ae70ea041b0dc20433db948a377ee4bb83f1000a2b04161f',
        55856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9e263acfccccaa522cc770ba9b7c2b426284666958a6fdebe3a9f5056e530d97',
        55968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cb7b98471aac8e038255bdbf2257ef9f9e990b74d246919e06553018725a9945',
        55908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f89e420a25f441b4174fbbfd3d152e1b5bde6328e1219dcd6d74398c8722b6a3',
        56028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a5f64145693eaf4de88cd1c4f75f9067f7763bf436872cf374ffe3f587e45dad',
        56024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BodoniModaSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bodoni Moda SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bodoni+Moda+SC
  static TextTheme bodoniModaScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bodoniModaSc(textStyle: textTheme.displayLarge),
      displayMedium: bodoniModaSc(textStyle: textTheme.displayMedium),
      displaySmall: bodoniModaSc(textStyle: textTheme.displaySmall),
      headlineLarge: bodoniModaSc(textStyle: textTheme.headlineLarge),
      headlineMedium: bodoniModaSc(textStyle: textTheme.headlineMedium),
      headlineSmall: bodoniModaSc(textStyle: textTheme.headlineSmall),
      titleLarge: bodoniModaSc(textStyle: textTheme.titleLarge),
      titleMedium: bodoniModaSc(textStyle: textTheme.titleMedium),
      titleSmall: bodoniModaSc(textStyle: textTheme.titleSmall),
      bodyLarge: bodoniModaSc(textStyle: textTheme.bodyLarge),
      bodyMedium: bodoniModaSc(textStyle: textTheme.bodyMedium),
      bodySmall: bodoniModaSc(textStyle: textTheme.bodySmall),
      labelLarge: bodoniModaSc(textStyle: textTheme.labelLarge),
      labelMedium: bodoniModaSc(textStyle: textTheme.labelMedium),
      labelSmall: bodoniModaSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bokor font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bokor
  static TextStyle bokor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48dc3bbb53942fe0f1dcda871b0b6600f23c80b68ea80345c182f17f10e36639',
        75392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bokor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bokor font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bokor
  static TextTheme bokorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bokor(textStyle: textTheme.displayLarge),
      displayMedium: bokor(textStyle: textTheme.displayMedium),
      displaySmall: bokor(textStyle: textTheme.displaySmall),
      headlineLarge: bokor(textStyle: textTheme.headlineLarge),
      headlineMedium: bokor(textStyle: textTheme.headlineMedium),
      headlineSmall: bokor(textStyle: textTheme.headlineSmall),
      titleLarge: bokor(textStyle: textTheme.titleLarge),
      titleMedium: bokor(textStyle: textTheme.titleMedium),
      titleSmall: bokor(textStyle: textTheme.titleSmall),
      bodyLarge: bokor(textStyle: textTheme.bodyLarge),
      bodyMedium: bokor(textStyle: textTheme.bodyMedium),
      bodySmall: bokor(textStyle: textTheme.bodySmall),
      labelLarge: bokor(textStyle: textTheme.labelLarge),
      labelMedium: bokor(textStyle: textTheme.labelMedium),
      labelSmall: bokor(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bona Nova font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bona+Nova
  static TextStyle bonaNova({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '078d2bfcfc80d682132d953545812db70e0f9f0b98ae0cac142ea71b158d1318',
        198112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f09688cecf4b8ba9818a169e25b836f04679a229109cb520cc95adef6e6ad81d',
        215808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43adb619f6b73f11f25abeeb80e1afc75285c402742402228abf38595b558505',
        196232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BonaNova',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bona Nova font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bona+Nova
  static TextTheme bonaNovaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bonaNova(textStyle: textTheme.displayLarge),
      displayMedium: bonaNova(textStyle: textTheme.displayMedium),
      displaySmall: bonaNova(textStyle: textTheme.displaySmall),
      headlineLarge: bonaNova(textStyle: textTheme.headlineLarge),
      headlineMedium: bonaNova(textStyle: textTheme.headlineMedium),
      headlineSmall: bonaNova(textStyle: textTheme.headlineSmall),
      titleLarge: bonaNova(textStyle: textTheme.titleLarge),
      titleMedium: bonaNova(textStyle: textTheme.titleMedium),
      titleSmall: bonaNova(textStyle: textTheme.titleSmall),
      bodyLarge: bonaNova(textStyle: textTheme.bodyLarge),
      bodyMedium: bonaNova(textStyle: textTheme.bodyMedium),
      bodySmall: bonaNova(textStyle: textTheme.bodySmall),
      labelLarge: bonaNova(textStyle: textTheme.labelLarge),
      labelMedium: bonaNova(textStyle: textTheme.labelMedium),
      labelSmall: bonaNova(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bona Nova SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bona+Nova+SC
  static TextStyle bonaNovaSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '737e6876332ec78b45985104a38b73928a38c3db5586719310d3d01ca6df4b61',
        238580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '05e6965dbf9b3fed96f5d3f1c921588867a97b97e88f3c4c7ead4382a4372190',
        253184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df10eb2e3751cdc600c97cad5d087f6557006dfd08f69721b443f7b6a4b1ba23',
        235580,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BonaNovaSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bona Nova SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bona+Nova+SC
  static TextTheme bonaNovaScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bonaNovaSc(textStyle: textTheme.displayLarge),
      displayMedium: bonaNovaSc(textStyle: textTheme.displayMedium),
      displaySmall: bonaNovaSc(textStyle: textTheme.displaySmall),
      headlineLarge: bonaNovaSc(textStyle: textTheme.headlineLarge),
      headlineMedium: bonaNovaSc(textStyle: textTheme.headlineMedium),
      headlineSmall: bonaNovaSc(textStyle: textTheme.headlineSmall),
      titleLarge: bonaNovaSc(textStyle: textTheme.titleLarge),
      titleMedium: bonaNovaSc(textStyle: textTheme.titleMedium),
      titleSmall: bonaNovaSc(textStyle: textTheme.titleSmall),
      bodyLarge: bonaNovaSc(textStyle: textTheme.bodyLarge),
      bodyMedium: bonaNovaSc(textStyle: textTheme.bodyMedium),
      bodySmall: bonaNovaSc(textStyle: textTheme.bodySmall),
      labelLarge: bonaNovaSc(textStyle: textTheme.labelLarge),
      labelMedium: bonaNovaSc(textStyle: textTheme.labelMedium),
      labelSmall: bonaNovaSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bonbon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonbon
  static TextStyle bonbon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1540a43fadea3f6ed9f2596f39c8ff93cb06629a9b9b1c32836ddd258f048700',
        33780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bonbon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bonbon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonbon
  static TextTheme bonbonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bonbon(textStyle: textTheme.displayLarge),
      displayMedium: bonbon(textStyle: textTheme.displayMedium),
      displaySmall: bonbon(textStyle: textTheme.displaySmall),
      headlineLarge: bonbon(textStyle: textTheme.headlineLarge),
      headlineMedium: bonbon(textStyle: textTheme.headlineMedium),
      headlineSmall: bonbon(textStyle: textTheme.headlineSmall),
      titleLarge: bonbon(textStyle: textTheme.titleLarge),
      titleMedium: bonbon(textStyle: textTheme.titleMedium),
      titleSmall: bonbon(textStyle: textTheme.titleSmall),
      bodyLarge: bonbon(textStyle: textTheme.bodyLarge),
      bodyMedium: bonbon(textStyle: textTheme.bodyMedium),
      bodySmall: bonbon(textStyle: textTheme.bodySmall),
      labelLarge: bonbon(textStyle: textTheme.labelLarge),
      labelMedium: bonbon(textStyle: textTheme.labelMedium),
      labelSmall: bonbon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bonheur Royale font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonheur+Royale
  static TextStyle bonheurRoyale({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '154b78777c911720d2396a0fd893d015295362dc1ef49b92d211d5b57f5b9b45',
        87260,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BonheurRoyale',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bonheur Royale font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonheur+Royale
  static TextTheme bonheurRoyaleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bonheurRoyale(textStyle: textTheme.displayLarge),
      displayMedium: bonheurRoyale(textStyle: textTheme.displayMedium),
      displaySmall: bonheurRoyale(textStyle: textTheme.displaySmall),
      headlineLarge: bonheurRoyale(textStyle: textTheme.headlineLarge),
      headlineMedium: bonheurRoyale(textStyle: textTheme.headlineMedium),
      headlineSmall: bonheurRoyale(textStyle: textTheme.headlineSmall),
      titleLarge: bonheurRoyale(textStyle: textTheme.titleLarge),
      titleMedium: bonheurRoyale(textStyle: textTheme.titleMedium),
      titleSmall: bonheurRoyale(textStyle: textTheme.titleSmall),
      bodyLarge: bonheurRoyale(textStyle: textTheme.bodyLarge),
      bodyMedium: bonheurRoyale(textStyle: textTheme.bodyMedium),
      bodySmall: bonheurRoyale(textStyle: textTheme.bodySmall),
      labelLarge: bonheurRoyale(textStyle: textTheme.labelLarge),
      labelMedium: bonheurRoyale(textStyle: textTheme.labelMedium),
      labelSmall: bonheurRoyale(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Boogaloo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Boogaloo
  static TextStyle boogaloo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e1b36d62ddaa798bc5c40fe7df6d951e6ca0026aef7208c4461bc057f0fbd61',
        31224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Boogaloo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Boogaloo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Boogaloo
  static TextTheme boogalooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: boogaloo(textStyle: textTheme.displayLarge),
      displayMedium: boogaloo(textStyle: textTheme.displayMedium),
      displaySmall: boogaloo(textStyle: textTheme.displaySmall),
      headlineLarge: boogaloo(textStyle: textTheme.headlineLarge),
      headlineMedium: boogaloo(textStyle: textTheme.headlineMedium),
      headlineSmall: boogaloo(textStyle: textTheme.headlineSmall),
      titleLarge: boogaloo(textStyle: textTheme.titleLarge),
      titleMedium: boogaloo(textStyle: textTheme.titleMedium),
      titleSmall: boogaloo(textStyle: textTheme.titleSmall),
      bodyLarge: boogaloo(textStyle: textTheme.bodyLarge),
      bodyMedium: boogaloo(textStyle: textTheme.bodyMedium),
      bodySmall: boogaloo(textStyle: textTheme.bodySmall),
      labelLarge: boogaloo(textStyle: textTheme.labelLarge),
      labelMedium: boogaloo(textStyle: textTheme.labelMedium),
      labelSmall: boogaloo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Borel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Borel
  static TextStyle borel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '783316b33c744e63516c15b94e9f31dba7bb17f181a8cb31c173c021cf367cf7',
        143872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Borel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Borel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Borel
  static TextTheme borelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: borel(textStyle: textTheme.displayLarge),
      displayMedium: borel(textStyle: textTheme.displayMedium),
      displaySmall: borel(textStyle: textTheme.displaySmall),
      headlineLarge: borel(textStyle: textTheme.headlineLarge),
      headlineMedium: borel(textStyle: textTheme.headlineMedium),
      headlineSmall: borel(textStyle: textTheme.headlineSmall),
      titleLarge: borel(textStyle: textTheme.titleLarge),
      titleMedium: borel(textStyle: textTheme.titleMedium),
      titleSmall: borel(textStyle: textTheme.titleSmall),
      bodyLarge: borel(textStyle: textTheme.bodyLarge),
      bodyMedium: borel(textStyle: textTheme.bodyMedium),
      bodySmall: borel(textStyle: textTheme.bodySmall),
      labelLarge: borel(textStyle: textTheme.labelLarge),
      labelMedium: borel(textStyle: textTheme.labelMedium),
      labelSmall: borel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bowlby One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One
  static TextStyle bowlbyOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '295679a1645b41e496426642f74f4e964ed1ca4ecba18d17e2c06fd48a855502',
        58036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BowlbyOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bowlby One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One
  static TextTheme bowlbyOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bowlbyOne(textStyle: textTheme.displayLarge),
      displayMedium: bowlbyOne(textStyle: textTheme.displayMedium),
      displaySmall: bowlbyOne(textStyle: textTheme.displaySmall),
      headlineLarge: bowlbyOne(textStyle: textTheme.headlineLarge),
      headlineMedium: bowlbyOne(textStyle: textTheme.headlineMedium),
      headlineSmall: bowlbyOne(textStyle: textTheme.headlineSmall),
      titleLarge: bowlbyOne(textStyle: textTheme.titleLarge),
      titleMedium: bowlbyOne(textStyle: textTheme.titleMedium),
      titleSmall: bowlbyOne(textStyle: textTheme.titleSmall),
      bodyLarge: bowlbyOne(textStyle: textTheme.bodyLarge),
      bodyMedium: bowlbyOne(textStyle: textTheme.bodyMedium),
      bodySmall: bowlbyOne(textStyle: textTheme.bodySmall),
      labelLarge: bowlbyOne(textStyle: textTheme.labelLarge),
      labelMedium: bowlbyOne(textStyle: textTheme.labelMedium),
      labelSmall: bowlbyOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bowlby One SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One+SC
  static TextStyle bowlbyOneSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7de8e3ab5995e51e27e2e02b0564c3ed2c6ef22dcc08b03e76a63233b1c3e5d5',
        42524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BowlbyOneSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bowlby One SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One+SC
  static TextTheme bowlbyOneScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bowlbyOneSc(textStyle: textTheme.displayLarge),
      displayMedium: bowlbyOneSc(textStyle: textTheme.displayMedium),
      displaySmall: bowlbyOneSc(textStyle: textTheme.displaySmall),
      headlineLarge: bowlbyOneSc(textStyle: textTheme.headlineLarge),
      headlineMedium: bowlbyOneSc(textStyle: textTheme.headlineMedium),
      headlineSmall: bowlbyOneSc(textStyle: textTheme.headlineSmall),
      titleLarge: bowlbyOneSc(textStyle: textTheme.titleLarge),
      titleMedium: bowlbyOneSc(textStyle: textTheme.titleMedium),
      titleSmall: bowlbyOneSc(textStyle: textTheme.titleSmall),
      bodyLarge: bowlbyOneSc(textStyle: textTheme.bodyLarge),
      bodyMedium: bowlbyOneSc(textStyle: textTheme.bodyMedium),
      bodySmall: bowlbyOneSc(textStyle: textTheme.bodySmall),
      labelLarge: bowlbyOneSc(textStyle: textTheme.labelLarge),
      labelMedium: bowlbyOneSc(textStyle: textTheme.labelMedium),
      labelSmall: bowlbyOneSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Braah One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Braah+One
  static TextStyle braahOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d5ca0f865302616e6509638fb3426f08a52c1d7671502fb3e8c94f1359a8391',
        78528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BraahOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Braah One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Braah+One
  static TextTheme braahOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: braahOne(textStyle: textTheme.displayLarge),
      displayMedium: braahOne(textStyle: textTheme.displayMedium),
      displaySmall: braahOne(textStyle: textTheme.displaySmall),
      headlineLarge: braahOne(textStyle: textTheme.headlineLarge),
      headlineMedium: braahOne(textStyle: textTheme.headlineMedium),
      headlineSmall: braahOne(textStyle: textTheme.headlineSmall),
      titleLarge: braahOne(textStyle: textTheme.titleLarge),
      titleMedium: braahOne(textStyle: textTheme.titleMedium),
      titleSmall: braahOne(textStyle: textTheme.titleSmall),
      bodyLarge: braahOne(textStyle: textTheme.bodyLarge),
      bodyMedium: braahOne(textStyle: textTheme.bodyMedium),
      bodySmall: braahOne(textStyle: textTheme.bodySmall),
      labelLarge: braahOne(textStyle: textTheme.labelLarge),
      labelMedium: braahOne(textStyle: textTheme.labelMedium),
      labelSmall: braahOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Brawler font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brawler
  static TextStyle brawler({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1d99ea60caa66d62f590c76f585d98017a2ec6218ac780cadc9e70b1ed635ea',
        39088,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46ec2bf8116aad4bac1627a1270e6313a630b72aa32acb27e5c8a8365ed4aa34',
        32472,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Brawler',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Brawler font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brawler
  static TextTheme brawlerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: brawler(textStyle: textTheme.displayLarge),
      displayMedium: brawler(textStyle: textTheme.displayMedium),
      displaySmall: brawler(textStyle: textTheme.displaySmall),
      headlineLarge: brawler(textStyle: textTheme.headlineLarge),
      headlineMedium: brawler(textStyle: textTheme.headlineMedium),
      headlineSmall: brawler(textStyle: textTheme.headlineSmall),
      titleLarge: brawler(textStyle: textTheme.titleLarge),
      titleMedium: brawler(textStyle: textTheme.titleMedium),
      titleSmall: brawler(textStyle: textTheme.titleSmall),
      bodyLarge: brawler(textStyle: textTheme.bodyLarge),
      bodyMedium: brawler(textStyle: textTheme.bodyMedium),
      bodySmall: brawler(textStyle: textTheme.bodySmall),
      labelLarge: brawler(textStyle: textTheme.labelLarge),
      labelMedium: brawler(textStyle: textTheme.labelMedium),
      labelSmall: brawler(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bree Serif font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bree+Serif
  static TextStyle breeSerif({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5502b26521a10457b7069809f6b093a2f84697033833fc0d231c14fc3d98449f',
        42876,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BreeSerif',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bree Serif font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bree+Serif
  static TextTheme breeSerifTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: breeSerif(textStyle: textTheme.displayLarge),
      displayMedium: breeSerif(textStyle: textTheme.displayMedium),
      displaySmall: breeSerif(textStyle: textTheme.displaySmall),
      headlineLarge: breeSerif(textStyle: textTheme.headlineLarge),
      headlineMedium: breeSerif(textStyle: textTheme.headlineMedium),
      headlineSmall: breeSerif(textStyle: textTheme.headlineSmall),
      titleLarge: breeSerif(textStyle: textTheme.titleLarge),
      titleMedium: breeSerif(textStyle: textTheme.titleMedium),
      titleSmall: breeSerif(textStyle: textTheme.titleSmall),
      bodyLarge: breeSerif(textStyle: textTheme.bodyLarge),
      bodyMedium: breeSerif(textStyle: textTheme.bodyMedium),
      bodySmall: breeSerif(textStyle: textTheme.bodySmall),
      labelLarge: breeSerif(textStyle: textTheme.labelLarge),
      labelMedium: breeSerif(textStyle: textTheme.labelMedium),
      labelSmall: breeSerif(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bricolage Grotesque font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bricolage+Grotesque
  static TextStyle bricolageGrotesque({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '749a547b99e0f8b0c40c705460dfec9883f970a58c8b30c6f0e4c748068d5e5d',
        82316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f40769977ea17b4ae2ad9953ecaea85a40dddcb62b3643b2e6b3f26a3c110c7',
        82188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2d910251022c851e26d045b9202776cf98dd15af8e539ebbda16503332a2b016',
        82168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a573cccd8a40c7163eb815be9f0ea609b0d2a613c5d3474c077b01253fde8d5',
        82220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c6cd547cb081dee4b2a4462c3e5d72091ca69386392b3ac3a73463f244f019e',
        82280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ed0995ec51fc124e42efc90831a6afe3825e317f7969a599ac7d654bc2d6821',
        82180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c56674eff2988656134508882d20ee5f74974787bcda3ba0eff27eed54576957',
        82308,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BricolageGrotesque',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bricolage Grotesque font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bricolage+Grotesque
  static TextTheme bricolageGrotesqueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bricolageGrotesque(textStyle: textTheme.displayLarge),
      displayMedium: bricolageGrotesque(textStyle: textTheme.displayMedium),
      displaySmall: bricolageGrotesque(textStyle: textTheme.displaySmall),
      headlineLarge: bricolageGrotesque(textStyle: textTheme.headlineLarge),
      headlineMedium: bricolageGrotesque(textStyle: textTheme.headlineMedium),
      headlineSmall: bricolageGrotesque(textStyle: textTheme.headlineSmall),
      titleLarge: bricolageGrotesque(textStyle: textTheme.titleLarge),
      titleMedium: bricolageGrotesque(textStyle: textTheme.titleMedium),
      titleSmall: bricolageGrotesque(textStyle: textTheme.titleSmall),
      bodyLarge: bricolageGrotesque(textStyle: textTheme.bodyLarge),
      bodyMedium: bricolageGrotesque(textStyle: textTheme.bodyMedium),
      bodySmall: bricolageGrotesque(textStyle: textTheme.bodySmall),
      labelLarge: bricolageGrotesque(textStyle: textTheme.labelLarge),
      labelMedium: bricolageGrotesque(textStyle: textTheme.labelMedium),
      labelSmall: bricolageGrotesque(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bruno Ace font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bruno+Ace
  static TextStyle brunoAce({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bbca71a0e002a28e06c19053cddd4dd36b766ed9df14c58fabb2b0fe187317f9',
        40284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BrunoAce',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bruno Ace font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bruno+Ace
  static TextTheme brunoAceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: brunoAce(textStyle: textTheme.displayLarge),
      displayMedium: brunoAce(textStyle: textTheme.displayMedium),
      displaySmall: brunoAce(textStyle: textTheme.displaySmall),
      headlineLarge: brunoAce(textStyle: textTheme.headlineLarge),
      headlineMedium: brunoAce(textStyle: textTheme.headlineMedium),
      headlineSmall: brunoAce(textStyle: textTheme.headlineSmall),
      titleLarge: brunoAce(textStyle: textTheme.titleLarge),
      titleMedium: brunoAce(textStyle: textTheme.titleMedium),
      titleSmall: brunoAce(textStyle: textTheme.titleSmall),
      bodyLarge: brunoAce(textStyle: textTheme.bodyLarge),
      bodyMedium: brunoAce(textStyle: textTheme.bodyMedium),
      bodySmall: brunoAce(textStyle: textTheme.bodySmall),
      labelLarge: brunoAce(textStyle: textTheme.labelLarge),
      labelMedium: brunoAce(textStyle: textTheme.labelMedium),
      labelSmall: brunoAce(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bruno Ace SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bruno+Ace+SC
  static TextStyle brunoAceSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '315dc296253f4a92e5a13e75d97b10efdbf0f5d67b7430d9eef38d0096c8bcf4',
        39244,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BrunoAceSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bruno Ace SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bruno+Ace+SC
  static TextTheme brunoAceScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: brunoAceSc(textStyle: textTheme.displayLarge),
      displayMedium: brunoAceSc(textStyle: textTheme.displayMedium),
      displaySmall: brunoAceSc(textStyle: textTheme.displaySmall),
      headlineLarge: brunoAceSc(textStyle: textTheme.headlineLarge),
      headlineMedium: brunoAceSc(textStyle: textTheme.headlineMedium),
      headlineSmall: brunoAceSc(textStyle: textTheme.headlineSmall),
      titleLarge: brunoAceSc(textStyle: textTheme.titleLarge),
      titleMedium: brunoAceSc(textStyle: textTheme.titleMedium),
      titleSmall: brunoAceSc(textStyle: textTheme.titleSmall),
      bodyLarge: brunoAceSc(textStyle: textTheme.bodyLarge),
      bodyMedium: brunoAceSc(textStyle: textTheme.bodyMedium),
      bodySmall: brunoAceSc(textStyle: textTheme.bodySmall),
      labelLarge: brunoAceSc(textStyle: textTheme.labelLarge),
      labelMedium: brunoAceSc(textStyle: textTheme.labelMedium),
      labelSmall: brunoAceSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Brygada 1918 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brygada+1918
  static TextStyle brygada1918({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96eafc12312661bd43f9dbc1c3082f70f9b835dceba9a9186c030a31fe25add4',
        121484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4caef60fdfc21fd176e5a597f56594dbfe9443fbdc3a478ba36d532a4f80ab12',
        122024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec7064ad1fba34b68ff49ee8517563c669c8138ba7c3839925d55773d327d2b3',
        122000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c9eff7ab58cf6b76dbe5f4c75740e22e9693801448a4d174047bbb599b45fe2',
        121940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0733f574ff2b0720cecf04711afad94c83ad1c9398b4fde7038bc340cdabdf13',
        120804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '475be130ee0389a5b91506249142bcf3db0d48732a6747a768ea057db6fcd14b',
        121004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2ec82159ff8f9492fe03f97a1d80bf572533cb9cab61a349fe31debf66c91c11',
        121128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '42324796fc7c48b3960d0c69d23b125807364d54e35e94383208dde3504eb278',
        121040,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Brygada1918',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Brygada 1918 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brygada+1918
  static TextTheme brygada1918TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: brygada1918(textStyle: textTheme.displayLarge),
      displayMedium: brygada1918(textStyle: textTheme.displayMedium),
      displaySmall: brygada1918(textStyle: textTheme.displaySmall),
      headlineLarge: brygada1918(textStyle: textTheme.headlineLarge),
      headlineMedium: brygada1918(textStyle: textTheme.headlineMedium),
      headlineSmall: brygada1918(textStyle: textTheme.headlineSmall),
      titleLarge: brygada1918(textStyle: textTheme.titleLarge),
      titleMedium: brygada1918(textStyle: textTheme.titleMedium),
      titleSmall: brygada1918(textStyle: textTheme.titleSmall),
      bodyLarge: brygada1918(textStyle: textTheme.bodyLarge),
      bodyMedium: brygada1918(textStyle: textTheme.bodyMedium),
      bodySmall: brygada1918(textStyle: textTheme.bodySmall),
      labelLarge: brygada1918(textStyle: textTheme.labelLarge),
      labelMedium: brygada1918(textStyle: textTheme.labelMedium),
      labelSmall: brygada1918(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bubblegum Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubblegum+Sans
  static TextStyle bubblegumSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '75c0878aea2de485a694ed9d6c7a7a3b2f48e6f5e8de30cf6b8bcbaf0872e1c2',
        36660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BubblegumSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bubblegum Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubblegum+Sans
  static TextTheme bubblegumSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bubblegumSans(textStyle: textTheme.displayLarge),
      displayMedium: bubblegumSans(textStyle: textTheme.displayMedium),
      displaySmall: bubblegumSans(textStyle: textTheme.displaySmall),
      headlineLarge: bubblegumSans(textStyle: textTheme.headlineLarge),
      headlineMedium: bubblegumSans(textStyle: textTheme.headlineMedium),
      headlineSmall: bubblegumSans(textStyle: textTheme.headlineSmall),
      titleLarge: bubblegumSans(textStyle: textTheme.titleLarge),
      titleMedium: bubblegumSans(textStyle: textTheme.titleMedium),
      titleSmall: bubblegumSans(textStyle: textTheme.titleSmall),
      bodyLarge: bubblegumSans(textStyle: textTheme.bodyLarge),
      bodyMedium: bubblegumSans(textStyle: textTheme.bodyMedium),
      bodySmall: bubblegumSans(textStyle: textTheme.bodySmall),
      labelLarge: bubblegumSans(textStyle: textTheme.labelLarge),
      labelMedium: bubblegumSans(textStyle: textTheme.labelMedium),
      labelSmall: bubblegumSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bubbler One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubbler+One
  static TextStyle bubblerOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1069015b76a5629afc944a3ce37f5cb51991c9a15bbed42a9c74b4995b44f01',
        29284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BubblerOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bubbler One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubbler+One
  static TextTheme bubblerOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bubblerOne(textStyle: textTheme.displayLarge),
      displayMedium: bubblerOne(textStyle: textTheme.displayMedium),
      displaySmall: bubblerOne(textStyle: textTheme.displaySmall),
      headlineLarge: bubblerOne(textStyle: textTheme.headlineLarge),
      headlineMedium: bubblerOne(textStyle: textTheme.headlineMedium),
      headlineSmall: bubblerOne(textStyle: textTheme.headlineSmall),
      titleLarge: bubblerOne(textStyle: textTheme.titleLarge),
      titleMedium: bubblerOne(textStyle: textTheme.titleMedium),
      titleSmall: bubblerOne(textStyle: textTheme.titleSmall),
      bodyLarge: bubblerOne(textStyle: textTheme.bodyLarge),
      bodyMedium: bubblerOne(textStyle: textTheme.bodyMedium),
      bodySmall: bubblerOne(textStyle: textTheme.bodySmall),
      labelLarge: bubblerOne(textStyle: textTheme.labelLarge),
      labelMedium: bubblerOne(textStyle: textTheme.labelMedium),
      labelSmall: bubblerOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Buda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buda
  static TextStyle buda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a3de746e9bb57f1126ceb335a59aceb989b2f7b1a424171bd75ce32288ec829',
        33364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Buda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Buda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buda
  static TextTheme budaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: buda(textStyle: textTheme.displayLarge),
      displayMedium: buda(textStyle: textTheme.displayMedium),
      displaySmall: buda(textStyle: textTheme.displaySmall),
      headlineLarge: buda(textStyle: textTheme.headlineLarge),
      headlineMedium: buda(textStyle: textTheme.headlineMedium),
      headlineSmall: buda(textStyle: textTheme.headlineSmall),
      titleLarge: buda(textStyle: textTheme.titleLarge),
      titleMedium: buda(textStyle: textTheme.titleMedium),
      titleSmall: buda(textStyle: textTheme.titleSmall),
      bodyLarge: buda(textStyle: textTheme.bodyLarge),
      bodyMedium: buda(textStyle: textTheme.bodyMedium),
      bodySmall: buda(textStyle: textTheme.bodySmall),
      labelLarge: buda(textStyle: textTheme.labelLarge),
      labelMedium: buda(textStyle: textTheme.labelMedium),
      labelSmall: buda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Buenard font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buenard
  static TextStyle buenard({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6530a057f44e97cf7b5124e45286942b0dd5cb652533e320357df9c3a712d26',
        56568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3098b97edeca864f79b6d2b8433c04363b80a8219f40e2f05b5fa2481e2e38e7',
        55608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Buenard',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Buenard font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buenard
  static TextTheme buenardTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: buenard(textStyle: textTheme.displayLarge),
      displayMedium: buenard(textStyle: textTheme.displayMedium),
      displaySmall: buenard(textStyle: textTheme.displaySmall),
      headlineLarge: buenard(textStyle: textTheme.headlineLarge),
      headlineMedium: buenard(textStyle: textTheme.headlineMedium),
      headlineSmall: buenard(textStyle: textTheme.headlineSmall),
      titleLarge: buenard(textStyle: textTheme.titleLarge),
      titleMedium: buenard(textStyle: textTheme.titleMedium),
      titleSmall: buenard(textStyle: textTheme.titleSmall),
      bodyLarge: buenard(textStyle: textTheme.bodyLarge),
      bodyMedium: buenard(textStyle: textTheme.bodyMedium),
      bodySmall: buenard(textStyle: textTheme.bodySmall),
      labelLarge: buenard(textStyle: textTheme.labelLarge),
      labelMedium: buenard(textStyle: textTheme.labelMedium),
      labelSmall: buenard(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee
  static TextStyle bungee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aa707aa79b5eac140e0b956c513c5a5e6e04d308d06047088a9c1437b1f88ea5',
        110432,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bungee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee
  static TextTheme bungeeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bungee(textStyle: textTheme.displayLarge),
      displayMedium: bungee(textStyle: textTheme.displayMedium),
      displaySmall: bungee(textStyle: textTheme.displaySmall),
      headlineLarge: bungee(textStyle: textTheme.headlineLarge),
      headlineMedium: bungee(textStyle: textTheme.headlineMedium),
      headlineSmall: bungee(textStyle: textTheme.headlineSmall),
      titleLarge: bungee(textStyle: textTheme.titleLarge),
      titleMedium: bungee(textStyle: textTheme.titleMedium),
      titleSmall: bungee(textStyle: textTheme.titleSmall),
      bodyLarge: bungee(textStyle: textTheme.bodyLarge),
      bodyMedium: bungee(textStyle: textTheme.bodyMedium),
      bodySmall: bungee(textStyle: textTheme.bodySmall),
      labelLarge: bungee(textStyle: textTheme.labelLarge),
      labelMedium: bungee(textStyle: textTheme.labelMedium),
      labelSmall: bungee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Hairline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Hairline
  static TextStyle bungeeHairline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9186c591f8dab61fb008dcc20b9970794de2285d3049d941905f228d9c0255aa',
        96152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeHairline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Hairline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Hairline
  static TextTheme bungeeHairlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bungeeHairline(textStyle: textTheme.displayLarge),
      displayMedium: bungeeHairline(textStyle: textTheme.displayMedium),
      displaySmall: bungeeHairline(textStyle: textTheme.displaySmall),
      headlineLarge: bungeeHairline(textStyle: textTheme.headlineLarge),
      headlineMedium: bungeeHairline(textStyle: textTheme.headlineMedium),
      headlineSmall: bungeeHairline(textStyle: textTheme.headlineSmall),
      titleLarge: bungeeHairline(textStyle: textTheme.titleLarge),
      titleMedium: bungeeHairline(textStyle: textTheme.titleMedium),
      titleSmall: bungeeHairline(textStyle: textTheme.titleSmall),
      bodyLarge: bungeeHairline(textStyle: textTheme.bodyLarge),
      bodyMedium: bungeeHairline(textStyle: textTheme.bodyMedium),
      bodySmall: bungeeHairline(textStyle: textTheme.bodySmall),
      labelLarge: bungeeHairline(textStyle: textTheme.labelLarge),
      labelMedium: bungeeHairline(textStyle: textTheme.labelMedium),
      labelSmall: bungeeHairline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Inline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Inline
  static TextStyle bungeeInline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1d48b3ce6fc0bdc54f38ef30425bdb199a3c48c395add01788652b2ab2b0f67',
        143768,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeInline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Inline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Inline
  static TextTheme bungeeInlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bungeeInline(textStyle: textTheme.displayLarge),
      displayMedium: bungeeInline(textStyle: textTheme.displayMedium),
      displaySmall: bungeeInline(textStyle: textTheme.displaySmall),
      headlineLarge: bungeeInline(textStyle: textTheme.headlineLarge),
      headlineMedium: bungeeInline(textStyle: textTheme.headlineMedium),
      headlineSmall: bungeeInline(textStyle: textTheme.headlineSmall),
      titleLarge: bungeeInline(textStyle: textTheme.titleLarge),
      titleMedium: bungeeInline(textStyle: textTheme.titleMedium),
      titleSmall: bungeeInline(textStyle: textTheme.titleSmall),
      bodyLarge: bungeeInline(textStyle: textTheme.bodyLarge),
      bodyMedium: bungeeInline(textStyle: textTheme.bodyMedium),
      bodySmall: bungeeInline(textStyle: textTheme.bodySmall),
      labelLarge: bungeeInline(textStyle: textTheme.labelLarge),
      labelMedium: bungeeInline(textStyle: textTheme.labelMedium),
      labelSmall: bungeeInline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Outline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Outline
  static TextStyle bungeeOutline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc3560f327a5463c3c20a61a5e83985706e35cc884e83ed979937e46a29899e8',
        193448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeOutline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Outline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Outline
  static TextTheme bungeeOutlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bungeeOutline(textStyle: textTheme.displayLarge),
      displayMedium: bungeeOutline(textStyle: textTheme.displayMedium),
      displaySmall: bungeeOutline(textStyle: textTheme.displaySmall),
      headlineLarge: bungeeOutline(textStyle: textTheme.headlineLarge),
      headlineMedium: bungeeOutline(textStyle: textTheme.headlineMedium),
      headlineSmall: bungeeOutline(textStyle: textTheme.headlineSmall),
      titleLarge: bungeeOutline(textStyle: textTheme.titleLarge),
      titleMedium: bungeeOutline(textStyle: textTheme.titleMedium),
      titleSmall: bungeeOutline(textStyle: textTheme.titleSmall),
      bodyLarge: bungeeOutline(textStyle: textTheme.bodyLarge),
      bodyMedium: bungeeOutline(textStyle: textTheme.bodyMedium),
      bodySmall: bungeeOutline(textStyle: textTheme.bodySmall),
      labelLarge: bungeeOutline(textStyle: textTheme.labelLarge),
      labelMedium: bungeeOutline(textStyle: textTheme.labelMedium),
      labelSmall: bungeeOutline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Shade font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Shade
  static TextStyle bungeeShade({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a013762d0a4a012f698a3e272235b218a06ad328e36612f72d71150395e5dc0',
        293112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeShade',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Shade font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Shade
  static TextTheme bungeeShadeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bungeeShade(textStyle: textTheme.displayLarge),
      displayMedium: bungeeShade(textStyle: textTheme.displayMedium),
      displaySmall: bungeeShade(textStyle: textTheme.displaySmall),
      headlineLarge: bungeeShade(textStyle: textTheme.headlineLarge),
      headlineMedium: bungeeShade(textStyle: textTheme.headlineMedium),
      headlineSmall: bungeeShade(textStyle: textTheme.headlineSmall),
      titleLarge: bungeeShade(textStyle: textTheme.titleLarge),
      titleMedium: bungeeShade(textStyle: textTheme.titleMedium),
      titleSmall: bungeeShade(textStyle: textTheme.titleSmall),
      bodyLarge: bungeeShade(textStyle: textTheme.bodyLarge),
      bodyMedium: bungeeShade(textStyle: textTheme.bodyMedium),
      bodySmall: bungeeShade(textStyle: textTheme.bodySmall),
      labelLarge: bungeeShade(textStyle: textTheme.labelLarge),
      labelMedium: bungeeShade(textStyle: textTheme.labelMedium),
      labelSmall: bungeeShade(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Spice font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Spice
  static TextStyle bungeeSpice({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e48fb9c3aa4cffe3742544a17c675a286135b62e3f6bf956bb2b56a69ff1ade',
        1487960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeSpice',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Spice font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Spice
  static TextTheme bungeeSpiceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: bungeeSpice(textStyle: textTheme.displayLarge),
      displayMedium: bungeeSpice(textStyle: textTheme.displayMedium),
      displaySmall: bungeeSpice(textStyle: textTheme.displaySmall),
      headlineLarge: bungeeSpice(textStyle: textTheme.headlineLarge),
      headlineMedium: bungeeSpice(textStyle: textTheme.headlineMedium),
      headlineSmall: bungeeSpice(textStyle: textTheme.headlineSmall),
      titleLarge: bungeeSpice(textStyle: textTheme.titleLarge),
      titleMedium: bungeeSpice(textStyle: textTheme.titleMedium),
      titleSmall: bungeeSpice(textStyle: textTheme.titleSmall),
      bodyLarge: bungeeSpice(textStyle: textTheme.bodyLarge),
      bodyMedium: bungeeSpice(textStyle: textTheme.bodyMedium),
      bodySmall: bungeeSpice(textStyle: textTheme.bodySmall),
      labelLarge: bungeeSpice(textStyle: textTheme.labelLarge),
      labelMedium: bungeeSpice(textStyle: textTheme.labelMedium),
      labelSmall: bungeeSpice(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Butcherman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butcherman
  static TextStyle butcherman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60fbc7f29a31d0500a432d0723b8770f65ea6319fdd801b6c45c1ad83b505c04',
        63296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Butcherman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Butcherman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butcherman
  static TextTheme butchermanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: butcherman(textStyle: textTheme.displayLarge),
      displayMedium: butcherman(textStyle: textTheme.displayMedium),
      displaySmall: butcherman(textStyle: textTheme.displaySmall),
      headlineLarge: butcherman(textStyle: textTheme.headlineLarge),
      headlineMedium: butcherman(textStyle: textTheme.headlineMedium),
      headlineSmall: butcherman(textStyle: textTheme.headlineSmall),
      titleLarge: butcherman(textStyle: textTheme.titleLarge),
      titleMedium: butcherman(textStyle: textTheme.titleMedium),
      titleSmall: butcherman(textStyle: textTheme.titleSmall),
      bodyLarge: butcherman(textStyle: textTheme.bodyLarge),
      bodyMedium: butcherman(textStyle: textTheme.bodyMedium),
      bodySmall: butcherman(textStyle: textTheme.bodySmall),
      labelLarge: butcherman(textStyle: textTheme.labelLarge),
      labelMedium: butcherman(textStyle: textTheme.labelMedium),
      labelSmall: butcherman(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Butterfly Kids font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butterfly+Kids
  static TextStyle butterflyKids({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3129ed9c8f8c847f01b767bb6439f519af3796ea3387cc5128092c2919aae4a9',
        200428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ButterflyKids',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Butterfly Kids font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butterfly+Kids
  static TextTheme butterflyKidsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: butterflyKids(textStyle: textTheme.displayLarge),
      displayMedium: butterflyKids(textStyle: textTheme.displayMedium),
      displaySmall: butterflyKids(textStyle: textTheme.displaySmall),
      headlineLarge: butterflyKids(textStyle: textTheme.headlineLarge),
      headlineMedium: butterflyKids(textStyle: textTheme.headlineMedium),
      headlineSmall: butterflyKids(textStyle: textTheme.headlineSmall),
      titleLarge: butterflyKids(textStyle: textTheme.titleLarge),
      titleMedium: butterflyKids(textStyle: textTheme.titleMedium),
      titleSmall: butterflyKids(textStyle: textTheme.titleSmall),
      bodyLarge: butterflyKids(textStyle: textTheme.bodyLarge),
      bodyMedium: butterflyKids(textStyle: textTheme.bodyMedium),
      bodySmall: butterflyKids(textStyle: textTheme.bodySmall),
      labelLarge: butterflyKids(textStyle: textTheme.labelLarge),
      labelMedium: butterflyKids(textStyle: textTheme.labelMedium),
      labelSmall: butterflyKids(textStyle: textTheme.labelSmall),
    );
  }
}
