// ignore_for_file: constant_identifier_names
import 'package:flutter/widgets.dart';

///  Lucide is a free, open-source icon set with 1450+ icons. It's a fork of the popular Feather icon set.
/// Lucide is licensed under the ISC license.
///
/// for more info visit [https://lucide.dev/](https://lucide.dev/).
///
@staticIconProvider
abstract final class LucideIcons {
  /// const constructor for [LucideIcons]
  const LucideIcons._();

  // /// [fromCode] is a helper function that returns the icon data for a particular icon code.
  // /// The icon code can be found in the Lucide icon library at [https://lucide.dev/](https://lucide.dev/).
  // ///
  // /// avoid using this function directly, instead use the icon directly from the [LucideIcons] class.
  // /// Tree shaking will remove the unused icons from the final build.
  // /// This will reduce the final build size.
  // ///
  // /// Example: To use the [a_arrow_down] icon, use the following code:
  // /// ```dart
  // /// Icon(LucideIcons.fromCode(0xe900))
  // /// ```
  // ///
  // Removed:
  // Unable to tree shake when build #3
  // [https://github.com/ravikovind/flutter_lucide/issues/3]
  //
  // static IconData? fromCode(int code) {
  //   try {
  //     return IconData(code, fontFamily: _fontFamily, fontPackage: _fontPackage);
  //   } on Exception catch (_) {
  //     return null;
  //   }
  // }

  /// [_fontFamily] is the font family for the lucide icon set.
  static const String _fontFamily = 'lucide';

  /// [_fontPackage] is the font package for the lucide icon set.
  static const String _fontPackage = 'flutter_lucide';

  /// Represents the [a_arrow_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [a_arrow_down] icon is a graphical symbol that conveys a specific idea or functionality related to letter, font size, text, formatting, smaller.
  /// - It belongs to the text, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData a_arrow_down =
      IconData(0xe589, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [a_arrow_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [a_arrow_up] icon is a graphical symbol that conveys a specific idea or functionality related to letter, font size, text, formatting, larger, bigger.
  /// - It belongs to the text, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData a_arrow_up =
      IconData(0xe58a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [a_large_small] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [a_large_small] icon is a graphical symbol that conveys a specific idea or functionality related to letter, font size, text, formatting.
  /// - It belongs to the text, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData a_large_small =
      IconData(0xe58b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [accessibility] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [accessibility] icon is a graphical symbol that conveys a specific idea or functionality related to disability, disabled, dda, wheelchair.
  /// - It belongs to the accessibility, medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData accessibility =
      IconData(0xe296, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [activity] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [activity] icon is a graphical symbol that conveys a specific idea or functionality related to pulse, action, motion, movement, exercise, fitness, healthcare, heart rate monitor, vital signs, vitals, emergency room, er, intensive care, hospital, defibrillator, earthquake, siesmic, magnitude, richter scale, aftershock, tremor, shockwave, audio, waveform, synthesizer, synthesiser, music.
  /// - It belongs to the medical, account, social, science, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData activity =
      IconData(0xe038, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [air_vent] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [air_vent] icon is a graphical symbol that conveys a specific idea or functionality related to air conditioner, ac, central air, cooling, climate-control.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData air_vent =
      IconData(0xe350, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [airplay] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [airplay] icon is a graphical symbol that conveys a specific idea or functionality related to stream, cast, mirroring, screen, monitor, macos, osx.
  /// - It belongs to the multimedia, connectivity, devices, brands categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData airplay =
      IconData(0xe039, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [alarm_clock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [alarm_clock] icon is a graphical symbol that conveys a specific idea or functionality related to morning.
  /// - It belongs to the devices, notifications, time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData alarm_clock =
      IconData(0xe03a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [alarm_clock_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [alarm_clock_check] icon is a graphical symbol that conveys a specific idea or functionality related to done, todo, tick, complete, task.
  /// - It belongs to the devices, notifications, time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData alarm_clock_check =
      IconData(0xe1eb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [alarm_clock_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [alarm_clock_minus] icon is a graphical symbol that conveys a specific idea or functionality related to remove.
  /// - It belongs to the devices, notifications, time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData alarm_clock_minus =
      IconData(0xe1ec, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [alarm_clock_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [alarm_clock_off] icon is a graphical symbol that conveys a specific idea or functionality related to morning, turn-off.
  /// - It belongs to the devices, notifications, time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData alarm_clock_off =
      IconData(0xe23a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [alarm_clock_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [alarm_clock_plus] icon is a graphical symbol that conveys a specific idea or functionality related to add.
  /// - It belongs to the devices, notifications, time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData alarm_clock_plus =
      IconData(0xe1ed, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [alarm_smoke] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [alarm_smoke] icon is a graphical symbol that conveys a specific idea or functionality related to fire, alert, warning, detector, carbon monoxide, safety, equipment, amenities.
  /// - It belongs to the home, devices, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData alarm_smoke =
      IconData(0xe57f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [album] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [album] icon is a graphical symbol that conveys a specific idea or functionality related to photo, book.
  /// - It belongs to the photography, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData album =
      IconData(0xe03b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_center] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_center] icon is a graphical symbol that conveys a specific idea or functionality related to text, alignment, center.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_center =
      IconData(0xe03c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_center_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_center_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_center_horizontal =
      IconData(0xe26b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_center_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_center_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_center_vertical =
      IconData(0xe26c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_end_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_end_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to items, bottom, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_end_horizontal =
      IconData(0xe26d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_end_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_end_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to items, right, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_end_vertical =
      IconData(0xe26e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_horizontal_distribute_center] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_horizontal_distribute_center] icon is a graphical symbol that conveys a specific idea or functionality related to items, flex, justify, space, evenly, around.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/r4lv](https://github.com/r4lv), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_horizontal_distribute_center =
      IconData(0xe03d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_horizontal_distribute_end] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_horizontal_distribute_end] icon is a graphical symbol that conveys a specific idea or functionality related to right, items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/r4lv](https://github.com/r4lv), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_horizontal_distribute_end =
      IconData(0xe03e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_horizontal_distribute_start] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_horizontal_distribute_start] icon is a graphical symbol that conveys a specific idea or functionality related to left, items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/r4lv](https://github.com/r4lv), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_horizontal_distribute_start =
      IconData(0xe03f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_horizontal_justify_center] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_horizontal_justify_center] icon is a graphical symbol that conveys a specific idea or functionality related to center, items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_horizontal_justify_center =
      IconData(0xe271, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_horizontal_justify_end] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_horizontal_justify_end] icon is a graphical symbol that conveys a specific idea or functionality related to right, items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_horizontal_justify_end =
      IconData(0xe272, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_horizontal_justify_start] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_horizontal_justify_start] icon is a graphical symbol that conveys a specific idea or functionality related to left, items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_horizontal_justify_start =
      IconData(0xe273, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_horizontal_space_around] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_horizontal_space_around] icon is a graphical symbol that conveys a specific idea or functionality related to center, items, flex, justify, distribute, between.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_horizontal_space_around =
      IconData(0xe274, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_horizontal_space_between] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_horizontal_space_between] icon is a graphical symbol that conveys a specific idea or functionality related to around, items, bottom, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_horizontal_space_between =
      IconData(0xe275, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_justify] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_justify] icon is a graphical symbol that conveys a specific idea or functionality related to text, alignment, justified, menu, list.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_justify =
      IconData(0xe040, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_left] icon is a graphical symbol that conveys a specific idea or functionality related to text, alignment, left, list.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_left =
      IconData(0xe041, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_right] icon is a graphical symbol that conveys a specific idea or functionality related to text, alignment, right.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_right =
      IconData(0xe042, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_start_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_start_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to top, items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_start_horizontal =
      IconData(0xe26f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_start_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_start_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to left, items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_start_vertical =
      IconData(0xe270, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_vertical_distribute_center] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_vertical_distribute_center] icon is a graphical symbol that conveys a specific idea or functionality related to items, flex, justify, space, evenly, around.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_vertical_distribute_center =
      IconData(0xe27d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_vertical_distribute_end] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_vertical_distribute_end] icon is a graphical symbol that conveys a specific idea or functionality related to bottom, items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_vertical_distribute_end =
      IconData(0xe27e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_vertical_distribute_start] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_vertical_distribute_start] icon is a graphical symbol that conveys a specific idea or functionality related to top, items, flex, justify.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_vertical_distribute_start =
      IconData(0xe27f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_vertical_justify_center] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_vertical_justify_center] icon is a graphical symbol that conveys a specific idea or functionality related to center, items, flex, justify, distribute, between.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_vertical_justify_center =
      IconData(0xe276, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_vertical_justify_end] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_vertical_justify_end] icon is a graphical symbol that conveys a specific idea or functionality related to bottom, items, flex, justify, distribute, between.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_vertical_justify_end =
      IconData(0xe277, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_vertical_justify_start] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_vertical_justify_start] icon is a graphical symbol that conveys a specific idea or functionality related to top, items, flex, justify, distribute, between.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_vertical_justify_start =
      IconData(0xe278, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_vertical_space_around] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_vertical_space_around] icon is a graphical symbol that conveys a specific idea or functionality related to center, items, flex, justify, distribute, between.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_vertical_space_around =
      IconData(0xe279, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [align_vertical_space_between] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [align_vertical_space_between] icon is a graphical symbol that conveys a specific idea or functionality related to center, items, flex, justify, distribute, between.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData align_vertical_space_between =
      IconData(0xe27a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ambulance] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ambulance] icon is a graphical symbol that conveys a specific idea or functionality related to ambulance, emergency, medical, vehicle, siren, healthcare, transportation, rescue, urgent, first aid.
  /// - It belongs to the medical, transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jordan808](https://github.com/jordan808), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ahtohbi4](https://github.com/ahtohbi4), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ambulance =
      IconData(0xe5bf, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ampersand] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ampersand] icon is a graphical symbol that conveys a specific idea or functionality related to and, typography, operator, join, concatenate, code, &.
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ampersand =
      IconData(0xe4a0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ampersands] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ampersands] icon is a graphical symbol that conveys a specific idea or functionality related to and, operator, then, code, &&.
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ampersands =
      IconData(0xe4a1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [amphora] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [amphora] icon is a graphical symbol that conveys a specific idea or functionality related to pottery, artifact, artefact, vase, ceramics, clay, archaeology, museum, wine, oil.
  /// - It belongs to the food-beverage, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData amphora =
      IconData(0xe61f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [anchor] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [anchor] icon is a graphical symbol that conveys a specific idea or functionality related to ship.
  /// - It belongs to the transportation, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData anchor =
      IconData(0xe043, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [angry] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [angry] icon is a graphical symbol that conveys a specific idea or functionality related to emoji, anger, face, emotion.
  /// - It belongs to the emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData angry =
      IconData(0xe2fb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [annoyed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [annoyed] icon is a graphical symbol that conveys a specific idea or functionality related to emoji, nuisance, face, emotion.
  /// - It belongs to the emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData annoyed =
      IconData(0xe2fc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [antenna] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [antenna] icon is a graphical symbol that conveys a specific idea or functionality related to signal, connection, connectivity, tv, television, broadcast, live, frequency, tune, scan, channels, aerial, receiver, transmission, transducer, terrestrial, satellite, cable.
  /// - It belongs to the devices, multimedia, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData antenna =
      IconData(0xe4e6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [anvil] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [anvil] icon is a graphical symbol that conveys a specific idea or functionality related to metal, iron, alloy, materials, heavy, weight, blacksmith, forge, acme.
  /// - It belongs to the buildings, tools, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData anvil =
      IconData(0xe584, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [aperture] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [aperture] icon is a graphical symbol that conveys a specific idea or functionality related to camera, photo, pictures, shutter, exposure.
  /// - It belongs to the photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData aperture =
      IconData(0xe044, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [app_window] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [app_window] icon is a graphical symbol that conveys a specific idea or functionality related to application, menu bar, pane, executable.
  /// - It belongs to the layout, design, development, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData app_window =
      IconData(0xe42a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [app_window_mac] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [app_window_mac] icon is a graphical symbol that conveys a specific idea or functionality related to application, menu bar, pane, preferences, macos, osx, executable.
  /// - It belongs to the layout, design, development, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData app_window_mac =
      IconData(0xe5d6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [apple] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [apple] icon is a graphical symbol that conveys a specific idea or functionality related to fruit, food.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData apple =
      IconData(0xe351, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [archive] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [archive] icon is a graphical symbol that conveys a specific idea or functionality related to index, backup, box, storage, records.
  /// - It belongs to the files, mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData archive =
      IconData(0xe045, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [archive_restore] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [archive_restore] icon is a graphical symbol that conveys a specific idea or functionality related to unarchive, index, backup, box, storage, records.
  /// - It belongs to the files, mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData archive_restore =
      IconData(0xe2cc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [archive_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [archive_x] icon is a graphical symbol that conveys a specific idea or functionality related to index, backup, box, storage, records, junk.
  /// - It belongs to the files, mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData archive_x =
      IconData(0xe510, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [armchair] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [armchair] icon is a graphical symbol that conveys a specific idea or functionality related to sofa, furniture, leisure, lounge, loveseat, couch.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData armchair =
      IconData(0xe2bf, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_big_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_big_down] icon is a graphical symbol that conveys a specific idea or functionality related to backwards, reverse, direction, south.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_big_down =
      IconData(0xe1e0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_big_down_dash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_big_down_dash] icon is a graphical symbol that conveys a specific idea or functionality related to backwards, reverse, slow, direction, south, download.
  /// - It belongs to the arrows, navigation, gaming, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_big_down_dash =
      IconData(0xe421, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_big_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_big_left] icon is a graphical symbol that conveys a specific idea or functionality related to previous, back, direction, west, indicate turn.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_big_left =
      IconData(0xe1e1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_big_left_dash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_big_left_dash] icon is a graphical symbol that conveys a specific idea or functionality related to previous, back, direction, west, turn, corner.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_big_left_dash =
      IconData(0xe422, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_big_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_big_right] icon is a graphical symbol that conveys a specific idea or functionality related to next, forward, direction, east, indicate turn.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_big_right =
      IconData(0xe1e2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_big_right_dash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_big_right_dash] icon is a graphical symbol that conveys a specific idea or functionality related to next, forward, direction, east, turn, corner.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_big_right_dash =
      IconData(0xe423, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_big_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_big_up] icon is a graphical symbol that conveys a specific idea or functionality related to shift, keyboard, button, mac, capitalize, capitalise, forward, direction, north.
  /// - It belongs to the arrows, navigation, text, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_big_up =
      IconData(0xe1e3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_big_up_dash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_big_up_dash] icon is a graphical symbol that conveys a specific idea or functionality related to caps lock, capitals, keyboard, button, mac, forward, direction, north, faster, speed, boost.
  /// - It belongs to the arrows, navigation, text, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_big_up_dash =
      IconData(0xe424, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down] icon is a graphical symbol that conveys a specific idea or functionality related to backwards, reverse, direction, south.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down =
      IconData(0xe046, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_0_1] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_0_1] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling, numerical.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_0_1 =
      IconData(0xe417, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_1_0] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_1_0] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling, numerical.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_1_0 =
      IconData(0xe418, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_a_z] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_a_z] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling, alphabetical.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_a_z =
      IconData(0xe419, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_from_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_from_line] icon is a graphical symbol that conveys a specific idea or functionality related to backwards, reverse, direction, south, download, expand, fold, vertical.
  /// - It belongs to the arrows, navigation, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_from_line =
      IconData(0xe458, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_left] icon is a graphical symbol that conveys a specific idea or functionality related to direction, south-west, diagonal.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_left =
      IconData(0xe047, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_narrow_wide] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_narrow_wide] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_narrow_wide =
      IconData(0xe048, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_right] icon is a graphical symbol that conveys a specific idea or functionality related to direction, south-east, diagonal.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_right =
      IconData(0xe049, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_to_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_to_dot] icon is a graphical symbol that conveys a specific idea or functionality related to direction, south, waypoint, location, step, into.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_to_dot =
      IconData(0xe451, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_to_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_to_line] icon is a graphical symbol that conveys a specific idea or functionality related to behind, direction, south, download, save, git, version control, pull, collapse, fold, vertical.
  /// - It belongs to the arrows, navigation, files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_to_line =
      IconData(0xe459, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_up] icon is a graphical symbol that conveys a specific idea or functionality related to bidirectional, two-way, 2-way, swap, switch, network, traffic, flow, mobile data, internet, sort, reorder, move.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_up =
      IconData(0xe04a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_wide_narrow] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_wide_narrow] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_wide_narrow =
      IconData(0xe04b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_down_z_a] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_down_z_a] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling, alphabetical, reverse.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_down_z_a =
      IconData(0xe41a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_left] icon is a graphical symbol that conveys a specific idea or functionality related to previous, back, direction, west, <-.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_left =
      IconData(0xe04c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_left_from_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_left_from_line] icon is a graphical symbol that conveys a specific idea or functionality related to previous, back, direction, west, expand, fold, horizontal, <-|.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_left_from_line =
      IconData(0xe45a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_left_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_left_right] icon is a graphical symbol that conveys a specific idea or functionality related to bidirectional, two-way, 2-way, swap, switch, transaction, reorder, move, <-, ->.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_left_right =
      IconData(0xe249, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_left_to_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_left_to_line] icon is a graphical symbol that conveys a specific idea or functionality related to previous, back, direction, west, collapse, fold, horizontal, |<-.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_left_to_line =
      IconData(0xe45b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_right] icon is a graphical symbol that conveys a specific idea or functionality related to forward, next, direction, east, ->.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_right =
      IconData(0xe04d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_right_from_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_right_from_line] icon is a graphical symbol that conveys a specific idea or functionality related to next, forward, direction, east, export, expand, fold, horizontal, |->.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_right_from_line =
      IconData(0xe45c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_right_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_right_left] icon is a graphical symbol that conveys a specific idea or functionality related to bidirectional, two-way, 2-way, swap, switch, transaction, reorder, move, <-, ->.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_right_left =
      IconData(0xe41b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_right_to_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_right_to_line] icon is a graphical symbol that conveys a specific idea or functionality related to next, forward, direction, east, tab, keyboard, mac, indent, collapse, fold, horizontal, ->|.
  /// - It belongs to the arrows, navigation, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_right_to_line =
      IconData(0xe45d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up] icon is a graphical symbol that conveys a specific idea or functionality related to forward, direction, north.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up =
      IconData(0xe04e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_0_1] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_0_1] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling, numerical.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_0_1 =
      IconData(0xe41c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_1_0] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_1_0] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling, numerical.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_1_0 =
      IconData(0xe41d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_a_z] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_a_z] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling, alphabetical.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_a_z =
      IconData(0xe41e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_down] icon is a graphical symbol that conveys a specific idea or functionality related to bidirectional, two-way, 2-way, swap, switch, network, mobile data, internet, sort, reorder, move.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_down =
      IconData(0xe380, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_from_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_from_dot] icon is a graphical symbol that conveys a specific idea or functionality related to direction, north, step, out.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_from_dot =
      IconData(0xe452, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_from_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_from_line] icon is a graphical symbol that conveys a specific idea or functionality related to forward, direction, north, upload, git, version control, push, expand, fold, vertical.
  /// - It belongs to the arrows, navigation, files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_from_line =
      IconData(0xe45e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_left] icon is a graphical symbol that conveys a specific idea or functionality related to direction, north-west, diagonal.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_left =
      IconData(0xe04f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_narrow_wide] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_narrow_wide] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lukesmurray](https://github.com/lukesmurray), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_narrow_wide =
      IconData(0xe050, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_right] icon is a graphical symbol that conveys a specific idea or functionality related to direction, north-east, diagonal.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_right =
      IconData(0xe051, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_to_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_to_line] icon is a graphical symbol that conveys a specific idea or functionality related to forward, direction, north, upload, collapse, fold, vertical.
  /// - It belongs to the arrows, navigation, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_to_line =
      IconData(0xe45f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_wide_narrow] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_wide_narrow] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_wide_narrow =
      IconData(0xe41f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrow_up_z_a] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrow_up_z_a] icon is a graphical symbol that conveys a specific idea or functionality related to filter, sort, ascending, descending, increasing, decreasing, rising, falling, alphabetical, reverse.
  /// - It belongs to the text, layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrow_up_z_a =
      IconData(0xe420, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [arrows_up_from_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [arrows_up_from_line] icon is a graphical symbol that conveys a specific idea or functionality related to direction, orientation, this way up, vertical, package, box, fragile, postage, shipping.
  /// - It belongs to the arrows, transportation, mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData arrows_up_from_line =
      IconData(0xe4d8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [asterisk] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [asterisk] icon is a graphical symbol that conveys a specific idea or functionality related to reference, times, multiply, multiplication, operator, code, glob pattern, wildcard, *.
  /// - It belongs to the text, math, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData asterisk =
      IconData(0xe1ee, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [at_sign] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [at_sign] icon is a graphical symbol that conveys a specific idea or functionality related to mention, at, email, message, @.
  /// - It belongs to the text, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData at_sign =
      IconData(0xe052, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [atom] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [atom] icon is a graphical symbol that conveys a specific idea or functionality related to atomic, nuclear, physics, particle, element, molecule, electricity, energy, chemistry.
  /// - It belongs to the science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData atom =
      IconData(0xe3da, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [audio_lines] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [audio_lines] icon is a graphical symbol that conveys a specific idea or functionality related to graphic equaliser, sound, noise, listen, hearing, hertz, frequency, wavelength, vibrate, sine, synthesizer, synthesiser, levels, track, music, playback, radio, broadcast, airwaves, voice, vocals, singer, song.
  /// - It belongs to the multimedia, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData audio_lines =
      IconData(0xe55e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [audio_waveform] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [audio_waveform] icon is a graphical symbol that conveys a specific idea or functionality related to sound, noise, listen, hearing, hertz, frequency, wavelength, vibrate, sine, synthesizer, synthesiser, levels, track, music, playback, radio, broadcast, airwaves, voice, vocals, singer, song.
  /// - It belongs to the multimedia, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData audio_waveform =
      IconData(0xe55f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [award] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [award] icon is a graphical symbol that conveys a specific idea or functionality related to achievement, badge, rosette, prize, winner.
  /// - It belongs to the account, sports, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData award =
      IconData(0xe053, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [axe] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [axe] icon is a graphical symbol that conveys a specific idea or functionality related to hatchet, weapon, chop, sharp, equipment, fireman, firefighter, brigade, lumberjack, woodcutter, logger, forestry.
  /// - It belongs to the tools, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData axe =
      IconData(0xe054, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [axis_3d] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [axis_3d] icon is a graphical symbol that conveys a specific idea or functionality related to gizmo, coordinates.
  /// - It belongs to the design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData axis_3d =
      IconData(0xe2fd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [baby] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [baby] icon is a graphical symbol that conveys a specific idea or functionality related to child, childproof, children.
  /// - It belongs to the accessibility, people categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData baby =
      IconData(0xe2cd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [backpack] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [backpack] icon is a graphical symbol that conveys a specific idea or functionality related to bag, hiking, travel, camping, school, childhood.
  /// - It belongs to the gaming, photography, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData backpack =
      IconData(0xe2c7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge] icon is a graphical symbol that conveys a specific idea or functionality related to check, verified, unverified.
  /// - It belongs to the account, social, shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge =
      IconData(0xe478, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_alert] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_alert] icon is a graphical symbol that conveys a specific idea or functionality related to check, verified, unverified, security, safety, issue.
  /// - It belongs to the account, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_alert =
      IconData(0xe479, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_cent] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_cent] icon is a graphical symbol that conveys a specific idea or functionality related to discount, offer, sale, voucher, tag, monetization, marketing, finance, financial, exchange, transaction, payment, cents, dollar, usd, $, ¢.
  /// - It belongs to the shopping, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_cent =
      IconData(0xe513, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_check] icon is a graphical symbol that conveys a specific idea or functionality related to verified, check.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_check =
      IconData(0xe240, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_dollar_sign] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_dollar_sign] icon is a graphical symbol that conveys a specific idea or functionality related to discount, offer, sale, voucher, tag, monetization, marketing, finance, financial, exchange, transaction, payment, usd, $.
  /// - It belongs to the shopping, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_dollar_sign =
      IconData(0xe47a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_euro] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_euro] icon is a graphical symbol that conveys a specific idea or functionality related to discount, offer, sale, voucher, tag, monetization, marketing, finance, financial, exchange, transaction, payment, €.
  /// - It belongs to the shopping, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_euro =
      IconData(0xe514, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_help] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_help] icon is a graphical symbol that conveys a specific idea or functionality related to verified, unverified, help.
  /// - It belongs to the accessibility, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_help =
      IconData(0xe47b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_indian_rupee] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_indian_rupee] icon is a graphical symbol that conveys a specific idea or functionality related to discount, offer, sale, voucher, tag, monetization, marketing, finance, financial, exchange, transaction, payment, inr, ₹.
  /// - It belongs to the shopping, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_indian_rupee =
      IconData(0xe515, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_info] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_info] icon is a graphical symbol that conveys a specific idea or functionality related to verified, unverified, help.
  /// - It belongs to the account, accessibility, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_info =
      IconData(0xe47c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_japanese_yen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_japanese_yen] icon is a graphical symbol that conveys a specific idea or functionality related to discount, offer, sale, voucher, tag, monetization, marketing, finance, financial, exchange, transaction, payment, jpy, ¥.
  /// - It belongs to the shopping, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_japanese_yen =
      IconData(0xe516, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_minus] icon is a graphical symbol that conveys a specific idea or functionality related to verified, unverified, delete, remove, erase.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_minus =
      IconData(0xe47d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_percent] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_percent] icon is a graphical symbol that conveys a specific idea or functionality related to verified, unverified, sale, discount, offer, marketing, sticker, price tag.
  /// - It belongs to the social, finance, shopping, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_percent =
      IconData(0xe47e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_plus] icon is a graphical symbol that conveys a specific idea or functionality related to verified, unverified, add, create, new.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_plus =
      IconData(0xe47f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_pound_sterling] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_pound_sterling] icon is a graphical symbol that conveys a specific idea or functionality related to discount, offer, sale, voucher, tag, monetization, marketing, finance, financial, exchange, transaction, payment, british, gbp, £.
  /// - It belongs to the shopping, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_pound_sterling =
      IconData(0xe517, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_russian_ruble] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_russian_ruble] icon is a graphical symbol that conveys a specific idea or functionality related to discount, offer, sale, voucher, tag, monetization, marketing, finance, financial, exchange, transaction, payment, rub, ₽.
  /// - It belongs to the shopping, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_russian_ruble =
      IconData(0xe518, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_swiss_franc] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_swiss_franc] icon is a graphical symbol that conveys a specific idea or functionality related to discount, offer, sale, voucher, tag, monetization, marketing, finance, financial, exchange, transaction, payment, chf, ₣.
  /// - It belongs to the shopping, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_swiss_franc =
      IconData(0xe519, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [badge_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [badge_x] icon is a graphical symbol that conveys a specific idea or functionality related to verified, unverified, lost, delete, remove.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData badge_x =
      IconData(0xe480, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [baggage_claim] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [baggage_claim] icon is a graphical symbol that conveys a specific idea or functionality related to baggage, luggage, travel, cart, trolley, suitcase.
  /// - It belongs to the transportation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData baggage_claim =
      IconData(0xe2c8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ban] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ban] icon is a graphical symbol that conveys a specific idea or functionality related to cancel, no, stop, forbidden, prohibited, error, incorrect, mistake, wrong, failure, circle, slash, null, void.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ban =
      IconData(0xe055, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [banana] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [banana] icon is a graphical symbol that conveys a specific idea or functionality related to fruit, food.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData banana =
      IconData(0xe352, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bandage] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bandage] icon is a graphical symbol that conveys a specific idea or functionality related to plaster, band-aid, first aid, medical, health, wound, injury, care, treatment, healing, protection, emergency, aid, safety.
  /// - It belongs to the medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jamiemlaw](https://github.com/jamiemlaw) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bandage =
      IconData(0xe621, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [banknote] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [banknote] icon is a graphical symbol that conveys a specific idea or functionality related to currency, money, payment.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData banknote =
      IconData(0xe056, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [barcode] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [barcode] icon is a graphical symbol that conveys a specific idea or functionality related to scan, checkout, till, cart, transaction, purchase, buy, product, packaging, retail, consumer.
  /// - It belongs to the shopping categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData barcode =
      IconData(0xe537, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [baseline] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [baseline] icon is a graphical symbol that conveys a specific idea or functionality related to text, format, color.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData baseline =
      IconData(0xe284, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bath] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bath] icon is a graphical symbol that conveys a specific idea or functionality related to amenities, services, bathroom, shower.
  /// - It belongs to the travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jamiemlaw](https://github.com/jamiemlaw) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bath =
      IconData(0xe2aa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [battery] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [battery] icon is a graphical symbol that conveys a specific idea or functionality related to power, electricity, energy, accumulator, charge.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData battery =
      IconData(0xe057, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [battery_charging] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [battery_charging] icon is a graphical symbol that conveys a specific idea or functionality related to power, electricity, energy, accumulator, charge.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData battery_charging =
      IconData(0xe058, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [battery_full] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [battery_full] icon is a graphical symbol that conveys a specific idea or functionality related to power, electricity, energy, accumulator, charge.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData battery_full =
      IconData(0xe059, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [battery_low] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [battery_low] icon is a graphical symbol that conveys a specific idea or functionality related to power, electricity, energy, accumulator, charge.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData battery_low =
      IconData(0xe05a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [battery_medium] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [battery_medium] icon is a graphical symbol that conveys a specific idea or functionality related to power, electricity, energy, accumulator, charge.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData battery_medium =
      IconData(0xe05b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [battery_warning] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [battery_warning] icon is a graphical symbol that conveys a specific idea or functionality related to power, electricity, energy, accumulator, charge, exclamation mark.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Kaladii](https://github.com/Kaladii), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData battery_warning =
      IconData(0xe3af, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [beaker] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [beaker] icon is a graphical symbol that conveys a specific idea or functionality related to cup, lab, chemistry, experiment, test.
  /// - It belongs to the science, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData beaker =
      IconData(0xe05c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bean] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bean] icon is a graphical symbol that conveys a specific idea or functionality related to legume, soy, food, seed.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bean =
      IconData(0xe392, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bean_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bean_off] icon is a graphical symbol that conveys a specific idea or functionality related to soy free, legume, soy, food, seed, allergy, intolerance, diet.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bean_off =
      IconData(0xe393, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bed] icon is a graphical symbol that conveys a specific idea or functionality related to sleep, hotel, furniture.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bed =
      IconData(0xe2c0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bed_double] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bed_double] icon is a graphical symbol that conveys a specific idea or functionality related to sleep, hotel, furniture.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bed_double =
      IconData(0xe2c1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bed_single] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bed_single] icon is a graphical symbol that conveys a specific idea or functionality related to sleep, hotel, furniture.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bed_single =
      IconData(0xe2c2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [beef] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [beef] icon is a graphical symbol that conveys a specific idea or functionality related to food, dish, restaurant, course, meal, meat, bbq, steak.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kemie](https://github.com/kemie), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData beef =
      IconData(0xe3a8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [beer] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [beer] icon is a graphical symbol that conveys a specific idea or functionality related to alcohol, bar, beverage, brewery, drink.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData beer =
      IconData(0xe2ce, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [beer_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [beer_off] icon is a graphical symbol that conveys a specific idea or functionality related to alcohol, bar, beverage, brewery, drink.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData beer_off =
      IconData(0xe5dd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bell] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bell] icon is a graphical symbol that conveys a specific idea or functionality related to alarm, notification, sound, reminder.
  /// - It belongs to the account, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bell =
      IconData(0xe05d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bell_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bell_dot] icon is a graphical symbol that conveys a specific idea or functionality related to alarm, notification, sound, reminder, unread.
  /// - It belongs to the account, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bell_dot =
      IconData(0xe42f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bell_electric] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bell_electric] icon is a graphical symbol that conveys a specific idea or functionality related to fire alarm, flames, smoke, firefighter, fireman, department, brigade, station, emergency, alert, safety, school bell, period break, recess, doorbell, entrance, entry, ring, reception.
  /// - It belongs to the devices, notifications, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bell_electric =
      IconData(0xe580, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bell_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bell_minus] icon is a graphical symbol that conveys a specific idea or functionality related to alarm, notification, silent, reminder, delete, remove, erase.
  /// - It belongs to the notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bell_minus =
      IconData(0xe1ef, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bell_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bell_off] icon is a graphical symbol that conveys a specific idea or functionality related to alarm, notification, silent, reminder.
  /// - It belongs to the notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bell_off =
      IconData(0xe05e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bell_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bell_plus] icon is a graphical symbol that conveys a specific idea or functionality related to notification, silent, reminder, add, create, new.
  /// - It belongs to the notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bell_plus =
      IconData(0xe1f0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bell_ring] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bell_ring] icon is a graphical symbol that conveys a specific idea or functionality related to alarm, notification, sound, reminder.
  /// - It belongs to the notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bell_ring =
      IconData(0xe223, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [between_horizontal_end] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [between_horizontal_end] icon is a graphical symbol that conveys a specific idea or functionality related to insert, add, left, slot, squeeze, space, vertical, grid, table, rows, cells, excel, spreadsheet, accountancy, data, enter, entry, entries, blocks, rectangles, chevron.
  /// - It belongs to the layout, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData between_horizontal_end =
      IconData(0xe595, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [between_horizontal_start] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [between_horizontal_start] icon is a graphical symbol that conveys a specific idea or functionality related to insert, add, right, slot, squeeze, space, vertical, grid, table, rows, cells, excel, spreadsheet, accountancy, data, enter, entry, entries, blocks, rectangles, chevron.
  /// - It belongs to the layout, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData between_horizontal_start =
      IconData(0xe596, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [between_vertical_end] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [between_vertical_end] icon is a graphical symbol that conveys a specific idea or functionality related to insert, add, top, slot, squeeze, space, vertical, grid, table, columns, cells, data, enter, entry, entries, blocks, rectangles, chevron.
  /// - It belongs to the layout, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData between_vertical_end =
      IconData(0xe597, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [between_vertical_start] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [between_vertical_start] icon is a graphical symbol that conveys a specific idea or functionality related to insert, add, bottom, slot, squeeze, space, vertical, grid, table, columns, cells, data, enter, entry, entries, blocks, rectangles, chevron.
  /// - It belongs to the layout, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData between_vertical_start =
      IconData(0xe598, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [biceps_flexed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [biceps_flexed] icon is a graphical symbol that conveys a specific idea or functionality related to arm, muscle, strong, working out, athletic, toned, muscular, forelimb, curled.
  /// - It belongs to the emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData biceps_flexed =
      IconData(0xe5ef, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bike] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bike] icon is a graphical symbol that conveys a specific idea or functionality related to bicycle, transport, trip.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ahtohbi4](https://github.com/ahtohbi4), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/csandman](https://github.com/csandman), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bike =
      IconData(0xe1d1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [binary] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [binary] icon is a graphical symbol that conveys a specific idea or functionality related to code, digits, computer, zero, one, boolean.
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData binary =
      IconData(0xe1f1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [binoculars] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [binoculars] icon is a graphical symbol that conveys a specific idea or functionality related to field glasses, lorgnette, pince-nez, observation, sightseeing, nature, wildlife, birdwatching, scouting, surveillance, search, discovery, monitoring, lookout, viewpoint, travel, tourism, research.
  /// - It belongs to the navigation, nature, photography, science, travel, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData binoculars =
      IconData(0xe625, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [biohazard] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [biohazard] icon is a graphical symbol that conveys a specific idea or functionality related to fallout, waste, biology, chemistry, chemical, element.
  /// - It belongs to the science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData biohazard =
      IconData(0xe445, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bird] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bird] icon is a graphical symbol that conveys a specific idea or functionality related to peace, freedom, wing, avian, tweet.
  /// - It belongs to the animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/it-is-not](https://github.com/it-is-not) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bird =
      IconData(0xe3c8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bitcoin] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bitcoin] icon is a graphical symbol that conveys a specific idea or functionality related to currency, money, payment.
  /// - It belongs to the brands, development, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bitcoin =
      IconData(0xe05f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [blend] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [blend] icon is a graphical symbol that conveys a specific idea or functionality related to mode, overlay, multiply, screen, opacity, transparency, alpha, filters, lenses, mixed, shades, tints, hues, saturation, brightness, overlap, colors, colours.
  /// - It belongs to the design, photography, tools, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData blend =
      IconData(0xe5a0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [blinds] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [blinds] icon is a graphical symbol that conveys a specific idea or functionality related to shades, screen, curtain, shutter, roller blind, window, lighting, household, home.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/it-is-not](https://github.com/it-is-not) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData blinds =
      IconData(0xe3c3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [blocks] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [blocks] icon is a graphical symbol that conveys a specific idea or functionality related to addon, plugin, integration, extension, package, build, stack, toys, kids, children, learning.
  /// - It belongs to the development, shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData blocks =
      IconData(0xe4fe, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bluetooth] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bluetooth] icon is a graphical symbol that conveys a specific idea or functionality related to wireless.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bluetooth =
      IconData(0xe060, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bluetooth_connected] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bluetooth_connected] icon is a graphical symbol that conveys a specific idea or functionality related to paired.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bluetooth_connected =
      IconData(0xe1b7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bluetooth_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bluetooth_off] icon is a graphical symbol that conveys a specific idea or functionality related to lost.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bluetooth_off =
      IconData(0xe1b8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bluetooth_searching] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bluetooth_searching] icon is a graphical symbol that conveys a specific idea or functionality related to pairing.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bluetooth_searching =
      IconData(0xe1b9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bold] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bold] icon is a graphical symbol that conveys a specific idea or functionality related to text, strong, format.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bold =
      IconData(0xe061, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bolt] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bolt] icon is a graphical symbol that conveys a specific idea or functionality related to nut, screw, settings, preferences, configuration, controls, edit, diy, fixed, build, contruction, parts.
  /// - It belongs to the tools, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bolt =
      IconData(0xe590, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bomb] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bomb] icon is a graphical symbol that conveys a specific idea or functionality related to fatal, error, crash, blockbuster, mine, explosion, explode, explosive.
  /// - It belongs to the  categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bomb =
      IconData(0xe2fe, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bone] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bone] icon is a graphical symbol that conveys a specific idea or functionality related to health, skeleton, skull, death, pets, dog.
  /// - It belongs to the animals, medical, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bone =
      IconData(0xe35b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book] icon is a graphical symbol that conveys a specific idea or functionality related to reading, paperback, booklet, magazine, leaflet, pamphlet, tome, library, writing, written, writer, author, story, script, fiction, novel, information, knowledge, education, high school, university, college, academy, student, study, learning, homework, research, documentation.
  /// - It belongs to the text, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book =
      IconData(0xe062, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_a] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_a] icon is a graphical symbol that conveys a specific idea or functionality related to dictionary, define, definition, thesaurus, encyclopedia, encyclopaedia, reading, booklet, magazine, leaflet, pamphlet, tome, library, writing, written, writer, author, story, script, fiction, novel, information, knowledge, education, high school, university, college, academy, student, study, learning, homework, research, language, translate, alphabetical, a-z, ordered.
  /// - It belongs to the text, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_a =
      IconData(0xe548, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_audio] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_audio] icon is a graphical symbol that conveys a specific idea or functionality related to audiobook, reading, listening, sound, story, fiction, novel, information, knowledge, education, student, study, learning, research.
  /// - It belongs to the multimedia, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_audio =
      IconData(0xe549, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_check] icon is a graphical symbol that conveys a specific idea or functionality related to read, booklet, magazine, leaflet, pamphlet, library, written, authored, published, informed, knowledgeable, educated, schooled, homework, examined, tested, marked, passed, graduated, studied, learned, lesson, researched, documented, revealed, blank, plain language, true, truth, verified, corrected, task, todo, done, completed, finished, ticked.
  /// - It belongs to the text, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_check =
      IconData(0xe54a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_copy] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_copy] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, clone, fork, duplicate, multiple, books, library, copies, copied, plagiarism, plagiarised, plagiarized, reading list, information, informed, knowledge, knowledgeable, knowledgable, education, high school, university, college, academy, student, study, learning, research, smart, intelligent, intellectual.
  /// - It belongs to the development, text, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_copy =
      IconData(0xe3f0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, template, draft, script, screenplay, writing, writer, author, unwritten, unpublished, untold.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_dashed =
      IconData(0xe3f1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_down] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, pull.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_down =
      IconData(0xe3f2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_headphones] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_headphones] icon is a graphical symbol that conveys a specific idea or functionality related to audiobook, reading, listening, sound, story, fiction, novel, information, knowledge, education, student, study, learning, research.
  /// - It belongs to the multimedia, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_headphones =
      IconData(0xe54b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_heart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_heart] icon is a graphical symbol that conveys a specific idea or functionality related to diary, romance, novel, journal, entry, entries, personal, private, secret, crush, like, love, emotion, feminine, girls, teens, teenager, therapy, theraputic, therapist, planner, organizer, organiser, notes, notepad, stationery, sketchbook, writing, written, reading, favorite, favourite, high school.
  /// - It belongs to the social, text, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_heart =
      IconData(0xe54c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_image] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_image] icon is a graphical symbol that conveys a specific idea or functionality related to images, pictures, photos, album, collection, event, magazine, catalog, catalogue, brochure, browse, gallery.
  /// - It belongs to the photography, text, multimedia, files, social, shopping, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_image =
      IconData(0xe54d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_key] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_key] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, private, public, secret, unlocked, hidden, revealed, knowledge, learning.
  /// - It belongs to the development, security, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_key =
      IconData(0xe3f3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_lock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_lock] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, private, secret, hidden, knowledge.
  /// - It belongs to the development, security, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_lock =
      IconData(0xe3f4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_marked] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_marked] icon is a graphical symbol that conveys a specific idea or functionality related to dictionary, reading, booklet, magazine, leaflet, pamphlet, tome, library, writing, written, writer, author, story, script, fiction, novel, information, knowledge, education, high school, university, college, academy, student, study, learning, homework, research, documentation, saved, later, future, reference, index, code, coding, version control, git, repository.
  /// - It belongs to the text, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_marked =
      IconData(0xe3f5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_minus] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, remove, delete, censor, cancel, forbid, prohibit, ban, uneducated, re-educate, unlearn, downgrade.
  /// - It belongs to the development, text, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_minus =
      IconData(0xe3f6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_open] icon is a graphical symbol that conveys a specific idea or functionality related to reading, pages, booklet, magazine, leaflet, pamphlet, library, writing, written, writer, author, story, script, screenplay, fiction, novel, information, knowledge, education, high school, university, college, academy, student, study, learning, homework, research, documentation, revealed, blank, plain.
  /// - It belongs to the text, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_open =
      IconData(0xe063, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_open_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_open_check] icon is a graphical symbol that conveys a specific idea or functionality related to read, pages, booklet, magazine, leaflet, pamphlet, library, written, authored, published, informed, knowledgeable, educated, schooled, homework, examined, tested, marked, passed, graduated, studied, learned, lesson, researched, documented, revealed, blank, plain language, true, truth, verified, corrected, task, todo, done, completed, finished, ticked.
  /// - It belongs to the text, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/schmidt-oliver](https://github.com/schmidt-oliver), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_open_check =
      IconData(0xe384, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_open_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_open_text] icon is a graphical symbol that conveys a specific idea or functionality related to reading, pages, booklet, magazine, leaflet, pamphlet, library, writing, written, writer, author, story, script, fiction, novel, information, knowledge, education, high school, university, college, academy, student, study, learning, homework, research, documentation, revealed.
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_open_text =
      IconData(0xe54e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_plus] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, remove, delete, read, write, author, publish, inform, graduate, re-educate, study, learn, research, knowledge, improve, upgrade, level up.
  /// - It belongs to the development, text, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_plus =
      IconData(0xe3f7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_text] icon is a graphical symbol that conveys a specific idea or functionality related to reading, booklet, magazine, leaflet, pamphlet, tome, library, writing, written, writer, author, story, script, fiction, novel, information, knowledge, education, high school, university, college, academy, student, study, learning, homework, research, documentation.
  /// - It belongs to the text, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_text =
      IconData(0xe54f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_type] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_type] icon is a graphical symbol that conveys a specific idea or functionality related to thesaurus, synonym, reading, booklet, magazine, leaflet, pamphlet, tome, library, writing, written, writer, author, story, script, fiction, novel, information, knowledge, education, high school, university, college, academy, student, study, learning, homework, research, language, translate, typography, fonts, collection.
  /// - It belongs to the text, design, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_type =
      IconData(0xe550, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_up] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, push.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_up =
      IconData(0xe3f8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_up_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_up_2] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, push, force.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_up_2 =
      IconData(0xe4aa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_user] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_user] icon is a graphical symbol that conveys a specific idea or functionality related to person, people, family, friends, acquaintances, contacts, details, addresses, phone numbers, directory, listing, networking.
  /// - It belongs to the account, connectivity, communication, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_user =
      IconData(0xe551, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [book_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [book_x] icon is a graphical symbol that conveys a specific idea or functionality related to code, coding, version control, git, repository, remove, delete, reading, misinformation, disinformation, misinformed, charlatan, sophistry, false, lies, untruth, propaganda, censored, cancelled, forbidden, prohibited, banned, uneducated, re-education, unlearn.
  /// - It belongs to the text, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData book_x =
      IconData(0xe3f9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bookmark] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bookmark] icon is a graphical symbol that conveys a specific idea or functionality related to read, clip, marker, tag.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/siarie](https://github.com/siarie), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bookmark =
      IconData(0xe064, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bookmark_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bookmark_check] icon is a graphical symbol that conveys a specific idea or functionality related to read, finished, complete, clip, marker, tag, task, todo.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bookmark_check =
      IconData(0xe523, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bookmark_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bookmark_minus] icon is a graphical symbol that conveys a specific idea or functionality related to delete, remove.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/siarie](https://github.com/siarie), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bookmark_minus =
      IconData(0xe23b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bookmark_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bookmark_plus] icon is a graphical symbol that conveys a specific idea or functionality related to add.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/siarie](https://github.com/siarie), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bookmark_plus =
      IconData(0xe23c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bookmark_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bookmark_x] icon is a graphical symbol that conveys a specific idea or functionality related to read, clip, marker, tag, cancel, close, delete, remove, clear.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bookmark_x =
      IconData(0xe524, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [boom_box] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [boom_box] icon is a graphical symbol that conveys a specific idea or functionality related to radio, speakers, audio, music, sound, broadcast, live, frequency.
  /// - It belongs to the devices, multimedia, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData boom_box =
      IconData(0xe4f2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bot] icon is a graphical symbol that conveys a specific idea or functionality related to robot, ai, chat, assistant.
  /// - It belongs to the development, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bot =
      IconData(0xe1ba, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bot_message_square] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bot_message_square] icon is a graphical symbol that conveys a specific idea or functionality related to robot, ai, chat, assistant.
  /// - It belongs to the development, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bot_message_square =
      IconData(0xe5d2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bot_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bot_off] icon is a graphical symbol that conveys a specific idea or functionality related to robot, ai, chat, assistant.
  /// - It belongs to the development, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/taichimaeda](https://github.com/taichimaeda), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bot_off =
      IconData(0xe5e4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [box] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [box] icon is a graphical symbol that conveys a specific idea or functionality related to cube, package, container, storage, geometry, 3d, isometric.
  /// - It belongs to the shapes, gaming, development, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData box =
      IconData(0xe065, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [boxes] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [boxes] icon is a graphical symbol that conveys a specific idea or functionality related to cubes, packages, parts, group, units, collection, cluster, geometry.
  /// - It belongs to the shapes, gaming, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData boxes =
      IconData(0xe2cf, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [braces] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [braces] icon is a graphical symbol that conveys a specific idea or functionality related to json, code, token, curly brackets, data, {, }.
  /// - It belongs to the development, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData braces =
      IconData(0xe36d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [brackets] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [brackets] icon is a graphical symbol that conveys a specific idea or functionality related to code, token, array, list, square, [, ].
  /// - It belongs to the development, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData brackets =
      IconData(0xe447, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [brain] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [brain] icon is a graphical symbol that conveys a specific idea or functionality related to medical, mind, intellect, cerebral, consciousness, genius, artificial intelligence, ai.
  /// - It belongs to the medical, science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/it-is-not](https://github.com/it-is-not) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData brain =
      IconData(0xe3c9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [brain_circuit] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [brain_circuit] icon is a graphical symbol that conveys a specific idea or functionality related to mind, intellect, artificial intelligence, ai, deep learning, machine learning, computing.
  /// - It belongs to the science, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData brain_circuit =
      IconData(0xe3ca, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [brain_cog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [brain_cog] icon is a graphical symbol that conveys a specific idea or functionality related to mind, intellect, artificial intelligence, ai, deep learning, machine learning, computing.
  /// - It belongs to the science, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/it-is-not](https://github.com/it-is-not) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData brain_cog =
      IconData(0xe3cb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [brick_wall] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [brick_wall] icon is a graphical symbol that conveys a specific idea or functionality related to bricks, mortar, cement, materials, construction, builder, labourer, quantity surveyor, blocks, stone.
  /// - It belongs to the buildings, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData brick_wall =
      IconData(0xe585, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [briefcase] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [briefcase] icon is a graphical symbol that conveys a specific idea or functionality related to work, bag, baggage, folder.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData briefcase =
      IconData(0xe066, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [briefcase_business] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [briefcase_business] icon is a graphical symbol that conveys a specific idea or functionality related to work, bag, baggage, folder, portfolio.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData briefcase_business =
      IconData(0xe5d9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [briefcase_conveyor_belt] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [briefcase_conveyor_belt] icon is a graphical symbol that conveys a specific idea or functionality related to baggage, luggage, travel, suitcase, conveyor, carousel.
  /// - It belongs to the travel, transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData briefcase_conveyor_belt =
      IconData(0xe62f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [briefcase_medical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [briefcase_medical] icon is a graphical symbol that conveys a specific idea or functionality related to doctor, medicine, first aid.
  /// - It belongs to the medical, transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData briefcase_medical =
      IconData(0xe5da, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bring_to_front] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bring_to_front] icon is a graphical symbol that conveys a specific idea or functionality related to bring, send, move, over, forward, front, overlap, layer, order.
  /// - It belongs to the design, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/james-yeoman](https://github.com/james-yeoman), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bring_to_front =
      IconData(0xe4f3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [brush] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [brush] icon is a graphical symbol that conveys a specific idea or functionality related to draw, paint, color, artist.
  /// - It belongs to the text, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData brush =
      IconData(0xe1d2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bug] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bug] icon is a graphical symbol that conveys a specific idea or functionality related to issue, report, debug, code, insect.
  /// - It belongs to the development, animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bug =
      IconData(0xe20b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bug_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bug_off] icon is a graphical symbol that conveys a specific idea or functionality related to debug, code, insect, kill, exterminate, pest control.
  /// - It belongs to the development, animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bug_off =
      IconData(0xe511, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bug_play] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bug_play] icon is a graphical symbol that conveys a specific idea or functionality related to debug, code, insect.
  /// - It belongs to the development, animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bug_play =
      IconData(0xe512, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [building] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [building] icon is a graphical symbol that conveys a specific idea or functionality related to organisation, organization.
  /// - It belongs to the account, buildings categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData building =
      IconData(0xe1cb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [building_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [building_2] icon is a graphical symbol that conveys a specific idea or functionality related to business, company, enterprise, skyscraper, organisation, organization, city.
  /// - It belongs to the account, buildings categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/maxim-s-barabash](https://github.com/maxim-s-barabash), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData building_2 =
      IconData(0xe28f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bus] icon is a graphical symbol that conveys a specific idea or functionality related to bus, vehicle, transport, trip.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ahtohbi4](https://github.com/ahtohbi4), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bus =
      IconData(0xe1d3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [bus_front] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [bus_front] icon is a graphical symbol that conveys a specific idea or functionality related to coach, vehicle, trip, road.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData bus_front =
      IconData(0xe4ff, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cable] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cable] icon is a graphical symbol that conveys a specific idea or functionality related to cord, wire, connector, connection, link, signal, console, computer, equipment, electricity, energy, electronics, recharging, charger, power, supply, disconnected, unplugged, plugs, interface, input, output, audio video, av, rca, scart, tv, television, optical.
  /// - It belongs to the connectivity, devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cable =
      IconData(0xe4e7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cable_car] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cable_car] icon is a graphical symbol that conveys a specific idea or functionality related to ski lift, winter holiday, alpine, resort, mountains.
  /// - It belongs to the transportation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cable_car =
      IconData(0xe500, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cake] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cake] icon is a graphical symbol that conveys a specific idea or functionality related to birthday, birthdate, celebration, party, surprise, gateaux, dessert, fondant, icing sugar, sweet, baking.
  /// - It belongs to the food-beverage, social, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cake =
      IconData(0xe347, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cake_slice] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cake_slice] icon is a graphical symbol that conveys a specific idea or functionality related to birthday, birthdate, celebration, party, surprise, gateaux, dessert, candles, wish, fondant, icing sugar, sweet, baking.
  /// - It belongs to the food-beverage, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cake_slice =
      IconData(0xe4bd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calculator] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calculator] icon is a graphical symbol that conveys a specific idea or functionality related to count, calculating machine.
  /// - It belongs to the math, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calculator =
      IconData(0xe1bb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar] icon is a graphical symbol that conveys a specific idea or functionality related to date, month, year, event, birthday, birthdate.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar =
      IconData(0xe067, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_1] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_1] icon is a graphical symbol that conveys a specific idea or functionality related to date, month, year, event, single, singular, once, 1, first.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/peteruithoven](https://github.com/peteruithoven) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_1 =
      IconData(0xe634, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_arrow_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_arrow_down] icon is a graphical symbol that conveys a specific idea or functionality related to date, month, year, event, sort, order, ascending, descending, increasing, decreasing, rising, falling.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_arrow_down =
      IconData(0xe602, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_arrow_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_arrow_up] icon is a graphical symbol that conveys a specific idea or functionality related to date, month, year, event, sort, order, ascending, descending, increasing, decreasing, rising, falling.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_arrow_up =
      IconData(0xe603, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_check] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, confirm, subscribe, schedule, done, todo, tick, complete, task.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_check =
      IconData(0xe2b6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_check_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_check_2] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, confirm, subscribe, schedule, done, todo, tick, complete, task.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_check_2 =
      IconData(0xe2b7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_clock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_clock] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, clock, hour.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_clock =
      IconData(0xe303, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_cog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_cog] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, events, settings, gear, cog.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/AlexandrePhilibert](https://github.com/AlexandrePhilibert) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_cog =
      IconData(0xe5f1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_days] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_days] icon is a graphical symbol that conveys a specific idea or functionality related to date, month, year, event.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_days =
      IconData(0xe2b8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_fold] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_fold] icon is a graphical symbol that conveys a specific idea or functionality related to date, month, year, event, birthday, birthdate, ics.
  /// - It belongs to the time, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_fold =
      IconData(0xe5b8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_heart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_heart] icon is a graphical symbol that conveys a specific idea or functionality related to date, month, year, event, heart, favourite, subscribe, valentines day.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_heart =
      IconData(0xe304, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_minus] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, delete, remove.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_minus =
      IconData(0xe2b9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_minus_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_minus_2] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, delete, remove.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_minus_2 =
      IconData(0xe5b9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_off] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, delete, remove.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_off =
      IconData(0xe2ba, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_plus] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, add, subscribe, create, new.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_plus =
      IconData(0xe2bb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_plus_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_plus_2] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, add, subscribe, create, new.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_plus_2 =
      IconData(0xe5ba, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_range] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_range] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, range, period.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_range =
      IconData(0xe2bc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_search] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_search] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, events, search.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_search =
      IconData(0xe305, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_sync] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_sync] icon is a graphical symbol that conveys a specific idea or functionality related to repeat, refresh, reconnect, transfer, backup, date, month, year, event, subscribe, recurring, schedule, reminder, automatic, auto.
  /// - It belongs to the arrows, time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/chessurisme](https://github.com/chessurisme) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_sync =
      IconData(0xe63a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_x] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, remove, busy.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_x =
      IconData(0xe2bd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [calendar_x_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [calendar_x_2] icon is a graphical symbol that conveys a specific idea or functionality related to date, day, month, year, event, remove.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData calendar_x_2 =
      IconData(0xe2be, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [camera] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [camera] icon is a graphical symbol that conveys a specific idea or functionality related to photo, webcam, video.
  /// - It belongs to the photography, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData camera =
      IconData(0xe068, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [camera_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [camera_off] icon is a graphical symbol that conveys a specific idea or functionality related to photo, webcam, video.
  /// - It belongs to the photography, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData camera_off =
      IconData(0xe069, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [candy] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [candy] icon is a graphical symbol that conveys a specific idea or functionality related to sugar, food, sweet.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData candy =
      IconData(0xe394, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [candy_cane] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [candy_cane] icon is a graphical symbol that conveys a specific idea or functionality related to sugar, food, sweet, christmas, xmas.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData candy_cane =
      IconData(0xe4be, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [candy_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [candy_off] icon is a graphical symbol that conveys a specific idea or functionality related to sugar free, food, sweet, allergy, intolerance, diet.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData candy_off =
      IconData(0xe395, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cannabis] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cannabis] icon is a graphical symbol that conveys a specific idea or functionality related to cannabis, weed, leaf.
  /// - It belongs to the nature categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cannabis =
      IconData(0xe5d8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [captions] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [captions] icon is a graphical symbol that conveys a specific idea or functionality related to closed captions, subtitles, subhead, transcription, transcribe, dialogue, accessibility.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/DefaultLP](https://github.com/DefaultLP) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData captions =
      IconData(0xe3a7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [captions_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [captions_off] icon is a graphical symbol that conveys a specific idea or functionality related to closed captions, subtitles, subhead, transcription, transcribe, dialogue, accessibility.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/DefaultLP](https://github.com/DefaultLP) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData captions_off =
      IconData(0xe5c5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [car] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [car] icon is a graphical symbol that conveys a specific idea or functionality related to vehicle, drive, trip, journey.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ahtohbi4](https://github.com/ahtohbi4), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/Andreto](https://github.com/Andreto) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData car =
      IconData(0xe1d4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [car_front] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [car_front] icon is a graphical symbol that conveys a specific idea or functionality related to vehicle, drive, trip, journey.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData car_front =
      IconData(0xe501, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [car_taxi_front] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [car_taxi_front] icon is a graphical symbol that conveys a specific idea or functionality related to cab, vehicle, drive, trip, journey.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData car_taxi_front =
      IconData(0xe502, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [caravan] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [caravan] icon is a graphical symbol that conveys a specific idea or functionality related to trailer, tow, camping, campsite, mobile home, holiday, nomadic, wilderness, outdoors.
  /// - It belongs to the transportation, travel, nature categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData caravan =
      IconData(0xe53d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [carrot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [carrot] icon is a graphical symbol that conveys a specific idea or functionality related to vegetable, food, eat.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData carrot =
      IconData(0xe259, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [case_lower] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [case_lower] icon is a graphical symbol that conveys a specific idea or functionality related to text, letters, characters, font, typography.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData case_lower =
      IconData(0xe3db, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [case_sensitive] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [case_sensitive] icon is a graphical symbol that conveys a specific idea or functionality related to text, letters, characters, font, typography.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData case_sensitive =
      IconData(0xe3dc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [case_upper] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [case_upper] icon is a graphical symbol that conveys a specific idea or functionality related to text, letters, characters, font, typography.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData case_upper =
      IconData(0xe3dd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cassette_tape] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cassette_tape] icon is a graphical symbol that conveys a specific idea or functionality related to audio, music, recording, play.
  /// - It belongs to the connectivity, devices, multimedia, communication, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cassette_tape =
      IconData(0xe4ce, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cast] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cast] icon is a graphical symbol that conveys a specific idea or functionality related to chromecast, airplay, screen.
  /// - It belongs to the devices, connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cast =
      IconData(0xe06a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [castle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [castle] icon is a graphical symbol that conveys a specific idea or functionality related to fortress, stronghold, palace, chateau, building.
  /// - It belongs to the buildings, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData castle =
      IconData(0xe3e3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cat] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cat] icon is a graphical symbol that conveys a specific idea or functionality related to animal, pet, kitten, feline.
  /// - It belongs to the animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kemie](https://github.com/kemie) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cat =
      IconData(0xe38f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cctv] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cctv] icon is a graphical symbol that conveys a specific idea or functionality related to camera, surveillance, recording, film, videotape, crime, watching.
  /// - It belongs to the security, devices, communication, connectivity, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cctv =
      IconData(0xe581, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_area] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_area] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, area.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/nstokoe](https://github.com/nstokoe) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_area =
      IconData(0xe4d7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_bar] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_bar] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_bar =
      IconData(0xe2a1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_bar_big] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_bar_big] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_bar_big =
      IconData(0xe4ab, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_bar_decreasing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_bar_decreasing] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, trending down.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_bar_decreasing =
      IconData(0xe60b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_bar_increasing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_bar_increasing] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, trending up.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_bar_increasing =
      IconData(0xe60c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_bar_stacked] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_bar_stacked] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, multivariate, categorical, comparison.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_bar_stacked =
      IconData(0xe60d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_candlestick] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_candlestick] icon is a graphical symbol that conveys a specific idea or functionality related to trading, trader, financial, markets, portfolio, assets, prices, value, valuation, commodities, currencies, currency, stocks, exchange, hedge fund, statistics, analytics, diagram, graph.
  /// - It belongs to the charts, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_candlestick =
      IconData(0xe4ac, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_column] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_column] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_column =
      IconData(0xe2a2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_column_big] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_column_big] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_column_big =
      IconData(0xe4ad, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_column_decreasing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_column_decreasing] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, trending down.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_column_decreasing =
      IconData(0xe06b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_column_increasing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_column_increasing] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, trending up.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_column_increasing =
      IconData(0xe2a3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_column_stacked] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_column_stacked] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, multivariate, categorical, comparison.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_column_stacked =
      IconData(0xe60e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_gantt] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_gantt] icon is a graphical symbol that conveys a specific idea or functionality related to diagram, graph, timeline, planning.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_gantt =
      IconData(0xe628, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_line] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_line =
      IconData(0xe2a4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_network] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_network] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, topology, cluster, web, nodes, connections, edges.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_network =
      IconData(0xe60f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_no_axes_column] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_no_axes_column] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_no_axes_column =
      IconData(0xe06c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_no_axes_column_decreasing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_no_axes_column_decreasing] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, trending down.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_no_axes_column_decreasing =
      IconData(0xe06d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_no_axes_column_increasing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_no_axes_column_increasing] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, trending up.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_no_axes_column_increasing =
      IconData(0xe06e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_no_axes_combined] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_no_axes_combined] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, trending up.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_no_axes_combined =
      IconData(0xe610, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_no_axes_gantt] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_no_axes_gantt] icon is a graphical symbol that conveys a specific idea or functionality related to projects, manage, overview, roadmap, plan, intentions, timeline, deadline, date, event, range, period, productivity, work, agile, code, coding.
  /// - It belongs to the charts, time, development, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_no_axes_gantt =
      IconData(0xe4c8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_pie] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_pie] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, presentation.
  /// - It belongs to the charts, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_pie =
      IconData(0xe06f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_scatter] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_scatter] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_scatter =
      IconData(0xe48e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chart_spline] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chart_spline] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, curve, continuous, smooth, polynomial, quadratic, function, interpolation.
  /// - It belongs to the charts categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chart_spline =
      IconData(0xe611, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [check] icon is a graphical symbol that conveys a specific idea or functionality related to done, todo, tick, complete, task.
  /// - It belongs to the notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData check =
      IconData(0xe070, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [check_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [check_check] icon is a graphical symbol that conveys a specific idea or functionality related to done, received, double, todo, tick, complete, task.
  /// - It belongs to the notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData check_check =
      IconData(0xe391, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chef_hat] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chef_hat] icon is a graphical symbol that conveys a specific idea or functionality related to cooking, food, kitchen, restaurant.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chef_hat =
      IconData(0xe2ab, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cherry] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cherry] icon is a graphical symbol that conveys a specific idea or functionality related to fruit, food.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cherry =
      IconData(0xe353, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevron_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevron_down] icon is a graphical symbol that conveys a specific idea or functionality related to backwards, reverse, slow, dropdown.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevron_down =
      IconData(0xe071, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevron_first] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevron_first] icon is a graphical symbol that conveys a specific idea or functionality related to previous, music.
  /// - It belongs to the arrows, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/dperezcabrera](https://github.com/dperezcabrera), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevron_first =
      IconData(0xe242, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevron_last] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevron_last] icon is a graphical symbol that conveys a specific idea or functionality related to skip, next, music.
  /// - It belongs to the arrows, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/dperezcabrera](https://github.com/dperezcabrera), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevron_last =
      IconData(0xe243, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevron_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevron_left] icon is a graphical symbol that conveys a specific idea or functionality related to back, previous, less than, fewer, menu, <.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevron_left =
      IconData(0xe072, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevron_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevron_right] icon is a graphical symbol that conveys a specific idea or functionality related to forward, next, more than, greater, menu, code, coding, command line, terminal, prompt, shell, >.
  /// - It belongs to the arrows, navigation, math, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevron_right =
      IconData(0xe073, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevron_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevron_up] icon is a graphical symbol that conveys a specific idea or functionality related to caret, keyboard, mac, control, ctrl, superscript, exponential, power, ahead, fast, ^, dropdown.
  /// - It belongs to the arrows, navigation, math, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevron_up =
      IconData(0xe074, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevrons_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevrons_down] icon is a graphical symbol that conveys a specific idea or functionality related to backwards, reverse, slower.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevrons_down =
      IconData(0xe075, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevrons_down_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevrons_down_up] icon is a graphical symbol that conveys a specific idea or functionality related to collapse, fold, vertical.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/PeterlitsZo](https://github.com/PeterlitsZo), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevrons_down_up =
      IconData(0xe227, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevrons_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevrons_left] icon is a graphical symbol that conveys a specific idea or functionality related to turn, corner.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevrons_left =
      IconData(0xe076, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevrons_left_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevrons_left_right] icon is a graphical symbol that conveys a specific idea or functionality related to expand, horizontal, unfold.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevrons_left_right =
      IconData(0xe292, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevrons_left_right_ellipsis] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevrons_left_right_ellipsis] icon is a graphical symbol that conveys a specific idea or functionality related to internet, network, connection, cable, lan, port, router, switch, hub, modem, web, online, networking, communication, socket, plug, slot, controller, connector, interface, console, signal, data, input, output.
  /// - It belongs to the communication, devices, multimedia, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevrons_left_right_ellipsis =
      IconData(0xe623, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevrons_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevrons_right] icon is a graphical symbol that conveys a specific idea or functionality related to turn, corner.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevrons_right =
      IconData(0xe077, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevrons_right_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevrons_right_left] icon is a graphical symbol that conveys a specific idea or functionality related to collapse, fold, horizontal.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevrons_right_left =
      IconData(0xe293, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevrons_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevrons_up] icon is a graphical symbol that conveys a specific idea or functionality related to forward, ahead, faster, speed, boost.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevrons_up =
      IconData(0xe078, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chevrons_up_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chevrons_up_down] icon is a graphical symbol that conveys a specific idea or functionality related to expand, unfold, vertical.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chevrons_up_down =
      IconData(0xe210, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [chrome] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [chrome] icon is a graphical symbol that conveys a specific idea or functionality related to browser, logo.
  /// - It belongs to the brands categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData chrome =
      IconData(0xe079, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [church] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [church] icon is a graphical symbol that conveys a specific idea or functionality related to temple, building.
  /// - It belongs to the buildings, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData church =
      IconData(0xe3e4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cigarette] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cigarette] icon is a graphical symbol that conveys a specific idea or functionality related to smoking.
  /// - It belongs to the travel, transportation, medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cigarette =
      IconData(0xe2c5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cigarette_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cigarette_off] icon is a graphical symbol that conveys a specific idea or functionality related to smoking, no-smoking.
  /// - It belongs to the travel, transportation, medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cigarette_off =
      IconData(0xe2c6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle] icon is a graphical symbol that conveys a specific idea or functionality related to off, zero, record, shape.
  /// - It belongs to the shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle =
      IconData(0xe07a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_alert] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_alert] icon is a graphical symbol that conveys a specific idea or functionality related to warning, alert, danger, exclamation mark.
  /// - It belongs to the notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_alert =
      IconData(0xe07b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_arrow_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_arrow_down] icon is a graphical symbol that conveys a specific idea or functionality related to backwards, reverse, direction, south, sign, button.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_arrow_down =
      IconData(0xe07c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_arrow_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_arrow_left] icon is a graphical symbol that conveys a specific idea or functionality related to previous, back, direction, west, sign, turn, button, <-.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_arrow_left =
      IconData(0xe07d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_arrow_out_down_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_arrow_out_down_left] icon is a graphical symbol that conveys a specific idea or functionality related to outwards, direction, south-west, diagonal.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_arrow_out_down_left =
      IconData(0xe3fb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_arrow_out_down_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_arrow_out_down_right] icon is a graphical symbol that conveys a specific idea or functionality related to outwards, direction, south-east, diagonal.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_arrow_out_down_right =
      IconData(0xe3fc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_arrow_out_up_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_arrow_out_up_left] icon is a graphical symbol that conveys a specific idea or functionality related to outwards, direction, north-west, diagonal, keyboard, button, escape.
  /// - It belongs to the arrows, navigation, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_arrow_out_up_left =
      IconData(0xe3fd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_arrow_out_up_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_arrow_out_up_right] icon is a graphical symbol that conveys a specific idea or functionality related to outwards, direction, north-east, diagonal.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_arrow_out_up_right =
      IconData(0xe3fe, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_arrow_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_arrow_right] icon is a graphical symbol that conveys a specific idea or functionality related to next, forward, direction, east, sign, turn, button, ->.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_arrow_right =
      IconData(0xe07e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_arrow_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_arrow_up] icon is a graphical symbol that conveys a specific idea or functionality related to forward, direction, north, sign, button.
  /// - It belongs to the arrows, navigation, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_arrow_up =
      IconData(0xe07f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_check] icon is a graphical symbol that conveys a specific idea or functionality related to done, todo, tick, complete, task.
  /// - It belongs to the notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_check =
      IconData(0xe225, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_check_big] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_check_big] icon is a graphical symbol that conveys a specific idea or functionality related to done, todo, tick, complete, task.
  /// - It belongs to the notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_check_big =
      IconData(0xe080, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_chevron_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_chevron_down] icon is a graphical symbol that conveys a specific idea or functionality related to back, menu.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_chevron_down =
      IconData(0xe4e1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_chevron_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_chevron_left] icon is a graphical symbol that conveys a specific idea or functionality related to back, previous, less than, fewer, menu, <.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_chevron_left =
      IconData(0xe4e2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_chevron_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_chevron_right] icon is a graphical symbol that conveys a specific idea or functionality related to back, more than, greater, menu, >.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_chevron_right =
      IconData(0xe4e3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_chevron_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_chevron_up] icon is a graphical symbol that conveys a specific idea or functionality related to caret, ahead, menu, ^.
  /// - It belongs to the arrows, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_chevron_up =
      IconData(0xe4e4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to pending, dot, progress, issue, draft, code, coding, version control.
  /// - It belongs to the development, shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_dashed =
      IconData(0xe4b4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_divide] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_divide] icon is a graphical symbol that conveys a specific idea or functionality related to calculate, math, ÷, /.
  /// - It belongs to the math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_divide =
      IconData(0xe081, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_dollar_sign] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_dollar_sign] icon is a graphical symbol that conveys a specific idea or functionality related to monetization, marketing, currency, money, payment.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_dollar_sign =
      IconData(0xe481, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_dot] icon is a graphical symbol that conveys a specific idea or functionality related to pending, dot, progress, issue, code, coding, version control, choices, multiple choice, choose.
  /// - It belongs to the development, shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_dot =
      IconData(0xe348, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_dot_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_dot_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to pending, dot, progress, issue, draft, code, coding, version control.
  /// - It belongs to the development, shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_dot_dashed =
      IconData(0xe4b5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_ellipsis] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_ellipsis] icon is a graphical symbol that conveys a specific idea or functionality related to ellipsis, et cetera, etc, loader, loading, progress, pending, throbber, menu, options, operator, code, spread, rest, more, further, extra, overflow, dots, …, ....
  /// - It belongs to the layout, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_ellipsis =
      IconData(0xe349, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_equal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_equal] icon is a graphical symbol that conveys a specific idea or functionality related to calculate, shape, =.
  /// - It belongs to the math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_equal =
      IconData(0xe404, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_fading_arrow_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_fading_arrow_up] icon is a graphical symbol that conveys a specific idea or functionality related to north, up, upgrade, improve, circle, button.
  /// - It belongs to the arrows, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jordan808](https://github.com/jordan808), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mosch](https://github.com/mosch) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_fading_arrow_up =
      IconData(0xe61c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_fading_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_fading_plus] icon is a graphical symbol that conveys a specific idea or functionality related to stories, social media, instagram, facebook, meta, snapchat, sharing, content.
  /// - It belongs to the communication, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jordan808](https://github.com/jordan808), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_fading_plus =
      IconData(0xe5c0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_gauge] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_gauge] icon is a graphical symbol that conveys a specific idea or functionality related to dashboard, dial, meter, speed, pressure, measure, level.
  /// - It belongs to the transportation, sports, science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_gauge =
      IconData(0xe4e5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_help] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_help] icon is a graphical symbol that conveys a specific idea or functionality related to question mark.
  /// - It belongs to the accessibility, text, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danbovey](https://github.com/danbovey), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_help =
      IconData(0xe082, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_minus] icon is a graphical symbol that conveys a specific idea or functionality related to subtract, remove, decrease, reduce, calculate, line, operator, code, coding, minimum, downgrade, -.
  /// - It belongs to the math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_minus =
      IconData(0xe083, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_off] icon is a graphical symbol that conveys a specific idea or functionality related to diameter, zero, Ø, nothing, null, void, cancel, ban, no, stop, forbidden, prohibited, error, incorrect, mistake, wrong, failure.
  /// - It belongs to the shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_off =
      IconData(0xe405, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_parking] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_parking] icon is a graphical symbol that conveys a specific idea or functionality related to parking lot, car park.
  /// - It belongs to the transportation, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_parking =
      IconData(0xe3cc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_parking_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_parking_off] icon is a graphical symbol that conveys a specific idea or functionality related to parking lot, car park, no parking.
  /// - It belongs to the transportation, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_parking_off =
      IconData(0xe3cd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_pause] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_pause] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, stop.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_pause =
      IconData(0xe084, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_percent] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_percent] icon is a graphical symbol that conveys a specific idea or functionality related to verified, unverified, sale, discount, offer, marketing, sticker, price tag.
  /// - It belongs to the social, finance, shopping, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_percent =
      IconData(0xe51e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_play] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_play] icon is a graphical symbol that conveys a specific idea or functionality related to music, start, run.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_play =
      IconData(0xe085, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_plus] icon is a graphical symbol that conveys a specific idea or functionality related to add, new, increase, increment, positive, calculate, crosshair, aim, target, scope, sight, reticule, maximum, upgrade, extra, operator, join, concatenate, code, coding, +.
  /// - It belongs to the math, development, cursors, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_plus =
      IconData(0xe086, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_power] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_power] icon is a graphical symbol that conveys a specific idea or functionality related to on, off, device, switch, toggle, binary, boolean, reboot, restart, button, keyboard, troubleshoot.
  /// - It belongs to the connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_power =
      IconData(0xe554, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_slash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_slash] icon is a graphical symbol that conveys a specific idea or functionality related to diameter, zero, Ø, nothing, null, void, cancel, ban, no, stop, forbidden, prohibited, error, incorrect, mistake, wrong, failure, divide, division, or, /.
  /// - It belongs to the development, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_slash =
      IconData(0xe406, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_slash_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_slash_2] icon is a graphical symbol that conveys a specific idea or functionality related to diameter, zero, Ø, nothing, null, void, ban, math, divide, division, half, split, /.
  /// - It belongs to the shapes, math, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_slash_2 =
      IconData(0xe212, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_stop] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_stop] icon is a graphical symbol that conveys a specific idea or functionality related to media, music.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_stop =
      IconData(0xe087, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_user] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_user] icon is a graphical symbol that conveys a specific idea or functionality related to person, account, contact.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_user =
      IconData(0xe465, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_user_round] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_user_round] icon is a graphical symbol that conveys a specific idea or functionality related to person, account, contact.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_user_round =
      IconData(0xe466, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circle_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circle_x] icon is a graphical symbol that conveys a specific idea or functionality related to cancel, close, delete, remove, times, clear, error, incorrect, wrong, mistake, failure, linter, multiply, multiplication.
  /// - It belongs to the math, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circle_x =
      IconData(0xe088, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [circuit_board] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [circuit_board] icon is a graphical symbol that conveys a specific idea or functionality related to computing, electricity, electronics.
  /// - It belongs to the science, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData circuit_board =
      IconData(0xe407, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [citrus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [citrus] icon is a graphical symbol that conveys a specific idea or functionality related to lemon, orange, grapefruit, fruit.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData citrus =
      IconData(0xe378, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clapperboard] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clapperboard] icon is a graphical symbol that conveys a specific idea or functionality related to movie, film, video, camera, cinema, cut, action, television, tv, show, entertainment.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clapperboard =
      IconData(0xe29a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard] icon is a graphical symbol that conveys a specific idea or functionality related to copy, paste.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard =
      IconData(0xe089, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_check] icon is a graphical symbol that conveys a specific idea or functionality related to copied, pasted, done, todo, tick, complete, task.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_check =
      IconData(0xe218, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_copy] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_copy] icon is a graphical symbol that conveys a specific idea or functionality related to copy, paste.
  /// - It belongs to the text, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_copy =
      IconData(0xe224, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_list] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_list] icon is a graphical symbol that conveys a specific idea or functionality related to copy, paste, tasks.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_list =
      IconData(0xe08a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_minus] icon is a graphical symbol that conveys a specific idea or functionality related to copy, delete, remove, erase, document, medical, report, doctor.
  /// - It belongs to the text, medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_minus =
      IconData(0xe5c2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_paste] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_paste] icon is a graphical symbol that conveys a specific idea or functionality related to copy, paste.
  /// - It belongs to the text, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/xnousnow](https://github.com/xnousnow), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_paste =
      IconData(0xe3eb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_pen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_pen] icon is a graphical symbol that conveys a specific idea or functionality related to paste, signature.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_pen =
      IconData(0xe306, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_pen_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_pen_line] icon is a graphical symbol that conveys a specific idea or functionality related to paste.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_pen_line =
      IconData(0xe307, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_plus] icon is a graphical symbol that conveys a specific idea or functionality related to copy, paste, add, create, new, document, medical, report, doctor.
  /// - It belongs to the text, medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_plus =
      IconData(0xe5c3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_type] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_type] icon is a graphical symbol that conveys a specific idea or functionality related to paste, format, text.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_type =
      IconData(0xe308, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clipboard_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clipboard_x] icon is a graphical symbol that conveys a specific idea or functionality related to copy, paste, discard, remove.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clipboard_x =
      IconData(0xe221, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock =
      IconData(0xe08b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_1] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_1] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_1 =
      IconData(0xe24a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_10] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_10] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_10 =
      IconData(0xe24b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_11] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_11] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_11 =
      IconData(0xe24c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_12] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_12] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm, noon, midnight.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_12 =
      IconData(0xe24d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_2] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_2 =
      IconData(0xe24e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_3] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_3] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_3 =
      IconData(0xe24f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_4] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_4] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_4 =
      IconData(0xe250, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_5] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_5] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_5 =
      IconData(0xe251, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_6] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_6] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_6 =
      IconData(0xe252, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_7] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_7] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_7 =
      IconData(0xe253, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_8] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_8] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_8 =
      IconData(0xe254, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_9] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_9] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_9 =
      IconData(0xe255, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_alert] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_alert] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm, warning, wrong.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_alert =
      IconData(0xe62e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_arrow_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_arrow_down] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm, sort, order, ascending, descending, increasing, decreasing, rising, falling.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_arrow_down =
      IconData(0xe604, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clock_arrow_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clock_arrow_up] icon is a graphical symbol that conveys a specific idea or functionality related to time, watch, alarm, sort, order, ascending, descending, increasing, decreasing, rising, falling.
  /// - It belongs to the time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clock_arrow_up =
      IconData(0xe605, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud] icon is a graphical symbol that conveys a specific idea or functionality related to weather.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud =
      IconData(0xe08c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_alert] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_alert] icon is a graphical symbol that conveys a specific idea or functionality related to weather, danger, warning, alert, error, sync, network, exclamation.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/lscheibel](https://github.com/lscheibel) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_alert =
      IconData(0xe637, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_cog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_cog] icon is a graphical symbol that conveys a specific idea or functionality related to computing, ai, cluster, network.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_cog =
      IconData(0xe309, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_download] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_download] icon is a graphical symbol that conveys a specific idea or functionality related to import.
  /// - It belongs to the arrows, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_download =
      IconData(0xe08d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_drizzle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_drizzle] icon is a graphical symbol that conveys a specific idea or functionality related to weather, shower.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_drizzle =
      IconData(0xe08e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_fog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_fog] icon is a graphical symbol that conveys a specific idea or functionality related to weather, mist.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_fog =
      IconData(0xe213, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_hail] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_hail] icon is a graphical symbol that conveys a specific idea or functionality related to weather, rainfall.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_hail =
      IconData(0xe08f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_lightning] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_lightning] icon is a graphical symbol that conveys a specific idea or functionality related to weather, bolt.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_lightning =
      IconData(0xe090, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_moon] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_moon] icon is a graphical symbol that conveys a specific idea or functionality related to weather, night.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_moon =
      IconData(0xe214, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_moon_rain] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_moon_rain] icon is a graphical symbol that conveys a specific idea or functionality related to weather, partly, night, rainfall.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_moon_rain =
      IconData(0xe2f9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_off] icon is a graphical symbol that conveys a specific idea or functionality related to disconnect.
  /// - It belongs to the connectivity, weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_off =
      IconData(0xe091, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_rain] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_rain] icon is a graphical symbol that conveys a specific idea or functionality related to weather, rainfall.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_rain =
      IconData(0xe092, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_rain_wind] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_rain_wind] icon is a graphical symbol that conveys a specific idea or functionality related to weather, rainfall.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_rain_wind =
      IconData(0xe093, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_snow] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_snow] icon is a graphical symbol that conveys a specific idea or functionality related to weather, blizzard.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_snow =
      IconData(0xe094, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_sun] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_sun] icon is a graphical symbol that conveys a specific idea or functionality related to weather, partly.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_sun =
      IconData(0xe215, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_sun_rain] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_sun_rain] icon is a graphical symbol that conveys a specific idea or functionality related to weather, partly, rainfall.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_sun_rain =
      IconData(0xe2fa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloud_upload] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloud_upload] icon is a graphical symbol that conveys a specific idea or functionality related to file.
  /// - It belongs to the arrows, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloud_upload =
      IconData(0xe095, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cloudy] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cloudy] icon is a graphical symbol that conveys a specific idea or functionality related to weather, clouds.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cloudy =
      IconData(0xe216, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [clover] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [clover] icon is a graphical symbol that conveys a specific idea or functionality related to leaf, luck, plant.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData clover =
      IconData(0xe096, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [club] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [club] icon is a graphical symbol that conveys a specific idea or functionality related to shape, suit, playing, cards.
  /// - It belongs to the shapes, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData club =
      IconData(0xe49a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [code] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [code] icon is a graphical symbol that conveys a specific idea or functionality related to source, programming, html, xml.
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData code =
      IconData(0xe097, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [code_xml] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [code_xml] icon is a graphical symbol that conveys a specific idea or functionality related to source, programming, html, xml.
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData code_xml =
      IconData(0xe205, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [codepen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [codepen] icon is a graphical symbol that conveys a specific idea or functionality related to logo.
  /// - It belongs to the brands, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData codepen =
      IconData(0xe098, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [codesandbox] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [codesandbox] icon is a graphical symbol that conveys a specific idea or functionality related to logo.
  /// - It belongs to the brands, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData codesandbox =
      IconData(0xe099, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [coffee] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [coffee] icon is a graphical symbol that conveys a specific idea or functionality related to drink, cup, mug, tea, cafe, hot, beverage.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData coffee =
      IconData(0xe09a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cog] icon is a graphical symbol that conveys a specific idea or functionality related to computing, settings, cog, edit, gear, preferences.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cog =
      IconData(0xe30a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [coins] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [coins] icon is a graphical symbol that conveys a specific idea or functionality related to money, cash, finance, gamble.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData coins =
      IconData(0xe09b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [columns_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [columns_2] icon is a graphical symbol that conveys a specific idea or functionality related to lines, list, queue, preview, panel, parallel, series, split, vertical, horizontal, half, center, middle, even, sidebar, drawer, gutter, fold, reflow, typography, pagination, pages.
  /// - It belongs to the layout, design, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/zenoamaro](https://github.com/zenoamaro), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData columns_2 =
      IconData(0xe09c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [columns_3] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [columns_3] icon is a graphical symbol that conveys a specific idea or functionality related to lines, list, queue, preview, parallel, series, split, vertical, horizontal, thirds, triple, center, middle, alignment, even, sidebars, drawers, gutters, fold, reflow, typography, pagination, pages.
  /// - It belongs to the layout, design, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData columns_3 =
      IconData(0xe09d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [columns_4] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [columns_4] icon is a graphical symbol that conveys a specific idea or functionality related to lines, list, queue, preview, parallel, series, split, vertical, horizontal, thirds, triple, center, middle, alignment, even, sidebars, drawers, gutters, fold, reflow, typography, pagination, pages, prison, jail, bars, sentence, police, cops, cell, crime, criminal, justice, law, enforcement, grill.
  /// - It belongs to the layout, design, text, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData columns_4 =
      IconData(0xe58d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [combine] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [combine] icon is a graphical symbol that conveys a specific idea or functionality related to cubes, packages, parts, units, collection, cluster, combine, gather, merge.
  /// - It belongs to the development, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData combine =
      IconData(0xe450, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [command] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [command] icon is a graphical symbol that conveys a specific idea or functionality related to keyboard, key, mac, cmd, button.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData command =
      IconData(0xe09e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [compass] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [compass] icon is a graphical symbol that conveys a specific idea or functionality related to direction, north, east, south, west, safari, browser.
  /// - It belongs to the navigation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData compass =
      IconData(0xe09f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [component] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [component] icon is a graphical symbol that conveys a specific idea or functionality related to design, element, group, module, part, symbol.
  /// - It belongs to the design, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData component =
      IconData(0xe2ac, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [computer] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [computer] icon is a graphical symbol that conveys a specific idea or functionality related to pc, chassis, codespaces, github.
  /// - It belongs to the devices, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData computer =
      IconData(0xe4e8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [concierge_bell] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [concierge_bell] icon is a graphical symbol that conveys a specific idea or functionality related to reception, bell, porter.
  /// - It belongs to the travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData concierge_bell =
      IconData(0xe37b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cone] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cone] icon is a graphical symbol that conveys a specific idea or functionality related to conical, triangle, triangular, geometry, filter, funnel, hopper, spotlight, searchlight.
  /// - It belongs to the shapes, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cone =
      IconData(0xe527, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [construction] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [construction] icon is a graphical symbol that conveys a specific idea or functionality related to roadwork, maintenance, blockade, barricade.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData construction =
      IconData(0xe3b7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [contact] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [contact] icon is a graphical symbol that conveys a specific idea or functionality related to user, person, family, friend, acquaintance, listing, networking.
  /// - It belongs to the account, connectivity, communication, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/FPDK](https://github.com/FPDK), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData contact =
      IconData(0xe0a0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [contact_round] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [contact_round] icon is a graphical symbol that conveys a specific idea or functionality related to user, person, family, friend, acquaintance, listing, networking.
  /// - It belongs to the account, connectivity, communication, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData contact_round =
      IconData(0xe467, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [container] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [container] icon is a graphical symbol that conveys a specific idea or functionality related to storage, shipping, freight, supply chain, docker, environment, devops, code, coding.
  /// - It belongs to the development, transportation, mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData container =
      IconData(0xe4d9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [contrast] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [contrast] icon is a graphical symbol that conveys a specific idea or functionality related to display, accessibility.
  /// - It belongs to the photography, accessibility, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData contrast =
      IconData(0xe0a1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cookie] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cookie] icon is a graphical symbol that conveys a specific idea or functionality related to biscuit, privacy, legal, food.
  /// - It belongs to the account, food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cookie =
      IconData(0xe26a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cooking_pot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cooking_pot] icon is a graphical symbol that conveys a specific idea or functionality related to pod, cooking, recipe, food, kitchen, chef, restaurant, dinner, lunch, breakfast, meal, eat.
  /// - It belongs to the food-beverage, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/guillermo-angeles](https://github.com/guillermo-angeles), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cooking_pot =
      IconData(0xe588, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [copy] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [copy] icon is a graphical symbol that conveys a specific idea or functionality related to clone, duplicate, multiple.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData copy =
      IconData(0xe0a2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [copy_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [copy_check] icon is a graphical symbol that conveys a specific idea or functionality related to clone, duplicate, done, multiple.
  /// - It belongs to the text, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData copy_check =
      IconData(0xe3ff, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [copy_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [copy_minus] icon is a graphical symbol that conveys a specific idea or functionality related to clone, duplicate, remove, delete, collapse, subtract, multiple, -.
  /// - It belongs to the text, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData copy_minus =
      IconData(0xe400, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [copy_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [copy_plus] icon is a graphical symbol that conveys a specific idea or functionality related to clone, duplicate, add, multiple, expand, +.
  /// - It belongs to the text, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData copy_plus =
      IconData(0xe401, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [copy_slash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [copy_slash] icon is a graphical symbol that conveys a specific idea or functionality related to clone, duplicate, cancel, ban, no, stop, forbidden, prohibited, error, multiple, divide, division, split, or, /.
  /// - It belongs to the text, development, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData copy_slash =
      IconData(0xe402, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [copy_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [copy_x] icon is a graphical symbol that conveys a specific idea or functionality related to cancel, close, delete, remove, clear, multiple, multiply, multiplication, times.
  /// - It belongs to the notifications, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData copy_x =
      IconData(0xe403, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [copyleft] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [copyleft] icon is a graphical symbol that conveys a specific idea or functionality related to licence.
  /// - It belongs to the  categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData copyleft =
      IconData(0xe0a3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [copyright] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [copyright] icon is a graphical symbol that conveys a specific idea or functionality related to licence, license.
  /// - It belongs to the  categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData copyright =
      IconData(0xe0a4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [corner_down_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [corner_down_left] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, return.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData corner_down_left =
      IconData(0xe0a5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [corner_down_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [corner_down_right] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, indent, tab.
  /// - It belongs to the arrows, text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData corner_down_right =
      IconData(0xe0a6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [corner_left_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [corner_left_down] icon is a graphical symbol that conveys a specific idea or functionality related to arrow.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData corner_left_down =
      IconData(0xe0a7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [corner_left_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [corner_left_up] icon is a graphical symbol that conveys a specific idea or functionality related to arrow.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData corner_left_up =
      IconData(0xe0a8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [corner_right_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [corner_right_down] icon is a graphical symbol that conveys a specific idea or functionality related to arrow.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData corner_right_down =
      IconData(0xe0a9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [corner_right_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [corner_right_up] icon is a graphical symbol that conveys a specific idea or functionality related to arrow.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData corner_right_up =
      IconData(0xe0aa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [corner_up_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [corner_up_left] icon is a graphical symbol that conveys a specific idea or functionality related to arrow.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData corner_up_left =
      IconData(0xe0ab, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [corner_up_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [corner_up_right] icon is a graphical symbol that conveys a specific idea or functionality related to arrow.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData corner_up_right =
      IconData(0xe0ac, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cpu] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cpu] icon is a graphical symbol that conveys a specific idea or functionality related to processor, cores, technology, computer, chip, circuit, memory, ram, specs, gigahertz, ghz.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cpu =
      IconData(0xe0ad, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [creative_commons] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [creative_commons] icon is a graphical symbol that conveys a specific idea or functionality related to licence, license.
  /// - It belongs to the  categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData creative_commons =
      IconData(0xe3b5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [credit_card] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [credit_card] icon is a graphical symbol that conveys a specific idea or functionality related to bank, purchase, payment, cc.
  /// - It belongs to the account, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData credit_card =
      IconData(0xe0ae, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [croissant] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [croissant] icon is a graphical symbol that conveys a specific idea or functionality related to bakery, cooking, food, pastry.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData croissant =
      IconData(0xe2ad, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [crop] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [crop] icon is a graphical symbol that conveys a specific idea or functionality related to photo, image.
  /// - It belongs to the photography, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData crop =
      IconData(0xe0af, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cross] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cross] icon is a graphical symbol that conveys a specific idea or functionality related to healthcare, first aid.
  /// - It belongs to the shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cross =
      IconData(0xe1e4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [crosshair] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [crosshair] icon is a graphical symbol that conveys a specific idea or functionality related to aim, target.
  /// - It belongs to the photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData crosshair =
      IconData(0xe0b0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [crown] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [crown] icon is a graphical symbol that conveys a specific idea or functionality related to diadem, tiara, circlet, corona, king, ruler, winner, favourite.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ahtohbi4](https://github.com/ahtohbi4), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData crown =
      IconData(0xe1d5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cuboid] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cuboid] icon is a graphical symbol that conveys a specific idea or functionality related to brick, block, container, storage, geometry, rectangular, hexahedron.
  /// - It belongs to the shapes, math, buildings categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cuboid =
      IconData(0xe528, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cup_soda] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cup_soda] icon is a graphical symbol that conveys a specific idea or functionality related to beverage, cup, drink, soda, straw, water.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cup_soda =
      IconData(0xe2d0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [currency] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [currency] icon is a graphical symbol that conveys a specific idea or functionality related to finance, money.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/connium](https://github.com/connium), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData currency =
      IconData(0xe22f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [cylinder] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [cylinder] icon is a graphical symbol that conveys a specific idea or functionality related to shape, elliptical, geometry, container, storage, tin, pot.
  /// - It belongs to the shapes, design, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData cylinder =
      IconData(0xe529, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dam] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dam] icon is a graphical symbol that conveys a specific idea or functionality related to electricity, energy, water.
  /// - It belongs to the buildings, sustainability categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/AndreasSas](https://github.com/AndreasSas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dam =
      IconData(0xe60a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [database] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [database] icon is a graphical symbol that conveys a specific idea or functionality related to storage, memory, container, tin, pot, bytes, servers.
  /// - It belongs to the devices, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData database =
      IconData(0xe0b1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [database_backup] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [database_backup] icon is a graphical symbol that conveys a specific idea or functionality related to storage, memory, bytes, servers, backup, timemachine, rotate, arrow, left.
  /// - It belongs to the devices, arrows, design, development, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData database_backup =
      IconData(0xe3ae, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [database_zap] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [database_zap] icon is a graphical symbol that conveys a specific idea or functionality related to cache busting, storage, memory, bytes, servers, power, crash.
  /// - It belongs to the devices, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData database_zap =
      IconData(0xe50f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [delete] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [delete] icon is a graphical symbol that conveys a specific idea or functionality related to backspace, remove.
  /// - It belongs to the text, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData delete =
      IconData(0xe0b2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dessert] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dessert] icon is a graphical symbol that conveys a specific idea or functionality related to pudding, christmas, xmas, custard, iced bun, icing, fondant, cake, ice cream, gelato, sundae, scoop, dollop, sugar, food, sweet.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dessert =
      IconData(0xe4bf, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [diameter] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [diameter] icon is a graphical symbol that conveys a specific idea or functionality related to shape, circle, geometry, trigonometry, width, height, size, calculate, measure.
  /// - It belongs to the shapes, math, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData diameter =
      IconData(0xe52a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [diamond] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [diamond] icon is a graphical symbol that conveys a specific idea or functionality related to square, rectangle, oblique, rhombus, shape, suit, playing, cards.
  /// - It belongs to the shapes, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData diamond =
      IconData(0xe2d1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [diamond_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [diamond_minus] icon is a graphical symbol that conveys a specific idea or functionality related to keyframe, subtract, remove, decrease, reduce, calculator, button, keyboard, line, divider, separator, horizontal rule, hr, html, markup, markdown, ---, toolbar, operator, code, coding, minimum, downgrade.
  /// - It belongs to the multimedia, photography, tools, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/chessurisme](https://github.com/chessurisme) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData diamond_minus =
      IconData(0xe5e5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [diamond_percent] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [diamond_percent] icon is a graphical symbol that conveys a specific idea or functionality related to verified, unverified, sale, discount, offer, marketing, sticker, price tag.
  /// - It belongs to the social, finance, shopping, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData diamond_percent =
      IconData(0xe51f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [diamond_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [diamond_plus] icon is a graphical symbol that conveys a specific idea or functionality related to keyframe, add, new, increase, increment, positive, calculate, toolbar, crosshair, aim, target, scope, sight, reticule, maximum, upgrade, extra, +.
  /// - It belongs to the multimedia, photography, tools, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/chessurisme](https://github.com/chessurisme) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData diamond_plus =
      IconData(0xe5e6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dice_1] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dice_1] icon is a graphical symbol that conveys a specific idea or functionality related to dice, random, tabletop, 1, board, game.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dice_1 =
      IconData(0xe286, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dice_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dice_2] icon is a graphical symbol that conveys a specific idea or functionality related to dice, random, tabletop, 2, board, game.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dice_2 =
      IconData(0xe287, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dice_3] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dice_3] icon is a graphical symbol that conveys a specific idea or functionality related to dice, random, tabletop, 3, board, game.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dice_3 =
      IconData(0xe288, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dice_4] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dice_4] icon is a graphical symbol that conveys a specific idea or functionality related to dice, random, tabletop, 4, board, game.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dice_4 =
      IconData(0xe289, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dice_5] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dice_5] icon is a graphical symbol that conveys a specific idea or functionality related to dice, random, tabletop, 5, board, game.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dice_5 =
      IconData(0xe28a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dice_6] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dice_6] icon is a graphical symbol that conveys a specific idea or functionality related to dice, random, tabletop, 6, board, game.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dice_6 =
      IconData(0xe28b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dices] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dices] icon is a graphical symbol that conveys a specific idea or functionality related to dice, random, tabletop, board, game.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dices =
      IconData(0xe2c4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [diff] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [diff] icon is a graphical symbol that conveys a specific idea or functionality related to patch, difference, compare, plus, minus, plus-minus, math.
  /// - It belongs to the development, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData diff =
      IconData(0xe30b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [disc] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [disc] icon is a graphical symbol that conveys a specific idea or functionality related to album, music, songs, format, cd, dvd, vinyl, sleeve, cover, platinum, compilation, ep, recording, playback, spin, rotate, rpm, dj.
  /// - It belongs to the devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData disc =
      IconData(0xe0b3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [disc_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [disc_2] icon is a graphical symbol that conveys a specific idea or functionality related to album, music, vinyl, record, cd, dvd, format, dj, spin, rotate, rpm.
  /// - It belongs to the devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData disc_2 =
      IconData(0xe3fa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [disc_3] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [disc_3] icon is a graphical symbol that conveys a specific idea or functionality related to album, music, vinyl, record, cd, dvd, format, dj, spin, rotate, rpm.
  /// - It belongs to the devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData disc_3 =
      IconData(0xe498, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [disc_album] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [disc_album] icon is a graphical symbol that conveys a specific idea or functionality related to album, music, songs, format, cd, dvd, vinyl, sleeve, cover, platinum, compilation, ep, recording, playback, spin, rotate, rpm, dj.
  /// - It belongs to the devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData disc_album =
      IconData(0xe560, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [divide] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [divide] icon is a graphical symbol that conveys a specific idea or functionality related to calculate, math, division, operator, code, ÷, /.
  /// - It belongs to the math, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData divide =
      IconData(0xe0b4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dna] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dna] icon is a graphical symbol that conveys a specific idea or functionality related to gene, gmo, helix, heredity, chromosome, nucleic acid.
  /// - It belongs to the medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dna =
      IconData(0xe396, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dna_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dna_off] icon is a graphical symbol that conveys a specific idea or functionality related to gene, gmo free, helix, heredity, chromosome, nucleic acid.
  /// - It belongs to the medical, food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dna_off =
      IconData(0xe397, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dock] icon is a graphical symbol that conveys a specific idea or functionality related to desktop, applications, launch, home, menu bar, bottom, line, macos, osx.
  /// - It belongs to the layout, design, development, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dock =
      IconData(0xe5d7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dog] icon is a graphical symbol that conveys a specific idea or functionality related to animal, pet, puppy, hound, canine.
  /// - It belongs to the animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kemie](https://github.com/kemie), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dog =
      IconData(0xe390, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dollar_sign] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dollar_sign] icon is a graphical symbol that conveys a specific idea or functionality related to currency, money, payment.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dollar_sign =
      IconData(0xe0b5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [donut] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [donut] icon is a graphical symbol that conveys a specific idea or functionality related to doughnut, sprinkles, topping, fast food, junk food, snack, treat, sweet, sugar, dessert, hollow, ring.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData donut =
      IconData(0xe4c0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [door_closed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [door_closed] icon is a graphical symbol that conveys a specific idea or functionality related to entrance, entry, exit, ingress, egress, gate, gateway, emergency exit.
  /// - It belongs to the home, travel, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData door_closed =
      IconData(0xe3d8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [door_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [door_open] icon is a graphical symbol that conveys a specific idea or functionality related to entrance, entry, exit, ingress, egress, gate, gateway, emergency exit.
  /// - It belongs to the home, travel, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData door_open =
      IconData(0xe3d9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dot] icon is a graphical symbol that conveys a specific idea or functionality related to interpunct, interpoint, middot, step, punctuation, period, full stop, end, finish, final, characters, font, typography, type, center, ..
  /// - It belongs to the shapes, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dot =
      IconData(0xe453, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [download] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [download] icon is a graphical symbol that conveys a specific idea or functionality related to import, export, save.
  /// - It belongs to the arrows, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData download =
      IconData(0xe0b6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [drafting_compass] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [drafting_compass] icon is a graphical symbol that conveys a specific idea or functionality related to geometry, trigonometry, radius, diameter, circumference, calculate, measure, arc, curve, draw, sketch.
  /// - It belongs to the math, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData drafting_compass =
      IconData(0xe52b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [drama] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [drama] icon is a graphical symbol that conveys a specific idea or functionality related to drama, masks, theater, theatre, entertainment, show.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData drama =
      IconData(0xe525, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dribbble] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dribbble] icon is a graphical symbol that conveys a specific idea or functionality related to design, social.
  /// - It belongs to the brands, social, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ahtohbi4](https://github.com/ahtohbi4) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dribbble =
      IconData(0xe0b7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [drill] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [drill] icon is a graphical symbol that conveys a specific idea or functionality related to power, bit, head, hole, diy, toolbox, build, construction.
  /// - It belongs to the tools, home, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData drill =
      IconData(0xe591, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [droplet] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [droplet] icon is a graphical symbol that conveys a specific idea or functionality related to water, weather, liquid, fluid, wet, moisture, damp, bead, globule.
  /// - It belongs to the weather, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData droplet =
      IconData(0xe0b8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [droplet_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [droplet_off] icon is a graphical symbol that conveys a specific idea or functionality related to water, weather, liquid, fluid, wet, moisture, damp, bead, globule.
  /// - It belongs to the weather, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/Footagesus](https://github.com/Footagesus) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData droplet_off =
      IconData(0xe63c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [droplets] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [droplets] icon is a graphical symbol that conveys a specific idea or functionality related to water, weather, liquid, fluid, wet, moisture, damp, bead, globule.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData droplets =
      IconData(0xe0b9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [drum] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [drum] icon is a graphical symbol that conveys a specific idea or functionality related to drummer, kit, sticks, instrument, beat, bang, bass, backing track, band, play, performance, concert, march, music, audio, sound, noise, loud.
  /// - It belongs to the multimedia, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData drum =
      IconData(0xe561, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [drumstick] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [drumstick] icon is a graphical symbol that conveys a specific idea or functionality related to food, chicken, meat.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData drumstick =
      IconData(0xe25a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [dumbbell] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [dumbbell] icon is a graphical symbol that conveys a specific idea or functionality related to barbell, weight, workout, gym.
  /// - It belongs to the navigation, sports categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData dumbbell =
      IconData(0xe3a4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ear] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ear] icon is a graphical symbol that conveys a specific idea or functionality related to hearing, noise, audio, accessibility.
  /// - It belongs to the medical, accessibility categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ear =
      IconData(0xe385, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ear_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ear_off] icon is a graphical symbol that conveys a specific idea or functionality related to hearing, hard of hearing, hearing loss, deafness, noise, silence, audio, accessibility.
  /// - It belongs to the medical, accessibility categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ear_off =
      IconData(0xe386, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [earth] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [earth] icon is a graphical symbol that conveys a specific idea or functionality related to world, browser, language, translate, globe.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData earth =
      IconData(0xe1f2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [earth_lock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [earth_lock] icon is a graphical symbol that conveys a specific idea or functionality related to vpn, private, privacy, network, world, browser, security, encryption, protection, connection.
  /// - It belongs to the security, development, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData earth_lock =
      IconData(0xe5d0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [eclipse] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [eclipse] icon is a graphical symbol that conveys a specific idea or functionality related to lunar, solar, crescent moon, sun, earth, day, night, planet, space, mode, dark, light, toggle, switch, color, css, styles, display, accessibility, contrast, brightness, blend, shade.
  /// - It belongs to the science, design, development, accessibility, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData eclipse =
      IconData(0xe5a1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [egg] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [egg] icon is a graphical symbol that conveys a specific idea or functionality related to bird, chicken, nest, hatch, shell, incubate, soft boiled, hard, breakfast, brunch, morning, easter.
  /// - It belongs to the food-beverage, animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData egg =
      IconData(0xe25c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [egg_fried] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [egg_fried] icon is a graphical symbol that conveys a specific idea or functionality related to food, breakfast.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData egg_fried =
      IconData(0xe354, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [egg_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [egg_off] icon is a graphical symbol that conveys a specific idea or functionality related to egg free, vegan, hatched, bad egg.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData egg_off =
      IconData(0xe398, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ellipsis] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ellipsis] icon is a graphical symbol that conveys a specific idea or functionality related to et cetera, etc, loader, loading, progress, pending, throbber, menu, options, operator, code, coding, spread, rest, more, further, extra, overflow, dots, …, ....
  /// - It belongs to the layout, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ellipsis =
      IconData(0xe0ba, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ellipsis_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ellipsis_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to menu, options, spread, more, further, extra, overflow, dots, …, ....
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ellipsis_vertical =
      IconData(0xe0bb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [equal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [equal] icon is a graphical symbol that conveys a specific idea or functionality related to calculate, math, operator, assignment, code, =.
  /// - It belongs to the math, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData equal =
      IconData(0xe1bc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [equal_approximately] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [equal_approximately] icon is a graphical symbol that conveys a specific idea or functionality related to about, calculate, math, operater.
  /// - It belongs to the math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ksk3110](https://github.com/ksk3110) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData equal_approximately =
      IconData(0xe638, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [equal_not] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [equal_not] icon is a graphical symbol that conveys a specific idea or functionality related to calculate, off, math, operator, code, ≠.
  /// - It belongs to the math, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData equal_not =
      IconData(0xe1bd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [eraser] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [eraser] icon is a graphical symbol that conveys a specific idea or functionality related to pencil, drawing, undo, delete, clear.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/maxwellito](https://github.com/maxwellito), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData eraser =
      IconData(0xe28e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ethernet_port] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ethernet_port] icon is a graphical symbol that conveys a specific idea or functionality related to internet, network, connection, cable, lan, port, router, switch, hub, modem, web, online, networking, communication, socket, plug, slot, controller, connector, interface, console, signal, data, input, output.
  /// - It belongs to the communication, devices, multimedia, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ethernet_port =
      IconData(0xe624, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [euro] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [euro] icon is a graphical symbol that conveys a specific idea or functionality related to currency, money, payment.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData euro =
      IconData(0xe0bc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [expand] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [expand] icon is a graphical symbol that conveys a specific idea or functionality related to scale, fullscreen.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData expand =
      IconData(0xe219, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [external_link] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [external_link] icon is a graphical symbol that conveys a specific idea or functionality related to outbound, open, share.
  /// - It belongs to the arrows, text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData external_link =
      IconData(0xe0bd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [eye] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [eye] icon is a graphical symbol that conveys a specific idea or functionality related to view, watch, see, show, expose, reveal, display, visible, visibility, vision, preview, read.
  /// - It belongs to the accessibility, photography, design, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData eye =
      IconData(0xe0be, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [eye_closed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [eye_closed] icon is a graphical symbol that conveys a specific idea or functionality related to view, watch, see, hide, conceal, mask, hidden, visibility, vision.
  /// - It belongs to the accessibility, photography, design, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData eye_closed =
      IconData(0xe632, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [eye_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [eye_off] icon is a graphical symbol that conveys a specific idea or functionality related to view, watch, see, hide, conceal, mask, hidden, visibility, vision.
  /// - It belongs to the accessibility, photography, design, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData eye_off =
      IconData(0xe0bf, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [facebook] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [facebook] icon is a graphical symbol that conveys a specific idea or functionality related to logo, social.
  /// - It belongs to the social, brands categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData facebook =
      IconData(0xe0c0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [factory] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [factory] icon is a graphical symbol that conveys a specific idea or functionality related to building, business, energy, industry, manufacture, sector.
  /// - It belongs to the buildings categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData factory =
      IconData(0xe29e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fan] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fan] icon is a graphical symbol that conveys a specific idea or functionality related to air, cooler, ventilation, ventilator, blower.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fan =
      IconData(0xe37c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fast_forward] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fast_forward] icon is a graphical symbol that conveys a specific idea or functionality related to music.
  /// - It belongs to the multimedia, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fast_forward =
      IconData(0xe0c1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [feather] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [feather] icon is a graphical symbol that conveys a specific idea or functionality related to logo.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData feather =
      IconData(0xe0c2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fence] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fence] icon is a graphical symbol that conveys a specific idea or functionality related to picket, panels, woodwork, diy, materials, suburban, garden, property, territory.
  /// - It belongs to the home, buildings categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fence =
      IconData(0xe586, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ferris_wheel] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ferris_wheel] icon is a graphical symbol that conveys a specific idea or functionality related to big wheel, daisy wheel, observation, attraction, entertainment, amusement park, theme park, funfair.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ferris_wheel =
      IconData(0xe483, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [figma] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [figma] icon is a graphical symbol that conveys a specific idea or functionality related to logo, design, tool.
  /// - It belongs to the brands, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData figma =
      IconData(0xe0c3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file] icon is a graphical symbol that conveys a specific idea or functionality related to document.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file =
      IconData(0xe0c4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_archive] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_archive] icon is a graphical symbol that conveys a specific idea or functionality related to zip, package, archive.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_archive =
      IconData(0xe30c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_audio] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_audio] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, sound, headphones.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_audio =
      IconData(0xe30d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_audio_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_audio_2] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, sound, headphones.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_audio_2 =
      IconData(0xe30e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_axis_3d] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_axis_3d] icon is a graphical symbol that conveys a specific idea or functionality related to model, 3d, axis, coordinates.
  /// - It belongs to the design, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_axis_3d =
      IconData(0xe30f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_badge] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_badge] icon is a graphical symbol that conveys a specific idea or functionality related to award, achievement, badge, rosette, prize, winner.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_badge =
      IconData(0xe310, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_badge_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_badge_2] icon is a graphical symbol that conveys a specific idea or functionality related to award, achievement, badge, rosette, prize, winner.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_badge_2 =
      IconData(0xe311, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_box] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_box] icon is a graphical symbol that conveys a specific idea or functionality related to box, package, model.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_box =
      IconData(0xe312, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_chart_column] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_chart_column] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, presentation.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_chart_column =
      IconData(0xe313, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_chart_column_increasing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_chart_column_increasing] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, presentation, trending up.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_chart_column_increasing =
      IconData(0xe314, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_chart_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_chart_line] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, presentation.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_chart_line =
      IconData(0xe315, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_chart_pie] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_chart_pie] icon is a graphical symbol that conveys a specific idea or functionality related to statistics, analytics, diagram, graph, presentation.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_chart_pie =
      IconData(0xe316, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_check] icon is a graphical symbol that conveys a specific idea or functionality related to done, document, todo, tick, complete, task.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_check =
      IconData(0xe0c5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_check_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_check_2] icon is a graphical symbol that conveys a specific idea or functionality related to done, document, todo, tick, complete, task.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_check_2 =
      IconData(0xe0c6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_clock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_clock] icon is a graphical symbol that conveys a specific idea or functionality related to history, log, clock.
  /// - It belongs to the files, time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_clock =
      IconData(0xe317, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_code] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_code] icon is a graphical symbol that conveys a specific idea or functionality related to script, document, gist, html, xml, property list, plist.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_code =
      IconData(0xe0c7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_code_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_code_2] icon is a graphical symbol that conveys a specific idea or functionality related to script, document, html, xml, property list, plist.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_code_2 =
      IconData(0xe462, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_cog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_cog] icon is a graphical symbol that conveys a specific idea or functionality related to executable, settings, cog, edit, gear.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_cog =
      IconData(0xe318, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_diff] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_diff] icon is a graphical symbol that conveys a specific idea or functionality related to diff, patch.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_diff =
      IconData(0xe319, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_digit] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_digit] icon is a graphical symbol that conveys a specific idea or functionality related to number, document.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_digit =
      IconData(0xe0c8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_down] icon is a graphical symbol that conveys a specific idea or functionality related to download, import, export.
  /// - It belongs to the files, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_down =
      IconData(0xe31a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_heart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_heart] icon is a graphical symbol that conveys a specific idea or functionality related to heart, favourite, bookmark, quick link.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_heart =
      IconData(0xe31b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_image] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_image] icon is a graphical symbol that conveys a specific idea or functionality related to image, graphics, photo, picture.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_image =
      IconData(0xe31c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_input] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_input] icon is a graphical symbol that conveys a specific idea or functionality related to document.
  /// - It belongs to the files, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_input =
      IconData(0xe0c9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_json] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_json] icon is a graphical symbol that conveys a specific idea or functionality related to code, json, curly braces, curly brackets.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_json =
      IconData(0xe36e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_json_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_json_2] icon is a graphical symbol that conveys a specific idea or functionality related to code, json, curly braces, curly brackets.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_json_2 =
      IconData(0xe36f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_key] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_key] icon is a graphical symbol that conveys a specific idea or functionality related to key, private, public, security.
  /// - It belongs to the files, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_key =
      IconData(0xe31d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_key_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_key_2] icon is a graphical symbol that conveys a specific idea or functionality related to key, private, public, security.
  /// - It belongs to the files, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_key_2 =
      IconData(0xe31e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_lock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_lock] icon is a graphical symbol that conveys a specific idea or functionality related to lock, password, security.
  /// - It belongs to the files, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_lock =
      IconData(0xe31f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_lock_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_lock_2] icon is a graphical symbol that conveys a specific idea or functionality related to lock, password, security.
  /// - It belongs to the files, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_lock_2 =
      IconData(0xe320, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_minus] icon is a graphical symbol that conveys a specific idea or functionality related to delete, remove, erase, document.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_minus =
      IconData(0xe0ca, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_minus_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_minus_2] icon is a graphical symbol that conveys a specific idea or functionality related to document.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_minus_2 =
      IconData(0xe0cb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_music] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_music] icon is a graphical symbol that conveys a specific idea or functionality related to audio, sound, noise, track, digital, recording, playback, piano, keyboard, keys, notes, chord, midi, octave.
  /// - It belongs to the files, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_music =
      IconData(0xe562, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_output] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_output] icon is a graphical symbol that conveys a specific idea or functionality related to document.
  /// - It belongs to the files, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_output =
      IconData(0xe0cc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_pen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_pen] icon is a graphical symbol that conveys a specific idea or functionality related to signature.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_pen =
      IconData(0xe321, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_pen_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_pen_line] icon is a graphical symbol that conveys a specific idea or functionality related to edit.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_pen_line =
      IconData(0xe322, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_plus] icon is a graphical symbol that conveys a specific idea or functionality related to add, create, new, document.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_plus =
      IconData(0xe0cd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_plus_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_plus_2] icon is a graphical symbol that conveys a specific idea or functionality related to add, create, new, document.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_plus_2 =
      IconData(0xe0ce, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_question] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_question] icon is a graphical symbol that conveys a specific idea or functionality related to readme, help, question.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_question =
      IconData(0xe323, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_scan] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_scan] icon is a graphical symbol that conveys a specific idea or functionality related to scan, code, qr-code.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_scan =
      IconData(0xe324, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_search] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_search] icon is a graphical symbol that conveys a specific idea or functionality related to lost, document, find, browser.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_search =
      IconData(0xe0cf, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_search_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_search_2] icon is a graphical symbol that conveys a specific idea or functionality related to lost, document, find, browser.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_search_2 =
      IconData(0xe325, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_sliders] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_sliders] icon is a graphical symbol that conveys a specific idea or functionality related to cogged, gear, mechanical, machinery, configuration, controls, preferences, settings, system, admin, edit, executable.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_sliders =
      IconData(0xe5a4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_spreadsheet] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_spreadsheet] icon is a graphical symbol that conveys a specific idea or functionality related to spreadsheet, sheet, table.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_spreadsheet =
      IconData(0xe326, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_stack] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_stack] icon is a graphical symbol that conveys a specific idea or functionality related to versions, multiple, copy, documents, revisions, version control, history.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_stack =
      IconData(0xe4a5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_symlink] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_symlink] icon is a graphical symbol that conveys a specific idea or functionality related to symlink, symbolic, link.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_symlink =
      IconData(0xe327, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_terminal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_terminal] icon is a graphical symbol that conveys a specific idea or functionality related to terminal, bash, script, executable.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_terminal =
      IconData(0xe328, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_text] icon is a graphical symbol that conveys a specific idea or functionality related to data, txt, pdf, document.
  /// - It belongs to the files, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_text =
      IconData(0xe0d0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_type] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_type] icon is a graphical symbol that conveys a specific idea or functionality related to font, text, typography, type.
  /// - It belongs to the files, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_type =
      IconData(0xe329, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_type_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_type_2] icon is a graphical symbol that conveys a specific idea or functionality related to font, text, typography, type.
  /// - It belongs to the files, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_type_2 =
      IconData(0xe370, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_up] icon is a graphical symbol that conveys a specific idea or functionality related to upload, import, export.
  /// - It belongs to the files, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_up =
      IconData(0xe32a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_user] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_user] icon is a graphical symbol that conveys a specific idea or functionality related to person, personal information, people, listing, networking, document, contact, cover letter, resume, cv, curriculum vitae, application form.
  /// - It belongs to the account, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_user =
      IconData(0xe631, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_video] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_video] icon is a graphical symbol that conveys a specific idea or functionality related to movie, video, film.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_video =
      IconData(0xe32b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_video_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_video_2] icon is a graphical symbol that conveys a specific idea or functionality related to movie, video, film.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_video_2 =
      IconData(0xe32c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_volume] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_volume] icon is a graphical symbol that conveys a specific idea or functionality related to audio, music, volume.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_volume =
      IconData(0xe32d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_volume_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_volume_2] icon is a graphical symbol that conveys a specific idea or functionality related to audio, music, volume.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_volume_2 =
      IconData(0xe32e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_warning] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_warning] icon is a graphical symbol that conveys a specific idea or functionality related to hidden, warning, alert, danger, protected, exclamation mark.
  /// - It belongs to the files, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_warning =
      IconData(0xe32f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_x] icon is a graphical symbol that conveys a specific idea or functionality related to lost, delete, remove, document.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_x =
      IconData(0xe0d1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [file_x_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [file_x_2] icon is a graphical symbol that conveys a specific idea or functionality related to lost, delete, remove, document.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData file_x_2 =
      IconData(0xe0d2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [files] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [files] icon is a graphical symbol that conveys a specific idea or functionality related to multiple, copy, documents.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData files =
      IconData(0xe0d3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [film] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [film] icon is a graphical symbol that conveys a specific idea or functionality related to movie, video, reel, camera, cinema, entertainment.
  /// - It belongs to the photography, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData film =
      IconData(0xe0d4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [filter] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [filter] icon is a graphical symbol that conveys a specific idea or functionality related to funnel, hopper.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData filter =
      IconData(0xe0d5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [filter_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [filter_x] icon is a graphical symbol that conveys a specific idea or functionality related to funnel, hopper.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/gubser](https://github.com/gubser), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData filter_x =
      IconData(0xe3b8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fingerprint] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fingerprint] icon is a graphical symbol that conveys a specific idea or functionality related to 2fa, authentication, biometric, identity, security.
  /// - It belongs to the account, security, medical, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fingerprint =
      IconData(0xe2ca, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fire_extinguisher] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fire_extinguisher] icon is a graphical symbol that conveys a specific idea or functionality related to flames, smoke, foam, water, spray, hose, firefighter, fireman, department, brigade, station, emergency, suppress, compressed, tank, cylinder, safety, equipment, amenities.
  /// - It belongs to the home, tools, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fire_extinguisher =
      IconData(0xe582, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fish] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fish] icon is a graphical symbol that conveys a specific idea or functionality related to dish, restaurant, course, meal, seafood, pet, sea, marine.
  /// - It belongs to the food-beverage, animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kemie](https://github.com/kemie) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fish =
      IconData(0xe3a9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fish_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fish_off] icon is a graphical symbol that conveys a specific idea or functionality related to food, dish, restaurant, course, meal, seafood, animal, pet, sea, marine, allergy, intolerance, diet.
  /// - It belongs to the food-beverage, animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/kemie](https://github.com/kemie), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fish_off =
      IconData(0xe3b3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fish_symbol] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fish_symbol] icon is a graphical symbol that conveys a specific idea or functionality related to dish, restaurant, course, meal, seafood, pet, sea, marine.
  /// - It belongs to the food-beverage, animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fish_symbol =
      IconData(0xe4f8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flag] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flag] icon is a graphical symbol that conveys a specific idea or functionality related to report.
  /// - It belongs to the account, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flag =
      IconData(0xe0d6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flag_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flag_off] icon is a graphical symbol that conveys a specific idea or functionality related to unflag.
  /// - It belongs to the account, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/cyberalien](https://github.com/cyberalien), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flag_off =
      IconData(0xe291, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flag_triangle_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flag_triangle_left] icon is a graphical symbol that conveys a specific idea or functionality related to report, timeline.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/tidoni](https://github.com/tidoni), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flag_triangle_left =
      IconData(0xe236, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flag_triangle_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flag_triangle_right] icon is a graphical symbol that conveys a specific idea or functionality related to report, timeline.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/tidoni](https://github.com/tidoni), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flag_triangle_right =
      IconData(0xe237, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flame] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flame] icon is a graphical symbol that conveys a specific idea or functionality related to fire, lit, burning, spark, embers, smoke, firefighter, fireman, department, brigade, station, emergency.
  /// - It belongs to the weather, social, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flame =
      IconData(0xe0d7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flame_kindling] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flame_kindling] icon is a graphical symbol that conveys a specific idea or functionality related to campfire, camping, wilderness, outdoors, lit, warmth, wood, twigs, sticks.
  /// - It belongs to the nature, social, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flame_kindling =
      IconData(0xe53e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flashlight] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flashlight] icon is a graphical symbol that conveys a specific idea or functionality related to torch.
  /// - It belongs to the photography, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flashlight =
      IconData(0xe0d8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flashlight_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flashlight_off] icon is a graphical symbol that conveys a specific idea or functionality related to torch.
  /// - It belongs to the photography, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flashlight_off =
      IconData(0xe0d9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flask_conical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flask_conical] icon is a graphical symbol that conveys a specific idea or functionality related to beaker, erlenmeyer, lab, chemistry, experiment, test.
  /// - It belongs to the science, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jamiemlaw](https://github.com/jamiemlaw) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flask_conical =
      IconData(0xe0da, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flask_conical_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flask_conical_off] icon is a graphical symbol that conveys a specific idea or functionality related to beaker, erlenmeyer, non toxic, lab, chemistry, experiment, test.
  /// - It belongs to the science, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jamiemlaw](https://github.com/jamiemlaw) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flask_conical_off =
      IconData(0xe399, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flask_round] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flask_round] icon is a graphical symbol that conveys a specific idea or functionality related to beaker, lab, chemistry, experiment, test.
  /// - It belongs to the science, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jamiemlaw](https://github.com/jamiemlaw) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flask_round =
      IconData(0xe0db, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flip_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flip_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to reflect, mirror, alignment, dashed.
  /// - It belongs to the design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flip_horizontal =
      IconData(0xe360, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flip_horizontal_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flip_horizontal_2] icon is a graphical symbol that conveys a specific idea or functionality related to reflect, mirror, alignment, dashed.
  /// - It belongs to the design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flip_horizontal_2 =
      IconData(0xe361, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flip_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flip_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to reflect, mirror, alignment, dashed.
  /// - It belongs to the design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flip_vertical =
      IconData(0xe362, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flip_vertical_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flip_vertical_2] icon is a graphical symbol that conveys a specific idea or functionality related to reflect, mirror, alignment, dashed.
  /// - It belongs to the design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flip_vertical_2 =
      IconData(0xe363, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flower] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flower] icon is a graphical symbol that conveys a specific idea or functionality related to sustainability, nature, plant, spring.
  /// - It belongs to the nature, gaming, sustainability categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flower =
      IconData(0xe2d2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [flower_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [flower_2] icon is a graphical symbol that conveys a specific idea or functionality related to sustainability, nature, plant.
  /// - It belongs to the nature, sustainability, seasons categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData flower_2 =
      IconData(0xe2d3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [focus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [focus] icon is a graphical symbol that conveys a specific idea or functionality related to camera, lens, photo, dashed.
  /// - It belongs to the photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData focus =
      IconData(0xe29d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fold_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fold_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, collapse, fold, vertical, dashed.
  /// - It belongs to the arrows, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fold_horizontal =
      IconData(0xe43f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fold_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fold_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, collapse, fold, vertical, dashed.
  /// - It belongs to the arrows, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fold_vertical =
      IconData(0xe440, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder] icon is a graphical symbol that conveys a specific idea or functionality related to directory.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder =
      IconData(0xe0dc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_archive] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_archive] icon is a graphical symbol that conveys a specific idea or functionality related to archive, zip, package.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_archive =
      IconData(0xe330, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_check] icon is a graphical symbol that conveys a specific idea or functionality related to done, directory, todo, tick, complete, task.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_check =
      IconData(0xe331, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_clock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_clock] icon is a graphical symbol that conveys a specific idea or functionality related to history, directory, clock.
  /// - It belongs to the files, time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_clock =
      IconData(0xe332, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_closed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_closed] icon is a graphical symbol that conveys a specific idea or functionality related to directory, closed.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_closed =
      IconData(0xe333, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_code] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_code] icon is a graphical symbol that conveys a specific idea or functionality related to directory, coding, develop, software.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_code =
      IconData(0xe5ff, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_cog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_cog] icon is a graphical symbol that conveys a specific idea or functionality related to directory, settings, control, preferences, cog, edit, gear.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_cog =
      IconData(0xe334, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_dot] icon is a graphical symbol that conveys a specific idea or functionality related to directory, root, project, pinned, active, current, cogged, gear, mechanical, machinery, configuration, controls, preferences, settings, system, admin, edit.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_dot =
      IconData(0xe4c9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_down] icon is a graphical symbol that conveys a specific idea or functionality related to directory, download, import, export.
  /// - It belongs to the files, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_down =
      IconData(0xe335, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_git] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_git] icon is a graphical symbol that conveys a specific idea or functionality related to directory, root, project, git, repo.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_git =
      IconData(0xe40d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_git_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_git_2] icon is a graphical symbol that conveys a specific idea or functionality related to directory, root, project, git, repo.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_git_2 =
      IconData(0xe40e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_heart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_heart] icon is a graphical symbol that conveys a specific idea or functionality related to directory, heart, favourite, bookmark, quick link.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_heart =
      IconData(0xe336, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_input] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_input] icon is a graphical symbol that conveys a specific idea or functionality related to directory, import, export.
  /// - It belongs to the files, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_input =
      IconData(0xe337, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_kanban] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_kanban] icon is a graphical symbol that conveys a specific idea or functionality related to projects, manage, overview, board, tickets, issues, roadmap, plan, intentions, productivity, work, agile, code, coding, directory, project, root.
  /// - It belongs to the charts, development, design, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_kanban =
      IconData(0xe4ca, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_key] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_key] icon is a graphical symbol that conveys a specific idea or functionality related to directory, key, private, security, protected.
  /// - It belongs to the files, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_key =
      IconData(0xe338, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_lock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_lock] icon is a graphical symbol that conveys a specific idea or functionality related to directory, lock, private, security, protected.
  /// - It belongs to the files, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_lock =
      IconData(0xe339, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_minus] icon is a graphical symbol that conveys a specific idea or functionality related to directory, remove, delete.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_minus =
      IconData(0xe0dd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_open] icon is a graphical symbol that conveys a specific idea or functionality related to directory.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_open =
      IconData(0xe246, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_open_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_open_dot] icon is a graphical symbol that conveys a specific idea or functionality related to directory, root, project, active, current, pinned.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_open_dot =
      IconData(0xe4cb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_output] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_output] icon is a graphical symbol that conveys a specific idea or functionality related to directory, import, export.
  /// - It belongs to the files, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_output =
      IconData(0xe33a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_pen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_pen] icon is a graphical symbol that conveys a specific idea or functionality related to directory, rename.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_pen =
      IconData(0xe33b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_plus] icon is a graphical symbol that conveys a specific idea or functionality related to directory, add, create, new.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_plus =
      IconData(0xe0de, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_root] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_root] icon is a graphical symbol that conveys a specific idea or functionality related to directory, root, project, git, repo.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_root =
      IconData(0xe4cc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_search] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_search] icon is a graphical symbol that conveys a specific idea or functionality related to directory, search, find, lost, browser.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_search =
      IconData(0xe33c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_search_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_search_2] icon is a graphical symbol that conveys a specific idea or functionality related to directory, search, find, lost, browser.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_search_2 =
      IconData(0xe33d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_symlink] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_symlink] icon is a graphical symbol that conveys a specific idea or functionality related to directory, symlink, symbolic, link.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_symlink =
      IconData(0xe33e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_sync] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_sync] icon is a graphical symbol that conveys a specific idea or functionality related to directory, synchronize, synchronise, refresh, reconnect, transfer, backup.
  /// - It belongs to the files, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_sync =
      IconData(0xe4cd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_tree] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_tree] icon is a graphical symbol that conveys a specific idea or functionality related to directory, tree, browser.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_tree =
      IconData(0xe33f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_up] icon is a graphical symbol that conveys a specific idea or functionality related to directory, upload, import, export.
  /// - It belongs to the files, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_up =
      IconData(0xe340, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folder_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folder_x] icon is a graphical symbol that conveys a specific idea or functionality related to directory, remove, delete.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folder_x =
      IconData(0xe341, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [folders] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [folders] icon is a graphical symbol that conveys a specific idea or functionality related to multiple, copy, directories.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData folders =
      IconData(0xe342, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [footprints] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [footprints] icon is a graphical symbol that conveys a specific idea or functionality related to steps, walking, foot, feet, trail, shoe.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData footprints =
      IconData(0xe3bc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [forklift] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [forklift] icon is a graphical symbol that conveys a specific idea or functionality related to vehicle, transport, logistics.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData forklift =
      IconData(0xe3c4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [forward] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [forward] icon is a graphical symbol that conveys a specific idea or functionality related to send, share, email.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData forward =
      IconData(0xe228, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [frame] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [frame] icon is a graphical symbol that conveys a specific idea or functionality related to logo, design, tool.
  /// - It belongs to the design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Bowero](https://github.com/Bowero), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData frame =
      IconData(0xe290, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [framer] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [framer] icon is a graphical symbol that conveys a specific idea or functionality related to logo, design, tool.
  /// - It belongs to the brands, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData framer =
      IconData(0xe0df, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [frown] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [frown] icon is a graphical symbol that conveys a specific idea or functionality related to emoji, face, bad, sad, emotion.
  /// - It belongs to the emoji, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData frown =
      IconData(0xe0e0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fuel] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fuel] icon is a graphical symbol that conveys a specific idea or functionality related to filling-station, gas, petrol, tank.
  /// - It belongs to the transportation, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fuel =
      IconData(0xe2ae, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [fullscreen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [fullscreen] icon is a graphical symbol that conveys a specific idea or functionality related to expand, zoom, preview, focus, camera, lens, image.
  /// - It belongs to the layout, multimedia, design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData fullscreen =
      IconData(0xe538, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gallery_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gallery_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to carousel, pictures, images, scroll, swipe, album, portfolio.
  /// - It belongs to the layout, design, development, photography, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gallery_horizontal =
      IconData(0xe4d2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gallery_horizontal_end] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gallery_horizontal_end] icon is a graphical symbol that conveys a specific idea or functionality related to carousel, pictures, images, scroll, swipe, album, portfolio, history, versions, backup, time machine.
  /// - It belongs to the layout, design, development, photography, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gallery_horizontal_end =
      IconData(0xe4d3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gallery_thumbnails] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gallery_thumbnails] icon is a graphical symbol that conveys a specific idea or functionality related to carousel, pictures, images, album, portfolio, preview.
  /// - It belongs to the layout, design, development, photography, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gallery_thumbnails =
      IconData(0xe4d4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gallery_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gallery_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to carousel, pictures, images, scroll, swipe, album, portfolio.
  /// - It belongs to the layout, design, development, photography, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gallery_vertical =
      IconData(0xe4d5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gallery_vertical_end] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gallery_vertical_end] icon is a graphical symbol that conveys a specific idea or functionality related to carousel, pictures, images, scroll, swipe, album, portfolio, history, versions, backup, time machine.
  /// - It belongs to the layout, design, development, photography, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gallery_vertical_end =
      IconData(0xe4d6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gamepad] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gamepad] icon is a graphical symbol that conveys a specific idea or functionality related to console.
  /// - It belongs to the gaming, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gamepad =
      IconData(0xe0e1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gamepad_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gamepad_2] icon is a graphical symbol that conveys a specific idea or functionality related to console.
  /// - It belongs to the gaming, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gamepad_2 =
      IconData(0xe0e2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gauge] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gauge] icon is a graphical symbol that conveys a specific idea or functionality related to dashboard, dial, meter, speed, pressure, measure, level.
  /// - It belongs to the transportation, sports, science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gauge =
      IconData(0xe1be, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gavel] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gavel] icon is a graphical symbol that conveys a specific idea or functionality related to hammer, mallet.
  /// - It belongs to the navigation, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gavel =
      IconData(0xe0e3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gem] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gem] icon is a graphical symbol that conveys a specific idea or functionality related to diamond, crystal, ruby, jewellery, price, special, present, gift, ring, wedding, proposal, marriage, rubygems.
  /// - It belongs to the gaming, development, finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/connium](https://github.com/connium), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gem =
      IconData(0xe241, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ghost] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ghost] icon is a graphical symbol that conveys a specific idea or functionality related to pac-man, spooky.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ghost =
      IconData(0xe20d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gift] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gift] icon is a graphical symbol that conveys a specific idea or functionality related to present, box, birthday, party.
  /// - It belongs to the gaming, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gift =
      IconData(0xe0e4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_branch] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_branch] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_branch =
      IconData(0xe0e5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_branch_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_branch_plus] icon is a graphical symbol that conveys a specific idea or functionality related to add, create, +.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_branch_plus =
      IconData(0xe1f3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_commit_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_commit_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, waypoint, stop, station.
  /// - It belongs to the development, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_commit_horizontal =
      IconData(0xe0e6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_commit_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_commit_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, waypoint, stop, station.
  /// - It belongs to the development, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_commit_vertical =
      IconData(0xe556, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_compare] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_compare] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, diff.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_compare =
      IconData(0xe35c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_compare_arrows] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_compare_arrows] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, diff.
  /// - It belongs to the development, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_compare_arrows =
      IconData(0xe557, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_fork] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_fork] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_fork =
      IconData(0xe28c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_graph] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_graph] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, commit graph, commits, gitlens.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_graph =
      IconData(0xe558, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_merge] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_merge] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_merge =
      IconData(0xe0e7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_pull_request] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_pull_request] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, open.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_pull_request =
      IconData(0xe0e8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_pull_request_arrow] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_pull_request_arrow] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, open.
  /// - It belongs to the development, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_pull_request_arrow =
      IconData(0xe559, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_pull_request_closed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_pull_request_closed] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, rejected, closed, cancelled, x.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_pull_request_closed =
      IconData(0xe35d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_pull_request_create] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_pull_request_create] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, open, plus, add, +.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_pull_request_create =
      IconData(0xe55a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_pull_request_create_arrow] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_pull_request_create_arrow] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, open, plus, add, +.
  /// - It belongs to the development, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_pull_request_create_arrow =
      IconData(0xe55b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [git_pull_request_draft] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [git_pull_request_draft] icon is a graphical symbol that conveys a specific idea or functionality related to code, version control, open, draft, dashed.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData git_pull_request_draft =
      IconData(0xe35e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [github] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [github] icon is a graphical symbol that conveys a specific idea or functionality related to logo, version control.
  /// - It belongs to the brands, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData github =
      IconData(0xe0e9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [gitlab] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [gitlab] icon is a graphical symbol that conveys a specific idea or functionality related to logo, version control.
  /// - It belongs to the brands, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData gitlab =
      IconData(0xe0ea, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [glass_water] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [glass_water] icon is a graphical symbol that conveys a specific idea or functionality related to beverage, drink, glass, water.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData glass_water =
      IconData(0xe2d4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [glasses] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [glasses] icon is a graphical symbol that conveys a specific idea or functionality related to glasses, spectacles.
  /// - It belongs to the accessibility categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ahtohbi4](https://github.com/ahtohbi4), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData glasses =
      IconData(0xe20c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [globe] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [globe] icon is a graphical symbol that conveys a specific idea or functionality related to world, browser, language, translate.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData globe =
      IconData(0xe0eb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [globe_lock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [globe_lock] icon is a graphical symbol that conveys a specific idea or functionality related to vpn, private, privacy, network, world, browser, security, encryption, protection, connection.
  /// - It belongs to the security, development, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData globe_lock =
      IconData(0xe5d1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [goal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [goal] icon is a graphical symbol that conveys a specific idea or functionality related to flag, bullseye.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/guillermo-angeles](https://github.com/guillermo-angeles), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData goal =
      IconData(0xe4a9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grab] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grab] icon is a graphical symbol that conveys a specific idea or functionality related to hand.
  /// - It belongs to the cursors, design, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grab =
      IconData(0xe1e5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [graduation_cap] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [graduation_cap] icon is a graphical symbol that conveys a specific idea or functionality related to school, university, learn, study, mortarboard, education, ceremony, academic, hat, diploma, bachlor's, master's, doctorate.
  /// - It belongs to the buildings categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Tummerhore](https://github.com/Tummerhore), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData graduation_cap =
      IconData(0xe233, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grape] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grape] icon is a graphical symbol that conveys a specific idea or functionality related to fruit, wine, food.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grape =
      IconData(0xe355, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grid_2x2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grid_2x2] icon is a graphical symbol that conveys a specific idea or functionality related to table, rows, columns, blocks, plot, land, geometry, measure, size, width, height, distance, surface area, square meter, acre, window, skylight.
  /// - It belongs to the text, layout, design, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grid_2x2 =
      IconData(0xe503, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grid_2x2_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grid_2x2_check] icon is a graphical symbol that conveys a specific idea or functionality related to table, rows, columns, blocks, plot, land, geometry, measure, data, size, width, height, distance, surface area, square meter, acre.
  /// - It belongs to the text, layout, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/chessurisme](https://github.com/chessurisme) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grid_2x2_check =
      IconData(0xe5e8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grid_2x2_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grid_2x2_plus] icon is a graphical symbol that conveys a specific idea or functionality related to table, rows, columns, blocks, plot, land, geometry, measure, data, size, width, height, distance, surface area, square meter, acre.
  /// - It belongs to the text, layout, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/chessurisme](https://github.com/chessurisme), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grid_2x2_plus =
      IconData(0xe62c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grid_2x2_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grid_2x2_x] icon is a graphical symbol that conveys a specific idea or functionality related to table, rows, columns, data, blocks, plot, land, geometry, measure, size, width, height, distance, surface area, square meter, acre.
  /// - It belongs to the text, layout, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/chessurisme](https://github.com/chessurisme) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grid_2x2_x =
      IconData(0xe5e9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grid_3x3] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grid_3x3] icon is a graphical symbol that conveys a specific idea or functionality related to table, rows, columns.
  /// - It belongs to the text, layout, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/zenoamaro](https://github.com/zenoamaro), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grid_3x3 =
      IconData(0xe0ec, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grip] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grip] icon is a graphical symbol that conveys a specific idea or functionality related to grab, dots, handle, move, drag.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/koole](https://github.com/koole), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grip =
      IconData(0xe3b4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grip_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grip_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to grab, dots, handle, move, drag.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grip_horizontal =
      IconData(0xe0ed, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [grip_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [grip_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to grab, dots, handle, move, drag.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData grip_vertical =
      IconData(0xe0ee, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [group] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [group] icon is a graphical symbol that conveys a specific idea or functionality related to cubes, packages, parts, units, collection, cluster, gather, dashed.
  /// - It belongs to the files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData group =
      IconData(0xe468, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [guitar] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [guitar] icon is a graphical symbol that conveys a specific idea or functionality related to acoustic, instrument, strings, riff, rock, band, country, concert, performance, play, lead, loud, music, audio, sound, noise.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData guitar =
      IconData(0xe563, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ham] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ham] icon is a graphical symbol that conveys a specific idea or functionality related to food, pork, pig, meat, bone, hock, knuckle, gammon, cured.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ham =
      IconData(0xe5db, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hammer] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hammer] icon is a graphical symbol that conveys a specific idea or functionality related to mallet, nails, diy, toolbox, build, construction.
  /// - It belongs to the tools, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hammer =
      IconData(0xe0ef, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hand] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hand] icon is a graphical symbol that conveys a specific idea or functionality related to wave, move, mouse, grab.
  /// - It belongs to the cursors, accessibility categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hand =
      IconData(0xe1d6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hand_coins] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hand_coins] icon is a graphical symbol that conveys a specific idea or functionality related to savings, banking, money, finance, offers, mortgage, payment, received, wage, payroll, allowance, pocket money, handout, pennies.
  /// - It belongs to the finance, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/kayleyhill](https://github.com/kayleyhill) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hand_coins =
      IconData(0xe5bc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hand_heart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hand_heart] icon is a graphical symbol that conveys a specific idea or functionality related to love, like, emotion.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/kayleyhill](https://github.com/kayleyhill) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hand_heart =
      IconData(0xe5bd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hand_helping] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hand_helping] icon is a graphical symbol that conveys a specific idea or functionality related to agreement, help, proposal, charity, begging, terms.
  /// - It belongs to the emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hand_helping =
      IconData(0xe3bb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hand_metal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hand_metal] icon is a graphical symbol that conveys a specific idea or functionality related to rock.
  /// - It belongs to the emoji, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hand_metal =
      IconData(0xe22b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hand_platter] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hand_platter] icon is a graphical symbol that conveys a specific idea or functionality related to waiter, waitress, restaurant, table service, served, dinner, dining, meal, course, luxury.
  /// - It belongs to the food-beverage, people categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hand_platter =
      IconData(0xe5be, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [handshake] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [handshake] icon is a graphical symbol that conveys a specific idea or functionality related to agreement, partnership, deal, business, assistance, cooperation, friendship, union, terms.
  /// - It belongs to the account, social, communication, finance, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData handshake =
      IconData(0xe5c4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hard_drive] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hard_drive] icon is a graphical symbol that conveys a specific idea or functionality related to computer, server, memory, data, ssd, disk, hard disk.
  /// - It belongs to the development, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hard_drive =
      IconData(0xe0f0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hard_drive_download] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hard_drive_download] icon is a graphical symbol that conveys a specific idea or functionality related to computer, server, memory, data, ssd, disk, hard disk, save.
  /// - It belongs to the development, devices, arrows, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hard_drive_download =
      IconData(0xe4e9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hard_drive_upload] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hard_drive_upload] icon is a graphical symbol that conveys a specific idea or functionality related to computer, server, memory, data, ssd, disk, hard disk, save.
  /// - It belongs to the development, devices, arrows, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hard_drive_upload =
      IconData(0xe4ea, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hard_hat] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hard_hat] icon is a graphical symbol that conveys a specific idea or functionality related to helmet, construction, safety, savety.
  /// - It belongs to the tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hard_hat =
      IconData(0xe0f1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hash] icon is a graphical symbol that conveys a specific idea or functionality related to hashtag, number, pound.
  /// - It belongs to the text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hash =
      IconData(0xe0f2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [haze] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [haze] icon is a graphical symbol that conveys a specific idea or functionality related to mist, fog.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData haze =
      IconData(0xe0f3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hdmi_port] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hdmi_port] icon is a graphical symbol that conveys a specific idea or functionality related to socket, plug, slot, controller, connector, interface, console, signal, audio, video, visual, av, data, input, output.
  /// - It belongs to the devices, multimedia, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hdmi_port =
      IconData(0xe4eb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heading] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heading] icon is a graphical symbol that conveys a specific idea or functionality related to h1, html, markup, markdown.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heading =
      IconData(0xe387, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heading_1] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heading_1] icon is a graphical symbol that conveys a specific idea or functionality related to h1, html, markup, markdown.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heading_1 =
      IconData(0xe388, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heading_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heading_2] icon is a graphical symbol that conveys a specific idea or functionality related to h2, html, markup, markdown.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heading_2 =
      IconData(0xe389, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heading_3] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heading_3] icon is a graphical symbol that conveys a specific idea or functionality related to h3, html, markup, markdown.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heading_3 =
      IconData(0xe38a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heading_4] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heading_4] icon is a graphical symbol that conveys a specific idea or functionality related to h4, html, markup, markdown.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heading_4 =
      IconData(0xe38b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heading_5] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heading_5] icon is a graphical symbol that conveys a specific idea or functionality related to h5, html, markup, markdown.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heading_5 =
      IconData(0xe38c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heading_6] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heading_6] icon is a graphical symbol that conveys a specific idea or functionality related to h6, html, markup, markdown.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heading_6 =
      IconData(0xe38d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [headphone_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [headphone_off] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, sound, mute, off.
  /// - It belongs to the multimedia, connectivity, communication, devices, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/Need-an-AwP](https://github.com/Need-an-AwP) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData headphone_off =
      IconData(0xe62d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [headphones] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [headphones] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, sound.
  /// - It belongs to the multimedia, connectivity, devices, files, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData headphones =
      IconData(0xe0f4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [headset] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [headset] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, sound, gaming, headphones, headset, call, center, phone, telephone, voip, video.
  /// - It belongs to the multimedia, connectivity, devices, files, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData headset =
      IconData(0xe5c1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heart] icon is a graphical symbol that conveys a specific idea or functionality related to like, love, emotion, suit, playing, cards.
  /// - It belongs to the medical, social, multimedia, emoji, gaming, shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heart =
      IconData(0xe0f5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heart_crack] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heart_crack] icon is a graphical symbol that conveys a specific idea or functionality related to heartbreak, sadness, emotion.
  /// - It belongs to the emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heart_crack =
      IconData(0xe2d5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heart_handshake] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heart_handshake] icon is a graphical symbol that conveys a specific idea or functionality related to agreement, charity, help, deal, terms, emotion, together, handshake.
  /// - It belongs to the emoji, account, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heart_handshake =
      IconData(0xe2d6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heart_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heart_off] icon is a graphical symbol that conveys a specific idea or functionality related to unlike, dislike, hate, emotion.
  /// - It belongs to the social, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heart_off =
      IconData(0xe294, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heart_pulse] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heart_pulse] icon is a graphical symbol that conveys a specific idea or functionality related to heartbeat, pulse, health, medical, blood pressure, cardiac, systole, diastole.
  /// - It belongs to the medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heart_pulse =
      IconData(0xe371, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [heater] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [heater] icon is a graphical symbol that conveys a specific idea or functionality related to heating, warmth, comfort, fire, stove, electric, electronics, amenities.
  /// - It belongs to the home, devices, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData heater =
      IconData(0xe592, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hexagon] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hexagon] icon is a graphical symbol that conveys a specific idea or functionality related to shape, node.js, logo.
  /// - It belongs to the shapes, brands, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hexagon =
      IconData(0xe0f6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [highlighter] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [highlighter] icon is a graphical symbol that conveys a specific idea or functionality related to mark, text.
  /// - It belongs to the text, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData highlighter =
      IconData(0xe0f7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [history] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [history] icon is a graphical symbol that conveys a specific idea or functionality related to time, redo, undo, rewind, timeline, version, time machine, backup, rotate, ccw.
  /// - It belongs to the arrows, time categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData history =
      IconData(0xe1f4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hop] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hop] icon is a graphical symbol that conveys a specific idea or functionality related to beer, brewery, drink.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hop =
      IconData(0xe39a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hop_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hop_off] icon is a graphical symbol that conveys a specific idea or functionality related to beer, brewery, drink, hop free, allergy, intolerance, diet.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hop_off =
      IconData(0xe39b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hospital] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hospital] icon is a graphical symbol that conveys a specific idea or functionality related to infirmary, sanatorium, healthcare, doctor, hospice, clinic, emergency room, ward, building, medical, vet.
  /// - It belongs to the medical, buildings, navigation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hospital =
      IconData(0xe5dc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hotel] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hotel] icon is a graphical symbol that conveys a specific idea or functionality related to building, hostel, motel, inn.
  /// - It belongs to the buildings, navigation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hotel =
      IconData(0xe3e5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [hourglass] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [hourglass] icon is a graphical symbol that conveys a specific idea or functionality related to timer, time, sandglass.
  /// - It belongs to the time, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData hourglass =
      IconData(0xe295, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [house] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [house] icon is a graphical symbol that conveys a specific idea or functionality related to home, living, building, residence, architecture.
  /// - It belongs to the buildings, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData house =
      IconData(0xe0f8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [house_plug] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [house_plug] icon is a graphical symbol that conveys a specific idea or functionality related to home, living, building, residence, architecture, autarky, energy.
  /// - It belongs to the buildings, home, sustainability categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData house_plug =
      IconData(0xe5f4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [house_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [house_plus] icon is a graphical symbol that conveys a specific idea or functionality related to home, living, medical, new, addition, building, residence, architecture.
  /// - It belongs to the buildings, medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData house_plus =
      IconData(0xe5f5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [house_wifi] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [house_wifi] icon is a graphical symbol that conveys a specific idea or functionality related to home, living, building, wifi, connectivity.
  /// - It belongs to the home, buildings, connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/akshaymemane](https://github.com/akshaymemane), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData house_wifi =
      IconData(0xe640, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ice_cream_bowl] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ice_cream_bowl] icon is a graphical symbol that conveys a specific idea or functionality related to gelato, food, dessert, dish, restaurant, course, meal.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kemie](https://github.com/kemie), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ice_cream_bowl =
      IconData(0xe3aa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ice_cream_cone] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ice_cream_cone] icon is a graphical symbol that conveys a specific idea or functionality related to gelato, food.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ice_cream_cone =
      IconData(0xe356, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [id_card] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [id_card] icon is a graphical symbol that conveys a specific idea or functionality related to card, badge, identity, authentication, secure.
  /// - It belongs to the security, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData id_card =
      IconData(0xe61b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [image] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [image] icon is a graphical symbol that conveys a specific idea or functionality related to picture, photo.
  /// - It belongs to the photography, text, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData image =
      IconData(0xe0f9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [image_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [image_down] icon is a graphical symbol that conveys a specific idea or functionality related to picture, photo, download, save, export.
  /// - It belongs to the photography, text, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData image_down =
      IconData(0xe540, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [image_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [image_minus] icon is a graphical symbol that conveys a specific idea or functionality related to remove, delete.
  /// - It belongs to the photography, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData image_minus =
      IconData(0xe1f5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [image_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [image_off] icon is a graphical symbol that conveys a specific idea or functionality related to picture, photo.
  /// - It belongs to the photography, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData image_off =
      IconData(0xe1bf, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [image_play] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [image_play] icon is a graphical symbol that conveys a specific idea or functionality related to picture, gif, photo.
  /// - It belongs to the photography, text, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData image_play =
      IconData(0xe5e3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [image_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [image_plus] icon is a graphical symbol that conveys a specific idea or functionality related to add, create, picture.
  /// - It belongs to the photography, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData image_plus =
      IconData(0xe1f6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [image_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [image_up] icon is a graphical symbol that conveys a specific idea or functionality related to picture, photo, upload, import.
  /// - It belongs to the photography, text, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData image_up =
      IconData(0xe5cf, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [image_upscale] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [image_upscale] icon is a graphical symbol that conveys a specific idea or functionality related to resize, picture, sharpen, increase.
  /// - It belongs to the photography, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/llaenowyd](https://github.com/llaenowyd), [https://github.com/mishkaio](https://github.com/mishkaio), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData image_upscale =
      IconData(0xe63b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [images] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [images] icon is a graphical symbol that conveys a specific idea or functionality related to picture, photo, multiple, copy, gallery, album, collection, slideshow, showcase.
  /// - It belongs to the photography, text, multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData images =
      IconData(0xe5c8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [import] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [import] icon is a graphical symbol that conveys a specific idea or functionality related to save.
  /// - It belongs to the arrows, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData import =
      IconData(0xe22e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [inbox] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [inbox] icon is a graphical symbol that conveys a specific idea or functionality related to email.
  /// - It belongs to the account, mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData inbox =
      IconData(0xe0fa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [indent_decrease] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [indent_decrease] icon is a graphical symbol that conveys a specific idea or functionality related to text, tab.
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Themistoklis](https://github.com/Themistoklis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData indent_decrease =
      IconData(0xe0fb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [indent_increase] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [indent_increase] icon is a graphical symbol that conveys a specific idea or functionality related to text, tab.
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Themistoklis](https://github.com/Themistoklis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData indent_increase =
      IconData(0xe0fc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [indian_rupee] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [indian_rupee] icon is a graphical symbol that conveys a specific idea or functionality related to currency, money, payment.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData indian_rupee =
      IconData(0xe0fd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [infinity] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [infinity] icon is a graphical symbol that conveys a specific idea or functionality related to unlimited, forever, loop, math.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData infinity =
      IconData(0xe1e6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [info] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [info] icon is a graphical symbol that conveys a specific idea or functionality related to help.
  /// - It belongs to the accessibility, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData info =
      IconData(0xe0fe, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [inspection_panel] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [inspection_panel] icon is a graphical symbol that conveys a specific idea or functionality related to access, cover, tile, metal, materials, screws.
  /// - It belongs to the tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData inspection_panel =
      IconData(0xe587, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [instagram] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [instagram] icon is a graphical symbol that conveys a specific idea or functionality related to logo, camera, social.
  /// - It belongs to the brands, social, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData instagram =
      IconData(0xe0ff, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [italic] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [italic] icon is a graphical symbol that conveys a specific idea or functionality related to oblique, text, format.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData italic =
      IconData(0xe100, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [iteration_ccw] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [iteration_ccw] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, right.
  /// - It belongs to the arrows, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData iteration_ccw =
      IconData(0xe427, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [iteration_cw] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [iteration_cw] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, left.
  /// - It belongs to the arrows, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData iteration_cw =
      IconData(0xe428, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [japanese_yen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [japanese_yen] icon is a graphical symbol that conveys a specific idea or functionality related to currency, money, payment.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData japanese_yen =
      IconData(0xe101, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [joystick] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [joystick] icon is a graphical symbol that conveys a specific idea or functionality related to game, console, control stick.
  /// - It belongs to the gaming, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData joystick =
      IconData(0xe358, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [kanban] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [kanban] icon is a graphical symbol that conveys a specific idea or functionality related to projects, manage, overview, board, tickets, issues, roadmap, plan, intentions, productivity, work, agile, code, coding.
  /// - It belongs to the charts, development, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData kanban =
      IconData(0xe4e0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [key] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [key] icon is a graphical symbol that conveys a specific idea or functionality related to password, login, authentication, secure, unlock, keychain, key ring, fob.
  /// - It belongs to the security, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ashygee](https://github.com/ashygee), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData key =
      IconData(0xe102, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [key_round] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [key_round] icon is a graphical symbol that conveys a specific idea or functionality related to password, login, authentication, secure, unlock.
  /// - It belongs to the security, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData key_round =
      IconData(0xe4a7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [key_square] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [key_square] icon is a graphical symbol that conveys a specific idea or functionality related to password, login, authentication, secure, unlock, car key.
  /// - It belongs to the security, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData key_square =
      IconData(0xe4a8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [keyboard] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [keyboard] icon is a graphical symbol that conveys a specific idea or functionality related to layout, spell, settings, mouse.
  /// - It belongs to the text, devices, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData keyboard =
      IconData(0xe283, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [keyboard_music] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [keyboard_music] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, sound, noise, notes, keys, chord, octave, midi, controller, instrument, electric, signal, digital, studio, production, producer, pianist, piano, play, performance, concert.
  /// - It belongs to the multimedia, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData keyboard_music =
      IconData(0xe564, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [keyboard_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [keyboard_off] icon is a graphical symbol that conveys a specific idea or functionality related to unkeys, layout, spell, settings, mouse.
  /// - It belongs to the devices, text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Diottodev](https://github.com/Diottodev), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData keyboard_off =
      IconData(0xe5e2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lamp] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lamp] icon is a graphical symbol that conveys a specific idea or functionality related to lighting, household, home, furniture.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lamp =
      IconData(0xe2d7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lamp_ceiling] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lamp_ceiling] icon is a graphical symbol that conveys a specific idea or functionality related to lighting, household, home, furniture.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lamp_ceiling =
      IconData(0xe2d8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lamp_desk] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lamp_desk] icon is a graphical symbol that conveys a specific idea or functionality related to lighting, household, office, desk, home, furniture.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lamp_desk =
      IconData(0xe2d9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lamp_floor] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lamp_floor] icon is a graphical symbol that conveys a specific idea or functionality related to lighting, household, floor, home, furniture.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lamp_floor =
      IconData(0xe2da, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lamp_wall_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lamp_wall_down] icon is a graphical symbol that conveys a specific idea or functionality related to lighting, household, wall, home, furniture.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lamp_wall_down =
      IconData(0xe2db, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lamp_wall_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lamp_wall_up] icon is a graphical symbol that conveys a specific idea or functionality related to lighting, household, wall, home, furniture.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lamp_wall_up =
      IconData(0xe2dc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [land_plot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [land_plot] icon is a graphical symbol that conveys a specific idea or functionality related to area, surface, square metres, allotment, parcel, property, plane, acres, measure, distance, isometric, flag, golf course, hole.
  /// - It belongs to the design, tools, math, sports, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData land_plot =
      IconData(0xe52c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [landmark] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [landmark] icon is a graphical symbol that conveys a specific idea or functionality related to bank, building, capitol, finance, money, government, institution.
  /// - It belongs to the finance, navigation, buildings categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/connium](https://github.com/connium), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData landmark =
      IconData(0xe239, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [languages] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [languages] icon is a graphical symbol that conveys a specific idea or functionality related to translate.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData languages =
      IconData(0xe103, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [laptop] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [laptop] icon is a graphical symbol that conveys a specific idea or functionality related to computer, screen, remote.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData laptop =
      IconData(0xe1cc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [laptop_minimal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [laptop_minimal] icon is a graphical symbol that conveys a specific idea or functionality related to computer, screen, remote.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData laptop_minimal =
      IconData(0xe1d7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [laptop_minimal_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [laptop_minimal_check] icon is a graphical symbol that conveys a specific idea or functionality related to computer, screen, remote, success, done, todo, tick, complete, task.
  /// - It belongs to the devices, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData laptop_minimal_check =
      IconData(0xe636, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lasso] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lasso] icon is a graphical symbol that conveys a specific idea or functionality related to select, cursor.
  /// - It belongs to the design, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mishkaio](https://github.com/mishkaio), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lasso =
      IconData(0xe1cd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lasso_select] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lasso_select] icon is a graphical symbol that conveys a specific idea or functionality related to select, cursor.
  /// - It belongs to the arrows, design, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mishkaio](https://github.com/mishkaio), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lasso_select =
      IconData(0xe1ce, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [laugh] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [laugh] icon is a graphical symbol that conveys a specific idea or functionality related to emoji, face, happy, good, emotion.
  /// - It belongs to the emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData laugh =
      IconData(0xe2ff, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [layers] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [layers] icon is a graphical symbol that conveys a specific idea or functionality related to stack, pile, pages, sheets, paperwork, copies, copy.
  /// - It belongs to the design, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData layers =
      IconData(0xe52d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [layers_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [layers_2] icon is a graphical symbol that conveys a specific idea or functionality related to stack, pile, pages, sheets, paperwork, copies, copy, duplicate, double, shortcuts.
  /// - It belongs to the design, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData layers_2 =
      IconData(0xe52e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [layout_dashboard] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [layout_dashboard] icon is a graphical symbol that conveys a specific idea or functionality related to masonry, brick.
  /// - It belongs to the design, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData layout_dashboard =
      IconData(0xe1c0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [layout_grid] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [layout_grid] icon is a graphical symbol that conveys a specific idea or functionality related to app, home, start.
  /// - It belongs to the design, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/zenoamaro](https://github.com/zenoamaro), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData layout_grid =
      IconData(0xe104, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [layout_list] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [layout_list] icon is a graphical symbol that conveys a specific idea or functionality related to todo, tasks, items, pending, image, photo.
  /// - It belongs to the design, layout, photography, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData layout_list =
      IconData(0xe1d8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [layout_panel_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [layout_panel_left] icon is a graphical symbol that conveys a specific idea or functionality related to app, home, start, grid.
  /// - It belongs to the design, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData layout_panel_left =
      IconData(0xe474, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [layout_panel_top] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [layout_panel_top] icon is a graphical symbol that conveys a specific idea or functionality related to window, webpage, block, section, grid, template, structure.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData layout_panel_top =
      IconData(0xe475, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [layout_template] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [layout_template] icon is a graphical symbol that conveys a specific idea or functionality related to window, webpage, block, section.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData layout_template =
      IconData(0xe206, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [leaf] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [leaf] icon is a graphical symbol that conveys a specific idea or functionality related to sustainability, nature, energy, plant, autumn.
  /// - It belongs to the nature, sustainability, seasons categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData leaf =
      IconData(0xe2dd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [leafy_green] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [leafy_green] icon is a graphical symbol that conveys a specific idea or functionality related to salad, lettuce, vegetable, chard, cabbage, bok choy.
  /// - It belongs to the food-beverage, emoji, sustainability categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData leafy_green =
      IconData(0xe473, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lectern] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lectern] icon is a graphical symbol that conveys a specific idea or functionality related to pulpit, podium, stand.
  /// - It belongs to the communication, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/gurtt](https://github.com/gurtt), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lectern =
      IconData(0xe5ed, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [letter_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [letter_text] icon is a graphical symbol that conveys a specific idea or functionality related to drop cap, text, format, typography, letter, font size.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/GRA0007](https://github.com/GRA0007) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData letter_text =
      IconData(0xe609, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [library] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [library] icon is a graphical symbol that conveys a specific idea or functionality related to books, reading, written, authors, stories, fiction, novels, information, knowledge, education, high school, university, college, academy, learning, study, research, collection, vinyl, records, albums, music, package.
  /// - It belongs to the text, photography, multimedia, navigation, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData library =
      IconData(0xe105, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [library_big] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [library_big] icon is a graphical symbol that conveys a specific idea or functionality related to books, reading, written, authors, stories, fiction, novels, information, knowledge, education, high school, university, college, academy, learning, study, research, collection, vinyl, records, albums, music, package.
  /// - It belongs to the text, photography, multimedia, navigation, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData library_big =
      IconData(0xe552, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [life_buoy] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [life_buoy] icon is a graphical symbol that conveys a specific idea or functionality related to preserver, life belt, lifesaver, help, rescue, ship, ring, raft, inflatable, wheel, donut.
  /// - It belongs to the accessibility, medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData life_buoy =
      IconData(0xe106, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ligature] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ligature] icon is a graphical symbol that conveys a specific idea or functionality related to text, font, typography, alternates, alternatives.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ligature =
      IconData(0xe43e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lightbulb] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lightbulb] icon is a graphical symbol that conveys a specific idea or functionality related to idea, bright, lights.
  /// - It belongs to the photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lightbulb =
      IconData(0xe1c1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lightbulb_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lightbulb_off] icon is a graphical symbol that conveys a specific idea or functionality related to lights.
  /// - It belongs to the photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lightbulb_off =
      IconData(0xe207, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [link] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [link] icon is a graphical symbol that conveys a specific idea or functionality related to chain, url.
  /// - It belongs to the text, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData link =
      IconData(0xe107, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [link_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [link_2] icon is a graphical symbol that conveys a specific idea or functionality related to chain, url.
  /// - It belongs to the text, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData link_2 =
      IconData(0xe108, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [link_2_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [link_2_off] icon is a graphical symbol that conveys a specific idea or functionality related to unchain, chain.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData link_2_off =
      IconData(0xe109, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [linkedin] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [linkedin] icon is a graphical symbol that conveys a specific idea or functionality related to logo, social media, social.
  /// - It belongs to the social, brands categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/okcoker](https://github.com/okcoker), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData linkedin =
      IconData(0xe10a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list] icon is a graphical symbol that conveys a specific idea or functionality related to options.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list =
      IconData(0xe10b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_check] icon is a graphical symbol that conveys a specific idea or functionality related to done, check, tick, complete, list, to-do, bom.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/guanboo-yang](https://github.com/guanboo-yang) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_check =
      IconData(0xe5fe, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_checks] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_checks] icon is a graphical symbol that conveys a specific idea or functionality related to todo, done, check, tick, complete, tasks, items, pending.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_checks =
      IconData(0xe1cf, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_collapse] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_collapse] icon is a graphical symbol that conveys a specific idea or functionality related to items, collapse, expand, details, disclosure, show, hide, toggle, accordion, more, less, fold, unfold.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ocavue](https://github.com/ocavue) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_collapse =
      IconData(0xe59f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_end] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_end] icon is a graphical symbol that conveys a specific idea or functionality related to queue, bottom, end, playlist.
  /// - It belongs to the multimedia, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_end =
      IconData(0xe2de, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_filter] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_filter] icon is a graphical symbol that conveys a specific idea or functionality related to options.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_filter =
      IconData(0xe464, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_filter_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_filter_plus] icon is a graphical symbol that conveys a specific idea or functionality related to filter, plus, options, add.
  /// - It belongs to the text, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/abdeniz](https://github.com/abdeniz) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_filter_plus =
      IconData(0xe63d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_minus] icon is a graphical symbol that conveys a specific idea or functionality related to playlist, remove, song, subtract, delete, unqueue.
  /// - It belongs to the multimedia, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_minus =
      IconData(0xe23d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_music] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_music] icon is a graphical symbol that conveys a specific idea or functionality related to playlist, queue, music, audio, playback.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_music =
      IconData(0xe2df, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_ordered] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_ordered] icon is a graphical symbol that conveys a specific idea or functionality related to number, order, queue.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_ordered =
      IconData(0xe1d0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_plus] icon is a graphical symbol that conveys a specific idea or functionality related to playlist, add, song, track, new.
  /// - It belongs to the multimedia, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_plus =
      IconData(0xe23e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_restart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_restart] icon is a graphical symbol that conveys a specific idea or functionality related to reset, refresh, reload, playlist, replay.
  /// - It belongs to the multimedia, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_restart =
      IconData(0xe456, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_start] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_start] icon is a graphical symbol that conveys a specific idea or functionality related to queue, top, start, next, playlist.
  /// - It belongs to the multimedia, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_start =
      IconData(0xe2e0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_todo] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_todo] icon is a graphical symbol that conveys a specific idea or functionality related to todo, done, check, tick, complete, tasks, items, pending.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_todo =
      IconData(0xe4c7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_tree] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_tree] icon is a graphical symbol that conveys a specific idea or functionality related to tree, browser.
  /// - It belongs to the files, text, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_tree =
      IconData(0xe40c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_video] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_video] icon is a graphical symbol that conveys a specific idea or functionality related to playlist, video, playback.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_video =
      IconData(0xe2e1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [list_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [list_x] icon is a graphical symbol that conveys a specific idea or functionality related to playlist, subtract, remove, delete, unqueue.
  /// - It belongs to the multimedia, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData list_x =
      IconData(0xe23f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [loader] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [loader] icon is a graphical symbol that conveys a specific idea or functionality related to loading, wait, busy, progress, spinner, spinning, throbber.
  /// - It belongs to the cursors, multimedia, layout, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData loader =
      IconData(0xe10c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [loader_circle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [loader_circle] icon is a graphical symbol that conveys a specific idea or functionality related to loading, wait, busy, progress, spinner, spinning, throbber, circle.
  /// - It belongs to the cursors, multimedia, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData loader_circle =
      IconData(0xe10d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [loader_pinwheel] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [loader_pinwheel] icon is a graphical symbol that conveys a specific idea or functionality related to loading, wait, busy, progress, throbber, spinner, spinning, beach ball, frozen, freeze.
  /// - It belongs to the cursors, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData loader_pinwheel =
      IconData(0xe5ea, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [locate] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [locate] icon is a graphical symbol that conveys a specific idea or functionality related to map, gps, location, cross.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData locate =
      IconData(0xe1d9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [locate_fixed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [locate_fixed] icon is a graphical symbol that conveys a specific idea or functionality related to map, gps, location, cross.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/csandman](https://github.com/csandman), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData locate_fixed =
      IconData(0xe1da, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [locate_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [locate_off] icon is a graphical symbol that conveys a specific idea or functionality related to map, gps, location, cross.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/fdev](https://github.com/fdev) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData locate_off =
      IconData(0xe281, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lock] icon is a graphical symbol that conveys a specific idea or functionality related to security, password, secure, admin.
  /// - It belongs to the security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lock =
      IconData(0xe10e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lock_keyhole] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lock_keyhole] icon is a graphical symbol that conveys a specific idea or functionality related to security, password, secure, admin.
  /// - It belongs to the security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/cd16b](https://github.com/cd16b), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lock_keyhole =
      IconData(0xe535, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lock_keyhole_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lock_keyhole_open] icon is a graphical symbol that conveys a specific idea or functionality related to security.
  /// - It belongs to the security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/cd16b](https://github.com/cd16b), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lock_keyhole_open =
      IconData(0xe536, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lock_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lock_open] icon is a graphical symbol that conveys a specific idea or functionality related to security.
  /// - It belongs to the security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lock_open =
      IconData(0xe10f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [log_in] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [log_in] icon is a graphical symbol that conveys a specific idea or functionality related to sign in, arrow, enter, auth.
  /// - It belongs to the arrows, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData log_in =
      IconData(0xe110, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [log_out] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [log_out] icon is a graphical symbol that conveys a specific idea or functionality related to sign out, arrow, exit, auth.
  /// - It belongs to the arrows, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData log_out =
      IconData(0xe111, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [logs] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [logs] icon is a graphical symbol that conveys a specific idea or functionality related to options, list, menu, order, queue, tasks, logs.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/AndreasSas](https://github.com/AndreasSas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData logs =
      IconData(0xe5f8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [lollipop] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [lollipop] icon is a graphical symbol that conveys a specific idea or functionality related to lolly, candy, sugar, food, sweet, dessert, spiral.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData lollipop =
      IconData(0xe4c1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [luggage] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [luggage] icon is a graphical symbol that conveys a specific idea or functionality related to baggage, luggage, travel, suitcase.
  /// - It belongs to the travel, transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData luggage =
      IconData(0xe2c9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [magnet] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [magnet] icon is a graphical symbol that conveys a specific idea or functionality related to horseshoe, lock, science, snap.
  /// - It belongs to the design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData magnet =
      IconData(0xe2b4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mail] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mail] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, letter, unread.
  /// - It belongs to the text, account, mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mail =
      IconData(0xe112, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mail_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mail_check] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, letter, subscribe, delivered, success, read, done, todo, tick, complete, task.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mail_check =
      IconData(0xe364, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mail_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mail_minus] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, letter, remove, delete.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mail_minus =
      IconData(0xe365, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mail_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mail_open] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, letter, read.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mail_open =
      IconData(0xe366, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mail_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mail_plus] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, letter, add, create, new, compose.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mail_plus =
      IconData(0xe367, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mail_question] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mail_question] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, letter, delivery, undelivered.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mail_question =
      IconData(0xe368, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mail_search] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mail_search] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, letter, search.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mail_search =
      IconData(0xe369, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mail_warning] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mail_warning] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, letter, delivery error, exclamation mark.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mail_warning =
      IconData(0xe36a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mail_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mail_x] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, letter, remove, delete.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mail_x =
      IconData(0xe36b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mailbox] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mailbox] icon is a graphical symbol that conveys a specific idea or functionality related to emails, messages, letters, mailing list, newsletter.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mailbox =
      IconData(0xe3d7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mails] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mails] icon is a graphical symbol that conveys a specific idea or functionality related to emails, messages, letters, multiple, mailing list, newsletter, copy.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mails =
      IconData(0xe36c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map] icon is a graphical symbol that conveys a specific idea or functionality related to location, navigation, travel.
  /// - It belongs to the text, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map =
      IconData(0xe113, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin =
      IconData(0xe114, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_check] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop, done, tick, complete, task, added.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_check =
      IconData(0xe613, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_check_inside] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_check_inside] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop, done, tick, complete, task, added.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_check_inside =
      IconData(0xe614, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_house] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_house] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop, home, living, building, residence, architecture, address, poi, real estate, property, navigation, destination, geolocation, place, landmark.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_house =
      IconData(0xe620, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_minus] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop, delete, remove, erase.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_minus =
      IconData(0xe615, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_minus_inside] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_minus_inside] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop, delete, remove, erase.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_minus_inside =
      IconData(0xe616, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_off] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, remove.
  /// - It belongs to the navigation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_off =
      IconData(0xe2a5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_plus] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop, add, create, new.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_plus =
      IconData(0xe617, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_plus_inside] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_plus_inside] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop, add, create, new.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_plus_inside =
      IconData(0xe618, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_x] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop, delete, remove, erase.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_x =
      IconData(0xe619, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pin_x_inside] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pin_x_inside] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop, delete, remove, erase.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pin_x_inside =
      IconData(0xe61a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [map_pinned] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [map_pinned] icon is a graphical symbol that conveys a specific idea or functionality related to location, waypoint, marker, drop.
  /// - It belongs to the navigation, travel, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData map_pinned =
      IconData(0xe541, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [martini] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [martini] icon is a graphical symbol that conveys a specific idea or functionality related to cocktail, alcohol, beverage, bar, drink, glass.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData martini =
      IconData(0xe2e2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [maximize] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [maximize] icon is a graphical symbol that conveys a specific idea or functionality related to fullscreen, expand, dashed.
  /// - It belongs to the layout, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData maximize =
      IconData(0xe115, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [maximize_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [maximize_2] icon is a graphical symbol that conveys a specific idea or functionality related to fullscreen, arrows, expand.
  /// - It belongs to the arrows, layout, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData maximize_2 =
      IconData(0xe116, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [medal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [medal] icon is a graphical symbol that conveys a specific idea or functionality related to prize, sports, winner, trophy, award, achievement.
  /// - It belongs to the sports, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData medal =
      IconData(0xe372, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [megaphone] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [megaphone] icon is a graphical symbol that conveys a specific idea or functionality related to advertisement, attention, alert, notification.
  /// - It belongs to the multimedia, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData megaphone =
      IconData(0xe234, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [megaphone_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [megaphone_off] icon is a graphical symbol that conveys a specific idea or functionality related to advertisement, attention, alert, notification, disable, silent.
  /// - It belongs to the multimedia, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData megaphone_off =
      IconData(0xe373, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [meh] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [meh] icon is a graphical symbol that conveys a specific idea or functionality related to emoji, face, neutral, emotion.
  /// - It belongs to the emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData meh =
      IconData(0xe117, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [memory_stick] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [memory_stick] icon is a graphical symbol that conveys a specific idea or functionality related to ram, random access, technology, computer, chip, circuit, specs, capacity, gigabytes, gb.
  /// - It belongs to the devices, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData memory_stick =
      IconData(0xe449, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [menu] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [menu] icon is a graphical symbol that conveys a specific idea or functionality related to bars, navigation, hamburger, options.
  /// - It belongs to the layout, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData menu =
      IconData(0xe118, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [merge] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [merge] icon is a graphical symbol that conveys a specific idea or functionality related to combine, join, unite.
  /// - It belongs to the development, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData merge =
      IconData(0xe443, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle =
      IconData(0xe119, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_code] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_code] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, code review, coding.
  /// - It belongs to the development, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_code =
      IconData(0xe566, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, draft.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_dashed =
      IconData(0xe567, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_heart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_heart] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, positive, like, love, interest, valentine, dating, date, speech bubble.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_heart =
      IconData(0xe568, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_more] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_more] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, typing, writing, responding, ellipsis, etc, et cetera, ..., ….
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_more =
      IconData(0xe569, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_off] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, clear, close, delete, remove, cancel, silence, mute, moderate.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_off =
      IconData(0xe56a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_plus] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, add.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_plus =
      IconData(0xe56b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_question] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_question] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, help.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_question =
      IconData(0xe56c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_reply] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_reply] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, reply, response.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_reply =
      IconData(0xe56d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_warning] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_warning] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, report, abuse, offense, alert, danger, caution, protected, exclamation mark.
  /// - It belongs to the social, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_warning =
      IconData(0xe56e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_circle_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_circle_x] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, clear, close, delete, remove, cancel, silence, mute, moderate.
  /// - It belongs to the account, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_circle_x =
      IconData(0xe56f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square =
      IconData(0xe11a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_code] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_code] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, code review, coding.
  /// - It belongs to the development, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_code =
      IconData(0xe570, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, draft.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_dashed =
      IconData(0xe40f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_diff] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_diff] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, add, patch, difference, plus, minus, plus-minus, math, code review, coding, version control, git.
  /// - It belongs to the development, files, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_diff =
      IconData(0xe571, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_dot] icon is a graphical symbol that conveys a specific idea or functionality related to unread, unresolved, comment, chat, conversation, dialog, feedback, speech bubble.
  /// - It belongs to the social, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_dot =
      IconData(0xe572, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_heart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_heart] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, positive, like, love, interest, valentine, dating, date, speech bubble.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_heart =
      IconData(0xe573, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_lock] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_lock] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, secure, encrypted.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_lock =
      IconData(0xe630, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_more] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_more] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, typing, writing, responding, ellipsis, etc, et cetera, ..., ….
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_more =
      IconData(0xe574, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_off] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, clear, close, delete, remove, cancel, silence, mute, moderate.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_off =
      IconData(0xe575, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_plus] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, add.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_plus =
      IconData(0xe410, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_quote] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_quote] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, blockquote, quotation, indent, reply, response.
  /// - It belongs to the social, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_quote =
      IconData(0xe576, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_reply] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_reply] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, reply, response.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_reply =
      IconData(0xe577, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_share] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_share] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, network, forward.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_share =
      IconData(0xe578, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_text] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_text =
      IconData(0xe579, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_warning] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_warning] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, report, abuse, offense, alert, danger, caution, protected, exclamation mark.
  /// - It belongs to the social, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_warning =
      IconData(0xe57a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [message_square_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [message_square_x] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubble, clear, close, delete, remove, cancel, silence, mute, moderate.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData message_square_x =
      IconData(0xe57b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [messages_square] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [messages_square] icon is a graphical symbol that conveys a specific idea or functionality related to comment, chat, conversation, dialog, feedback, speech bubbles, copy, multiple.
  /// - It belongs to the social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData messages_square =
      IconData(0xe411, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mic] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mic] icon is a graphical symbol that conveys a specific idea or functionality related to record, sound, listen, radio, podcast, microphone.
  /// - It belongs to the devices, communication, connectivity, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mic =
      IconData(0xe11b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mic_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mic_off] icon is a graphical symbol that conveys a specific idea or functionality related to record, sound, mute, microphone.
  /// - It belongs to the devices, communication, connectivity, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mic_off =
      IconData(0xe11c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mic_vocal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mic_vocal] icon is a graphical symbol that conveys a specific idea or functionality related to lyrics, voice, listen, sound, music, radio, podcast, karaoke, singing, microphone.
  /// - It belongs to the devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mic_vocal =
      IconData(0xe34c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [microchip] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [microchip] icon is a graphical symbol that conveys a specific idea or functionality related to processor, cores, technology, computer, chip, integrated circuit, memory, ram, specs, gpu, gigahertz, ghz.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData microchip =
      IconData(0xe61e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [microscope] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [microscope] icon is a graphical symbol that conveys a specific idea or functionality related to medical, education, science, imaging, research.
  /// - It belongs to the science, medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData microscope =
      IconData(0xe2e3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [microwave] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [microwave] icon is a graphical symbol that conveys a specific idea or functionality related to oven, cooker, toaster oven, bake.
  /// - It belongs to the food-beverage, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData microwave =
      IconData(0xe37d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [milestone] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [milestone] icon is a graphical symbol that conveys a specific idea or functionality related to signpost, direction, right, east, forward, version control, waypoint.
  /// - It belongs to the arrows, navigation, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData milestone =
      IconData(0xe297, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [milk] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [milk] icon is a graphical symbol that conveys a specific idea or functionality related to lactose, bottle, beverage, drink, water, diet.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData milk =
      IconData(0xe39c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [milk_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [milk_off] icon is a graphical symbol that conveys a specific idea or functionality related to lactose free, bottle, beverage, drink, water, allergy, intolerance, diet.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData milk_off =
      IconData(0xe39d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [minimize] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [minimize] icon is a graphical symbol that conveys a specific idea or functionality related to exit fullscreen, close, shrink.
  /// - It belongs to the layout, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData minimize =
      IconData(0xe11d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [minimize_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [minimize_2] icon is a graphical symbol that conveys a specific idea or functionality related to exit fullscreen, arrows, close, shrink.
  /// - It belongs to the arrows, layout, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData minimize_2 =
      IconData(0xe11e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [minus] icon is a graphical symbol that conveys a specific idea or functionality related to subtract, remove, decrease, decrement, reduce, negative, calculate, line, divider, separator, horizontal rule, hr, html, markup, markdown, ---, toolbar, operator, code, coding, minimum, downgrade.
  /// - It belongs to the math, development, text, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData minus =
      IconData(0xe11f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, virtual machine, vm.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor =
      IconData(0xe120, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_check] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, desktop, running, active, virtual machine, vm.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_check =
      IconData(0xe486, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_cog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_cog] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, virtual machine, vm, executable, settings, cog, edit, gear, configuration, preferences, system, control panel, network, computing.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_cog =
      IconData(0xe607, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_dot] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, desktop, running, active, virtual machine, vm.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_dot =
      IconData(0xe487, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_down] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, desktop, download.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_down =
      IconData(0xe425, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_off] icon is a graphical symbol that conveys a specific idea or functionality related to share.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/yukosgiti](https://github.com/yukosgiti), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_off =
      IconData(0xe1db, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_pause] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_pause] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, desktop, video, movie, film, suspend, hibernate, boot, virtual machine, vm.
  /// - It belongs to the connectivity, devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_pause =
      IconData(0xe488, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_play] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_play] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, desktop, video, movie, film, running, start, boot, virtual machine, vm.
  /// - It belongs to the connectivity, devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_play =
      IconData(0xe489, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_smartphone] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_smartphone] icon is a graphical symbol that conveys a specific idea or functionality related to smartphone, phone, cellphone, device, mobile, desktop, monitor, responsive, screens.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/badraxas](https://github.com/badraxas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_smartphone =
      IconData(0xe3a5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_speaker] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_speaker] icon is a graphical symbol that conveys a specific idea or functionality related to devices, connect, cast.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_speaker =
      IconData(0xe20f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_stop] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_stop] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, desktop, video, movie, film, stop, shutdown, virtual machine, vm.
  /// - It belongs to the connectivity, devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_stop =
      IconData(0xe48a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_up] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, upload, connect, remote, screen share.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_up =
      IconData(0xe426, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [monitor_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [monitor_x] icon is a graphical symbol that conveys a specific idea or functionality related to tv, screen, display, desktop, virtual machine, vm, close, stop, suspend, remove, delete.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData monitor_x =
      IconData(0xe48b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [moon] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [moon] icon is a graphical symbol that conveys a specific idea or functionality related to dark, night.
  /// - It belongs to the accessibility categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData moon =
      IconData(0xe121, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [moon_star] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [moon_star] icon is a graphical symbol that conveys a specific idea or functionality related to dark, night, star.
  /// - It belongs to the accessibility, weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData moon_star =
      IconData(0xe414, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mountain] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mountain] icon is a graphical symbol that conveys a specific idea or functionality related to climb, hike, rock.
  /// - It belongs to the nature, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kerkeslager](https://github.com/kerkeslager), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mountain =
      IconData(0xe230, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mountain_snow] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mountain_snow] icon is a graphical symbol that conveys a specific idea or functionality related to alpine, climb, snow.
  /// - It belongs to the nature categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kerkeslager](https://github.com/kerkeslager), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mountain_snow =
      IconData(0xe231, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mouse] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mouse] icon is a graphical symbol that conveys a specific idea or functionality related to device, scroll, click.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mouse =
      IconData(0xe28d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mouse_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mouse_off] icon is a graphical symbol that conveys a specific idea or functionality related to device, scroll, click, disabled.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mouse_off =
      IconData(0xe5df, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mouse_pointer] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mouse_pointer] icon is a graphical symbol that conveys a specific idea or functionality related to click, select.
  /// - It belongs to the arrows, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ashygee](https://github.com/ashygee), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mouse_pointer =
      IconData(0xe122, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mouse_pointer_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mouse_pointer_2] icon is a graphical symbol that conveys a specific idea or functionality related to click, select.
  /// - It belongs to the arrows, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mouse_pointer_2 =
      IconData(0xe1c2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mouse_pointer_ban] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mouse_pointer_ban] icon is a graphical symbol that conveys a specific idea or functionality related to wait, busy, loading, blocked, frozen, freeze.
  /// - It belongs to the arrows, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mouse_pointer_ban =
      IconData(0xe5eb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [mouse_pointer_click] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [mouse_pointer_click] icon is a graphical symbol that conveys a specific idea or functionality related to click, select.
  /// - It belongs to the arrows, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData mouse_pointer_click =
      IconData(0xe123, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move] icon is a graphical symbol that conveys a specific idea or functionality related to arrows.
  /// - It belongs to the arrows, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move =
      IconData(0xe124, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_3d] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_3d] icon is a graphical symbol that conveys a specific idea or functionality related to arrows, axis, gizmo, coordinates, transform, translate.
  /// - It belongs to the design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_3d =
      IconData(0xe2e4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_diagonal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_diagonal] icon is a graphical symbol that conveys a specific idea or functionality related to double, arrow.
  /// - It belongs to the arrows, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_diagonal =
      IconData(0xe1c3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_diagonal_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_diagonal_2] icon is a graphical symbol that conveys a specific idea or functionality related to double, arrow.
  /// - It belongs to the arrows, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_diagonal_2 =
      IconData(0xe1c4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_down] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_down] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, direction, downwards, south.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_down =
      IconData(0xe490, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_down_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_down_left] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, direction.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/siarie](https://github.com/siarie), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_down_left =
      IconData(0xe491, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_down_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_down_right] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, direction.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_down_right =
      IconData(0xe492, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to double, arrow.
  /// - It belongs to the arrows, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_horizontal =
      IconData(0xe1c5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_left] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, direction, back, west.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_left =
      IconData(0xe493, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_right] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, direction, trend flat, east.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_right =
      IconData(0xe494, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_up] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_up] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, direction, upwards, north.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_up =
      IconData(0xe495, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_up_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_up_left] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, direction.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_up_left =
      IconData(0xe496, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_up_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_up_right] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, direction.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_up_right =
      IconData(0xe497, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [move_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [move_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to double, arrow.
  /// - It belongs to the arrows, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData move_vertical =
      IconData(0xe1c6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [music] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [music] icon is a graphical symbol that conveys a specific idea or functionality related to note, quaver, eighth note.
  /// - It belongs to the multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData music =
      IconData(0xe125, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [music_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [music_2] icon is a graphical symbol that conveys a specific idea or functionality related to quaver, eighth note, note.
  /// - It belongs to the multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData music_2 =
      IconData(0xe34d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [music_3] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [music_3] icon is a graphical symbol that conveys a specific idea or functionality related to crotchet, minim, quarter note, half note, note.
  /// - It belongs to the multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData music_3 =
      IconData(0xe34e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [music_4] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [music_4] icon is a graphical symbol that conveys a specific idea or functionality related to semiquaver, sixteenth note, note.
  /// - It belongs to the multimedia, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData music_4 =
      IconData(0xe34f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [navigation] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [navigation] icon is a graphical symbol that conveys a specific idea or functionality related to location, travel.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData navigation =
      IconData(0xe126, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [navigation_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [navigation_2] icon is a graphical symbol that conveys a specific idea or functionality related to location, travel.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData navigation_2 =
      IconData(0xe127, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [navigation_2_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [navigation_2_off] icon is a graphical symbol that conveys a specific idea or functionality related to location, travel.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData navigation_2_off =
      IconData(0xe2a6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [navigation_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [navigation_off] icon is a graphical symbol that conveys a specific idea or functionality related to location, travel.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData navigation_off =
      IconData(0xe2a7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [network] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [network] icon is a graphical symbol that conveys a specific idea or functionality related to tree.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData network =
      IconData(0xe128, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [newspaper] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [newspaper] icon is a graphical symbol that conveys a specific idea or functionality related to news, feed, home, magazine, article, headline.
  /// - It belongs to the multimedia, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData newspaper =
      IconData(0xe34b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [nfc] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [nfc] icon is a graphical symbol that conveys a specific idea or functionality related to contactless, payment, near-field communication.
  /// - It belongs to the communication, finance, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData nfc =
      IconData(0xe3c6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [notebook] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [notebook] icon is a graphical symbol that conveys a specific idea or functionality related to notepad, notes, stationery, sketchbook, moleskine, closure, strap, band, elastic, organizer, organiser, planner, diary, journal, writing, written, writer, reading, high school, university, college, academy, student, study, homework, research.
  /// - It belongs to the text, communication, social, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData notebook =
      IconData(0xe599, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [notebook_pen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [notebook_pen] icon is a graphical symbol that conveys a specific idea or functionality related to pencil, notepad, notes, noted, stationery, sketchbook, organizer, organiser, planner, diary, journal, writing, write, written, reading, high school, university, college, academy, student, study, research, homework, eraser, rubber.
  /// - It belongs to the text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData notebook_pen =
      IconData(0xe59a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [notebook_tabs] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [notebook_tabs] icon is a graphical symbol that conveys a specific idea or functionality related to notepad, notes, people, family, friends, acquaintances, contacts, details, addresses, phone numbers, directory, listing, networking, alphabetical, a-z, organizer, organiser, planner, diary, stationery.
  /// - It belongs to the account, communication, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData notebook_tabs =
      IconData(0xe59b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [notebook_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [notebook_text] icon is a graphical symbol that conveys a specific idea or functionality related to notepad, notes, pages, paper, stationery, sketchbook, organizer, organiser, planner, diary, journal, writing, write, written, reading, high school, university, college, academy, student, study, research, homework, lines, opened.
  /// - It belongs to the text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData notebook_text =
      IconData(0xe59c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [notepad_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [notepad_text] icon is a graphical symbol that conveys a specific idea or functionality related to notebook, notes, pages, paper, stationery, sketchbook, organizer, organiser, planner, diary, journal, writing, write, written, reading, high school, university, college, academy, student, study, homework, research, lines, opened.
  /// - It belongs to the text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData notepad_text =
      IconData(0xe59d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [notepad_text_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [notepad_text_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to notebook, notes, pages, paper, stationery, diary, journal, writing, write, written, draft, template, lines.
  /// - It belongs to the text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData notepad_text_dashed =
      IconData(0xe59e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [nut] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [nut] icon is a graphical symbol that conveys a specific idea or functionality related to hazelnut, acorn, food, diet.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData nut =
      IconData(0xe39e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [nut_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [nut_off] icon is a graphical symbol that conveys a specific idea or functionality related to hazelnut, acorn, food, allergy, intolerance, diet.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData nut_off =
      IconData(0xe39f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [octagon] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [octagon] icon is a graphical symbol that conveys a specific idea or functionality related to stop, shape.
  /// - It belongs to the shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData octagon =
      IconData(0xe129, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [octagon_alert] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [octagon_alert] icon is a graphical symbol that conveys a specific idea or functionality related to warning, alert, danger, exclamation mark.
  /// - It belongs to the notifications, shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData octagon_alert =
      IconData(0xe12a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [octagon_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [octagon_minus] icon is a graphical symbol that conveys a specific idea or functionality related to stop, forbidden, subtract, remove, decrease, reduce, -, traffic, halt, restricted.
  /// - It belongs to the transportation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData octagon_minus =
      IconData(0xe62b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [octagon_pause] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [octagon_pause] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, stop.
  /// - It belongs to the multimedia, shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData octagon_pause =
      IconData(0xe21a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [octagon_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [octagon_x] icon is a graphical symbol that conveys a specific idea or functionality related to delete, stop, alert, warning, times, clear, math.
  /// - It belongs to the math, notifications categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData octagon_x =
      IconData(0xe12b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [omega] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [omega] icon is a graphical symbol that conveys a specific idea or functionality related to greek, symbol, mathematics, education, physics, engineering, ohms, electrical resistance, angular frequency, dynamical systems, astronomy, constellations, philosophy.
  /// - It belongs to the math, development, text, science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData omega =
      IconData(0xe61d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [option] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [option] icon is a graphical symbol that conveys a specific idea or functionality related to keyboard, key, mac, alt, button.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData option =
      IconData(0xe1f7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [orbit] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [orbit] icon is a graphical symbol that conveys a specific idea or functionality related to planet, space, physics, satellites, moons.
  /// - It belongs to the science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData orbit =
      IconData(0xe3ea, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [origami] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [origami] icon is a graphical symbol that conveys a specific idea or functionality related to paper, bird.
  /// - It belongs to the animals, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/gurtt](https://github.com/gurtt) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData origami =
      IconData(0xe5e7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [package] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [package] icon is a graphical symbol that conveys a specific idea or functionality related to box, container, storage, sealed, delivery, undelivered, unopened, packed, archive, zip, module.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData package =
      IconData(0xe12c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [package_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [package_2] icon is a graphical symbol that conveys a specific idea or functionality related to box, container, storage, sealed, packed, unopened, undelivered, archive, zip.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData package_2 =
      IconData(0xe343, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [package_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [package_check] icon is a graphical symbol that conveys a specific idea or functionality related to confirm, verified, done, todo, tick, complete, task, delivered.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Reund0](https://github.com/Reund0), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData package_check =
      IconData(0xe265, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [package_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [package_minus] icon is a graphical symbol that conveys a specific idea or functionality related to delete, remove.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Reund0](https://github.com/Reund0), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData package_minus =
      IconData(0xe266, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [package_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [package_open] icon is a graphical symbol that conveys a specific idea or functionality related to box, container, storage, unpack, unarchive, unzip, opened, delivered.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData package_open =
      IconData(0xe2cb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [package_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [package_plus] icon is a graphical symbol that conveys a specific idea or functionality related to new, add, create.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Reund0](https://github.com/Reund0), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData package_plus =
      IconData(0xe267, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [package_search] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [package_search] icon is a graphical symbol that conveys a specific idea or functionality related to find, product process.
  /// - It belongs to the files, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Reund0](https://github.com/Reund0), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData package_search =
      IconData(0xe268, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [package_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [package_x] icon is a graphical symbol that conveys a specific idea or functionality related to delete, remove.
  /// - It belongs to the development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Reund0](https://github.com/Reund0), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData package_x =
      IconData(0xe269, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [paint_bucket] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [paint_bucket] icon is a graphical symbol that conveys a specific idea or functionality related to fill, paint, bucket, color, colour.
  /// - It belongs to the design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData paint_bucket =
      IconData(0xe2e5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [paint_roller] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [paint_roller] icon is a graphical symbol that conveys a specific idea or functionality related to brush, color, colour, decoration, diy.
  /// - It belongs to the text, design, home, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData paint_roller =
      IconData(0xe5a2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [paintbrush] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [paintbrush] icon is a graphical symbol that conveys a specific idea or functionality related to brush, paintbrush, design, color, colour, decoration, diy.
  /// - It belongs to the text, design, photography, home, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData paintbrush =
      IconData(0xe2e6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [paintbrush_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [paintbrush_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to brush, paintbrush, design, color, colour, decoration, diy.
  /// - It belongs to the text, design, photography, home, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData paintbrush_vertical =
      IconData(0xe2e7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [palette] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [palette] icon is a graphical symbol that conveys a specific idea or functionality related to colors, colours, theme, scheme, paint, watercolor, watercolour, artist.
  /// - It belongs to the text, design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData palette =
      IconData(0xe1dc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_bottom] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_bottom] icon is a graphical symbol that conveys a specific idea or functionality related to drawer, dock.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_bottom =
      IconData(0xe430, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_bottom_close] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_bottom_close] icon is a graphical symbol that conveys a specific idea or functionality related to drawer, dock, hide, chevron, down.
  /// - It belongs to the layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_bottom_close =
      IconData(0xe431, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_bottom_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_bottom_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to drawer, dock, show, reveal.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_bottom_dashed =
      IconData(0xe432, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_bottom_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_bottom_open] icon is a graphical symbol that conveys a specific idea or functionality related to drawer, dock, show, reveal, chevron, up.
  /// - It belongs to the layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_bottom_open =
      IconData(0xe433, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_left] icon is a graphical symbol that conveys a specific idea or functionality related to primary, drawer.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_left =
      IconData(0xe12d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_left_close] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_left_close] icon is a graphical symbol that conveys a specific idea or functionality related to primary, drawer, hide, chevron, <.
  /// - It belongs to the layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_left_close =
      IconData(0xe21b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_left_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_left_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to sidebar, primary, drawer, show, reveal.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_left_dashed =
      IconData(0xe434, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_left_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_left_open] icon is a graphical symbol that conveys a specific idea or functionality related to primary, drawer, show, reveal, chevron, right, >.
  /// - It belongs to the layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_left_open =
      IconData(0xe21c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_right] icon is a graphical symbol that conveys a specific idea or functionality related to sidebar, secondary, drawer.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_right =
      IconData(0xe435, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_right_close] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_right_close] icon is a graphical symbol that conveys a specific idea or functionality related to sidebar, secondary, drawer, hide, chevron, >.
  /// - It belongs to the layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_right_close =
      IconData(0xe436, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_right_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_right_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to sidebar, secondary, drawer, show, reveal.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_right_dashed =
      IconData(0xe437, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_right_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_right_open] icon is a graphical symbol that conveys a specific idea or functionality related to sidebar, secondary, drawer, show, reveal, chevron, left, <.
  /// - It belongs to the layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_right_open =
      IconData(0xe438, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_top] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_top] icon is a graphical symbol that conveys a specific idea or functionality related to drawer, browser, webpage.
  /// - It belongs to the layout, design, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_top =
      IconData(0xe439, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_top_close] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_top_close] icon is a graphical symbol that conveys a specific idea or functionality related to menu bar, drawer, hide, chevron, up.
  /// - It belongs to the layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_top_close =
      IconData(0xe43a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_top_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_top_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to menu bar, drawer, show, reveal.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_top_dashed =
      IconData(0xe43b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panel_top_open] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panel_top_open] icon is a graphical symbol that conveys a specific idea or functionality related to menu bar, drawer, show, reveal, chevron, down.
  /// - It belongs to the layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panel_top_open =
      IconData(0xe43c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panels_left_bottom] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panels_left_bottom] icon is a graphical symbol that conveys a specific idea or functionality related to drawers, sidebar, primary.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panels_left_bottom =
      IconData(0xe12e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panels_right_bottom] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panels_right_bottom] icon is a graphical symbol that conveys a specific idea or functionality related to drawers, sidebar, secondary.
  /// - It belongs to the layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panels_right_bottom =
      IconData(0xe58c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [panels_top_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [panels_top_left] icon is a graphical symbol that conveys a specific idea or functionality related to menu bar, sidebar, primary, drawers, window, webpage, projects, overview.
  /// - It belongs to the layout, design, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData panels_top_left =
      IconData(0xe12f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [paperclip] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [paperclip] icon is a graphical symbol that conveys a specific idea or functionality related to attachment, file.
  /// - It belongs to the text, design, files, mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData paperclip =
      IconData(0xe130, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [parentheses] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [parentheses] icon is a graphical symbol that conveys a specific idea or functionality related to code, token, parenthesis, parens, brackets, parameters, arguments, args, input, call, math, formula, function, (, ).
  /// - It belongs to the development, files, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData parentheses =
      IconData(0xe448, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [parking_meter] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [parking_meter] icon is a graphical symbol that conveys a specific idea or functionality related to driving, car park, pay, sidewalk, pavement.
  /// - It belongs to the transportation, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData parking_meter =
      IconData(0xe504, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [party_popper] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [party_popper] icon is a graphical symbol that conveys a specific idea or functionality related to emoji, congratulations, celebration, party, tada, 🎉, 🎊, excitement, exciting, excites, confetti.
  /// - It belongs to the emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData party_popper =
      IconData(0xe346, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pause] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pause] icon is a graphical symbol that conveys a specific idea or functionality related to music, stop.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pause =
      IconData(0xe131, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [paw_print] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [paw_print] icon is a graphical symbol that conveys a specific idea or functionality related to pets, vets, veterinarian, domesticated, cat, dog, bear.
  /// - It belongs to the animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData paw_print =
      IconData(0xe4f9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pc_case] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pc_case] icon is a graphical symbol that conveys a specific idea or functionality related to computer, chassis.
  /// - It belongs to the devices, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pc_case =
      IconData(0xe44a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pen] icon is a graphical symbol that conveys a specific idea or functionality related to pencil, change, create, draw, writer, writing, biro, ink, marker, felt tip, stationery, artist.
  /// - It belongs to the text, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pen =
      IconData(0xe132, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pen_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pen_line] icon is a graphical symbol that conveys a specific idea or functionality related to pencil, change, create, draw, writer, writing, biro, ink, marker, felt tip, stationery, artist.
  /// - It belongs to the text, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pen_line =
      IconData(0xe133, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pen_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pen_off] icon is a graphical symbol that conveys a specific idea or functionality related to disabled, inactive, non-editable, locked, read-only, unmodifiable, frozen, restricted, pencil, change, create, draw, writer, writing, biro, ink, marker, felt tip, stationery, artist.
  /// - It belongs to the text, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pen_off =
      IconData(0xe5f2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pen_tool] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pen_tool] icon is a graphical symbol that conveys a specific idea or functionality related to vector, drawing, path.
  /// - It belongs to the text, design, cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ashygee](https://github.com/ashygee), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pen_tool =
      IconData(0xe134, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pencil] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pencil] icon is a graphical symbol that conveys a specific idea or functionality related to rubber, edit, create, draw, sketch, draft, writer, writing, stationery, artist.
  /// - It belongs to the design, cursors, tools, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pencil =
      IconData(0xe1f8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pencil_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pencil_line] icon is a graphical symbol that conveys a specific idea or functionality related to pencil, change, create, draw, sketch, draft, writer, writing, biro, ink, marker, felt tip, stationery, artist.
  /// - It belongs to the text, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pencil_line =
      IconData(0xe4f4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pencil_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pencil_off] icon is a graphical symbol that conveys a specific idea or functionality related to disabled, inactive, non-editable, locked, read-only, unmodifiable, frozen, restricted, rubber, edit, create, draw, sketch, draft, writer, writing, stationery, artist.
  /// - It belongs to the design, cursors, tools, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pencil_off =
      IconData(0xe5f3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pencil_ruler] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pencil_ruler] icon is a graphical symbol that conveys a specific idea or functionality related to edit, create, draw, sketch, draft, writer, writing, stationery, artist, measurements, centimeters, cm, millimeters, mm, metre, foot, feet, inches, units, size, length, width, height, dimensions, depth, breadth, extent.
  /// - It belongs to the tools, design, layout, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pencil_ruler =
      IconData(0xe4f5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pentagon] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pentagon] icon is a graphical symbol that conveys a specific idea or functionality related to shape.
  /// - It belongs to the shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pentagon =
      IconData(0xe52f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [percent] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [percent] icon is a graphical symbol that conveys a specific idea or functionality related to percentage, modulo, modulus, remainder, %, sale, discount, offer, marketing.
  /// - It belongs to the math, development, finance, shopping categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData percent =
      IconData(0xe135, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [person_standing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [person_standing] icon is a graphical symbol that conveys a specific idea or functionality related to people, human, accessibility, stick figure.
  /// - It belongs to the accessibility, people categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData person_standing =
      IconData(0xe21d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [philippine_peso] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [philippine_peso] icon is a graphical symbol that conveys a specific idea or functionality related to currency, peso, money, php.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/kasutu](https://github.com/kasutu), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData philippine_peso =
      IconData(0xe608, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [phone] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [phone] icon is a graphical symbol that conveys a specific idea or functionality related to call.
  /// - It belongs to the text, connectivity, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData phone =
      IconData(0xe136, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [phone_call] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [phone_call] icon is a graphical symbol that conveys a specific idea or functionality related to ring.
  /// - It belongs to the connectivity, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData phone_call =
      IconData(0xe137, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [phone_forwarded] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [phone_forwarded] icon is a graphical symbol that conveys a specific idea or functionality related to call.
  /// - It belongs to the arrows, connectivity, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData phone_forwarded =
      IconData(0xe138, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [phone_incoming] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [phone_incoming] icon is a graphical symbol that conveys a specific idea or functionality related to call.
  /// - It belongs to the arrows, connectivity, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData phone_incoming =
      IconData(0xe139, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [phone_missed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [phone_missed] icon is a graphical symbol that conveys a specific idea or functionality related to call.
  /// - It belongs to the connectivity, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData phone_missed =
      IconData(0xe13a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [phone_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [phone_off] icon is a graphical symbol that conveys a specific idea or functionality related to call, mute.
  /// - It belongs to the connectivity, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData phone_off =
      IconData(0xe13b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [phone_outgoing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [phone_outgoing] icon is a graphical symbol that conveys a specific idea or functionality related to call.
  /// - It belongs to the arrows, connectivity, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData phone_outgoing =
      IconData(0xe13c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pi] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pi] icon is a graphical symbol that conveys a specific idea or functionality related to constant, code, coding, programming, symbol, trigonometry, geometry, formula.
  /// - It belongs to the development, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pi =
      IconData(0xe476, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [piano] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [piano] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, sound, noise, notes, chord, keys, octave, acoustic, instrument, play, pianist, performance, concert.
  /// - It belongs to the multimedia, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData piano =
      IconData(0xe565, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pickaxe] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pickaxe] icon is a graphical symbol that conveys a specific idea or functionality related to mining, mine, land worker, extraction, labor, construction, progress, advancement, crafting, building, creation.
  /// - It belongs to the tools, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pickaxe =
      IconData(0xe5ca, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [picture_in_picture] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [picture_in_picture] icon is a graphical symbol that conveys a specific idea or functionality related to display, play, video, pop out, always on top, window, inset, multitask.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/cd16b](https://github.com/cd16b), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData picture_in_picture =
      IconData(0xe3b1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [picture_in_picture_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [picture_in_picture_2] icon is a graphical symbol that conveys a specific idea or functionality related to display, play, video, pop out, always on top, window, inset, multitask.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/cd16b](https://github.com/cd16b), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData picture_in_picture_2 =
      IconData(0xe3b2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [piggy_bank] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [piggy_bank] icon is a graphical symbol that conveys a specific idea or functionality related to money, savings.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData piggy_bank =
      IconData(0xe13d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pilcrow] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pilcrow] icon is a graphical symbol that conveys a specific idea or functionality related to paragraph, mark, paraph, blind, typography, type, text, prose, symbol.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pilcrow =
      IconData(0xe3a6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pilcrow_left] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pilcrow_left] icon is a graphical symbol that conveys a specific idea or functionality related to direction, paragraph, mark, paraph, blind, typography, type, text, prose, symbol.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/zaaakher](https://github.com/zaaakher), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pilcrow_left =
      IconData(0xe5e0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pilcrow_right] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pilcrow_right] icon is a graphical symbol that conveys a specific idea or functionality related to direction, paragraph, mark, paraph, blind, typography, type, text, prose, symbol.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/zaaakher](https://github.com/zaaakher), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jonas-hoebenreich](https://github.com/jonas-hoebenreich) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pilcrow_right =
      IconData(0xe5e1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pill] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pill] icon is a graphical symbol that conveys a specific idea or functionality related to medicine, medication, drug, prescription, tablet, pharmacy.
  /// - It belongs to the medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/it-is-not](https://github.com/it-is-not) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pill =
      IconData(0xe3c0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pill_bottle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pill_bottle] icon is a graphical symbol that conveys a specific idea or functionality related to medicine, medication, prescription, drug, supplement, vitamin, capsule, jar, container, healthcare, pharmaceutical, tablet.
  /// - It belongs to the medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pill_bottle =
      IconData(0xe5ee, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pin] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pin] icon is a graphical symbol that conveys a specific idea or functionality related to save, map, lock, fix.
  /// - It belongs to the navigation, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pin =
      IconData(0xe258, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pin_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pin_off] icon is a graphical symbol that conveys a specific idea or functionality related to unpin, map, unlock, unfix, unsave, remove.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pin_off =
      IconData(0xe2b5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pipette] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pipette] icon is a graphical symbol that conveys a specific idea or functionality related to eye dropper, color picker, lab, chemistry.
  /// - It belongs to the text, design, science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pipette =
      IconData(0xe13e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pizza] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pizza] icon is a graphical symbol that conveys a specific idea or functionality related to pie, quiche, food.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/jamiemlaw](https://github.com/jamiemlaw) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pizza =
      IconData(0xe357, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [plane] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [plane] icon is a graphical symbol that conveys a specific idea or functionality related to plane, trip, airplane.
  /// - It belongs to the transportation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ahtohbi4](https://github.com/ahtohbi4), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData plane =
      IconData(0xe1dd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [plane_landing] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [plane_landing] icon is a graphical symbol that conveys a specific idea or functionality related to arrival, plane, trip, airplane, landing.
  /// - It belongs to the transportation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/it-is-not](https://github.com/it-is-not) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData plane_landing =
      IconData(0xe3d0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [plane_takeoff] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [plane_takeoff] icon is a graphical symbol that conveys a specific idea or functionality related to departure, plane, trip, airplane, takeoff.
  /// - It belongs to the transportation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/it-is-not](https://github.com/it-is-not) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData plane_takeoff =
      IconData(0xe3d1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [play] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [play] icon is a graphical symbol that conveys a specific idea or functionality related to music, audio, video, start, run.
  /// - It belongs to the arrows, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData play =
      IconData(0xe13f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [plug] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [plug] icon is a graphical symbol that conveys a specific idea or functionality related to electricity, energy, electronics, socket, outlet.
  /// - It belongs to the devices, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData plug =
      IconData(0xe382, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [plug_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [plug_2] icon is a graphical symbol that conveys a specific idea or functionality related to electricity, energy, socket, outlet.
  /// - It belongs to the devices, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData plug_2 =
      IconData(0xe383, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [plug_zap] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [plug_zap] icon is a graphical symbol that conveys a specific idea or functionality related to electricity, energy, electronics, charge, charging, battery, connect.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData plug_zap =
      IconData(0xe460, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [plus] icon is a graphical symbol that conveys a specific idea or functionality related to add, new, increase, increment, positive, calculate, toolbar, crosshair, aim, target, scope, sight, reticule, maximum, upgrade, extra, +.
  /// - It belongs to the math, tools, development, text, cursors, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData plus =
      IconData(0xe140, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pocket] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pocket] icon is a graphical symbol that conveys a specific idea or functionality related to logo, save.
  /// - It belongs to the brands categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pocket =
      IconData(0xe141, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pocket_knife] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pocket_knife] icon is a graphical symbol that conveys a specific idea or functionality related to swiss army knife, penknife, multi-tool, multitask, blade, cutter, gadget, corkscrew.
  /// - It belongs to the tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pocket_knife =
      IconData(0xe4a4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [podcast] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [podcast] icon is a graphical symbol that conveys a specific idea or functionality related to audio, music, mic, talk, voice, subscribe, subscription, stream.
  /// - It belongs to the multimedia, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/iiaishwarya](https://github.com/iiaishwarya), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData podcast =
      IconData(0xe1f9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pointer] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pointer] icon is a graphical symbol that conveys a specific idea or functionality related to mouse.
  /// - It belongs to the cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pointer =
      IconData(0xe1e7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pointer_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pointer_off] icon is a graphical symbol that conveys a specific idea or functionality related to mouse.
  /// - It belongs to the cursors categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pointer_off =
      IconData(0xe583, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [popcorn] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [popcorn] icon is a graphical symbol that conveys a specific idea or functionality related to cinema, movies, films, salted, sweet, sugar, candy, snack.
  /// - It belongs to the food-beverage, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData popcorn =
      IconData(0xe4c2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [popsicle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [popsicle] icon is a graphical symbol that conveys a specific idea or functionality related to ice lolly, ice cream, sweet, food.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData popsicle =
      IconData(0xe4c3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pound_sterling] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pound_sterling] icon is a graphical symbol that conveys a specific idea or functionality related to currency, money, payment.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pound_sterling =
      IconData(0xe142, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [power] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [power] icon is a graphical symbol that conveys a specific idea or functionality related to on, off, device, switch, toggle, binary, boolean, reboot, restart, button, keyboard, troubleshoot.
  /// - It belongs to the connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData power =
      IconData(0xe143, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [power_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [power_off] icon is a graphical symbol that conveys a specific idea or functionality related to on, off, device, switch.
  /// - It belongs to the connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData power_off =
      IconData(0xe208, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [presentation] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [presentation] icon is a graphical symbol that conveys a specific idea or functionality related to screen, whiteboard, marker pens, markers, blackboard, chalk, easel, school, learning, lesson, office, meeting, project, planning.
  /// - It belongs to the multimedia, photography, devices, communication, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData presentation =
      IconData(0xe4b2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [printer] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [printer] icon is a graphical symbol that conveys a specific idea or functionality related to fax, office, device.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData printer =
      IconData(0xe144, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [printer_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [printer_check] icon is a graphical symbol that conveys a specific idea or functionality related to fax, office, device, success, printed.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData printer_check =
      IconData(0xe5f9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [projector] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [projector] icon is a graphical symbol that conveys a specific idea or functionality related to cinema, film, movie, home video, presentation, slideshow, office, meeting, project, planning.
  /// - It belongs to the multimedia, photography, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData projector =
      IconData(0xe4b3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [proportions] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [proportions] icon is a graphical symbol that conveys a specific idea or functionality related to screens, sizes, rotate, rotation, adjust, aspect ratio, 16:9, widescreen, 4:3, resolution, responsive, mobile, desktop, dimensions, monitor, orientation, portrait, landscape.
  /// - It belongs to the layout, design, photography, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData proportions =
      IconData(0xe5d3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [puzzle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [puzzle] icon is a graphical symbol that conveys a specific idea or functionality related to component, module, part, piece.
  /// - It belongs to the development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jamiemlaw](https://github.com/jamiemlaw) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData puzzle =
      IconData(0xe29b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [pyramid] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [pyramid] icon is a graphical symbol that conveys a specific idea or functionality related to prism, triangle, triangular, hierarchy, structure, geometry, ancient, egyptian, landmark, tourism.
  /// - It belongs to the shapes, math, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData pyramid =
      IconData(0xe530, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [qr_code] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [qr_code] icon is a graphical symbol that conveys a specific idea or functionality related to barcode, scan, link, url, information, digital.
  /// - It belongs to the development, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData qr_code =
      IconData(0xe1de, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [quote] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [quote] icon is a graphical symbol that conveys a specific idea or functionality related to quotation.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Billiam](https://github.com/Billiam), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData quote =
      IconData(0xe238, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rabbit] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rabbit] icon is a graphical symbol that conveys a specific idea or functionality related to animal, rodent, pet, pest, bunny, hare, fast, speed, hop.
  /// - It belongs to the animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rabbit =
      IconData(0xe4fa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [radar] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [radar] icon is a graphical symbol that conveys a specific idea or functionality related to scan, sonar, detect, find, locate.
  /// - It belongs to the navigation, security, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData radar =
      IconData(0xe49b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [radiation] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [radiation] icon is a graphical symbol that conveys a specific idea or functionality related to radioactive, nuclear, fallout, waste, atomic, physics, particle, element, molecule.
  /// - It belongs to the science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData radiation =
      IconData(0xe446, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [radical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [radical] icon is a graphical symbol that conveys a specific idea or functionality related to calculate, formula, math, operator, root, square, symbol.
  /// - It belongs to the development, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/smnandre](https://github.com/smnandre), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData radical =
      IconData(0xe5c6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [radio] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [radio] icon is a graphical symbol that conveys a specific idea or functionality related to signal, broadcast, connectivity, live, frequency.
  /// - It belongs to the devices, multimedia, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData radio =
      IconData(0xe145, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [radio_receiver] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [radio_receiver] icon is a graphical symbol that conveys a specific idea or functionality related to device, music, connect.
  /// - It belongs to the devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData radio_receiver =
      IconData(0xe1fa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [radio_tower] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [radio_tower] icon is a graphical symbol that conveys a specific idea or functionality related to signal, broadcast, connectivity, live, frequency.
  /// - It belongs to the devices, multimedia, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData radio_tower =
      IconData(0xe408, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [radius] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [radius] icon is a graphical symbol that conveys a specific idea or functionality related to shape, circle, geometry, trigonometry, radii, calculate, measure, size.
  /// - It belongs to the shapes, math, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData radius =
      IconData(0xe531, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rail_symbol] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rail_symbol] icon is a graphical symbol that conveys a specific idea or functionality related to railway, train, track, line.
  /// - It belongs to the transportation, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rail_symbol =
      IconData(0xe505, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rainbow] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rainbow] icon is a graphical symbol that conveys a specific idea or functionality related to colors, colours, spectrum, light, prism, arc, clear, sunshine.
  /// - It belongs to the weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rainbow =
      IconData(0xe4c6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rat] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rat] icon is a graphical symbol that conveys a specific idea or functionality related to mouse, mice, gerbil, rodent, pet, pest, plague, disease.
  /// - It belongs to the animals categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/henri42](https://github.com/henri42), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rat =
      IconData(0xe3ef, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ratio] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ratio] icon is a graphical symbol that conveys a specific idea or functionality related to screens, sizes, rotate, rotation, adjust, aspect ratio, proportions, 16:9, widescreen, 4:3, resolution, responsive, mobile, desktop, dimensions, monitor, orientation, portrait, landscape.
  /// - It belongs to the layout, design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ratio =
      IconData(0xe4ec, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [receipt] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [receipt] icon is a graphical symbol that conveys a specific idea or functionality related to bill, voucher, slip, check, counterfoil, currency, dollar, usd, $.
  /// - It belongs to the finance, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData receipt =
      IconData(0xe3d6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [receipt_cent] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [receipt_cent] icon is a graphical symbol that conveys a specific idea or functionality related to bill, voucher, slip, check, counterfoil, currency, cents, dollar, usd, $, ¢.
  /// - It belongs to the finance, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData receipt_cent =
      IconData(0xe5a9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [receipt_euro] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [receipt_euro] icon is a graphical symbol that conveys a specific idea or functionality related to bill, voucher, slip, check, counterfoil, currency, €.
  /// - It belongs to the finance, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData receipt_euro =
      IconData(0xe5aa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [receipt_indian_rupee] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [receipt_indian_rupee] icon is a graphical symbol that conveys a specific idea or functionality related to bill, voucher, slip, check, counterfoil, currency, inr, ₹.
  /// - It belongs to the finance, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData receipt_indian_rupee =
      IconData(0xe5ab, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [receipt_japanese_yen] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [receipt_japanese_yen] icon is a graphical symbol that conveys a specific idea or functionality related to bill, voucher, slip, check, counterfoil, currency, jpy, ¥.
  /// - It belongs to the finance, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/it-is-not](https://github.com/it-is-not), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData receipt_japanese_yen =
      IconData(0xe5ac, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [receipt_pound_sterling] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [receipt_pound_sterling] icon is a graphical symbol that conveys a specific idea or functionality related to bill, voucher, slip, check, counterfoil, british, currency, gbp, £.
  /// - It belongs to the finance, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData receipt_pound_sterling =
      IconData(0xe5ad, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [receipt_russian_ruble] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [receipt_russian_ruble] icon is a graphical symbol that conveys a specific idea or functionality related to bill, voucher, slip, check, counterfoil, currency, rub, ₽.
  /// - It belongs to the finance, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData receipt_russian_ruble =
      IconData(0xe5ae, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [receipt_swiss_franc] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [receipt_swiss_franc] icon is a graphical symbol that conveys a specific idea or functionality related to bill, voucher, slip, check, counterfoil, currency, chf, ₣.
  /// - It belongs to the finance, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData receipt_swiss_franc =
      IconData(0xe5af, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [receipt_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [receipt_text] icon is a graphical symbol that conveys a specific idea or functionality related to bill, voucher, slip, check, counterfoil, details, small print, terms, conditions, contract.
  /// - It belongs to the finance, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData receipt_text =
      IconData(0xe5b0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rectangle_ellipsis] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rectangle_ellipsis] icon is a graphical symbol that conveys a specific idea or functionality related to login, password, authenticate, 2fa, field, fill, ellipsis, et cetera, etc, loader, loading, progress, pending, throbber, menu, options, operator, code, spread, rest, more, further, extra, overflow, dots, …, ....
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rectangle_ellipsis =
      IconData(0xe21e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rectangle_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rectangle_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to rectangle, aspect ratio, 16:9, horizontal, shape.
  /// - It belongs to the shapes, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/Reund0](https://github.com/Reund0), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rectangle_horizontal =
      IconData(0xe379, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rectangle_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rectangle_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to rectangle, aspect ratio, 9:16, vertical, shape.
  /// - It belongs to the shapes, design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/Reund0](https://github.com/Reund0), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rectangle_vertical =
      IconData(0xe37a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [recycle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [recycle] icon is a graphical symbol that conveys a specific idea or functionality related to sustainability, salvage, arrows.
  /// - It belongs to the sustainability categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData recycle =
      IconData(0xe2e8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [redo] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [redo] icon is a graphical symbol that conveys a specific idea or functionality related to undo, rerun, history.
  /// - It belongs to the text, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/aelfric](https://github.com/aelfric), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData redo =
      IconData(0xe146, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [redo_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [redo_2] icon is a graphical symbol that conveys a specific idea or functionality related to undo, rerun, history.
  /// - It belongs to the text, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData redo_2 =
      IconData(0xe29f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [redo_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [redo_dot] icon is a graphical symbol that conveys a specific idea or functionality related to redo, history, step, over, forward.
  /// - It belongs to the text, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData redo_dot =
      IconData(0xe454, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [refresh_ccw] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [refresh_ccw] icon is a graphical symbol that conveys a specific idea or functionality related to arrows, rotate, reload, rerun, synchronise, synchronize, circular, cycle.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData refresh_ccw =
      IconData(0xe147, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [refresh_ccw_dot] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [refresh_ccw_dot] icon is a graphical symbol that conveys a specific idea or functionality related to arrows, rotate, reload, synchronise, synchronize, circular, cycle, issue, code, coding, version control.
  /// - It belongs to the arrows, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData refresh_ccw_dot =
      IconData(0xe4b6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [refresh_cw] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [refresh_cw] icon is a graphical symbol that conveys a specific idea or functionality related to rotate, reload, rerun, synchronise, synchronize, arrows, circular, cycle.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData refresh_cw =
      IconData(0xe148, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [refresh_cw_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [refresh_cw_off] icon is a graphical symbol that conveys a specific idea or functionality related to rotate, reload, rerun, synchronise, synchronize, arrows, circular, cycle, cancel, no, stop, error, disconnect, ignore.
  /// - It belongs to the arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData refresh_cw_off =
      IconData(0xe49c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [refrigerator] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [refrigerator] icon is a graphical symbol that conveys a specific idea or functionality related to frigerator, fridge, freezer, cooler, icebox, chiller, cold storage.
  /// - It belongs to the food-beverage, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData refrigerator =
      IconData(0xe37e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [regex] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [regex] icon is a graphical symbol that conveys a specific idea or functionality related to search, text, code.
  /// - It belongs to the text, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData regex =
      IconData(0xe1fb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [remove_formatting] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [remove_formatting] icon is a graphical symbol that conveys a specific idea or functionality related to text, font, typography, format, x, remove, delete, times, clear.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData remove_formatting =
      IconData(0xe3b6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [repeat] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [repeat] icon is a graphical symbol that conveys a specific idea or functionality related to loop, arrows.
  /// - It belongs to the arrows, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData repeat =
      IconData(0xe149, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [repeat_1] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [repeat_1] icon is a graphical symbol that conveys a specific idea or functionality related to replay.
  /// - It belongs to the multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData repeat_1 =
      IconData(0xe1fc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [repeat_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [repeat_2] icon is a graphical symbol that conveys a specific idea or functionality related to arrows, retweet, repost, share, repeat, loop.
  /// - It belongs to the arrows, social, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData repeat_2 =
      IconData(0xe415, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [replace] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [replace] icon is a graphical symbol that conveys a specific idea or functionality related to search, substitute, swap, change.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData replace =
      IconData(0xe3de, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [replace_all] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [replace_all] icon is a graphical symbol that conveys a specific idea or functionality related to search, substitute, swap, change.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData replace_all =
      IconData(0xe3df, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [reply] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [reply] icon is a graphical symbol that conveys a specific idea or functionality related to email.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData reply =
      IconData(0xe229, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [reply_all] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [reply_all] icon is a graphical symbol that conveys a specific idea or functionality related to email.
  /// - It belongs to the mail categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData reply_all =
      IconData(0xe22a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rewind] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rewind] icon is a graphical symbol that conveys a specific idea or functionality related to music.
  /// - It belongs to the arrows, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rewind =
      IconData(0xe14a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ribbon] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ribbon] icon is a graphical symbol that conveys a specific idea or functionality related to awareness, strip, band, tape, strap, cordon.
  /// - It belongs to the social, medical, emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ribbon =
      IconData(0xe55c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rocket] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rocket] icon is a graphical symbol that conveys a specific idea or functionality related to release, boost, launch, space, version.
  /// - It belongs to the gaming, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rocket =
      IconData(0xe285, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rocking_chair] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rocking_chair] icon is a graphical symbol that conveys a specific idea or functionality related to chair, furniture, seat.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/connium](https://github.com/connium), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rocking_chair =
      IconData(0xe232, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [roller_coaster] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [roller_coaster] icon is a graphical symbol that conveys a specific idea or functionality related to attraction, entertainment, amusement park, theme park, funfair.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData roller_coaster =
      IconData(0xe484, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rotate_3d] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rotate_3d] icon is a graphical symbol that conveys a specific idea or functionality related to gizmo, transform, orientation, orbit, axis.
  /// - It belongs to the design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rotate_3d =
      IconData(0xe2e9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rotate_ccw] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rotate_ccw] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, left, counter-clockwise, restart, reload, rerun, refresh, backup, undo, replay, redo, retry, rewind, reverse.
  /// - It belongs to the arrows, design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rotate_ccw =
      IconData(0xe14b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rotate_ccw_square] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rotate_ccw_square] icon is a graphical symbol that conveys a specific idea or functionality related to left, counter-clockwise, rotate, image, 90, 45, degrees, °.
  /// - It belongs to the layout, design, photography, tools, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rotate_ccw_square =
      IconData(0xe5d4, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rotate_cw] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rotate_cw] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, right, clockwise, refresh, reload, rerun, redo.
  /// - It belongs to the arrows, design, photography categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rotate_cw =
      IconData(0xe14c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rotate_cw_square] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rotate_cw_square] icon is a graphical symbol that conveys a specific idea or functionality related to right, clockwise, rotate, image, 90, 45, degrees, °.
  /// - It belongs to the layout, design, photography, tools, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rotate_cw_square =
      IconData(0xe5d5, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [route] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [route] icon is a graphical symbol that conveys a specific idea or functionality related to path, journey, planner, points, stops, stations.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData route =
      IconData(0xe542, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [route_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [route_off] icon is a graphical symbol that conveys a specific idea or functionality related to path, journey, planner, points, stops, stations, reset, clear, cancelled, closed, blocked.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData route_off =
      IconData(0xe543, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [router] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [router] icon is a graphical symbol that conveys a specific idea or functionality related to computer, server, cloud.
  /// - It belongs to the development, devices, connectivity, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/FrancoMaxime](https://github.com/FrancoMaxime), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData router =
      IconData(0xe3c2, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rows_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rows_2] icon is a graphical symbol that conveys a specific idea or functionality related to lines, list, queue, preview, panel, paragraphs, parallel, series, split, vertical, horizontal, half, center, middle, even, drawer.
  /// - It belongs to the layout, design, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rows_2 =
      IconData(0xe43d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rows_3] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rows_3] icon is a graphical symbol that conveys a specific idea or functionality related to lines, list, queue, preview, paragraphs, parallel, series, split, vertical, horizontal, half, center, middle, even, drawers.
  /// - It belongs to the layout, design, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rows_3 =
      IconData(0xe58e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rows_4] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rows_4] icon is a graphical symbol that conveys a specific idea or functionality related to lines, list, queue, preview, paragraphs, parallel, series, split, vertical, horizontal, half, center, middle, even, drawers, grill.
  /// - It belongs to the layout, design, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rows_4 =
      IconData(0xe58f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [rss] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [rss] icon is a graphical symbol that conveys a specific idea or functionality related to feed, subscribe, news, updates, notifications, content, blog, articles, broadcast, syndication, reader, channels, posts, publishing, digest, alert, following, inbox, newsletter, weblog, podcast.
  /// - It belongs to the development, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData rss =
      IconData(0xe14d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ruler] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ruler] icon is a graphical symbol that conveys a specific idea or functionality related to measurements, centimeters, cm, millimeters, mm, metre, foot, feet, inches, units, size, length, width, height, dimensions, depth, breadth, extent, stationery.
  /// - It belongs to the tools, design, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ruler =
      IconData(0xe14e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [russian_ruble] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [russian_ruble] icon is a graphical symbol that conveys a specific idea or functionality related to currency, money, payment.
  /// - It belongs to the finance categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData russian_ruble =
      IconData(0xe14f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [sailboat] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [sailboat] icon is a graphical symbol that conveys a specific idea or functionality related to ship, boat, harbor, harbour, dock.
  /// - It belongs to the transportation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData sailboat =
      IconData(0xe381, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [salad] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [salad] icon is a graphical symbol that conveys a specific idea or functionality related to food, vegetarian, dish, restaurant, course, meal, side, vegetables, health.
  /// - It belongs to the food-beverage, emoji categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kemie](https://github.com/kemie) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData salad =
      IconData(0xe3ab, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [sandwich] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [sandwich] icon is a graphical symbol that conveys a specific idea or functionality related to food, snack, dish, restaurant, lunch, meal.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kemie](https://github.com/kemie), [https://github.com/jamiemlaw](https://github.com/jamiemlaw) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData sandwich =
      IconData(0xe3ac, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [satellite] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [satellite] icon is a graphical symbol that conveys a specific idea or functionality related to space station, orbit, transmitter.
  /// - It belongs to the connectivity, science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData satellite =
      IconData(0xe44b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [satellite_dish] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [satellite_dish] icon is a graphical symbol that conveys a specific idea or functionality related to antenna, receiver, dish aerial, saucer.
  /// - It belongs to the connectivity, devices, multimedia categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData satellite_dish =
      IconData(0xe44c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [save] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [save] icon is a graphical symbol that conveys a specific idea or functionality related to floppy disk.
  /// - It belongs to the text, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData save =
      IconData(0xe150, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [save_all] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [save_all] icon is a graphical symbol that conveys a specific idea or functionality related to floppy disks, copy.
  /// - It belongs to the text, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData save_all =
      IconData(0xe413, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [save_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [save_off] icon is a graphical symbol that conveys a specific idea or functionality related to floppy disk, unsalvageable.
  /// - It belongs to the text, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/AndreasSas](https://github.com/AndreasSas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData save_off =
      IconData(0xe5f7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scale] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scale] icon is a graphical symbol that conveys a specific idea or functionality related to balance, legal, license, right, rule, law.
  /// - It belongs to the navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scale =
      IconData(0xe211, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scale_3d] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scale_3d] icon is a graphical symbol that conveys a specific idea or functionality related to gizmo, transform, size, axis.
  /// - It belongs to the design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scale_3d =
      IconData(0xe2ea, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scaling] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scaling] icon is a graphical symbol that conveys a specific idea or functionality related to scale, resize, design.
  /// - It belongs to the design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scaling =
      IconData(0xe2eb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scan] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scan] icon is a graphical symbol that conveys a specific idea or functionality related to qr-code, barcode, checkout, augmented reality, ar, target, surveillance, camera, lens, focus, frame, select, box, boundary, bounds, area, square, dashed.
  /// - It belongs to the devices, shopping, security, social, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scan =
      IconData(0xe256, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scan_barcode] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scan_barcode] icon is a graphical symbol that conveys a specific idea or functionality related to checkout, till, cart, transaction, purchase, buy, product, packaging, retail, consumer.
  /// - It belongs to the shopping, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scan_barcode =
      IconData(0xe539, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scan_eye] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scan_eye] icon is a graphical symbol that conveys a specific idea or functionality related to preview, zoom, expand, fullscreen, gallery, image, camera, watch, surveillance, retina, focus, lens, biometric, identification, authentication, access, login.
  /// - It belongs to the photography, multimedia, accessibility, security, devices, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scan_eye =
      IconData(0xe53a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scan_face] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scan_face] icon is a graphical symbol that conveys a specific idea or functionality related to face, biometric, identification, authentication, 2fa, access, login, dashed.
  /// - It belongs to the account, security, devices, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scan_face =
      IconData(0xe374, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scan_heart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scan_heart] icon is a graphical symbol that conveys a specific idea or functionality related to health, heart rate, pulse, monitoring, healthiness, screening, dashed.
  /// - It belongs to the medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scan_heart =
      IconData(0xe63e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scan_line] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scan_line] icon is a graphical symbol that conveys a specific idea or functionality related to checkout, till, cart, transaction, purchase, buy, product, packaging, retail, consumer, qr-code, dashed.
  /// - It belongs to the devices, shopping categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scan_line =
      IconData(0xe257, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scan_qr_code] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scan_qr_code] icon is a graphical symbol that conveys a specific idea or functionality related to barcode, scan, qrcode, url, information, digital, scanner.
  /// - It belongs to the account, shopping, devices, security categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/vexkiddy](https://github.com/vexkiddy) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scan_qr_code =
      IconData(0xe5fa, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scan_search] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scan_search] icon is a graphical symbol that conveys a specific idea or functionality related to preview, zoom, expand, fullscreen, gallery, image, focus, lens.
  /// - It belongs to the photography, multimedia, accessibility categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scan_search =
      IconData(0xe53b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scan_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scan_text] icon is a graphical symbol that conveys a specific idea or functionality related to recognition, read, translate, copy, lines.
  /// - It belongs to the text, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scan_text =
      IconData(0xe53c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [school] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [school] icon is a graphical symbol that conveys a specific idea or functionality related to building, education, childhood, university, learning, campus, scholar, student, lecture, degree, course, academia, study, knowledge, classroom, research, diploma, graduation, professor, tutorial, homework, assignment, exam.
  /// - It belongs to the buildings, navigation categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData school =
      IconData(0xe3e6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scissors] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scissors] icon is a graphical symbol that conveys a specific idea or functionality related to cut, snip, chop, stationery, crafts.
  /// - It belongs to the text, design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scissors =
      IconData(0xe151, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scissors_line_dashed] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scissors_line_dashed] icon is a graphical symbol that conveys a specific idea or functionality related to cut here, along, snip, chop, stationery, crafts, instructions, diagram.
  /// - It belongs to the design, tools categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scissors_line_dashed =
      IconData(0xe4ed, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [screen_share] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [screen_share] icon is a graphical symbol that conveys a specific idea or functionality related to host, desktop, monitor.
  /// - It belongs to the connectivity, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData screen_share =
      IconData(0xe152, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [screen_share_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [screen_share_off] icon is a graphical symbol that conveys a specific idea or functionality related to desktop, disconnect, monitor.
  /// - It belongs to the connectivity, devices, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/johnletey](https://github.com/johnletey) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData screen_share_off =
      IconData(0xe153, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scroll] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scroll] icon is a graphical symbol that conveys a specific idea or functionality related to paper, log, scripture, document, notes, parchment, list, long, script, story, code, coding.
  /// - It belongs to the gaming, development, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scroll =
      IconData(0xe2ec, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [scroll_text] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [scroll_text] icon is a graphical symbol that conveys a specific idea or functionality related to paper, log, scripture, document, notes, parchment, list, long, script, story, code, coding.
  /// - It belongs to the gaming, development, text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData scroll_text =
      IconData(0xe463, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [search] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [search] icon is a graphical symbol that conveys a specific idea or functionality related to find, scan, magnifier, magnifying glass.
  /// - It belongs to the text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData search =
      IconData(0xe154, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [search_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [search_check] icon is a graphical symbol that conveys a specific idea or functionality related to find, scan, magnifier, magnifying glass, found, correct, complete, tick.
  /// - It belongs to the text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData search_check =
      IconData(0xe4ae, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [search_code] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [search_code] icon is a graphical symbol that conveys a specific idea or functionality related to find, scan, magnifier, magnifying glass, grep, chevrons, <>.
  /// - It belongs to the text, social, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData search_code =
      IconData(0xe4af, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [search_slash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [search_slash] icon is a graphical symbol that conveys a specific idea or functionality related to find, scan, magnifier, magnifying glass, stop, clear, cancel, abort, /.
  /// - It belongs to the text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData search_slash =
      IconData(0xe4b0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [search_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [search_x] icon is a graphical symbol that conveys a specific idea or functionality related to find, scan, magnifier, magnifying glass, stop, clear, cancel, abort.
  /// - It belongs to the text, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData search_x =
      IconData(0xe4b1, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [section] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [section] icon is a graphical symbol that conveys a specific idea or functionality related to mark, typography, punctuation, legal, type, text, prose, symbol.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/gurtt](https://github.com/gurtt), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData section =
      IconData(0xe5ec, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [send] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [send] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, mail, paper airplane, paper aeroplane, submit.
  /// - It belongs to the mail, communication, connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData send =
      IconData(0xe155, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [send_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [send_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to email, message, mail, paper airplane, paper aeroplane, submit.
  /// - It belongs to the mail, communication, connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData send_horizontal =
      IconData(0xe4f6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [send_to_back] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [send_to_back] icon is a graphical symbol that conveys a specific idea or functionality related to bring, send, move, under, back, backwards, overlap, layer, order.
  /// - It belongs to the design, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/james-yeoman](https://github.com/james-yeoman), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData send_to_back =
      IconData(0xe4f7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [separator_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [separator_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to move, split.
  /// - It belongs to the text, arrows, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData separator_horizontal =
      IconData(0xe1c7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [separator_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [separator_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to move, split.
  /// - It belongs to the text, arrows, layout categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData separator_vertical =
      IconData(0xe1c8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [server] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [server] icon is a graphical symbol that conveys a specific idea or functionality related to cloud, storage.
  /// - It belongs to the development, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData server =
      IconData(0xe156, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [server_cog] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [server_cog] icon is a graphical symbol that conveys a specific idea or functionality related to cloud, storage, computing, cog, gear.
  /// - It belongs to the development, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData server_cog =
      IconData(0xe344, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [server_crash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [server_crash] icon is a graphical symbol that conveys a specific idea or functionality related to cloud, storage, problem, error.
  /// - It belongs to the development, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData server_crash =
      IconData(0xe1e8, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [server_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [server_off] icon is a graphical symbol that conveys a specific idea or functionality related to cloud, storage.
  /// - It belongs to the development, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/yukosgiti](https://github.com/yukosgiti), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData server_off =
      IconData(0xe1e9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [settings] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [settings] icon is a graphical symbol that conveys a specific idea or functionality related to cog, edit, gear, preferences.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData settings =
      IconData(0xe157, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [settings_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [settings_2] icon is a graphical symbol that conveys a specific idea or functionality related to cog, edit, gear, preferences.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData settings_2 =
      IconData(0xe244, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shapes] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shapes] icon is a graphical symbol that conveys a specific idea or functionality related to triangle, equilateral, square, circle, classification, different, collection, toy, blocks, learning.
  /// - It belongs to the shapes, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shapes =
      IconData(0xe4b7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [share] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [share] icon is a graphical symbol that conveys a specific idea or functionality related to network, connections.
  /// - It belongs to the account, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData share =
      IconData(0xe158, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [share_2] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [share_2] icon is a graphical symbol that conveys a specific idea or functionality related to network, connections.
  /// - It belongs to the account, social categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData share_2 =
      IconData(0xe159, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [sheet] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [sheet] icon is a graphical symbol that conveys a specific idea or functionality related to spreadsheets, table, excel.
  /// - It belongs to the text, files categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/zenoamaro](https://github.com/zenoamaro), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData sheet =
      IconData(0xe15a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shell] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shell] icon is a graphical symbol that conveys a specific idea or functionality related to beach, sand, holiday, sealife, fossil, ammonite, biology, ocean, terminal, command line, session, bash, zsh, roll, wrap, chewing gum, bubble gum, sweet, sugar, hosepipe, carpet, string, spiral, spinner, hypnotise, hypnosis.
  /// - It belongs to the animals, development, nature, science, travel, food-beverage, home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shell =
      IconData(0xe4fb, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield] icon is a graphical symbol that conveys a specific idea or functionality related to cybersecurity, secure, safety, protection, guardian, armored, armoured, defense, defence, defender, block, threat, prevention, antivirus, vigilance, vigilant, detection, scan, find, strength, strong, tough, invincible, invincibility, invulnerable, undamaged, audit, admin, verification, crest, bravery, knight, foot soldier, infantry, trooper, pawn, battle, war, military, army, cadet, scout.
  /// - It belongs to the account, security, development, gaming, shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield =
      IconData(0xe15b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_alert] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_alert] icon is a graphical symbol that conveys a specific idea or functionality related to unshielded, cybersecurity, insecure, unsecured, safety, unsafe, protection, unprotected, guardian, unguarded, unarmored, unarmoured, defenseless, defenceless, undefended, defender, blocked, stopped, intercepted, interception, saved, thwarted, threat, prevention, unprevented, antivirus, vigilance, vigilant, detection, detected, scanned, found, exploit, vulnerability, vulnerable, weakness, infection, infected, comprimised, data leak, audited, admin, verification, unverified, uncertified, warning, emergency, attention, urgent, alarm, crest, bravery, strength, tough, attacked, damaged, injured, hit, expired, disabled, inactive, error, exclamation mark, !.
  /// - It belongs to the account, security, development, notifications, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_alert =
      IconData(0xe1fd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_ban] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_ban] icon is a graphical symbol that conveys a specific idea or functionality related to unshielded, cybersecurity, insecure, unsecured, safety, unsafe, protection, unprotected, guardian, unguarded, unarmored, unarmoured, defenseless, defenceless, undefended, defender, blocked, stopped, intercepted, interception, saved, thwarted, threat, prevention, unprevented, antivirus, vigilance, vigilant, detection, detected, scanned, found, exploit, vulnerability, vulnerable, weakness, infection, infected, comprimised, data leak, audited, admin, verification, unverified, uncertified, cancel, error, crest, bravery, attacked, damaged, injured, hit, expired, eliminated, disabled, inactive, /.
  /// - It belongs to the account, security, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_ban =
      IconData(0xe15c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_check] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_check] icon is a graphical symbol that conveys a specific idea or functionality related to cybersecurity, secured, safety, protection, protected, guardian, guarded, armored, armoured, defense, defence, defended, blocked, threat, prevention, prevented, antivirus, vigilance, vigilant, active, activated, enabled, detection, scanned, found, strength, strong, tough, invincible, invincibility, invulnerable, undamaged, audited, admin, verification, verified, certification, certified, tested, passed, qualified, cleared, cleaned, disinfected, uninfected, task, completed, todo, done, ticked, checked, crest, bravery.
  /// - It belongs to the account, security, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_check =
      IconData(0xe1fe, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_ellipsis] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_ellipsis] icon is a graphical symbol that conveys a specific idea or functionality related to cybersecurity, securing, protecting, guarding, armoring, armouring, defending, blocking, preventing, antivirus, detecting, scanning, finding, auditing, admin, verifying, crest, upgrading, loader, loading, throbber, progress, dots, more, etc, ..., ….
  /// - It belongs to the account, security, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_ellipsis =
      IconData(0xe51a, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_half] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_half] icon is a graphical symbol that conveys a specific idea or functionality related to cybersecurity, secure, safety, protection, guardian, armored, armoured, defense, defence, defender, block, threat, prevention, antivirus, vigilance, vigilant, detection, scan, strength, strong, tough, invincible, invincibility, invulnerable, undamaged, audit, admin, verification, crest, logo, sigil, flag, team, faction, fraternity, university, college, academy, school, education, uniform, bravery, knight, foot soldier, infantry, trooper, pawn, battle, war, military, ranking, army, cadet, scout.
  /// - It belongs to the account, security, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_half =
      IconData(0xe51b, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_minus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_minus] icon is a graphical symbol that conveys a specific idea or functionality related to unshield, cybersecurity, unsecure, unguard, unblock, antivirus, clean, clear, disinfect, patch, fix, stop, cancel, remove, relax, admin, crest, bravery, weakened, damaged, hit, unarm, disable, deactivate, decommission, downgraded, minimum, -.
  /// - It belongs to the account, security, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_minus =
      IconData(0xe51c, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_off] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_off] icon is a graphical symbol that conveys a specific idea or functionality related to unshielded, cybersecurity, insecure, unsecured, safety, unsafe, protection, unprotected, guardian, unguarded, unarmored, unarmoured, defenseless, defenceless, undefended, defender, interception, threat, prevention, unprevented, antivirus, detection, undetected, exploit, vulnerability, vulnerable, weakness, infected, infection, comprimised, data leak, unaudited, admin, verification, unverified, inactive, cancelled, error, crest, bravery, damaged, injured, hit, expired, eliminated.
  /// - It belongs to the account, security, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_off =
      IconData(0xe15d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_plus] icon is a graphical symbol that conveys a specific idea or functionality related to cybersecurity, secure, safety, protection, guardian, armored, armoured, defense, defence, defender, block, threat, prevention, antivirus, vigilance, vigilant, detection, scan, strength, strong, tough, invincible, invincibility, invulnerable, undamaged, extra, added, professional, enterprise, full, maximum, upgraded, ultra, activate, enable, audit, admin, verification, crest, medic, +.
  /// - It belongs to the account, security, development, gaming, medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_plus =
      IconData(0xe51d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_question] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_question] icon is a graphical symbol that conveys a specific idea or functionality related to unshielded, cybersecurity, insecure, unsecured, safety, unsafe, protection, unprotected, guardian, unguarded, unarmored, unarmoured, defenseless, defenceless, undefended, defender, threat, prevention, unprevented, antivirus, vigilance, vigilant, detection, undetected, scan, find, exploit, vulnerability, vulnerable, weakness, infection, comprimised, data leak, audit, admin, verification, unverified, uncertified, uncertain, unknown, inactive, crest, question mark, ?.
  /// - It belongs to the account, security, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_question =
      IconData(0xe412, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shield_x] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shield_x] icon is a graphical symbol that conveys a specific idea or functionality related to unshielded, cybersecurity, insecure, unsecured, safety, unsafe, protection, unprotected, guardian, unguarded, unarmored, unarmoured, defenseless, defenceless, undefended, defender, blocked, stopped, intercepted, interception, saved, thwarted, threat, prevention, prevented, antivirus, vigilance, vigilant, detection, detected, scanned, found, exploit, vulnerability, vulnerable, weakness, infection, infected, comprimised, data leak, audited, admin, verification, unverified, inactive, cancel, error, wrong, false, crest, bravery, attacked, damaged, injured, hit, dead, deceased, expired, eliminated, exterminated.
  /// - It belongs to the account, security, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shield_x =
      IconData(0xe1ff, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ship] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ship] icon is a graphical symbol that conveys a specific idea or functionality related to boat, knots, nautical mile, maritime, sailing, yacht, cruise, ocean liner, tanker, vessel, navy, trip.
  /// - It belongs to the transportation, navigation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ship =
      IconData(0xe3bd, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [ship_wheel] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [ship_wheel] icon is a graphical symbol that conveys a specific idea or functionality related to steering, rudder, boat, knots, nautical mile, maritime, sailing, yacht, cruise, ocean liner, tanker, vessel, navy, trip.
  /// - It belongs to the transportation, navigation, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData ship_wheel =
      IconData(0xe506, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shirt] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shirt] icon is a graphical symbol that conveys a specific idea or functionality related to t-shirt, shopping, store, clothing, clothes.
  /// - It belongs to the shopping categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shirt =
      IconData(0xe1c9, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shopping_bag] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shopping_bag] icon is a graphical symbol that conveys a specific idea or functionality related to ecommerce, cart, purchase, store.
  /// - It belongs to the shopping categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shopping_bag =
      IconData(0xe15e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shopping_basket] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shopping_basket] icon is a graphical symbol that conveys a specific idea or functionality related to cart, e-commerce, store, purchase, products, items, ingredients.
  /// - It belongs to the shopping categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shopping_basket =
      IconData(0xe4ee, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shopping_cart] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shopping_cart] icon is a graphical symbol that conveys a specific idea or functionality related to trolley, cart, basket, e-commerce, store, purchase, products, items, ingredients.
  /// - It belongs to the shopping categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shopping_cart =
      IconData(0xe15f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shovel] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shovel] icon is a graphical symbol that conveys a specific idea or functionality related to dig, spade, treasure.
  /// - It belongs to the nature, tools, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Andreto](https://github.com/Andreto), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shovel =
      IconData(0xe160, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shower_head] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shower_head] icon is a graphical symbol that conveys a specific idea or functionality related to shower, bath, bathroom, amenities, services.
  /// - It belongs to the home, travel categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shower_head =
      IconData(0xe37f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shrink] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shrink] icon is a graphical symbol that conveys a specific idea or functionality related to scale, fullscreen.
  /// - It belongs to the layout, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shrink =
      IconData(0xe21f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shrub] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shrub] icon is a graphical symbol that conveys a specific idea or functionality related to forest, undergrowth, park, nature.
  /// - It belongs to the nature categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shrub =
      IconData(0xe2ed, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [shuffle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [shuffle] icon is a graphical symbol that conveys a specific idea or functionality related to music, random, reorder.
  /// - It belongs to the multimedia, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData shuffle =
      IconData(0xe161, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [sigma] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [sigma] icon is a graphical symbol that conveys a specific idea or functionality related to sum, calculate, formula, math, enumeration, enumerate.
  /// - It belongs to the text, math, science categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/johnletey](https://github.com/johnletey), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData sigma =
      IconData(0xe200, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [signal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [signal] icon is a graphical symbol that conveys a specific idea or functionality related to connection, wireless, gsm, phone, 2g, 3g, 4g, 5g.
  /// - It belongs to the connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData signal =
      IconData(0xe25e, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [signal_high] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [signal_high] icon is a graphical symbol that conveys a specific idea or functionality related to connection, wireless, gsm, phone, 2g, 3g, 4g, 5g.
  /// - It belongs to the connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData signal_high =
      IconData(0xe25f, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [signal_low] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [signal_low] icon is a graphical symbol that conveys a specific idea or functionality related to connection, wireless, gsm, phone, 2g, 3g, 4g, 5g.
  /// - It belongs to the connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData signal_low =
      IconData(0xe260, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [signal_medium] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [signal_medium] icon is a graphical symbol that conveys a specific idea or functionality related to connection, wireless, gsm, phone, 2g, 3g, 4g, 5g.
  /// - It belongs to the connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData signal_medium =
      IconData(0xe261, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [signal_zero] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [signal_zero] icon is a graphical symbol that conveys a specific idea or functionality related to connection, wireless, gsm, phone, 2g, 3g, 4g, 5g, lost.
  /// - It belongs to the connectivity categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/azdle](https://github.com/azdle) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData signal_zero =
      IconData(0xe262, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [signature] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [signature] icon is a graphical symbol that conveys a specific idea or functionality related to text, format, input, contract, autograph, handwriting, sign, cursive, ink, scribble, authorize, personal, agreement, legal, document, identity, authentic, approval, verification, unique.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/AndreasSas](https://github.com/AndreasSas), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData signature =
      IconData(0xe5f6, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [signpost] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [signpost] icon is a graphical symbol that conveys a specific idea or functionality related to bidirectional, left, right, east, west.
  /// - It belongs to the arrows, navigation, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData signpost =
      IconData(0xe544, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [signpost_big] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [signpost_big] icon is a graphical symbol that conveys a specific idea or functionality related to bidirectional, left, right, east, west.
  /// - It belongs to the arrows, navigation, development, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData signpost_big =
      IconData(0xe545, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [siren] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [siren] icon is a graphical symbol that conveys a specific idea or functionality related to police, ambulance, emergency, security, alert, alarm, light.
  /// - It belongs to the medical categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData siren =
      IconData(0xe2ee, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [skip_back] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [skip_back] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, previous, music.
  /// - It belongs to the multimedia, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData skip_back =
      IconData(0xe162, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [skip_forward] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [skip_forward] icon is a graphical symbol that conveys a specific idea or functionality related to arrow, skip, next, music.
  /// - It belongs to the multimedia, arrows categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData skip_forward =
      IconData(0xe163, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [skull] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [skull] icon is a graphical symbol that conveys a specific idea or functionality related to death, danger, bone.
  /// - It belongs to the gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData skull =
      IconData(0xe220, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [slack] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [slack] icon is a graphical symbol that conveys a specific idea or functionality related to logo.
  /// - It belongs to the account, social, brands, development categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ashygee](https://github.com/ashygee), [https://github.com/wojtekmaj](https://github.com/wojtekmaj), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData slack =
      IconData(0xe164, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [slash] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [slash] icon is a graphical symbol that conveys a specific idea or functionality related to divide, division, or, /.
  /// - It belongs to the development, math categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData slash =
      IconData(0xe521, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [slice] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [slice] icon is a graphical symbol that conveys a specific idea or functionality related to cutter, scalpel, knife.
  /// - It belongs to the design categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/jguddas](https://github.com/jguddas) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData slice =
      IconData(0xe2ef, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [sliders_horizontal] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [sliders_horizontal] icon is a graphical symbol that conveys a specific idea or functionality related to settings, filters, controls.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData sliders_horizontal =
      IconData(0xe299, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [sliders_vertical] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [sliders_vertical] icon is a graphical symbol that conveys a specific idea or functionality related to settings, controls.
  /// - It belongs to the account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData sliders_vertical =
      IconData(0xe165, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [smartphone] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [smartphone] icon is a graphical symbol that conveys a specific idea or functionality related to phone, cellphone, device, screen.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData smartphone =
      IconData(0xe166, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [smartphone_charging] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [smartphone_charging] icon is a graphical symbol that conveys a specific idea or functionality related to phone, cellphone, device, power, screen.
  /// - It belongs to the connectivity, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData smartphone_charging =
      IconData(0xe22d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [smartphone_nfc] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [smartphone_nfc] icon is a graphical symbol that conveys a specific idea or functionality related to contactless, payment, near-field communication, screen.
  /// - It belongs to the communication, finance, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData smartphone_nfc =
      IconData(0xe3c7, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [smile] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [smile] icon is a graphical symbol that conveys a specific idea or functionality related to emoji, face, happy, good, emotion.
  /// - It belongs to the emoji, account categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/csandman](https://github.com/csandman), [https://github.com/mittalyashu](https://github.com/mittalyashu), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData smile =
      IconData(0xe167, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [smile_plus] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [smile_plus] icon is a graphical symbol that conveys a specific idea or functionality related to emoji, face, happy, good, emotion, react, reaction, add.
  /// - It belongs to the emoji, social, notifications, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData smile_plus =
      IconData(0xe300, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [snail] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [snail] icon is a graphical symbol that conveys a specific idea or functionality related to animal, insect, slow, speed, delicacy, spiral.
  /// - It belongs to the animals, food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData snail =
      IconData(0xe4fc, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [snowflake] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [snowflake] icon is a graphical symbol that conveys a specific idea or functionality related to cold, weather, freeze, snow, winter.
  /// - It belongs to the weather, seasons categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere), [https://github.com/lscheibel](https://github.com/lscheibel), [https://github.com/ericfennis](https://github.com/ericfennis) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData snowflake =
      IconData(0xe168, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [sofa] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [sofa] icon is a graphical symbol that conveys a specific idea or functionality related to armchair, furniture, leisure, lounge, loveseat, couch.
  /// - It belongs to the home categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData sofa =
      IconData(0xe2c3, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [soup] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [soup] icon is a graphical symbol that conveys a specific idea or functionality related to food, dish, restaurant, course, meal, bowl, starter.
  /// - It belongs to the food-beverage categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/kemie](https://github.com/kemie) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData soup =
      IconData(0xe3ad, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [space] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [space] icon is a graphical symbol that conveys a specific idea or functionality related to text, selection, letters, characters, font, typography.
  /// - It belongs to the text categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData space =
      IconData(0xe3e0, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [spade] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [spade] icon is a graphical symbol that conveys a specific idea or functionality related to shape, suit, playing, cards.
  /// - It belongs to the shapes, gaming categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/danielbayley](https://github.com/danielbayley), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData spade =
      IconData(0xe49d, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [sparkle] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [sparkle] icon is a graphical symbol that conveys a specific idea or functionality related to star, effect, filter, night, magic, shiny, glitter, twinkle, celebration.
  /// - It belongs to the shapes categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/Shiva953](https://github.com/Shiva953), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData sparkle =
      IconData(0xe482, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [sparkles] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [sparkles] icon is a graphical symbol that conveys a specific idea or functionality related to stars, effect, filter, night, magic.
  /// - It belongs to the cursors, multimedia, gaming, weather categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData sparkles =
      IconData(0xe416, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [speaker] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [speaker] icon is a graphical symbol that conveys a specific idea or functionality related to sound, audio, music, tweeter, subwoofer, bass, production, producer, dj.
  /// - It belongs to the multimedia, devices categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/colebemis](https://github.com/colebemis), [https://github.com/ericfennis](https://github.com/ericfennis), [https://github.com/danielbayley](https://github.com/danielbayley) have been instrumental in the development of this icon.
  ///
  /// - For more insights, please visit the Lucide icon library at [https://lucide.dev/].
  ///
  static const IconData speaker =
      IconData(0xe169, fontFamily: _fontFamily, fontPackage: _fontPackage);

  /// Represents the [speech] icon from the Lucide icon set.
  ///
  /// Description:
  /// - The [speech] icon is a graphical symbol that conveys a specific idea or functionality related to disability, disabled, dda, human, accessibility, people, sound.
  /// - It belongs to the accessibility, communication categories.
  ///
  /// Acknowledgements:
  /// - Contributions from [https://github.com/doerge](https://github.com/doerge), [https://github.com/airone01](https://github.com/airone01), [https://github.com/jguddas](https://github.com/jguddas), [https://github.com/karsa-mistmere](https://github.com/karsa-mistmere)