# Changelog

## 3.1.0

- **Security**: Added `SECURITY.md` for vulnerability reporting and security best practices.
- **Enhancement**: Added a `Pull Request template` to ensure thorough checks for new contributions.
- **Fix**: [`issue #56`](https://github.com/nixrajput/flutter_carousel_widget/issues/56) fixed.
- **Fix**: [`issue #55`](https://github.com/nixrajput/flutter_carousel_widget/issues/55) fixed.

## 3.0.1

- **Improvement**: Added comments to the classes, controllers, states, options, enums, and indicators.
- **Improvement**: Formatted the code to pass static analysis.
- **Documentation**: Removed demo `gif` to reduce package size.

## 3.0.0

- **Breaking Change**: New `FlutterCarouselOptions` introduced for `FlutterCarousel`.
- **Breaking Change**: New `FlutterCarouselController` introduced for `FlutterCarousel`.
- **Breaking Change**: New `FlutterCarouselState` introduced for `FlutterCarousel`.
- **Breaking Change**: New `ExpandableCarouselOptions` introduced for `ExpandableCarousel`.
- **Breaking Change**: New `ExpandableCarouselController` introduced for `ExpandableCarousel`.
- **Breaking Change**: New `ExpandableCarouselState` introduced for `ExpandableCarousel`.
- **Documentation**: Updated the documentation to include breaking changes.
- **Fix**: `issue #52` fixed.
- **Fix**: `issue #51` fixed.
- **Fix**: `issue #50` fixed.
- **Fix**: `issue #48` fixed.
- **Fix**: `issue #38` fixed.
- **Fix**: `issue #37` fixed.
- **Improvement**: Performance improvements.

## 2.3.0

- **Breaking Change**: New `ExpandableCarouselOptions` introduced for `ExpandableCarousel`.
- **Breaking Change**: New `ExpandableCarouselController` introduced for `ExpandableCarousel`.
- **Breaking Change**: New `ExpandableCarouselState` introduced for `ExpandableCarousel`.
- **Breaking Change**: All slide indicator properties have been consolidated into the `SlideIndicatorOptions` class.
- **Enhancement**: `issue #44` Added optional halo effect for slide indicators, customizable via `SlideIndicatorOptions` properties (`enableHalo`, `haloPadding`, `haloDecoration`).
- **Chore**: Removed dead code.
- **Fix**: `issue #46` fixed.
- **Fix**: `issue #44` fixed.
- **Fix**: `issue #40` fixed.

## 2.2.0

- **New Feature**: Support for custom slide indicators added.
- **Documentation**: Updated the documentation to show all contributors.
- **Documentation**: Updated the documentation to demonstrate the use of custom slide indicator.
- **Fix**: `issue #28` fixed.
- **Fix**: `issue #30` fixed.
- **Improvement**: Performance improvements.
- **Optimization**: Removed unnecessary codes.

## 2.1.2

- **Documentation**: Updated the documentation to display the screenshots.

## 2.1.1

- **Documentation**: Updated the documentation to display the screenshots.

## 2.1.0

- **Fix**: `issue #27` LICENSE updated to MIT.
- **Fix**: `issue #24` fixed.
- **Fix**: `issue #22` fixed.
- **Fix**: `issue #20` fixed.
- **Fix**: `issue #17` fixed.
- **Improvement**: Performance improvements.

## 2.0.4

- **Optimization**: Removed unnecessary codes.

## 2.0.3

- **Improvement**: Removed unnecessary dependencies.
- **Fix**: All known bug fixed and removed.
- **Improvement**: Performance improvements.
- **Optimization**: Removed unnecessary codes.

## 2.0.2

- **Add**: `indicatorMargin` property added to `CarouselOptions`.
- **Improvement**: Removed unnecessary dependencies.
- **Fix**: All known bug fixed and removed.
- **Improvement**: Performance improvements.
- **Optimization**: Removed unnecessary codes.

## 2.0.1

- **Documentation**: Updated the documentation to reflect the new Github Pages deployment.
- **Fix**: All known bug fixed and removed.

## 2.0.0+1

- **Fix**: Enums are now exported.
- **New Feature**: `ExpandableCarousel` widget added.
- **Breaking Change**: `scrollPhysics` is now `physics` in `CarouselOptions`.
- **Breaking Change**: `carouselController` is now `controller` in `CarouselOptions`.
- **Breaking Change**: Project architecture changed.
- **Fix**: All known bug fixed and removed.
- **Improvement**: Performance improvements.
- **Optimization**: Removed unnecessary codes.

## 2.0.0

- **New Feature**: `ExpandableCarousel` widget added.
- **Breaking Change**: `scrollPhysics` is now `physics` in `CarouselOptions`.
- **Breaking Change**: `carouselController` is now `controller` in `CarouselOptions`.
- **Breaking Change**: Project architecture changed.
- **Fix**: All known bug fixed and removed.
- **Improvement**: Performance improvements.
- **Optimization**: Removed unnecessary codes.

## 1.2.3

- **Fix**: bug auto play carousel is not working.
- All known bug fixed and removed.
- Performance improvements.
- Removed unnecessary codes.

## 1.2.2

- **Fix**: `issue #7` bug show indicator when no custom `CarouselController` is set and `showIndicator` is set to `true` and `onPageChanged` is called.
- Custom `CarouselController` can be set via `CarouselOptions` property.
- All known bugs are fixed.
- Performance improvements.

## 1.2.1

- Github Actions: Web Demo is now deployed to Github Pages
- Documentation: Updated the documentation to reflect the new Github Pages deployment

## 1.2.0

- Project structure changed.
- Minor bug fixes.
- Removed unnecessary codes.

## 1.1.0

- Minor bug fixes.
- Performance improvements.

## 1.0.5

- Minor bug fixes.
- Performance improvements.

## 1.0.4

- Minor bug fixes.
- Performance improvements.

## 1.0.3

- Minor bug fixes.
- Performance improvements.

## 1.0.2

- Option to float Slide Indicator over Carousel or to show below Carousel added.
- Screenshots updated.
- Source code optimized.
- Performance improvements.

## 1.0.1

- Web app example demo added.
- Indicator color will change according to System theme.
- Screenshots updated.
- Documentation updated.
- Source code optimized.
- Performance improvements.

## 1.0.0

- Source code optimized.
- Bug fixes.
- Performance improvements.
- Documentation updated.

## 0.1.5

- Default Slide Indicator added.
- Bug fixes.
- Performance improvements.

## 0.1.4

- Bug fixes.
- Documentation updated.

## 0.1.3

- Minor bug fixes.

## 0.1.2

- Auto-sized child support.
- Bug fixes.

## 0.1.1

- Bug fixes.
- Documentation updated.

## 0.1.0

- Pre-built Carousel indicator support added.
- Bug fixes.
- Documentation updated.

## 0.0.1

- Initial Version.
