/*
 * Alex vs Bus
 * Copyright (C) 2021-2025 M374LX
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

/*
 * File:
 * data.c
 *
 * Description:
 * Read-only data
 *
 */

//------------------------------------------------------------------------------

#include "defs.h"

#include <raylib.h>

//------------------------------------------------------------------------------

//Supported virtual screen widths
const int data_screen_widths[] = {
	480, 432, 416, 320, 256, -1
};

//Supported virtual screen heights
const int data_screen_heights[] = {
	270, 256, 240, 224, 192, -1
};

//Number of levels per difficulty
const int data_difficulty_num_levels[] = {
	[DIFFICULTY_NORMAL] = 5,
	[DIFFICULTY_HARD]   = 5,
	[DIFFICULTY_SUPER]  = 3,
};

//A cheat code
const int data_cheat_sequence[] = {
	3, 0, 2, 1, 3, 0, 1, 2, 1, 3, 0, 2, -1
};

//Level block numbers for each level column type
const int data_level_column_blocks[] = {
	//LVLCOL_NORMAL_FLOOR
	0x04, 0x05, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00,

	//LVLCOL_DEEP_HOLE_LEFT
	0x07, 0x08, 0x09, 0x09, 0x09, 0x09, 0x00, 0x00,

	//LVLCOL_DEEP_HOLE_MIDDLE
	0x0A, 0x0B, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00,

	//LVLCOL_DEEP_HOLE_RIGHT
	0x0D, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00,

	//LVLCOL_PASSAGEWAY_LEFT
	0x10, 0x11, 0x12, 0x12, 0x12, 0x06, 0x00, 0x00,

	//LVLCOL_PASSAGEWAY_MIDDLE
	0x04, 0x13, 0x0C, 0x0C, 0x0C, 0x06, 0x00, 0x00,

	//LVLCOL_PASSAGEWAY_RIGHT
	0x14, 0x15, 0x0F, 0x0F, 0x0F, 0x06, 0x00, 0x00,
};

//Sprites within the gfx.png file
//
//For each sprite: x, y, width, height
//
//For sprites with more than one animation frame, the width refers to a single
//frame
const int data_sprites[] = {
	0,    0,    0,   0,   //SPR_NULL
	928,  144,  8,   8,   //SPR_BANANA_PEEL
	104,  272,  32,  64,  //SPR_BEARDED_MAN_STAND
	136,  272,  32,  64,  //SPR_BEARDED_MAN_WALK
	328,  272,  32,  64,  //SPR_BEARDED_MAN_JUMP
	984,  144,  8,   8,   //SPR_BG_BLACK
	992,  144,  8,   8,   //SPR_BG_SKY1
	1000, 144,  8,   8,   //SPR_BG_SKY2
	1008, 144,  8,   8,   //SPR_BG_SKY3
	784,  72,   16,  8,   //SPR_BIRD
	592,  312,  408, 104, //SPR_BUS
	600,  424,  24,  64,  //SPR_BUS_CHARACTER_1
	624,  424,  24,  64,  //SPR_BUS_CHARACTER_2
	648,  424,  24,  64,  //SPR_BUS_CHARACTER_3
	840,  424,  40,  88,  //SPR_BUS_DOOR
	672,  472,  24,  32,  //SPR_BUS_ROUTE
	736,  0,    16,  88,  //SPR_BUS_STOP_SIGN
	688,  424,  48,  40,  //SPR_BUS_WHEEL
	448,  288,  136, 56,  //SPR_CAR_BLUE
	448,  352,  136, 56,  //SPR_CAR_SILVER
	448,  416,  136, 56,  //SPR_CAR_YELLOW
	528,  480,  24,  24,  //SPR_CAR_WHEEL
	304,  632,  8,   8,   //SPR_CHARSET_WHITE
	440,  632,  8,   8,   //SPR_CHARSET_GREEN
	576,  632,  8,   8,   //SPR_CHARSET_GRAY
	928,  112,  8,   8,   //SPR_COIN_SILVER
	928,  128,  8,   8,   //SPR_COIN_GOLD
	976,  112,  8,   8,   //SPR_COIN_SPARK_SILVER
	976,  128,  8,   8,   //SPR_COIN_SPARK_GOLD
	872,  64,   8,   8,   //SPR_CRACK_PARTICLE
	872,  0,    24,  24,  //SPR_CRATE
	104,  344,  24,  16,  //SPR_DEEP_HOLE_LEFT_FG
	856,  72,   8,   8,   //SPR_DUNG
	152,  696,  40,  8,   //SPR_ERROR
	0,    176,  64,  88,  //SPR_FLAGMAN
	952,  0,    24,  88,  //SPR_GUSH
	1000, 96,   16,  8,   //SPR_GUSH_CRACK
	976,  96,   16,  8,   //SPR_GUSH_HOLE
	760,  88,   32,  32,  //SPR_HEN
	872,  32,   16,  24,  //SPR_HYDRANT
	480,  696,  224, 64,  //SPR_LOGO_SMALL
	712,  680,  296, 80,  //SPR_LOGO_LARGE
	288,  168,  32,  32,  //SPR_MEDAL1
	328,  168,  32,  32,  //SPR_MEDAL2
	368,  168,  32,  32,  //SPR_MEDAL3
	816,  0,    16,  32,  //SPR_OVERHEAD_SIGN
	1008, 184,  8,   320, //SPR_OVERHEAD_SIGN_BASE
	840,  8,    16,  24,  //SPR_OVERHEAD_SIGN_BASE_TOP
	136,  344,  32,  16,  //SPR_PASSAGEWAY_LEFT_FG
	176,  344,  24,  16,  //SPR_PASSAGEWAY_RIGHT_FG
	208,  344,  24,  24,  //SPR_PASSAGEWAY_RIGHT_CLOSED
	688,  512,  32,  32,  //SPR_PAUSE
	0,    0,    32,  64,  //SPR_PLAYER_STAND
	32,   0,    32,  64,  //SPR_PLAYER_WALK
	224,  0,    32,  64,  //SPR_PLAYER_JUMP
	256,  0,    32,  64,  //SPR_PLAYER_GRABROPE
	288,  0,    32,  64,  //SPR_PLAYER_THROWBACK
	384,  0,    48,  64,  //SPR_PLAYER_SLIP
	232,  72,   48,  64,  //SPR_PLAYER_RUN
	0,    72,   24,  64,  //SPR_PLAYER_CLEAN_DUNG
	904,  24,   24,  136, //SPR_POLE
	712,  120,  40,  24,  //SPR_PUSH_ARROW
	616,  168,  400, 16,  //SPR_ROPE_HORIZONTAL
	936,  56,   8,   48,  //SPR_ROPE_VERTICAL
	760,  120,  24,  16,  //SPR_SPRING
	720,  184,  280, 128, //SPR_TRUCK
	0,    384,  24,  24,  //SPR_LEVEL_BLOCK_0
	32,   384,  24,  24,  //SPR_LEVEL_BLOCK_1
	64,   384,  24,  24,  //SPR_LEVEL_BLOCK_2
	96,   384,  24,  24,  //SPR_LEVEL_BLOCK_3
	128,  384,  24,  24,  //SPR_LEVEL_BLOCK_4
	160,  384,  24,  24,  //SPR_LEVEL_BLOCK_5
	192,  384,  24,  24,  //SPR_LEVEL_BLOCK_6
	224,  384,  24,  24,  //SPR_LEVEL_BLOCK_7
	0,    416,  24,  24,  //SPR_LEVEL_BLOCK_8
	32,   416,  24,  24,  //SPR_LEVEL_BLOCK_9
	64,   416,  24,  24,  //SPR_LEVEL_BLOCK_10
	96,   416,  24,  24,  //SPR_LEVEL_BLOCK_11
	128,  416,  24,  24,  //SPR_LEVEL_BLOCK_12
	160,  416,  24,  24,  //SPR_LEVEL_BLOCK_13
	192,  416,  24,  24,  //SPR_LEVEL_BLOCK_14
	224,  416,  24,  24,  //SPR_LEVEL_BLOCK_15
	0,    448,  24,  24,  //SPR_LEVEL_BLOCK_16
	32,   448,  24,  24,  //SPR_LEVEL_BLOCK_17
	64,   448,  24,  24,  //SPR_LEVEL_BLOCK_18
	96,   448,  24,  24,  //SPR_LEVEL_BLOCK_19
	128,  448,  24,  24,  //SPR_LEVEL_BLOCK_20
	160,  448,  24,  24,  //SPR_LEVEL_BLOCK_21
	8,    512,  80,  24,  //SPR_MENU_PLAY
	296,  512,  80,  24,  //SPR_MENU_PLAY_SELECTED
	104,  512,  24,  24,  //SPR_MENU_TRYAGAIN
	392,  512,  24,  24,  //SPR_MENU_TRYAGAIN_SELECTED
	136,  512,  24,  24,  //SPR_MENU_JUKEBOX
	424,  512,  24,  24,  //SPR_MENU_JUKEBOX_SELECTED
	168,  512,  24,  24,  //SPR_MENU_SETTINGS
	456,  512,  24,  24,  //SPR_MENU_SETTINGS_SELECTED
	200,  512,  24,  24,  //SPR_MENU_ABOUT
	488,  512,  24,  24,  //SPR_MENU_ABOUT_SELECTED
	232,  512,  24,  24,  //SPR_MENU_QUIT
	520,  512,  24,  24,  //SPR_MENU_QUIT_SELECTED
	8,    544,  24,  24,  //SPR_MENU_RETURN
	296,  544,  24,  24,  //SPR_MENU_RETURN_SELECTED
	40,   544,  24,  24,  //SPR_MENU_AUDIO_ON
	328,  544,  24,  24,  //SPR_MENU_AUDIO_ON_SELECTED
	72,   544,  24,  24,  //SPR_MENU_AUDIO_OFF
	360,  544,  24,  24,  //SPR_MENU_AUDIO_OFF_SELECTED
	104,  544,  24,  24,  //SPR_MENU_CONFIRM
	392,  544,  24,  24,  //SPR_MENU_CONFIRM_SELECTED
	136,  544,  24,  24,  //SPR_MENU_CANCEL
	424,  544,  24,  24,  //SPR_MENU_CANCEL_SELECTED
	168,  544,  24,  24,  //SPR_MENU_RETURN_SMALL
	456,  544,  24,  24,  //SPR_MENU_RETURN_SMALL_SELECTED
	8,    576,  24,  32,  //SPR_MENU_1
	296,  576,  24,  32,  //SPR_MENU_1_SELECTED
	40,   576,  24,  32,  //SPR_MENU_2
	328,  576,  24,  32,  //SPR_MENU_2_SELECTED
	72,   576,  24,  32,  //SPR_MENU_3
	360,  576,  24,  32,  //SPR_MENU_3_SELECTED
	104,  576,  24,  32,  //SPR_MENU_4
	392,  576,  24,  32,  //SPR_MENU_4_SELECTED
	136,  576,  24,  32,  //SPR_MENU_5
	424,  576,  24,  32,  //SPR_MENU_5_SELECTED
	168,  576,  24,  32,  //SPR_MENU_LOCKED
	8,    696,  8,   8,   //SPR_MENU_BORDER_TOPLEFT
	56,   696,  8,   8,   //SPR_MENU_BORDER_TOPLEFT_SELECTED
	104,  696,  8,   8,   //SPR_MENU_BORDER_TOPLEFT_DISABLED
	24,   696,  8,   8,   //SPR_MENU_BORDER_TOP
	72,   696,  8,   8,   //SPR_MENU_BORDER_TOP_SELECTED
	120,  696,  8,   8,   //SPR_MENU_BORDER_TOP_DISABLED
	40,   696,  8,   8,   //SPR_MENU_BORDER_LEFT
	88,   696,  8,   8,   //SPR_MENU_BORDER_LEFT_SELECTED
	136,  696,  8,   8,   //SPR_MENU_BORDER_LEFT_DISABLED
	672,  512,  0,   0,   //SPR_SCANLINE
	824,  520,  64,  64,  //SPR_TOUCH_LEFT
	824,  584,  64,  64,  //SPR_TOUCH_LEFT_HELD
	888,  520,  64,  64,  //SPR_TOUCH_RIGHT
	888,  584,  64,  64,  //SPR_TOUCH_RIGHT_HELD
	952,  520,  64,  64,  //SPR_TOUCH_JUMP
	952,  584,  64,  64,  //SPR_TOUCH_JUMP_HELD
};

//Sprite corresponding to each player character animation type
const int data_player_anim_sprites[] = {
	[PLAYER_ANIM_STAND]     = SPR_PLAYER_STAND,
	[PLAYER_ANIM_WALK]      = SPR_PLAYER_WALK,
	[PLAYER_ANIM_WALKBACK]  = SPR_PLAYER_WALK,
	[PLAYER_ANIM_JUMP]      = SPR_PLAYER_JUMP,
	[PLAYER_ANIM_SLIP]      = SPR_PLAYER_SLIP,
	[PLAYER_ANIM_SLIPREV]   = SPR_PLAYER_SLIP,
	[PLAYER_ANIM_THROWBACK] = SPR_PLAYER_THROWBACK,
	[PLAYER_ANIM_GRABROPE]  = SPR_PLAYER_GRABROPE,
};

//Sprite corresponding to each object type (OBJ_* constants)
const int data_obj_sprites[] = {
	[OBJ_COIN_SILVER]        = SPR_COIN_SILVER,
	[OBJ_COIN_GOLD]          = SPR_COIN_GOLD,
	[OBJ_CRATE_PUSHABLE]     = SPR_CRATE,
	[OBJ_BANANA_PEEL]        = SPR_BANANA_PEEL,
	[OBJ_BANANA_PEEL_MOVING] = SPR_BANANA_PEEL,
	[OBJ_GUSH]               = SPR_GUSH,
	[OBJ_GUSH_CRACK]         = SPR_GUSH_CRACK,
	[OBJ_ROPE_HORIZONTAL]    = SPR_ROPE_HORIZONTAL,
	[OBJ_ROPE_VERTICAL]      = SPR_ROPE_VERTICAL,
	[OBJ_SPRING]             = SPR_SPRING,
	[OBJ_HYDRANT]            = SPR_HYDRANT,
	[OBJ_OVERHEAD_SIGN]      = SPR_OVERHEAD_SIGN,
	[OBJ_PARKED_CAR_BLUE]    = SPR_CAR_BLUE,
	[OBJ_PARKED_CAR_SILVER]  = SPR_CAR_SILVER,
	[OBJ_PARKED_CAR_YELLOW]  = SPR_CAR_YELLOW,
	[OBJ_PARKED_TRUCK]       = SPR_TRUCK,
};

//Gush movement patterns
//
//For each pair of values, the first value is the vertical velocity (yvel)
//and the second value is the destination Y position (ydest)
//
//The value zero indicates the end of the pattern
const int data_gush_move_pattern_1[] = {
	-60, 224, 60, 232,
	-60, 224, 60, 232,
	-60, 224, 60, 232,
	-60, 224, 60, 232,
	-60, 224, 60, 232,
	-144, 200, 144, 232,
	0,
};

const int data_gush_move_pattern_2[] = {
	-60, 216, 60, 224,
	0,
};

const char* data_menu_display_names[] = {
	[MENU_MAIN]             = "",
	[MENU_DIFFICULTY]       = "DIFFICULTY SELECT",
	[MENU_LEVEL]            = "LEVEL SELECT",
	[MENU_JUKEBOX]          = "JUKEBOX",
	[MENU_SETTINGS]         = "SETTINGS",
	[MENU_DISPLAY_SETTINGS] = "DISPLAY SETTINGS",
	[MENU_VSCREEN_SIZE]     = "VSCREEN SIZE",
	[MENU_VSCREEN_WIDTH]    = "VSCREEN WIDTH",
	[MENU_VSCREEN_HEIGHT]   = "VSCREEN HEIGHT",
	[MENU_WINDOW_SCALE]     = "WINDOW SCALE",
	[MENU_AUDIO_SETTINGS]   = "AUDIO SETTINGS",
	[MENU_ABOUT]            = "ABOUT",
	[MENU_CREDITS]          = "CREDITS",
	[MENU_PAUSE]            = "",
	[MENU_TRYAGAIN_PAUSE]   = "CONFIRMATION",
	[MENU_TRYAGAIN_TIMEUP]  = "CONFIRMATION",
	[MENU_QUIT]             = "CONFIRMATION",
	[MENU_ERROR]            = "",
};

const char* data_sfx_files[] = {
	[SFX_COIN]    = "coin",
	[SFX_CRATE]   = "crate",
	[SFX_ERROR]   = "error",
	[SFX_FALL]    = "fall",
	[SFX_HIT]     = "hit",
	[SFX_HOLE]    = "hole",
	[SFX_RESPAWN] = "respawn",
	[SFX_SCORE]   = "score",
	[SFX_SELECT]  = "select",
	[SFX_SLIP]    = "slip",
	[SFX_SPRING]  = "spring",
	[SFX_TIME]    = "time",
};

const char* data_bgm_files[] = {
	[BGMTITLE] = "bgmtitle",
	[BGM1]     = "bgm1",
	[BGM2]     = "bgm2",
	[BGM3]     = "bgm3",
};

const InputActionKey data_input_keyboard[] = {
	{ KEY_BACK,          (INPUT_PAUSE_TOUCH | INPUT_MENU_RETURN) },
	{ KEY_ESCAPE,        (INPUT_PAUSE | INPUT_MENU_RETURN)       },
	{ KEY_LEFT_CONTROL,  (INPUT_JUMP | INPUT_MENU_CONFIRM)       },
	{ KEY_RIGHT_CONTROL, (INPUT_JUMP | INPUT_MENU_CONFIRM)       },
	{ KEY_SPACE,         (INPUT_JUMP | INPUT_MENU_CONFIRM)       },
	{ KEY_ENTER,         (INPUT_MENU_CONFIRM)                    },
	{ KEY_UP,            (INPUT_UP | INPUT_JUMP)                 },
	{ KEY_DOWN,          (INPUT_DOWN)                            },
	{ KEY_LEFT,          (INPUT_LEFT)                            },
	{ KEY_RIGHT,         (INPUT_RIGHT)                           },
	{ KEY_W,             (INPUT_UP | INPUT_JUMP)                 },
	{ KEY_S,             (INPUT_DOWN)                            },
	{ KEY_A,             (INPUT_LEFT)                            },
	{ KEY_D,             (INPUT_RIGHT)                           },
	{ KEY_F9,            (INPUT_CFG_AUDIO_TOGGLE)                },
	{ -1,                (0)                                     },
};

const InputActionButton data_input_gamepad[] = {
	{ GAMEPAD_BUTTON_RIGHT_FACE_DOWN,   (INPUT_JUMP | INPUT_MENU_CONFIRM)  },
	{ GAMEPAD_BUTTON_RIGHT_FACE_RIGHT,  (INPUT_JUMP | INPUT_MENU_RETURN)   },
	{ GAMEPAD_BUTTON_RIGHT_FACE_LEFT,   (INPUT_JUMP | INPUT_MENU_RETURN)   },
	{ GAMEPAD_BUTTON_MIDDLE_RIGHT,      (INPUT_PAUSE | INPUT_MENU_CONFIRM) },
	{ GAMEPAD_BUTTON_LEFT_FACE_UP,      (INPUT_UP)                         },
	{ GAMEPAD_BUTTON_LEFT_FACE_DOWN,    (INPUT_DOWN)                       },
	{ GAMEPAD_BUTTON_LEFT_FACE_LEFT,    (INPUT_LEFT)                       },
	{ GAMEPAD_BUTTON_LEFT_FACE_RIGHT,   (INPUT_RIGHT)                      },
	{ -1,                               (0)                                },
};

//Raw RGB image (32x32 pixels; 32-bit RGBA)
unsigned char data_window_icon[] = {
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0xAA, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xFF, 0xAA, 0xAA, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xAA, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x55, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xFF, 0xAA, 0xAA, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0xFF, 0xFF,
	0x00, 0x00, 0xFF, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x00, 0x00, 0xAA, 0xFF,
	0x00, 0x00, 0x00, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0x00, 0x00, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0x00, 0x00, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
	0xAA, 0xAA, 0xAA, 0xFF,
};

