package com.github.libretube.api.obj

import android.content.Context
import android.os.Parcelable
import com.github.libretube.R
import com.github.libretube.db.obj.DownloadItem
import com.github.libretube.enums.FileType
import com.github.libretube.helpers.ProxyHelper
import kotlinx.parcelize.Parcelize
import kotlinx.serialization.Serializable
import kotlin.io.path.Path

@Serializable
@Parcelize
data class Subtitle(
    val url: String? = null,
    val mimeType: String? = null,
    val name: String? = null,
    val code: String? = null,
    val autoGenerated: Boolean? = null
): Parcelable {
    fun getDisplayName(context: Context) = if (autoGenerated != true) {
        name!!
    } else {
        "$name (${context.getString(R.string.auto_generated)})"
    }

    fun toDownloadItem(videoId: String) = DownloadItem(
        type = FileType.SUBTITLE,
        videoId = videoId,
        fileName = "${videoId}_${code}.srt",
        path = Path(""),
        url = url?.let { ProxyHelper.unwrapUrl(it) }
    )
}
