<!-- markdownlint-disable MD033 MD041 -->
<br/>
<p align="center">
  <a href="https://github.com/IamRezaMousavi/Mafia">
    <img src="./icon/foreground.svg" alt="Logo" width="200" height="200">
  </a>

  <h3 align="center">Mafia Party Game</h3>

  <p align="center">
    A Mafia party game app for Android using Clean Architecture, MVVM, Kotlin and View Binding Build with ❤️
    <br/>
    <br/>
    <a href="./docs/mafia-en.md"><strong>Explore the docs »</strong></a>
    <br/>
    <br/>
    <a href="https://github.com/IamRezaMousavi/Mafia/issues">Report Bug</a>
    .
    <a href="https://github.com/IamRezaMousavi/Mafia/issues">Request Feature</a>
  </p>
</p>
<!-- markdownlint-enable MD041 -->

![Downloads](https://img.shields.io/github/downloads/IamRezaMousavi/Mafia/total) ![Contributors](https://img.shields.io/github/contributors/IamRezaMousavi/Mafia?color=dark-green) ![Issues](https://img.shields.io/github/issues/IamRezaMousavi/Mafia) ![License](https://img.shields.io/github/license/IamRezaMousavi/Mafia)

<a href='https://github.com/IamRezaMousavi/Mafia/releases/latest'><img height=70 alt='Get it on GitHub' src='./assets/github.svg'/></a>
<a href='https://f-droid.org/packages/com.github.iamrezamousavi.mafia'><img height=70 alt="Get it on F-Droid" src='./assets/fdroid.svg'/></a>

## Table Of Contents

* [About the Project](#about-the-project)
* [Supported Language](#supported-languages)
* [Roadmap](#roadmap)
* [Contributing](#contributing)
* [License](#license)
* [Authors](#authors)

## About The Project

The Main Page | The Role Page | The Player Roles Dialog | The Role Dialog
--- | --- | --- | ---
![main-page](./fastlane/metadata/android/en-US/images/phoneScreenshots/1.png) | ![role-page](./fastlane/metadata/android/en-US/images/phoneScreenshots/2.png) | ![player-role-page](./fastlane/metadata/android/en-US/images/phoneScreenshots/3.png) | ![role-dialog](./fastlane/metadata/android/en-US/images/phoneScreenshots/4.png)

See full documentation: [English](./docs/mafia-en.md), [فارسی](./docs/mafia-fa.md)

**[Mafia](https://en.wikipedia.org/wiki/Mafia_(party_game))**, also known as **Werewolf**, is a Russian [social deduction game](https://en.wikipedia.org/wiki/Social_deduction_game) created by Dimitry Davidoff in 1986.
The game models a conflict between two groups:

* An informed minority (the mafiosi or the werewolves)
* An uninformed majority (the villagers)

At the start of the game, each player is secretly assigned a role affiliated with one of these teams.
The game has two alternating phases:

* Night-phase: during which those with night-killing-powers may covertly kill other players
* Day-phase: in which all surviving players debate and vote to eliminate a suspect

The game continues until a faction achieves its [win-condition](https://en.wikipedia.org/wiki/Win_condition):

* For the village, this usually means eliminating the evil minority
* While for the minority, this usually means reaching numerical parity with the village and eliminating any rival evil groups

## Supported Languages

* English
* Persian
* Spanish

The app automatically launches in Persian, but you can change the language anytime in the settings.

## Roadmap

See the [open issues](https://github.com/IamRezaMousavi/Mafia/issues) for a list of proposed features (and known issues).

## Contributing

Contributions are what make the open source community such an amazing place to be learn, inspire, and create. Any contributions you make are **greatly appreciated**.

* If you have suggestions for adding or removing projects, feel free to [open an issue](https://github.com/IamRezaMousavi/Mafia/issues/new) to discuss it, or directly create a pull request after you edit the *README.md* file with necessary changes.
* Please make sure you check your spelling and grammar.
* Create individual PR for each suggestion.
* Please also read through the [Code Of Conduct](https://github.com/IamRezaMousavi/Mafia/blob/main/CODE_OF_CONDUCT.md) before posting your first idea as well.

### Creating A Pull Request

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## License

Distributed under the GPL-3.0 License. See [LICENSE](https://github.com/IamRezaMousavi/Mafia/blob/master/LICENSE) for more information.

## Authors

* **Reza Mousavi** - *Comp Eng Student* - [Reza Mousavi](https://github.com/IamRezaMousavi/) - *Maintainer*

---
