# Mafia (party game)

[به فارسی ببینید](./mafia-fa.md)

**[Mafia](https://en.wikipedia.org/wiki/Mafia_(party_game))**, also known as **Werewolf**, is a Russian [social deduction game](https://en.wikipedia.org/wiki/Social_deduction_game) created by Dimitry Davidoff in 1986.
The game models a conflict between two groups:

* An informed minority (the mafiosi or the werewolves)
* An uninformed majority (the villagers)

At the start of the game, each player is secretly assigned a role affiliated with one of these teams.
The game has two alternating phases:

* **Night-phase**: during which those with night-killing-powers may covertly kill other players
* **Day-phase**: in which all surviving players debate and vote to eliminate a suspect

The game continues until a faction achieves its [win-condition](https://en.wikipedia.org/wiki/Win_condition):

* For the village, this usually means eliminating the evil minority
* While for the minority, this usually means reaching numerical parity with the village and eliminating any rival evil groups

---

## Gameplay

In its simplest form, Mafia is played by two teams: the mafiosi and the villagers. Live games require a moderator who does not participate as a player, and identities are assigned by handing out cards, or by other non-verbal methods such as physically tapping players. At the start of the game, every mafioso is given the identities of their teammates, whereas the innocents only receive the number of mafiosi in the game.

There are two phases: night and day. At night, certain players secretly perform special actions; during day, players discuss and vote to eliminate one player. These phases alternate with each other until all mafiosi have been eliminated or they reach numerical parity with the innocents.

Some players may be given roles with special abilities (see below). Common special roles include [an investigative role](#investigative-roles), [a protector role](#protective-roles), and [some association roles](#association-roles).

Andrew Plotkin recommends having exactly two mafiosi, whereas the original Davidoff rules suggest a third of the players (rounding to the nearest whole number) be mafiosi. Davidoff's original game does not include roles with special abilities. In his rules for "Werewolf", Plotkin recommends that the first phase be night and that there be an odd number of players (including the moderator). These specifications avoid tie votes for eliminations and ensure that the game will end dramatically on an elimination rather than anticlimactically with murder as a foregone conclusion.

### Night

Werewolves discussing whom to kill during the night

All players close their eyes. The moderator then instructs all mafiosi to open their eyes and acknowledge their accomplices. The mafiosi pick a "victim" by silently gesturing to indicate their target and to show [unanimity](https://en.wikipedia.org/wiki/Unanimity) then close their eyes again.

A similar process occurs for other roles with nightly actions. In the case of the seer, the moderator may indicate the target's innocence or guilt by using gestures such as nodding or head shaking. Night may be accompanied by players tapping gently to mask sounds made by gesturing.

### Day

During the "day" phase, players vote on whom to eliminate

The moderator instructs players to open their eyes and announces who "died" the previous night. Discussion ensues among the living players. At any point, a player may accuse someone of being a mafioso and prompt others to vote to eliminate them. If over half of the players do so, the accused person is eliminated and night begins. Otherwise, the phase continues until an elimination occurs.

According to some rules, the role of dead players should be revealed; according to others, for example, if the protector dies, nobody should know that. In both cases, dead players are not permitted to attempt to influence the remainder of the game.

Because players have more freedom to deliberate, days tend to be longer than nights.

---

## Optional roles

These additional roles are named differently in the many versions of Mafia, for [thematic flavor](https://en.wikipedia.org/wiki/Setting_(fiction)), or historical reasons. Also, the same role-name can have differing functions across different versions of the game. What follows is a general list of role types found in Mafia variants; since the specific names vary by milieu it must be non-exhaustive.

### Investigative roles

Players with these roles use their own night-phase to discover something about other players. Though the standard game now includes the basic Detective, these roles are optional, and games can exclude them entirely (such as the stool pigeon variant, or Davidoff's original rules).

#### Investigative roles (standard)

Detective, Seer, Commandant, Sheriff, Police, etc.

Allied with the Innocents, the Detective can detect whether a player is a mafioso. They will typically wake up, and point at one person; the Narrator will silently indicate to the Detective whether that player is Mafia or Innocent. In some versions of the game, the Detective's investigation result is announced publicly by the Narrator, for example the Detective found a Mafioso!. More commonly, no announcement is made. As with other roles, which player is the detective is not generally known, leaving anyone the option of pretending to be the Detective.

A Detective is usually included in modern games. For example, somebody is always assigned this role in all commercial card game versions, and almost all internet-based, and most face-to-face games start with at least one detective. Multiple detectives either act in separate night phases (unaware of the identities of other detectives) or work together as the police (an association role).

### Protective roles

Guardian Angel, Doctor, Bodyguard, Hero, Jailer, etc.

Allied with the Innocents, the Doctor-type role defends others at night. Typically, they will awaken at night after the Mafia have gone back to sleep and point at one person to protect; that person will survive any night-time attack. They are typically allowed to protect themselves, and are commonly barred from protecting the same target on successive nights. A Guardian Angel can only protect others. The Nurse gains the Doctor's abilities if the Doctor dies. The Jailer protects innocents just like the doctor, but also simultaneously blocks their night action. The Firefighter, or the Herbalist can protect from some night-time attacks but not others (in Werewolf, for example, they choose one person to protect with wolfsbane, but that person may still be killed by the Serial Killer). Other games limit this ability to a certain number of times.

### Association roles

Freemasons (Masons), Siblings, Lovers, Police, etc.

Possessors of these roles know one another and what their roles are. On the innocent's side, a Mason usually has no special abilities, but knows the identity of all other Masons and that all Masons are also innocent. Every member of the detectives or the police knows all the rest, because they collaborate at night to investigate someone (sharing the powers of the Detective role between them).
Sibling pairs typically consist of one Mafia and one Innocent; in most versions, if one is killed, the other also dies. Cupid in Werewolf chooses a pair of Lovers on the first night. In this variant, the Lovers can also win the game (regardless of whether they are Mafia, Innocents, or both) by being the last two standing. Like Siblings, however, if one of the pair dies, the other dies as well.

---

For more information, see [Wikipedia](https://en.wikipedia.org/wiki/Mafia_(party_game))
