/*
 * Gotify REST-API.
 * This is the documentation of the Gotify REST-API.  # Authentication In Gotify there are two token types: __clientToken__: a client is something that receives message and manages stuff like creating new tokens or delete messages. (f.ex this token should be used for an android app) __appToken__: an application is something that sends messages (f.ex. this token should be used for a shell script)  The token can be transmitted in a header named `X-Gotify-Key`, in a query parameter named `token` or through a header named `Authorization` with the value prefixed with `Bearer` (Ex. `Bearer randomtoken`). There is also the possibility to authenticate through basic auth, this should only be used for creating a clientToken.  \\---  Found a bug or have some questions? [Create an issue on GitHub](https://github.com/gotify/server/issues)
 *
 * OpenAPI spec version: 2.0.2
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.github.gotify.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * The Paging holds information about the limit and making requests to the next page.
 */
@Schema(description = "The Paging holds information about the limit and making requests to the next page.")


public class Paging {
  @SerializedName("limit")
  private Long limit = null;

  @SerializedName("next")
  private String next = null;

  @SerializedName("since")
  private Long since = null;

  @SerializedName("size")
  private Long size = null;

   /**
   * The limit of the messages for the current request.
   * minimum: 1
   * maximum: 200
   * @return limit
  **/
  @Schema(example = "123", required = true, description = "The limit of the messages for the current request.")
  public Long getLimit() {
    return limit;
  }

   /**
   * The request url for the next page. Empty/Null when no next page is available.
   * @return next
  **/
  @Schema(example = "http://example.com/message?limit=50&since=123456", description = "The request url for the next page. Empty/Null when no next page is available.")
  public String getNext() {
    return next;
  }

   /**
   * The ID of the last message returned in the current request. Use this as alternative to the next link.
   * minimum: 0
   * @return since
  **/
  @Schema(example = "5", required = true, description = "The ID of the last message returned in the current request. Use this as alternative to the next link.")
  public Long getSince() {
    return since;
  }

   /**
   * The amount of messages that got returned in the current request.
   * @return size
  **/
  @Schema(example = "5", required = true, description = "The amount of messages that got returned in the current request.")
  public Long getSize() {
    return size;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Paging paging = (Paging) o;
    return Objects.equals(this.limit, paging.limit) &&
        Objects.equals(this.next, paging.next) &&
        Objects.equals(this.since, paging.since) &&
        Objects.equals(this.size, paging.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(limit, next, since, size);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Paging {\n");
    
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    next: ").append(toIndentedString(next)).append("\n");
    sb.append("    since: ").append(toIndentedString(since)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
