/*
 * Gotify REST-API.
 * This is the documentation of the Gotify REST-API.  # Authentication In Gotify there are two token types: __clientToken__: a client is something that receives message and manages stuff like creating new tokens or delete messages. (f.ex this token should be used for an android app) __appToken__: an application is something that sends messages (f.ex. this token should be used for a shell script)  The token can be transmitted in a header named `X-Gotify-Key`, in a query parameter named `token` or through a header named `Authorization` with the value prefixed with `Bearer` (Ex. `Bearer randomtoken`). There is also the possibility to authenticate through basic auth, this should only be used for creating a clientToken.  \\---  Found a bug or have some questions? [Create an issue on GitHub](https://github.com/gotify/server/issues)
 *
 * OpenAPI spec version: 2.0.2
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.github.gotify.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.threeten.bp.OffsetDateTime;
/**
 * The MessageExternal holds information about a message which was sent by an Application.
 */
@Schema(description = "The MessageExternal holds information about a message which was sent by an Application.")


public class Message {
  @SerializedName("appid")
  private Long appid = null;

  @SerializedName("date")
  private OffsetDateTime date = null;

  @SerializedName("extras")
  private Map<String, Object> extras = null;

  @SerializedName("id")
  private Long id = null;

  @SerializedName("message")
  private String message = null;

  @SerializedName("priority")
  private Long priority = null;

  @SerializedName("title")
  private String title = null;

   /**
   * The application id that send this message.
   * @return appid
  **/
  @Schema(example = "5", required = true, description = "The application id that send this message.")
  public Long getAppid() {
    return appid;
  }

   /**
   * The date the message was created.
   * @return date
  **/
  @Schema(example = "2018-02-27T19:36:10.504504400+01:00", required = true, description = "The date the message was created.")
  public OffsetDateTime getDate() {
    return date;
  }

  public Message extras(Map<String, Object> extras) {
    this.extras = extras;
    return this;
  }

  public Message putExtrasItem(String key, Object extrasItem) {
    if (this.extras == null) {
      this.extras = new HashMap<String, Object>();
    }
    this.extras.put(key, extrasItem);
    return this;
  }

   /**
   * The extra data sent along the message.  The extra fields are stored in a key-value scheme. Only accepted in CreateMessage requests with application/json content-type.  The keys should be in the following format: &amp;lt;top-namespace&amp;gt;::[&amp;lt;sub-namespace&amp;gt;::]&amp;lt;action&amp;gt;  These namespaces are reserved and might be used in the official clients: gotify android ios web server client. Do not use them for other purposes.
   * @return extras
  **/
  @Schema(example = "{\"home::appliances::lighting::on\":{\"brightness\":15},\"home::appliances::thermostat::change_temperature\":{\"temperature\":23}}", description = "The extra data sent along the message.  The extra fields are stored in a key-value scheme. Only accepted in CreateMessage requests with application/json content-type.  The keys should be in the following format: &lt;top-namespace&gt;::[&lt;sub-namespace&gt;::]&lt;action&gt;  These namespaces are reserved and might be used in the official clients: gotify android ios web server client. Do not use them for other purposes.")
  public Map<String, Object> getExtras() {
    return extras;
  }

  public void setExtras(Map<String, Object> extras) {
    this.extras = extras;
  }

   /**
   * The message id.
   * @return id
  **/
  @Schema(example = "25", required = true, description = "The message id.")
  public Long getId() {
    return id;
  }

  public Message message(String message) {
    this.message = message;
    return this;
  }

   /**
   * The message. Markdown (excluding html) is allowed.
   * @return message
  **/
  @Schema(example = "**Backup** was successfully finished.", required = true, description = "The message. Markdown (excluding html) is allowed.")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public Message priority(Long priority) {
    this.priority = priority;
    return this;
  }

   /**
   * The priority of the message. If unset, then the default priority of the application will be used.
   * @return priority
  **/
  @Schema(example = "2", description = "The priority of the message. If unset, then the default priority of the application will be used.")
  public Long getPriority() {
    return priority;
  }

  public void setPriority(Long priority) {
    this.priority = priority;
  }

  public Message title(String title) {
    this.title = title;
    return this;
  }

   /**
   * The title of the message.
   * @return title
  **/
  @Schema(example = "Backup", description = "The title of the message.")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Message message = (Message) o;
    return Objects.equals(this.appid, message.appid) &&
        Objects.equals(this.date, message.date) &&
        Objects.equals(this.extras, message.extras) &&
        Objects.equals(this.id, message.id) &&
        Objects.equals(this.message, message.message) &&
        Objects.equals(this.priority, message.priority) &&
        Objects.equals(this.title, message.title);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appid, date, extras, id, message, priority, title);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Message {\n");
    
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    extras: ").append(toIndentedString(extras)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
