/*
 * Gotify REST-API.
 * This is the documentation of the Gotify REST-API.  # Authentication In Gotify there are two token types: __clientToken__: a client is something that receives message and manages stuff like creating new tokens or delete messages. (f.ex this token should be used for an android app) __appToken__: an application is something that sends messages (f.ex. this token should be used for a shell script)  The token can be transmitted in a header named `X-Gotify-Key`, in a query parameter named `token` or through a header named `Authorization` with the value prefixed with `Bearer` (Ex. `Bearer randomtoken`). There is also the possibility to authenticate through basic auth, this should only be used for creating a clientToken.  \\---  Found a bug or have some questions? [Create an issue on GitHub](https://github.com/gotify/server/issues)
 *
 * OpenAPI spec version: 2.0.2
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.github.gotify.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * Params allowed to create or update Applications.
 */
@Schema(description = "Params allowed to create or update Applications.")


public class ApplicationParams {
  @SerializedName("defaultPriority")
  private Long defaultPriority = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("name")
  private String name = null;

  public ApplicationParams defaultPriority(Long defaultPriority) {
    this.defaultPriority = defaultPriority;
    return this;
  }

   /**
   * The default priority of messages sent by this application. Defaults to 0.
   * @return defaultPriority
  **/
  @Schema(example = "5", description = "The default priority of messages sent by this application. Defaults to 0.")
  public Long getDefaultPriority() {
    return defaultPriority;
  }

  public void setDefaultPriority(Long defaultPriority) {
    this.defaultPriority = defaultPriority;
  }

  public ApplicationParams description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the application.
   * @return description
  **/
  @Schema(example = "Backup server for the interwebs", description = "The description of the application.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ApplicationParams name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The application name. This is how the application should be displayed to the user.
   * @return name
  **/
  @Schema(example = "Backup Server", required = true, description = "The application name. This is how the application should be displayed to the user.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationParams applicationParams = (ApplicationParams) o;
    return Objects.equals(this.defaultPriority, applicationParams.defaultPriority) &&
        Objects.equals(this.description, applicationParams.description) &&
        Objects.equals(this.name, applicationParams.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defaultPriority, description, name);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationParams {\n");
    
    sb.append("    defaultPriority: ").append(toIndentedString(defaultPriority)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
