/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.periodictable;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.ElementPTHandler;
import org.openscience.cdk.tools.periodictable.PeriodicTableElement;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.tools.periodictable.ElementPTReaderTest")
class ElementPTReader {
    private XMLReader parser;
    private Reader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ElementPTReader.class);

    @TestMethod(value="testReading")
    public ElementPTReader(Reader input) {
        this.init();
        this.input = input;
    }

    private void init() {
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                logger.info((Object)"Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (Exception exception) {
                logger.warn((Object)"Could not instantiate JAXP/SAX XML reader!");
                logger.debug((Object)exception);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                logger.info((Object)"Using Aelfred2 XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn((Object)"Could not instantiate Aelfred2 XML reader!");
                logger.debug((Object)e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                logger.info((Object)"Using Xerces XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn((Object)"Could not instantiate Xerces XML reader!");
                logger.debug((Object)e);
            }
        }
        if (!success) {
            logger.error((Object)"Could not instantiate any XML parser!");
        }
    }

    @TestMethod(value="testReading")
    public List<PeriodicTableElement> readElements() {
        ArrayList<PeriodicTableElement> elements = new ArrayList();
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.info((Object)"Deactivated validation");
        }
        catch (SAXException exception) {
            logger.warn((Object)"Cannot deactivate validation: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
        }
        ElementPTHandler handler = new ElementPTHandler();
        this.parser.setContentHandler(handler);
        try {
            this.parser.parse(new InputSource(this.input));
            elements = handler.getElements();
        }
        catch (IOException exception) {
            logger.error((Object)"IOException: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
        }
        catch (SAXException saxe) {
            logger.error((Object)"SAXException: ", new Object[]{saxe.getClass().getName()});
            logger.error((Object)saxe.getMessage());
            logger.debug((Object)saxe);
        }
        return elements;
    }
}

