/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.graph.AllCycles;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.EdgeShortCycles;
import org.openscience.cdk.graph.EssentialCycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.InitialCycles;
import org.openscience.cdk.graph.MinimumCycleBasis;
import org.openscience.cdk.graph.RelevantCycles;
import org.openscience.cdk.graph.TripletShortCycles;
import org.openscience.cdk.graph.VertexShortCycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.graph.CyclesTest")
public final class Cycles {
    private final int[][] paths;
    private final IAtomContainer container;

    private Cycles(int[][] paths, IAtomContainer container) {
        this.paths = paths;
        this.container = container;
    }

    @TestMethod(value="all,mcb,relevant,essential,tripletShort,vertexShort,edgeShort")
    public int numberOfCycles() {
        return this.paths.length;
    }

    @TestMethod(value="pathsAreCopy")
    public int[][] paths() {
        int[][] cpy = new int[this.paths.length][];
        for (int i = 0; i < this.paths.length; ++i) {
            cpy[i] = (int[])this.paths[i].clone();
        }
        return cpy;
    }

    @TestMethod(value="toRingSet")
    public IRingSet toRingSet() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)this.container.getBondCount());
        for (IBond bond : this.container.bonds()) {
            int u = this.container.getAtomNumber(bond.getAtom(0));
            int v = this.container.getAtomNumber(bond.getAtom(1));
            map.put(new InitialCycles.Edge(u, v), bond);
        }
        return Cycles.toRingSet(this.container, this.paths, map);
    }

    @TestMethod(value="all")
    public static CycleFinder all() {
        return CycleComputation.ALL;
    }

    @TestMethod(value="mcb")
    public static CycleFinder mcb() {
        return CycleComputation.MCB;
    }

    @TestMethod(value="relevant")
    public static CycleFinder relevant() {
        return CycleComputation.RELEVANT;
    }

    @TestMethod(value="essential")
    public static CycleFinder essential() {
        return CycleComputation.ESSENTIAL;
    }

    @TestMethod(value="tripletShort")
    public static CycleFinder tripletShort() {
        return CycleComputation.TRIPLET_SHORT;
    }

    @TestMethod(value="vertexShort")
    public static CycleFinder vertexShort() {
        return CycleComputation.VERTEX_SHORT;
    }

    @TestMethod(value="edgeShort")
    public static CycleFinder edgeShort() {
        return CycleComputation.EDGE_SHORT;
    }

    @TestMethod(value="all")
    public static Cycles all(IAtomContainer container) throws Intractable {
        return Cycles.all().find(container);
    }

    @TestMethod(value="mcb")
    public static Cycles mcb(IAtomContainer container) {
        return Cycles._invoke(Cycles.mcb(), container);
    }

    @TestMethod(value="mcb")
    public static Cycles sssr(IAtomContainer container) {
        return Cycles.mcb(container);
    }

    @TestMethod(value="relevant")
    public static Cycles relevant(IAtomContainer container) {
        return Cycles._invoke(Cycles.relevant(), container);
    }

    @TestMethod(value="essential")
    public static Cycles essential(IAtomContainer container) {
        return Cycles._invoke(Cycles.essential(), container);
    }

    @TestMethod(value="tripletShort")
    public static Cycles tripletShort(IAtomContainer container) {
        return Cycles._invoke(Cycles.tripletShort(), container);
    }

    @TestMethod(value="vertexShort")
    public static Cycles vertexShort(IAtomContainer container) {
        return Cycles._invoke(Cycles.vertexShort(), container);
    }

    @TestMethod(value="edgeShort")
    public static Cycles edgeShort(IAtomContainer container) {
        return Cycles._invoke(Cycles.edgeShort(), container);
    }

    private static Cycles _invoke(CycleFinder finder, IAtomContainer container) {
        try {
            return finder.find(container);
        }
        catch (Intractable e) {
            throw new RuntimeException("Cycle computation should not be intractable: ", e);
        }
    }

    private static int[] lift(int[] path, int[] mapping) {
        for (int i = 0; i < path.length; ++i) {
            path[i] = mapping[path[i]];
        }
        return path;
    }

    private static IRingSet toRingSet(IAtomContainer container, int[][] cycles, Map<InitialCycles.Edge, IBond> edgeMap) {
        IChemObjectBuilder builder = container.getBuilder();
        IRingSet rings = (IRingSet)builder.newInstance(IRingSet.class, new Object[0]);
        for (int[] cycle : cycles) {
            rings.addAtomContainer((IAtomContainer)Cycles.toRing(container, cycle, edgeMap));
        }
        return rings;
    }

    private static IRing toRing(IAtomContainer container, int[] cycle, Map<InitialCycles.Edge, IBond> edgeMap) {
        IAtom[] atoms = new IAtom[cycle.length - 1];
        IBond[] bonds = new IBond[cycle.length - 1];
        for (int i = 1; i < cycle.length; ++i) {
            int v = cycle[i];
            int u = cycle[i - 1];
            atoms[i - 1] = container.getAtom(u);
            bonds[i - 1] = edgeMap.get(new InitialCycles.Edge(u, v));
        }
        IChemObjectBuilder builder = container.getBuilder();
        IAtomContainer ring = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[]{0, 0, 0, 0});
        ring.setAtoms(atoms);
        ring.setBonds(bonds);
        return (IRing)builder.newInstance(IRing.class, new Object[]{ring});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CycleComputation implements CycleFinder
    {
        MCB{

            int[][] apply(int[][] graph) {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph);
                return new MinimumCycleBasis(ic).paths();
            }
        }
        ,
        ESSENTIAL{

            int[][] apply(int[][] graph) {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph);
                RelevantCycles rc = new RelevantCycles(ic);
                return new EssentialCycles(rc, ic).paths();
            }
        }
        ,
        RELEVANT{

            int[][] apply(int[][] graph) {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph);
                return new RelevantCycles(ic).paths();
            }
        }
        ,
        ALL{

            int[][] apply(int[][] graph) throws Intractable {
                int threshold = 684;
                AllCycles ac = new AllCycles(graph, graph.length, 684);
                if (!ac.completed()) {
                    throw new Intractable("A large number of cycles were being generated and the computation was aborted. Please us AllCycles/AllRingsFinder with and specify a larger threshold or an alternative cycle set.");
                }
                return ac.paths();
            }
        }
        ,
        TRIPLET_SHORT{

            int[][] apply(int[][] graph) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph);
                return new TripletShortCycles(new MinimumCycleBasis(ic), false).paths();
            }
        }
        ,
        VERTEX_SHORT{

            int[][] apply(int[][] graph) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph);
                return new VertexShortCycles(ic).paths();
            }
        }
        ,
        EDGE_SHORT{

            int[][] apply(int[][] graph) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph);
                return new EdgeShortCycles(ic).paths();
            }
        };


        abstract int[][] apply(int[][] var1) throws Intractable;

        @Override
        public Cycles find(IAtomContainer molecule) throws Intractable {
            int[][] graph = GraphUtil.toAdjList(molecule);
            RingSearch ringSearch = new RingSearch(molecule, graph);
            ArrayList<int[]> walks = new ArrayList<int[]>(6);
            for (int[] isolated : ringSearch.isolated()) {
                walks.add(GraphUtil.cycle(graph, isolated));
            }
            for (int[] fused : ringSearch.fused()) {
                for (int[] cycle : this.apply(GraphUtil.subgraph(graph, fused))) {
                    walks.add(Cycles.lift(cycle, fused));
                }
            }
            return new Cycles((int[][])walks.toArray((T[])new int[walks.size()][0]), molecule);
        }
    }
}

