package com.nutomic.syncthingandroid.model;

/**
 * Sources:
 * - https://github.com/syncthing/syncthing/tree/master/lib/config
 * - https://github.com/syncthing/syncthing/blob/master/lib/config/guiconfiguration.go
 */
public class Gui {
    public boolean enabled = true;

    /**
     * REST: useTLS
     * XML: tls
     */
    public boolean useTLS = false;

    public String address = "127.0.0.1:8384";
    public String user;
    public String password;
    public String apiKey;                           // Automatically generated by SyncthingNative

    /**
     * Available: default, dark, black
     */
    public String theme = "default";

    // omitEmpty
    public boolean insecureAdminAccess = false;
    public boolean insecureAllowFrameLoading = false;
    public boolean insecureSkipHostCheck = false;

    public String getBindAddress() {
        if (address == null) {
            return "";
        }
        String[] split = address.split(":");
        return split.length < 1 ? "" : split[0];
    }

    public String getBindPort() {
        if (address == null) {
            return "";
        }
        String[] split = address.split(":");
        return split.length < 2 ? "" : split[1];
    }
}
