# 🌿 Contributing to Leafpad

Thank you for your interest in contributing to Leafpad!  
Whether you're fixing a bug, improving the UI, writing documentation, or suggesting a new idea — you're very welcome here.

This guide will help you get started and make the process smooth for everyone.

---

## 🤝 General Guidelines

- **Be respectful and kind** in discussions and reviews.
- **Use clear and constructive communication.**
- **You don’t need to be an expert** — beginners are welcome!
- Try to keep contributions **focused** and **well-tested.**
- Respect the project’s **structure, style, and goals.**

---

## 🛠️ Code Contributions

### 📁 Project Structure

Leafpad follows the MVVM pattern, uses Material3 components, and is written in Java. Please:
- Avoid introducing Kotlin unless discussed
- Use proper naming conventions
- Keep logic out of the UI layer whenever possible

### ✅ When You Contribute

- Stick to one **feature or fix per branch/PR**
- Test your changes on a real device or emulator
- Ensure your code builds cleanly and doesn’t break existing functionality
- Follow existing code style and conventions

---

## 📝 Non-Code Contributions

All help is welcome:
- Translating the app
- Improving icons or colors
- Enhancing documentation
- Reporting bugs or proposing features

Please keep accessibility and simplicity in mind.

---

## 🔀 Pull Request Guidelines

Pull Requests (PRs) are the best way to propose changes.  
To keep the process smooth:

### Before You Open a PR

- **Update your branch:**
  ```bash
  git checkout development
  git pull origin development
  git checkout your-feature-branch
  git rebase development
