// Copyright 2014 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';

void main() {
  testWidgets('test', (WidgetTester tester) async {
    await tester.pumpWidget(
      const Directionality(
        textDirection: TextDirection.ltr,
        child: Text('label', semanticsLabel: 'semantics label'),
      ),
    );

    expect(
      tester.getSemantics(find.text('label')),
      containsSemantics(label: 'semantics label'),
    );
  });
}
