// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef FLUTTER_SHELL_COMMON_SERIALIZATION_CALLBACKS_H_
#define FLUTTER_SHELL_COMMON_SERIALIZATION_CALLBACKS_H_

#include "flutter/fml/logging.h"
#include "third_party/skia/include/core/SkImage.h"
#include "third_party/skia/include/core/SkSerialProcs.h"
#include "third_party/skia/include/core/SkStream.h"
#include "third_party/skia/include/core/SkTypeface.h"

namespace flutter {

SkSerialReturnType SerializeTypefaceWithoutData(SkTypeface* typeface,
                                                void* ctx);
SkSerialReturnType SerializeTypefaceWithData(SkTypeface* typeface, void* ctx);
sk_sp<SkTypeface> DeserializeTypefaceWithoutData(SkStream&, void* ctx);

// Serializes only the metadata of the image and not the underlying pixel data.
SkSerialReturnType SerializeImageWithoutData(SkImage* image, void* ctx);
sk_sp<SkImage> DeserializeImageWithoutData(const void* data,
                                           size_t length,
                                           void* ctx);

}  // namespace flutter

#endif  // FLUTTER_SHELL_COMMON_SERIALIZATION_CALLBACKS_H_
