// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include <impeller/types.glsl>

uniform FrameInfo {
  mat4 mvp;
}
frame_info;

in vec2 position;
in float gaussian;

out float16_t v_gaussian;

void main() {
  gl_Position = frame_info.mvp * vec4(position, 0.0, 1.0);
  v_gaussian = float16_t(gaussian);
}
