export default {
	focusEditor: {
		description: "Focus editor",
		key: "Ctrl-1",
		readOnly: false,
	},
	copy: {
		description: "Copy",
		key: "Ctrl-C",
		readOnly: true,
		editorOnly: true,
	},
	cut: {
		description: "Cut",
		key: "Ctrl-X",
		readOnly: false,
		editorOnly: true,
	},
	paste: {
		description: "Paste",
		key: "Ctrl-V",
		readOnly: false,
		editorOnly: true,
	},
	findFile: {
		description: "Find a file",
		key: "Ctrl-P",
		action: "find-file",
	},
	closeCurrentTab: {
		description: "Close current tab.",
		key: "Ctrl-Q",
		readOnly: false,
		action: "close-current-tab",
	},
	closeAllTabs: {
		description: "Close all tabs.",
		key: "Ctrl-Shift-Q",
		readOnly: false,
		action: "close-all-tabs",
	},
	newFile: {
		description: "Create new file",
		key: "Ctrl-N",
		readOnly: true,
		action: "new-file",
	},
	openFile: {
		description: "Open a file",
		key: "Ctrl-O",
		readOnly: true,
		action: "open-file",
	},
	openFolder: {
		description: "Open a folder",
		key: "Ctrl-Shift-O",
		readOnly: true,
		action: "open-folder",
	},
	saveFile: {
		description: "Save current file",
		key: "Ctrl-S",
		readOnly: true,
		action: "save",
		editorOnly: true,
	},
	saveFileAs: {
		description: "Save as current file",
		key: "Ctrl-Shift-S",
		readOnly: true,
		action: "save-as",
		editorOnly: true,
	},
	nextFile: {
		description: "Open next file tab",
		key: "Ctrl-Tab",
		readOnly: true,
		action: "next-file",
	},
	prevFile: {
		description: "Open previous file tab",
		key: "Ctrl-Shift-Tab",
		readOnly: true,
		action: "prev-file",
	},
	renameFile: {
		description: "Rename current file",
		key: "F2",
		readOnly: true,
		action: "rename",
		editorOnly: true,
	},
	run: {
		description: "Run current file",
		key: "F5",
		readOnly: false,
		action: "run",
		editorOnly: true,
	},
	selectWord: {
		description: "Select current word",
		key: "Ctrl-D",
		readOnly: false,
		action: "select-word",
		editorOnly: true,
	},
	autoindent: {
		key: null,
		description: "Auto indentation",
		readOnly: false,
	},
	showSettingsMenu: {
		key: "Ctrl-,",
		description: "Show settings menu",
		readOnly: false,
	},
	toggleFullscreen: {
		key: "F11",
		description: "Toggle full screen mode",
		readOnly: false,
		action: "toggle-fullscreen",
	},
	toggleSidebar: {
		key: "Ctrl-B",
		description: "Toggle sidebar",
		readOnly: true,
		action: "toggle-sidebar",
	},
	toggleMenu: {
		key: "F3",
		description: "Toggle edit menu",
		readOnly: true,
		action: "toggle-menu",
	},
	toggleEditMenu: {
		key: "F4",
		description: "Toggle edit menu",
		readOnly: true,
		action: "toggle-editmenu",
	},
	goToNextError: {
		key: "Alt-E",
		description: "Go to next error",
		readOnly: false,
		editorOnly: true,
	},
	goToPreviousError: {
		key: "Alt-Shift-E",
		description: "Go to previous error",
		readOnly: false,
		editorOnly: true,
	},
	selectall: {
		description: "Select all",
		key: "Ctrl-A",
		readOnly: true,
		editorOnly: true,
	},
	centerselection: {
		description: "Center selection",
		key: null,
		readOnly: false,
	},
	gotoline: {
		description: "Go to line...",
		key: "Ctrl-G",
		readOnly: true,
		editorOnly: true,
	},
	fold: {
		description: "Fold",
		key: "Alt-L|Ctrl-F1",
		readOnly: false,
		editorOnly: true,
	},
	unfold: {
		description: "Unfold",
		key: "Alt-Shift-L|Ctrl-Shift-F1",
		readOnly: false,
		editorOnly: true,
	},
	toggleFoldWidget: {
		key: null,
		readOnly: false,
		editorOnly: true,
	},
	toggleParentFoldWidget: {
		key: "Alt-F2",
		readOnly: false,
		editorOnly: true,
	},
	foldall: {
		description: "Fold all",
		key: null,
		readOnly: false,
		editorOnly: true,
	},
	foldOther: {
		description: "Fold other",
		key: "Alt-0",
		readOnly: false,
		editorOnly: true,
	},
	unfoldall: {
		description: "Unfold all",
		key: "Alt-Shift-0",
		readOnly: false,
		editorOnly: true,
	},
	findnext: {
		description: "Find next",
		key: "Ctrl-K",
		readOnly: false,
	},
	findprevious: {
		description: "Find previous",
		key: "Ctrl-Shift-X",
		readOnly: false,
	},
	selectOrFindNext: {
		description: "Select or find next",
		key: "Alt-K",
		readOnly: false,
	},
	selectOrFindPrevious: {
		description: "Select or find previous",
		key: "Alt-Shift-K",
		readOnly: false,
	},
	find: {
		description: "Find",
		key: "Ctrl-F",
		readOnly: true,
		editorOnly: true,
	},
	overwrite: {
		description: "Overwrite",
		key: "Insert",
		readOnly: true,
	},
	selecttostart: {
		description: "Select to start",
		key: "Ctrl-Shift-Home",
		readOnly: true,
		editorOnly: true,
	},
	gotostart: {
		description: "Go to start",
		key: "Ctrl-Home",
		readOnly: true,
		editorOnly: true,
	},
	selectup: {
		description: "Select up",
		key: "Shift-Up",
		readOnly: true,
		editorOnly: true,
	},
	golineup: {
		description: "Go line up",
		key: "Up",
		readOnly: true,
		editorOnly: true,
	},
	selecttoend: {
		description: "Select to end",
		key: "Ctrl-Shift-End",
		readOnly: true,
		editorOnly: true,
	},
	gotoend: {
		description: "Go to end",
		key: "Ctrl-End",
		readOnly: true,
		editorOnly: true,
	},
	selectdown: {
		description: "Select down",
		key: "Shift-Down",
		readOnly: true,
		editorOnly: true,
	},
	golinedown: {
		description: "Go line down",
		key: "Down",
		readOnly: true,
		editorOnly: true,
	},
	selectwordleft: {
		description: "Select word left",
		key: "Ctrl-Shift-Left",
		readOnly: true,
		editorOnly: true,
	},
	gotowordleft: {
		description: "Go to word left",
		key: "Ctrl-Left",
		readOnly: true,
		editorOnly: true,
	},
	selecttolinestart: {
		description: "Select to line start",
		key: "Alt-Shift-Left",
		readOnly: true,
		editorOnly: true,
	},
	gotolinestart: {
		description: "Go to line start",
		key: "Alt-Left|Home",
		readOnly: true,
		editorOnly: true,
	},
	selectleft: {
		description: "Select left",
		key: "Shift-Left",
		readOnly: true,
		editorOnly: true,
	},
	gotoleft: {
		description: "Go to left",
		key: "Left",
		readOnly: true,
		editorOnly: true,
	},
	selectwordright: {
		description: "Select word right",
		key: "Ctrl-Shift-Right",
		readOnly: true,
		editorOnly: true,
	},
	gotowordright: {
		description: "Go to word right",
		key: "Ctrl-Right",
		readOnly: true,
		editorOnly: true,
	},
	selecttolineend: {
		description: "Select to line end",
		key: "Alt-Shift-Right",
		readOnly: true,
		editorOnly: true,
	},
	gotolineend: {
		description: "Go to line end",
		key: "Alt-Right|End",
		readOnly: true,
		editorOnly: true,
	},
	selectright: {
		description: "Select right",
		key: "Shift-Right",
		readOnly: true,
		editorOnly: true,
	},
	gotoright: {
		description: "Go to right",
		key: "Right",
		readOnly: true,
		editorOnly: true,
	},
	selectpagedown: {
		description: "Select page down",
		key: "Shift-PageDown",
		readOnly: true,
		editorOnly: true,
	},
	pagedown: {
		description: "Page down",
		key: null,
		readOnly: true,
		editorOnly: true,
	},
	gotopagedown: {
		description: "Go to page down",
		key: "PageDown",
		readOnly: false,
		editorOnly: true,
	},
	selectpageup: {
		description: "Select page up",
		key: "Shift-PageUp",
		readOnly: true,
		editorOnly: true,
	},
	pageup: {
		description: "Page up",
		key: null,
		readOnly: false,
		editorOnly: true,
	},
	problems: {
		description: "Show problems",
		key: "Ctrl-Shift-K",
		readOnly: true,
		editorOnly: true,
	},
	gotopageup: {
		description: "Go to page up",
		key: "PageUp",
		readOnly: true,
		editorOnly: true,
	},
	scrollup: {
		description: "Scroll up",
		key: "Ctrl-Up",
		readOnly: true,
		editorOnly: true,
	},
	scrolldown: {
		description: "Scroll down",
		key: "Ctrl-Down",
		readOnly: true,
		editorOnly: true,
	},
	selectlinestart: {
		description: "Select line start",
		key: "Shift-Home",
		readOnly: true,
		editorOnly: true,
	},
	selectlineend: {
		description: "Select line end",
		key: "Shift-End",
		readOnly: true,
		editorOnly: true,
	},
	togglerecording: {
		description: "Toggle recording",
		key: "Ctrl-Alt-E",
		readOnly: true,
		editorOnly: true,
	},
	formatcode: {
		description: "Format Code",
		key: "Ctrl-Alt-F",
		readOnly: false,
		editorOnly: true,
		action: "format",
	},
	replaymacro: {
		description: "Replay macro",
		key: "Ctrl-Shift-E",
		readOnly: true,
		editorOnly: true,
	},
	jumptomatching: {
		description: "Jump to matching",
		key: "Ctrl-\\",
		readOnly: true,
		editorOnly: true,
	},
	selecttomatching: {
		description: "Select to matching",
		key: "Ctrl-Shift-\\",
		readOnly: false,
		editorOnly: true,
	},
	expandToMatching: {
		description: "Expand to matching",
		key: "Ctrl-Shift-M",
		readOnly: false,
		editorOnly: true,
	},
	removeline: {
		description: "Remove line",
		key: null,
		readOnly: false,
		editorOnly: true,
	},
	duplicateSelection: {
		description: "Duplicate selection",
		key: "Ctrl-Shift-D",
		readOnly: false,
		editorOnly: true,
	},
	sortlines: {
		description: "Sort lines",
		key: "Ctrl-Alt-S",
		readOnly: false,
		editorOnly: true,
	},
	togglecomment: {
		description: "Toggle comment",
		key: "Ctrl-/",
		readOnly: false,
		editorOnly: true,
	},
	toggleBlockComment: {
		description: "Toggle block comment",
		key: "Ctrl-Shift-/",
		readOnly: false,
		editorOnly: true,
	},
	modifyNumberUp: {
		description: "Modify number up",
		key: "Ctrl-Shift-Up",
		readOnly: false,
		editorOnly: true,
	},
	modifyNumberDown: {
		description: "Modify number down",
		key: "Ctrl-Shift-Down",
		readOnly: false,
		editorOnly: true,
	},
	replace: {
		description: "Replace",
		key: "Ctrl-R",
		readOnly: false,
		editorOnly: true,
	},
	undo: {
		description: "Undo",
		key: "Ctrl-Z",
		readOnly: false,
		editorOnly: true,
	},
	redo: {
		description: "Redo",
		key: "Ctrl-Shift-Z|Ctrl-Y",
		readOnly: false,
		editorOnly: true,
	},
	copylinesup: {
		description: "Copy lines up",
		key: "Alt-Shift-Up",
		readOnly: false,
		editorOnly: true,
	},
	movelinesup: {
		description: "Move lines up",
		key: "Alt-Up",
		readOnly: false,
		editorOnly: true,
	},
	copylinesdown: {
		description: "Copy lines down",
		key: "Alt-Shift-Down",
		readOnly: false,
		editorOnly: true,
	},
	movelinesdown: {
		description: "Move lines down",
		key: "Alt-Down",
		readOnly: false,
		editorOnly: true,
	},
	del: {
		description: "Delete",
		key: "Delete",
		readOnly: true,
		editorOnly: true,
	},
	backspace: {
		description: "Backspace",
		key: "Shift-Backspace|Backspace",
		readOnly: false,
		editorOnly: true,
	},
	cut_or_delete: {
		description: "Cut or delete",
		key: "Shift-Delete",
		readOnly: false,
		editorOnly: true,
	},
	removetolinestart: {
		description: "Remove to line start",
		key: "Alt-Backspace",
		readOnly: false,
		editorOnly: true,
	},
	removetolineend: {
		description: "Remove to line end",
		key: "Alt-Delete",
		readOnly: false,
		editorOnly: true,
	},
	removetolinestarthard: {
		description: "Remove to line start hard",
		key: "Ctrl-Shift-Backspace",
		readOnly: false,
		editorOnly: true,
	},
	removetolineendhard: {
		description: "Remove to line end hard",
		key: "Ctrl-Shift-Delete",
		readOnly: false,
		editorOnly: true,
	},
	removewordleft: {
		description: "Remove word left",
		key: "Ctrl-Backspace",
		readOnly: false,
		editorOnly: true,
	},
	removewordright: {
		description: "Remove word right",
		key: "Ctrl-Delete",
		readOnly: false,
		editorOnly: true,
	},
	outdent: {
		description: "Outdent",
		key: "Shift-Tab",
		readOnly: false,
		editorOnly: true,
	},
	indent: {
		description: "Indent",
		key: "Tab",
		readOnly: true,
		editorOnly: true,
	},
	blockoutdent: {
		description: "Block outdent",
		key: "Ctrl-[",
		readOnly: false,
		editorOnly: true,
	},
	blockindent: {
		description: "Block indent",
		key: "Ctrl-]",
		readOnly: false,
		editorOnly: true,
	},
	splitline: {
		description: "Split line",
		key: null,
		readOnly: false,
		editorOnly: true,
	},
	transposeletters: {
		description: "Transpose letters",
		key: "Alt-Shift-X",
		readOnly: false,
		editorOnly: true,
	},
	touppercase: {
		description: "To uppercase",
		key: "Ctrl-U",
		readOnly: false,
		editorOnly: true,
	},
	tolowercase: {
		description: "To lowercase",
		key: "Ctrl-Shift-U",
		readOnly: false,
		editorOnly: true,
	},
	expandtoline: {
		description: "Expand to line",
		key: "Ctrl-Shift-L",
		readOnly: true,
		editorOnly: true,
	},
	joinlines: {
		description: "Join lines",
		key: null,
		readOnly: false,
		editorOnly: true,
	},
	invertSelection: {
		description: "Invert selection",
		key: null,
		readOnly: false,
		editorOnly: true,
	},
	openCommandPalette: {
		description: "Open command palette",
		key: "Ctrl-Shift-P",
		readOnly: true,
	},
	modeSelect: {
		description: "Change language mode",
		key: "Ctrl-M",
		readOnly: false,
		editorOnly: true,
	},
	increaseFontSize: {
		description: "Increase font size",
		key: "Ctrl-+|Ctrl-=",
		editorOnly: true,
	},
	decreaseFontSize: {
		description: "Decrease font size",
		key: "Ctrl+-|Ctrl-_",
		editorOnly: true,
	},
	resetFontSize: {
		description: "Reset font size",
		key: "Ctrl+0|Ctrl-Numpad0",
		editorOnly: true,
	},
	openTerminal: {
		description: "Open Terminal",
		key: "Ctrl-`",
		readOnly: true,
		action: "new-terminal",
	},
	"run-tests": {
		description: "Run Tests",
		key: "Ctrl-Shift-T",
		readOnly: true,
		action: "run-tests",
	},
	"dev:toggleDevTools": {
		description: "Toggle DevTools",
		key: "Ctrl-Shift-I",
		readOnly: true,
		action: "toggle-inspector",
	},
};
