import ajax from "@deadlyjack/ajax";
import fsOperation from "../fileSystem";
import Url from "../utils/Url";

export default async function checkPluginsUpdate() {
	const plugins = await fsOperation(PLUGIN_DIR).lsDir();
	const promises = [];
	const updates = [];

	plugins.forEach((pluginDir) => {
		promises.push(
			(async () => {
				const plugin = await fsOperation(
					Url.join(pluginDir.url, "plugin.json"),
				).readFile("json");

				const res = await ajax({
					url: `https://acode.app/api/plugin/check-update/${plugin.id}/${plugin.version}`,
				});

				if (res.update) {
					updates.push(plugin.id);
				}
			})(),
		);
	});

	await Promise.allSettled(promises);
	return updates;
}
