# Change Log

## v1.11.8 (967) 

### Features
* feat: add acode cli by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1768
* feat: Add FileTree component with virtual scrolling by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1774
* feat(welcome): add welcome tab for first-time users by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1783
* feat: Add visibility toggle for quicktools toggler on terminal input by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1766
* feat: Add smart path shortening to terminal prompt by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1767
* feat(settings): add option to preserve original item order by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1772
* feat: add "Open in Terminal" option to folder context menu by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1809
* feat: add proper fallback and saf uri handling for ischeck by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1814
* feat: extensionless URL resolution in preview server by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1824
* feat: improve DevContainer and Docker support for easier dev setup by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1823
* feat: add eruda devtools for debugging by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1831
* feat: Refactor li-icon set and add new icon by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1759
* feat: Enhance `addIcon` to support svg currentColor by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1760
* feat: Offload file change detection to background thread by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1802
* feat: move service to background by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1754
* feat: add quiet hours for ads by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1779
* feat(auth): move authentication to native Android plugin with encrypted storage by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1794
* feat: do not close milestone issues by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1799
* feat: close search dialog with ctrl+f by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1807
* feat: added executor tests by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1816
* Added tests by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1813
* CustomTabs web api for plugins by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1785
* Implement plugin loading callbacks and tracking for installed plugins by @7HR4IZ3 in https://github.com/Acode-Foundation/Acode/pull/1558
* Added Documents viewer plugin id to load pdf/excel/csv etc. files by @hackesofice in https://github.com/Acode-Foundation/Acode/pull/1833
* Refactor quicktools settings by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1761

### Fixes
* fix: use correct timezone by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1716
* fix: sanitize plugin readme before rendering by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1731
* fix: make rm wrapper silent by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1727
* fix: remove duplicate rm command by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1732
* fix: sidebar app icon size and scrolling by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1733
* fix: terminal bug by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1741
* fix: sidebar apps active and removal things with fallback by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1749
* fix: improve the backup and restore by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1744
* fix: console by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1763
* fix(terminal): cleanup broken tabs and show alerts on terminal errors by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1780
* fix(plugin): sanitize markdown and prevent horizontal overflow by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1782
* fix: run current File not respecting `preview mode` option. by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1805
* fix: memory leak when toggling search panel by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1808
* fix: prevent mixed content in SFTP/FTP cached files by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1815
* Fix: Remove trimming of matched content in Executor.js by @dikidjatar in https://github.com/Acode-Foundation/Acode/pull/1798
* revert: relative http paths by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1743

### Chore & CI
* Add F-droid Build in GH nightly releases by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1719
* fix(CI): normal nightly & fdroid flavor build paths. by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1722
* Update devcontainer.json and add Dependabot for devcontainer's version updates by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1742
* enhance nightly build workflow by adding a step to generate release notes by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1747
* chore: update nightly build workflow to use a fine-grained GITHUB_TOKEN for generating nightly release notes by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1751
* chore: message type detection in release notes script by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1786
* update(sftp): dependencies for SFTP plugin by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1792
* chore(deps): bump tmp and cordova by @dependabot[bot] in https://github.com/Acode-Foundation/Acode/pull/1720
* chore(deps): bump tough-cookie and cordova by @dependabot[bot] in https://github.com/Acode-Foundation/Acode/pull/1721
* chore(deps): bump systeminformation from 5.27.11 to 5.27.14 by @dependabot[bot] in https://github.com/Acode-Foundation/Acode/pull/1750
* chore(deps): bump tar from 7.5.2 to 7.5.3 by @dependabot[bot] in https://github.com/Acode-Foundation/Acode/pull/1829

### Translations & i18n
* `pl-pl.json` by @andrewczm in https://github.com/Acode-Foundation/Acode/pull/1709
* `de-de.json` by @Mr-Update in https://github.com/Acode-Foundation/Acode/pull/1714, https://github.com/Acode-Foundation/Acode/pull/1764
* `cs-cz.json` by @Amereyeu in https://github.com/Acode-Foundation/Acode/pull/1752, https://github.com/Acode-Foundation/Acode/pull/1828
* `hu-hu.json` by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1755, https://github.com/Acode-Foundation/Acode/pull/1762, https://github.com/Acode-Foundation/Acode/pull/1787, https://github.com/Acode-Foundation/Acode/pull/1810, https://github.com/Acode-Foundation/Acode/pull/1834
* `zh-cn.json`, `zh-hant.json` by @LaunchLee in https://github.com/Acode-Foundation/Acode/pull/1769
* `pt-br.json` by @sebastianjnuwu in https://github.com/Acode-Foundation/Acode/pull/1775
* `uk-ua.json` by @PavloPogonets in https://github.com/Acode-Foundation/Acode/pull/1818, https://github.com/Acode-Foundation/Acode/pull/1821

## v1.11.7 (966) 

* revert: sidebar/style.scss changes to fix collapse folders by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1572
* Terminal Service by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1570
* fix(i18n): fix typo in ./src/lang/id-id.json by @hyperz111 in https://github.com/Acode-Foundation/Acode/pull/1577
* fix: browser download by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1587
* Terminal initrc support by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1590
* chore(i18n): update de-de.json by @Mr-Update in https://github.com/Acode-Foundation/Acode/pull/1600
* Updated & Added Missing ar-ye.json (Arabic) translations by @Hussain96o in https://github.com/Acode-Foundation/Acode/pull/1601
* Restore terminal tabs  by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1592
  - fix: terminal font issue
  - Breaking change: Changed default terminal configs
* feat: service on/off by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1602
* fix: service stop on app exit by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1603
* fix: ED25519 SSH keys not working by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1595
* CI: Nightly Builds by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1612
* style(terminal): Some touch selection handle enhancements by @peasneovoyager2banana2 in https://github.com/Acode-Foundation/Acode/pull/1611
* fix: pip by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1617
* feat: Enable all file access in nightly builds by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1618
* Add support for renaming documents in provider by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1619
* fix: support for Acode terminal SAF URIs by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1621
* fix: rm command by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1623
* feat: add 'check for app updates' setting to toggle the automatic behaviour by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1624
* chore(i18n): update hu-hu.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1626
* Enforce Unix lf endings for shell scripts by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1637
* AutoSuggest install command in terminal by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1638
* feat: add plugin filtering by author and keywords by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1625
  - Refactored filtering logic to support multi-page results and improved UI feedback for filter actions.
* Translation: Update hu-hu.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1640
* fix: init-alpine by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1641
* fix: ANSI escape sequence in init-alpine by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1643
* chore(i18n): update de-de.json by @Mr-Update in https://github.com/Acode-Foundation/Acode/pull/1648
* fix: update proot binaries to support 16kb page size by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1649
* chore(i18n): update id-id.json with new strings by @hyperz111 in https://github.com/Acode-Foundation/Acode/pull/1650
* Translation: Update hu-Hu.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1653
* Add confirmation prompt before closing terminal tabs by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1655
* fix: compatibility for old android versions by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1656
* fix: improve file sharing and URI handling by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1662
  - Improved file sharing and fixed permission issue (also in case of open with , edit with)
* fix: do not restore terminals if axs is dead by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1664
* fix: .capitalize() removed because it changes the translations (also English) by @Mr-Update in https://github.com/Acode-Foundation/Acode/pull/1665
* fix: `switchFile` api to respect custom subtitle by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1672
* Update zh-cn.json and zh-hant.json by @LaunchLee in https://github.com/Acode-Foundation/Acode/pull/1674
* fix: Translation corrected in terminal settings by @Mr-Update in https://github.com/Acode-Foundation/Acode/pull/1676
* fix: Added missing translation for info window in file browser and app settings. by @Mr-Update in https://github.com/Acode-Foundation/Acode/pull/1677
* Translation: Update hungarian hu-HU.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1680
* Update ads plugin and fix some issues of free version by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1683
  - fix: system them on free version
* fix: restore folds when formatting if available by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1682
* fix: Added missing translation for info window in terminal settings by @Mr-Update in https://github.com/Acode-Foundation/Acode/pull/1681
* Translation: Update hungarian hu-hu.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1687
* feat: Add clean install state functionality to app settings by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1690
* Translation: Update hungarian hu-hu.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1693


## v1.11.6 (965)

* fix: Terminal in F-Droid flavour by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1478
* feat: update target SDK to API 35 and fix edge-to-edge compatibility by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1486
* improve German translation by @brian200508 in https://github.com/Acode-Foundation/Acode/pull/1487
* Translation: Update hu-hu.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1489
* chore(update IAP library to lateset version) by @deadlyjack in https://github.com/Acode-Foundation/Acode/pull/1405
* feat: font manager ui for managing custom fonts by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1491
* feat: add package updated time display on plugin page by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1494
* chore: update id-id.json by @hyperz111 in https://github.com/Acode-Foundation/Acode/pull/1495
* fix: document provider by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1497
* feat(sponsor page) by @deadlyjack in https://github.com/Acode-Foundation/Acode/pull/1496
* fix: load custom fonts on restart by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1499
* Update hu-hu.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1498
* fix: resolve GitHub URI preview issues in server by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1501
* fix: plugins page scrolling by @deadlyjack in https://github.com/Acode-Foundation/Acode/pull/1505
* [chore] bump workflow dependencies to latest versions by @Jvr2022 in https://github.com/Acode-Foundation/Acode/pull/1506
* fix: load base app stylesheet in custom editor tab by @deadlyjack in https://github.com/Acode-Foundation/Acode/pull/1507
* update src/lang/pt-br.json by @sebastianjnuwu in https://github.com/Acode-Foundation/Acode/pull/1510
* Add code formatter keybind by @UnschooledGamer in https://github.com/Acode-Foundation/Acode/pull/1511
* Added hyphen in quicktools and more strings for i18n by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1516
* chore(i18n): update id-id.json with new strings by @hyperz111 in https://github.com/Acode-Foundation/Acode/pull/1521
* chore(i18n): update hu-hu.json with new strings by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1520
* Add/Update Bengali (bn-BD) Translation File by @thebadhonbiswas in https://github.com/Acode-Foundation/Acode/pull/1522
* feat: take confirmation before uninstalling terminal by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1528
* fix ui issue by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1527
* fix: disable changing editor theme when system is selected by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1529
* fix: svg render issue by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1530
* fix: encoding detection by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1533
* fix: big screen ui and global search worker issue by @deadlyjack in https://github.com/Acode-Foundation/Acode/pull/1534
* fix: improved terminal mounts by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1537
* chore(i18n): refine Russian (ru-ru.json) localization with updated and new strings by @Nein-Ich-wurde-Gewinnen in https://github.com/Acode-Foundation/Acode/pull/1541
* Fixed Plugin installation issues(in some cases) by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1546
* feat: add option to auto detect encoding by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1547
* fix: ftp infinite loading by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1552
* fix: tab active state when switching tab with api by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1557
* fix: resize of terminal and some small patches by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1562
* fix: fdroid builds by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1565

## v1.11.5 (963)

* Alpine Linux Backend by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1401
* fix: html escaping for console page by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1411
* Create plugin for native libs by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1413
* feat: terminal frontend by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1415
* Update hu-hu.json translation by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1423, https://github.com/Acode-Foundation/Acode/pull/1425, https://github.com/Acode-Foundation/Acode/pull/1440
* chore: update id-id.json translation by @hyperz111 in https://github.com/Acode-Foundation/Acode/pull/1424, https://github.com/Acode-Foundation/Acode/pull/1447
* All file access permission for terminal by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1426
* refactor: plugins page by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1428
	* Fixed infinite scrolling in case of filtering on both plugin page and sidebar
    * Ui improvements on plugin page
* Revamped few themes(fixes visibility issue) and Added few new ones  by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1430
	* New theme: Neon, Sunset, Glass, Glass Dark
	* Revamped themes: System (Dark & Light), Oled, Light
	* System theme option is available on free too.
* fix: scaling issue by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1431
* fix: quicktools toggler responsiveness(scaling) and migrate biome by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1442
* chore: update ace to v1.43.2 by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1443
* feat: add uninstall option in terminal setting and tab subtitle fixes by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1445
* feat: alpine document provider(exposes terminal public dir to saf picker) by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1444
* feat: improved logging + fix terminal installation failure by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1446
* some terminal related quality improvements by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1449
	* fix: dont start selection in case of back gesture
	* remove useless border-radius from terminal container
	* fix: improve terminal cursor positioning for mobile keyboard events
	* fix: update terminal container background when theme changes
* exclude alpine/public while backup by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1450
* Custom port support in Terminal manager by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1459
* 🌐 i18n(locale): update vietnamese translations by @Nekitori17 in https://github.com/Acode-Foundation/Acode/pull/1461
* fix: infinite loading when previewing by @RohitKushvaha01 in https://github.com/Acode-Foundation/Acode/pull/1460
* Feat/some improvements to terminal and its api by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1463
* Fixes/sidebar extension state by clearing and active autocompletion box background  by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1466
* feat: add terminal like search and replace history by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1467
* fix: theme issue in terminal context menu
* fix: prevent folder paste loops and improve SAF handling(termux) in cut operation by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1474
	- Add validation to prevent pasting folders into themselves or subdirectories
	- Implement special Termux SAF handling for cut operations with recursive file/folder moving
	- Fix createFileStructure to handle nested paths (foo/bar) for file:// URIs

## v1.11.4 (962)

* Fix renaming current Termux URI file whilst viewing/editing it by @peasneovoyager2banana2
* fix: html preview on unsaved files by @RohitKushvaha01
* Add markdown-it-footnote and task lists support by @UnschooledGamer
* Fix quickTools height fallback by @bajrangCoder
* Comment out column adjustment in touchHandler.js for weird selection by @bajrangCoder
* Update Indonesian Translation by @hyperz111
* feat: :sparkles: Native Websocket Plugin (uses okhttp) by @UnschooledGamer
* fix: unintentional scrolling of tab container while dragging a tab by @peasneovoyager2banana2
* feat. alert user when changing editor theme by @RohitKushvaha01
* feat: Improve handling of intents before files are restored on startup by @bajrangCoder
* fix: don't save state of SAFMode="single" files by @bajrangCoder
* fix: plugin passing undefined to plugin item on plugin page by @bajrangCoder
* Integrated cordova-plugin-buildinfo as a local plugin by @RohitKushvaha01
* fix: crash when running unsaved file by @RohitKushvaha01
* feat: show open source plugin url on plugin page by @bajrangCoder
* fix: Make "None" option clickable in select dialog on formatter settings by @bajrangCoder
* fix: show confirm when copy/cut in sidebar instead of alert so user can proceed if they want by @bajrangCoder
* feat: plugin enable/disable functionality and update translations by @UnschooledGamer
* Update hu-hu.json by @summoner001
* Advanced execution interface by @RohitKushvaha01

## v1.11.3 (959)

* feat: added system theme by @RohitKushvaha01
* add: close-inactive-issues.yml by @UnschooledGamer
* Added Executor by @RohitKushvaha01
* fix: Executor Plugin's js module/interface path by @UnschooledGamer
* fix: teardrop goes out of viewport when there is no gutter by @bajrangCoder
* fix: infinite loading screen due to executor by @RohitKushvaha01
* fix: infinite loading when previewing html files by @RohitKushvaha01
* fix: apk related issues

## v1.11.2 (958)

* fix: cors related issues when installing plugins from remote by @bajrangCoder
* fix: Acode ignoring main, readme and icon fields in plugin manifest by @alMukaafih
* feat: inapp acode account login by @bajrangCoder
* fix: launchApp function by @RohitKushvaha01
* Update plugin documentation url by @RohitKushvaha01
* Backup restore fixes by @bajrangCoder
* file: re-emit switch and load file events after plugin load by @bajrangCoder
* fix: File copy-paste retains paste option after file is copied. by @RohitKushvaha01
* Fix sftp sidebar UI issue by @bajrangCoder
* fix: http relative path by @RohitKushvaha01
* Download support by @RohitKushvaha01
* Add Custom File Type Handler API by @bajrangCoder
* fix: applying folds on reopening the app by @bajrangCoder
* feat(tabs): Implement Shadow DOM isolation for non-editor tabs by @bajrangCoder
* remove invalid font by @bajrangCoder
* Improve Indonesian Translation by @hyperz111
* feat: improve changelogs page by @bajrangCoder
* Refactor, feat: Select dialog by @overskul
* Fix: Translate "Donation Message" and some words by @hyperz111
* Fix: "File Not Found" error when previewing HTML files from a Termux directory by @RohitKushvaha01
* Update zh-cn.json and zh-hant.json by @LaunchLee
* fix: console not showing on unsaved html file by @RohitKushvaha01
* File Menu & QuickTools Visibility for editor tabs by @bajrangCoder
* fix: handle edge case for `hideQuickTools` property by @bajrangCoder
* feat: add more new keys(<kbd>Home</kbd>,<kbd>End</kbd>, <kbd>PageUp</kbd>, <kbd>PageDown</kbd>, <kbd>Delete</kbd>) and symbols(`~` `Backtick`,`#` ,`$` ,`%` ,`^`) for quicktools by @bajrangCoder
* Fixed select box issue and improved it by @bajrangCoder
	* Added `x` to delete recent files/folder from dialog
* Update Hungarian translation by @summoner001
* chore(i18n): update vi-vn.json by @Nekitori17
* fix: file not found error by @RohitKushvaha01
* feat: revamped file tree by @bajrangCoder
* fix: pagedown key issue in editor by @bajrangCoder
* feat: open files with arbitrary extension names by @RohitKushvaha01
* add Hebrew language by @elid34
* feat: add support for compound file paths like `.blade.php` by @bajrangCoder
* support string content in tabs by @overskul
* update Tagalog/Filipino language by @ychwah
* fix: keyboard shortcuts leaks into ace editor by @RohitKushvaha01
* Resizeable activity by @RohitKushvaha01
* update ace v1.41.0 by @bajrangCoder
* Fix html content access by @RohitKushvaha01
* fix: path overlap issue in html viewer by @RohitKushvaha01
* fix: only initiate iap stuff in case of paid plugin on sidebar by @bajrangCoder

## v1.11.1 (957)

### Features
- **Syntax Highlighting**: Added syntax highlighting for code blocks on the plugin page using Ace Editor.
- **Theme Settings Fallback**: Implemented a fallback mechanism on the theme settings page when a custom tab is opened.
- **QuickTools Scroll Wheel Support**: Added support for scroll wheel events in QuickTools when in click mode.
- **SFTP Improvements**:
  - Enhanced logging for better debugging.
  - Enabled Bouncy Castle for SFTP, resolving connection issues with certain key types.
- **App Update Mechanism**:
  - Now checks for updates after app startup.
  - Uses a native approach instead of traditional fetch.

### Fixes & Improvements
- **SD Card Plugin**: Handled a few edge cases to prevent crashes.
- **GitHub Plugin Palette Fix**: Resolved an issue where the color palette was breaking the GitHub plugin.
- **Plugin Installation Fixes**:
  - Updated the install button in the sidebar to prevent multiple installations.
  - Fixed the installation mechanism in both the sidebar and the `installPlugin` API.
- **Quality of Life Enhancements**:
  - Various small improvements when installing/uninstalling plugins from the sidebar.

#### ⚠️ Experimental Changes ⚠️
- **Improved Plugin Loading**:
  - Only **theme plugins** load on Acode startup for faster performance.
  - All other plugins load **after** Acode startup.
- **Important for Theme Developers**:
  - Ensure your **plugin ID includes the word "theme"** to be correctly recognized as a theme plugin.
  - No changes are needed for existing theme plugins.
- **Potential Issues**: Since this is an experimental change, some features may break. Please report any issues encountered.

## v1.11.0 (956)

### Fixes
* Fixed a typo: "vission" → "vision" by @ByteJoseph in #1125
* Fixed heading and image alignment issues with `alignment="center"` on the plugin page by @bajrangCoder in #1132
* Fixed file listing in SFTP by @bajrangCoder in #1133
* Fixed fallback to `*/*` when the `accept` attribute is absent in `<input type="file">` in the in-app browser by @bajrangCoder in #1154
* Fixed console not reappearing after page reload in the in-app browser by @bajrangCoder in #1155
* Fixed infinite scroll on the plugin page to remove duplicates by @bajrangCoder in #1171
* Fixed logger to limit its size in #1167
* Fixed an issue where the info dialog wouldn't appear for non-editor tabs in #1167
* Fixed incorrect file attributes in FTP by @bajrangCoder in #1194
* Fixed the palette not opening when triggered from an existing palette by @bajrangCoder in #1197
* Fixed triggering of infinite scroll on plugin page while searching by @bajrangCoder in #1200

### Features
* Improved tab view gesture handling to distinguish between scroll and swipe on the plugin page by @bajrangCoder in #1131
* Added color preview for SVG files by @bajrangCoder in #1135
* Implemented custom editor tab support by @bajrangCoder in #1136
  * Now supports image, video, and audio previews directly in the editor instead of pop-ups
  * Exposed API for plugin developers to add content in editor tabs via `EditorFile`
* Redesigned the About page by @bajrangCoder in #1153
* Added a plugin rebuild option for local plugins by @bajrangCoder in #1150
  * Plugins can use `cordova.plugin.http` instead of `fetch` to avoid CORS issues when making network requests
* Redesigned the Plugin page by @bajrangCoder in #1152
  * Added new metadata fields in `plugin.json`: `license`, `changelog`, `keywords`, and `contributors`
* Added a new option to open files in an external app from the file browser in #1163
* Added minor sidebar UI tweaks and improved input element styling in #1164
* Used theme colors in the extra cutout area in landscape mode instead of the default color in #1165
* Improved file info dialog design in #1170
* Added Eruda console support for external sites in Acode's built-in browser in #1172
* Added a new editor setting: **"Fade fold widgets"** by @bajrangCoder in #1195
* Added a command to change the editor and app theme via the command palette by @bajrangCoder in #1197
* Added option to install plugins directly from sidebar extensions app by @bajrangCoder in #1200

### Improvements
* Improved paste operation with proper error handling in #1162
* Rewritten SFTP implementation(#1167):
  * Better performance and stability
  * Improved symlink support with better visual distinction
  * Proper error handling
  * Enhanced file reading (downloading) and writing
  * Uses native APIs for file system operations
  * Better buffer handling—now even 30-40 minute videos load within seconds (faster than internal storage)
  * Emoji support added
* Improved the FTP client (#1193) by @bajrangCoder
  * Supports emoji-named files
  * Improved symlink handling
  * Better handling of videos and images as binary files
  * Displays file names instead of full paths
* Reworked the plugin page UI—now displays essential info such as author, license, price, etc., in the list view by @bajrangCoder in #1196
* Tweaked breadcrumbs in the file browser to follow the app theme in #1167
* Updated the SSH library to `v3.1.2` in #1167
* Removed deprecated APIs in #1167
* Added experimental support for saving native logs in Acode Logger in #1167
* Tweaked the donation page  #1188

### Other Changes
* **Chore**: Updated Ace Editor to `v1.39.0`
  * Added CSV & TSV mode
  * Improved search support for multi-line patterns (`\n`, `\t`)
  * And more—see the Ace Changelog
* Many translation updates for `hu-hu` by @summoner

## v1.10.7 (955)

* Update hu-hu.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1092
* build(deps): bump path-to-regexp and express by @dependabot in https://github.com/Acode-Foundation/Acode/pull/1093
* Update hu-hu.json by @summoner001 in https://github.com/Acode-Foundation/Acode/pull/1094
* Exclude python `venv` and php `vendor` folders to speedup startup by @Jobians in https://github.com/Acode-Foundation/Acode/pull/1096
* Update de-de.json to 1.10.6.954 by @Micha-he in https://github.com/Acode-Foundation/Acode/pull/1097
* Update pl-pl.json by @andrewczm in https://github.com/Acode-Foundation/Acode/pull/1099
* minor fixes and tweaks by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1103
  * Added new command(file explorer) to open file manager
  * Added copy button to code blocks on plugin page
  * some error logging for debugging
  * few markdown tweaks
* Updating Brazilian Portuguese language  by @sebastianjnuwu in https://github.com/Acode-Foundation/Acode/pull/1102
* add className by @NezitX in https://github.com/Acode-Foundation/Acode/pull/1104
* Add monochrome icon by @Npepperlinux in https://github.com/Acode-Foundation/Acode/pull/1108
* fix: issue while making request to any ipv4, etc from app by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1107
* Update zh-cn.json and zh-hant.json by @LaunchLee in https://github.com/Acode-Foundation/Acode/pull/1109
* fix: show "No matches found" when palette has no matching items by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1110
* build(deps): bump systeminformation from 5.21.8 to 5.23.14 by @dependabot in https://github.com/Acode-Foundation/Acode/pull/1111
* Follow up for #1110 by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1112
* fix: cleanup plugin install state on failed installations by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1113
* feat: implement infinite scroll for plugin list by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1114
* feat: add quick install button for plugins in sidebar by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1115
* Plugin Dependencies by @alMukaafih in https://github.com/Acode-Foundation/Acode/pull/1030
* updated install state to reflect fs behaviour of android by @alMukaafih in https://github.com/Acode-Foundation/Acode/pull/1118
* fix: clean broken or half installed plugins on start by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1121
* few improvements by @bajrangCoder in https://github.com/Acode-Foundation/Acode/pull/1122

## v1.10.6 (954)

### New Features
- **Install State for Plugins**: Added an install state to improve plugin updates (#1026) by @alMukaafih, further enhanced by @bajrangCoder.
- **Selection Mode in File Browser**: Introduced a selection mode in the file browser by @bajrangCoder.
- **Persistent Notification System**: Added a persistent notification system with toast notifications by @bajrangCoder.
- **In-App Browser Command**: Added a command to open an in-app browser with a given URL by @angeloyana.
- **Font Size Shortcut Keys**: Added new key shortcuts for changing font size by @bajrangCoder:
    - Increase Font Size: `Ctrl - +` or `Ctrl - =`
    - Decrease Font Size: `Ctrl + -` or `Ctrl - _`
- **Command Palette Enhancements**:
    - "Open Plugin Page" command for quick access to plugin pages, especially for keyboard users.
    - "Copy Device Info" command to share device information for troubleshooting.
- **GitHub Alert Support**: Added GitHub alert support in plugin descriptions by @bajrangCoder.
- **File Tab Drop Behavior**: Dropping a file tab into any input or editor now inserts its path by @bajrangCoder.
- **File Browser Context Menu**: Added a "Copy URI" option in the file browser context menu by @bajrangCoder.
- **Project Import as ZIP**: Added the option to import projects as ZIP files by @bajrangCoder.
- **Backup Plugins**: You can now back up plugins, whether they are paid or free by @bajrangCoder.
- **Task List Markdown Support**: Added support for task lists (`- [x]`) in the plugin page markdown by @bajrangCoder.
- **Install as Plugin for ZIP Files**: Added the "Install as Plugin" option in the sidebar files section for ZIP files containing a `plugin.json` in the root directory by @bajrangCoder.
- **`acode.installPlugin` API**: Introduced an API for plugins to install other plugins with user consent by @bajrangCoder(available from versionCode: `954`).
- **View Changelogs in Settings**: Added an option in the settings page to view changelogs directly inside the app by @bajrangCoder.
- **App Update Checker**: Implemented an app update checker that runs on startup by @bajrangCoder.
- feat: copy/cut current line when selection is empty with same key shortcut by @angeloyana
- feat: add symlinks support in SFTP by @bajrangCoder

### Fixes
- **Plugin Loading Failures**: Improved handling of plugin loading failures by @bajrangCoder:
    - Prevents the app from crashing when plugins fail to load.
    - Shows user feedback for each failed plugin while continuing to load others.
- **Internal URL Navigation**: Replaced browser navigation with scroll behavior for internal links in plugin descriptions. Links to the same markdown now scroll instead of opening a browser by @bajrangCoder.
- **Pro Version Ads Issue**: Fixed an issue where plugin context menu actions displayed ads even if the Pro version was purchased by @UnschooledGamer.
- **Termux Private URI Operations**: Resolved issues with deleting folders/files and renaming files in Termux private URI file systems.
- **Logger Enhancements**: Improved the logger to automatically detect failures and use `console.error` in Acode.
- **Preview and Server Port Issue**: Fixed an issue where the browser did not open on the given port when the preview port and server port differed.
- **Font Persistence**: Resolved an issue where fonts did not persist after restarting the app.
- **Markdown Linking**: Fixed issues with linking to headings within the same page in markdown.
- **Search Bar in File Browser**: Fixed a bug where the search bar in the file browser would get stuck and become unclosable.
- **Theme Page Issues**: Addressed issues with theme plugins, including preview rendering and checkbox state changes.
- **Formatter Mode Selection**: Fixed the formatter ignoring the selected mode for files by @alMukaafih.
- fix: fetch plugin updates even if any fails by @UnschooledGamer
- fix: plugin update page by removing unwanted option icon @bajrangCoder

### Others
- **Plugin Refactor**: Migrated the old plugin update icon to a new toast-like notification widget.

### Translators
- Updated translations for specific languages contributed by:
    - **@Micha-he**: `de-de.json`
    - **@LaunchLee**: `zh-cn.json` and `zh-hant.json`
    - **@andrewczm**: `pl-pl.json`
    - **@Nekitori17**: `vi-vn`
    - **@s4ntiksu**: `ru-ru.json`
    - **@summoner001**: `hu-hu.json`
    - **@antikruk**: `be-by.json`

---

## [1.10.5] (953)

- New
  - Plugin Filtering System in #1011
  - feat: Add more action menu in sidebar plugin in #1017
  - Implement Logger system in #1020
  - Feat: Use Current File for preview (Toggle option) in #1006
  - updated ace editor to v1.36.2 in #1025

- Fixes
  - Update de-de.json in #1039
  - fixed sidebar plugin search list scrolling in #1002
  - Improve zh-TW traditional Chinese translation in #1004
  - fix: Fixed save all changes option in #1010
  - chore(i18n): vi-vn in #1016
  - removed auto paste of url on plugin page in #1023
  - fixed weird spacing issue on header #925 in #1024
  - Update zh-cn.json and zh-hant.json in #1031
  - Refactor Iap.java: Use WeakReference for Context and Activity to prevent memory leaks in #1040
  - Updated Polish translation in #1043
  - ru-ru improved in #1041
  - Update pl-pl.json in #1044 & #1045
  - fix: termux related fs operations failure in #1046

## [1.10.4] (952)

- New
  - Nested Files/Folder Creation
  - Updated ace to latest version
  - Improved displaying of Download count on Plugins page as well as on Sidebar
  - Enhanced search functionality to allow searching across all available plugins from the "all" section of the plugin page.
  - Added a new option on Help page for submitting bug reports.
- Fixes
  - Fixed issue with the search bar on the plugin page
  - Fixed issue with the search bar closing accidentally when clicking elsewhere on the screen

## [1.10.2]

- New
  - [x] **Updated Ace editor** | 947
    - Updated Ace editor to version 1.33.1.

## [1.10.1]

- New
  - [x] **Updated Ace editor** | 946
    - Updated Ace editor to version 1.32.9
- Fixes
  - [x] **Scrolling** | 946
    - Fixed scrollbars not showing up properly.

## [1.10.0]

- New
  - [x] **Ace editor** | 937
    - Updated Ace editor to version 1.32.7
- Fixes
  - [x] **UI** | 944
    - Fixed status and navigation text color not visible in light theme.
  - [x] **Plugin** | 944
    - Fixed updates for plugin not showing up.
  - [x] **Markdown** | 945
    - Fixed markdown preview not working properly.
  - [x] **Text selection** | 937
    - Fixed context menu not showing up when selecting all text from context menu after click and hold.

## [1.9.0]

- New
  - [x] **New in app browser** | 324
    - New in app browser with new UI.
    - You can emulate multiple devices.
  - [x] **New mode** | 933
    - Zig mode
    - Astro mode
- Fixes
  - [x] **File** | 931
    - Fixed not able share, edit or open with other apps.
    - Fixed file rename not working properly. | 934
  - [x] **Preview** | 934
    - Fixed preview where it opens browser two times.

## [1.8.8]

- New
  - [x] **Natural Scrolling** | 331
    - Acode now uses natural scrolling.
- Fixes
  - [x] **Selecting text** | 331
    - Fixed an issue where selecting text using long press and adding text to selection behaves unexpectedly.
  - [x] **Open folders** | 331
    - Fixed an issue where removing folder from sidebar doesn't remove the selected folder.

## [1.8.7]

- New
  - [x] **Updated Ace editor** | 318
    - Updated Ace editor to version 1.28.0
  - [x] **New problems page** | 318
    - You can now see all the problems in one place.
    - You can also see the problems in opened file.
  - [x] **New settings** | 318
    - New settings to toggle side buttons.
  - [x] **New Plugin API** | 318
    - `SideButton` is a new component that can be used to add side buttons.
  - [x] **New theme color** | 318
    - New `danger-color` and `danger-text-color` theme color.
  - [x] **New key binding** | 318
    - Use `Ctrl+Shift+X` key binding to open problems page.
  - [x] **Plugin** | 320
    - Install plugin directly from browser.
  - [x] **Intent** | 323
    - Plugin has now API to handle intent with uri acode://module/action/value.
- Fixes
  - [x] **Plugin page** | 318
    - Improved plugin page UI.
    - Shows plugin quickly when opened and loads new information in background.
  - [x] **Unsaved changes** | 318
    - Fixed unsaved changes not showing up in file when app restarted.
  - [x] **Quicktools** | 319
    - Fixed quicktools slides back when touch moved slightly.
  - [x] **Settings** | 321
    - Fixed settings not saving properly.
  - [x] **Internal storage** | 322
    - Fixed renaming file.
  - [x] **Side buttons** | 323
    - Fixed side buttons not shown properly.
  - [x] **Open folders** | 330
    - Fixed move file/folder not working properly.
  - [x] **Editor** | 330
    - Improved scrolling.
  - [x] **Quicktools** | 330
    - Improved quicktools.

## [1.8.6] - Build 313

- New
  - [x] **Search in settings**
    - You can now search for any settings in settings page.
- Updates
  - [x] **Language**
    - Updated language pack for Russian, Spanish, Portuguese and Deutsche.
  - [x] **Updated Ace editor**
    - Updated Ace editor to version 1.5.0
- Fixes
  - [x] **Sidebar search**
    - Fixed sidebar search not rendering words with special characters.
  - [x] **Not Loading**
    - Fixed app not loading on older devices.
  - [x] **Scrolling**
    - Fixed scrolling not working properly on some devices.
  - [x] **Eruda console**
    - Fixed eruda console not working properly.
  - [x] **Scrollbar**
    - Fixed scrollbar not working properly.
  - [x] **Custom theme**
    - Fixed custom theme not working properly.

## [1.8.5] - Build 295

- New
  - [x] **Scroll speed**
    - New 'Fast x2' scroll speed.
  - [x] **Touch handling**
    - Prevent accidental touch when tapping tear drop.
  - [x] **Color Preview**
    - You can now see color preview in css, scss, less, stylus and sass codes.
    - No need to select the whole color.
    - Enable/disable this feature from editor settings.
  - [x] **Smaller app size**
    - Reduced app size.
  - [x] **Updated icon pack**
    - Updated icon pack (mono color).
  - [x] **Default file encoding**
    - You can set default file encoding from settings.
  - [x] **File encoding**
    - Remember file encoding for each file.
  - [x] **Sidebar apps**
    - File list and extension list now remembers scroll position.
  - [x] **File tab bar**
    - When repositioning file tab bar, tab container will scroll when current tab is at the edge.
- Fixes
  - [x] **Touch handling**
    - Fixed teardrop and text menu not updated when switching tabs.
  - [x] **File encoding**
    - Fixed file encoding not working properly.
  - [x] **File icon**
    - Fixed inconsistent file icon.
  - [x] **JavaScript console**
    - Fixed JavaScript console not opening.
  - [x] **Ads**
    - Fixed ads taking screen when keyboard is open.
  - [x] **Insert file**
    - Fixed 'insert file' in opened folder not working properly.

## [1.8.4] - Build 283

- New
  - [x] **Updated Ace editor**
    - Updated Ace editor to version 1.22.0
  - [x] **Open files position**
    - **Bottom** `beta`: This is new option for open files position. You can change
      this from settings. This will open files in bottom of the screen.
  - [x] **Search in All Files** `beta`
    - This feature can be used to search and replace in all files in the opened projects.
    - To use this feature, open side bar and click on the search icon.
    - Note: This feature is in beta, so it may not work as expected.
  - [x] **Fast File Listing in Find Files (Ctrl + P)**
    - Loads files at startup and caches them for faster loading.
    - Watches file being created or modified from sidebar and updates the list
      accordingly.
  - [x] **Ctrl Key Functionality**
    - Keyboard shortcuts:
      - Ctrl+S: Save
      - Ctrl+Shift+P: Open the command palette. (Your shortcut may be different
        depending on what is saved in .keybindings.json file.)
  - [x] **Plugin API**
    - `contextMenu` is a component that can be used to show context menu in your plugin page.
  - [x] **Customisable quick tools**
    - You can now customise quick tools from settings.
- Fixes
  - [x] **Scrolling Issue**
    - Resolved an issue causing automatic scrolling from the cursor's
      position when the back button is pressed with the soft keyboard up.
    - Fixed a bug where scrollbar gets visible even when the file is not
      scrollable.
  - [x] **Active files in sidebar**
    - Fixed active files taking whole height of sidebar.
  - [x] **File opened using intent**
    - Fixed file opened using intent is not set as active file.
  - [x] **App doesn't load**
    - Fixed an issue where the app wouldn't load when an error occurred.
  - [x] **File tab bar**
    - Changing file tab bar position will not make editor lose focus.
  - [x] **Sidebar**
    - Fixed sidebar resized unknowingly when dragged to open or close it.
  - [x] **Close all tabs**
    - Fixed "close all" action opens up multiple confirm dialog for every unsaved file.
    - Now it will ask what to do with unsaved files.
  - [x] **File changed alert**
    - Fixed file changed alert showing up even when file is not changed.
  - [x] **Explore**
    - Fixed file not opening when opened from Explore.
  - [x] **Extensions app in sidebar**
    - Fixed extensions app's explore not rendering properly.
  - [x] **Minor bugs**
    - Fixed many minor bugs.
    - Improved stability.

## [1.8.3] - Build 278

- [x] Bugs fixes

## [1.8.2] - Build 276

- [x] Updated ace editor to version v1.18.0
- [x] Bugs fixes

## [1.8.1] - Build 274

- [x] Clicking on gutter will go to that line
- [x] Plugin Stability improvement
- [x] Updated ace editor
- [x] Bugs fixes

## [1.8.0] - Build 272

- [x] Plugins can support themes, fonts and sidebar items
- [x] Redesigned sidebar and quicktools
- [x] UI improvements
- [x] Bugs fixes

## [1.7.2] - Build 268

- [x] Added new command to toggle quick tools
- [x] Added back search in quick tools
- [x] Palette will close on ESC key
- [x] Plugin settings UI
- [x] Bugs fixes

## [1.7.1] - Build 266

- [x] Swipe to change tab in plugins page
- [x] Fixed update paid plugin
- [x] Bugs fixes

## [1.7.0] - Build 262

- [x] New medium size teardrop
- [x] Fixed some indic languages rendering
- [x] Fixed selection bug
- [x] Support for paid plugins
- [x] Quick tools improvement
- [x] Settings will have info button, you can see more info about settings
- [x] Updated plugin system
- [x] You can see plugin review and rating
- [x] GitHub is removed from app but, you can still use it from plugin
- [x] Bugs fixes

## [1.7.0] - Build 260

- [x] Quick tools improvement
- [x] Settings will have info button, you can see more info about settings
- [x] Updated plugin system
- [x] You can see plugin review and rating
- [x] GitHub is removed from app but, you can still use it from plugin
- [x] Bugs fixes

## [1.6.1] - Build 245

- [x] Updated plugin CDN

## [1.6.0] - Build 244

- [x] Updated plugin APIs
- [x] Updated text menu
- [x] Install plugin form device
- [x] Updated ace editor

## [1.6.0] - Build 239

- [x] Fixed horizontal scroll bug
- [x] Updated ace editor

## [1.6.0] - Build 235

- [x] Retry FTP/SFTP connection when fail
- [x] Supports plugin
- [x] Updated custom theme settings
- [x] Set custom port for preview in app settings
- [x] New option find file
- [x] Stability improvement
- [x] UI improvement
- [x] Fixed keyboard issues
- [x] Fixed tap hold to select text
- [x] Fixed loading files using FTP/SFTP
- [x] Fixed File checking
- [x] Fixed settings
- [x] Various fixes
