package com.exner.tools.meditationtimer.ui.helpers

import android.content.Context
import androidx.core.net.toUri
import com.exner.tools.meditationtimer.data.persistence.MeditationTimerProcess
import com.exner.tools.meditationtimer.network.MeditationTimerProcessForWear
import com.google.android.gms.tasks.Task
import com.google.android.gms.tasks.Tasks
import com.google.android.gms.wearable.DataItem
import com.google.android.gms.wearable.PutDataMapRequest
import com.google.android.gms.wearable.PutDataRequest
import com.google.android.gms.wearable.Wearable.getDataClient
import com.google.android.gms.wearable.Wearable.getNodeClient
import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.Moshi
import com.squareup.moshi.adapter
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory

fun removeProcessFromWear(context: Context, process: MeditationTimerProcess?) {
    var nodeId = Tasks.await(getNodeClient(context).localNode).id
    val dataClient = getDataClient(context)
    if (!process?.uuid.isNullOrEmpty()) {
        val uriString = "wear:$nodeId//delete/${process.uuid}"
        val putDataTask: Task<Int> = dataClient.deleteDataItems(uriString.toUri())
        // putDataTask.addOnSuccessListener {  }
    }
}

@OptIn(ExperimentalStdlibApi::class)
fun shareProcessOnWear(context: Context, process: MeditationTimerProcess) {
    // for that, we need it as JSON string
    val moshi = Moshi.Builder().addLast(KotlinJsonAdapterFactory()).build()
    val jsonAdapter: JsonAdapter<MeditationTimerProcessForWear> =
        moshi.adapter<MeditationTimerProcessForWear>()
    val simplifiedProcess = MeditationTimerProcessForWear(
        name = process.name,
        uuid = process.uuid,
        processTime = process.processTime,
        intervalTime = process.intervalTime,
        hasAutoChain = process.hasAutoChain,
        gotoUuid = process.gotoUuid,
        gotoName = process.gotoName
    )
    val processAsJson = jsonAdapter.toJson(simplifiedProcess)
    val dataClient = getDataClient(context)
    val putDataReq: PutDataRequest =
        PutDataMapRequest.create("/process/${process.uuid}").run {
            dataMap.putString("PROCESS_UUID", process.uuid)
            dataMap.putString("PROCESS_DATA", processAsJson)
            asPutDataRequest().setUrgent()
        }
    val putDataTask: Task<DataItem> = dataClient.putDataItem(putDataReq)
    // putDataTask.addOnSuccessListener {  }
}