package com.exner.tools.meditationtimer.network

import android.util.Log
import com.exner.tools.meditationtimer.data.persistence.MeditationTimerDataRepository
import com.google.android.gms.wearable.CapabilityClient
import com.google.android.gms.wearable.CapabilityInfo
import com.google.android.gms.wearable.DataClient
import com.google.android.gms.wearable.DataEvent
import com.google.android.gms.wearable.DataEventBuffer
import com.google.android.gms.wearable.DataMapItem

private const val TAG = "WDL"

class WearDataLayer(
    val repository: MeditationTimerDataRepository
) : DataClient.OnDataChangedListener, CapabilityClient.OnCapabilityChangedListener {

    override fun onDataChanged(dataEventBuffer: DataEventBuffer) {
        Log.d(TAG, "Data changed: $dataEventBuffer")
        dataEventBuffer.forEach { dataEvent ->
            Log.d(TAG, "  type ${dataEvent.type} (1 == CHANGED, 2 == DELETED)")
            when (dataEvent.type) {
                DataEvent.TYPE_CHANGED -> {
                    dataEvent.dataItem.also { item ->
                        val uri = DataMapItem.fromDataItem(item).uri
                        Log.d(TAG, "  uri $uri")
                        val dataMap = DataMapItem.fromDataItem(item).dataMap
                        Log.d(TAG, "  data ${dataMap.size()}")
                        dataMap.keySet().forEach { key ->
                            val value = dataMap.getString(key) // TODO only strings for now!
                            Log.d(TAG, "  $key -> $value")
                        }
                    }
                }

                DataEvent.TYPE_DELETED -> {
                    dataEvent.dataItem.also { item ->
                        Log.d(TAG, "  uri ${DataMapItem.fromDataItem(item).uri}")
                    }
                }
            }
        }
    }

    override fun onCapabilityChanged(capabilityInfo: CapabilityInfo) {
        Log.d(TAG, "Capability changed: $capabilityInfo")
    }


}