Trigger
=======

Trigger is an Android App to unlock/lock doors, show the door status and ring a bell.

Features:
 - Support of HTTPS, SSH, Bluetooth/BLE and MQTT.
 - Support for Nuki SmartLock.
 - Multiple door profiles.
 - Auto select profiles by connected WiFi.
 - HTTPS server/client certificate support.
 - SSH key generation support (ED25519, RSA).
 - Custom status images.
 - QR code support.
 - Support of backup.

![image](docs/screenshot_states.png)

(more [Screenshots](docs/screenshots.md))


## Download

[<img src="docs/fdroid.png" alt="Get it on F-Droid" height="90">](https://f-droid.org/packages/com.example.trigger/)
[<img src="docs/obtainium.png" alt="Get it on Obtainium" height="90">](https://apps.obtainium.imranr.dev/redirect?r=obtainium://app/%7B%22id%22%3A%22com.example.trigger%22%2C%22url%22%3A%22https%3A%2F%2Fgithub.com%2Fmwarning%2Ftrigger%22%2C%22author%22%3A%22mwarning%22%2C%22name%22%3A%22Trigger%22%2C%22preferredApkIndex%22%3A0%2C%22additionalSettings%22%3A%22%7B%5C%22includePrereleases%5C%22%3Afalse%2C%5C%22fallbackToOlderReleases%5C%22%3Atrue%2C%5C%22filterReleaseTitlesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22filterReleaseNotesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22verifyLatestTag%5C%22%3Afalse%2C%5C%22sortMethodChoice%5C%22%3A%5C%22date%5C%22%2C%5C%22useLatestAssetDateAsReleaseDate%5C%22%3Afalse%2C%5C%22releaseTitleAsVersion%5C%22%3Afalse%2C%5C%22trackOnly%5C%22%3Afalse%2C%5C%22versionExtractionRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22matchGroupToUse%5C%22%3A%5C%22%5C%22%2C%5C%22versionDetection%5C%22%3Atrue%2C%5C%22releaseDateAsVersion%5C%22%3Afalse%2C%5C%22useVersionCodeAsOSVersion%5C%22%3Afalse%2C%5C%22apkFilterRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22invertAPKFilter%5C%22%3Afalse%2C%5C%22autoApkFilterByArch%5C%22%3Atrue%2C%5C%22appName%5C%22%3A%5C%22%5C%22%2C%5C%22appAuthor%5C%22%3A%5C%22%5C%22%2C%5C%22shizukuPretendToBeGooglePlay%5C%22%3Afalse%2C%5C%22allowInsecure%5C%22%3Afalse%2C%5C%22exemptFromBackgroundUpdates%5C%22%3Afalse%2C%5C%22skipUpdateNotifications%5C%22%3Afalse%2C%5C%22about%5C%22%3A%5C%22%5C%22%2C%5C%22refreshBeforeDownload%5C%22%3Afalse%7D%22%2C%22overrideSource%22%3Anull%7D)
[<img src="docs/apk.png" alt="Get it on GitHub" height="90">](https://github.com/mwarning/trigger/releases)

The minimum supported Android version is 5.0.

## Documentation

For further feature explanations and How-Tos, see the [Documentation](docs/documentation.md) page.

## Contribution

Any help, bugfixes, new features, translations are much appreciated.

For translations use https://toolate.othing.xyz/projects/trigger/

## Similar/Related Projects

* [Sphincter-Remote](https://github.com/openlab-aux/Sphincter-Remote) / [Sphincter](https://github.com/openlab-aux/sphincter) / [Sphincterd](https://github.com/openlab-aux/sphincterd)
* [D00r-app](https://github.com/h42i/d00r-app) / [D00r-key-server](https://github.com/h42i/d00r-key-server)
* [labadoor](https://github.com/ToLABaki/labadoor) / [DoorLock](https://wiki.tolabaki.gr/w/DoorLock_v3)
* [Krautschlüssel](https://gitlab.com/fiveop/krautschluessel)
* [MetalabDoorWidget](https://github.com/zoff99/MetalabDoorWidget)
* [HACKS](https://github.com/ktt-ol/hacs)
* [Stratum0Widget](https://github.com/Valodim/Stratum0Widget)
* [HTTP Request Shortcuts](https://http-shortcuts.rmy.ch/) [F-Droid](https://f-droid.org/packages/ch.rmy.android.http_shortcuts/) send HTTP Requests from Shortcuts on your Home Screen

## License

GNU GENERAL PUBLIC LICENSE 3.0 or later, see [license text](LICENSE) or on [spdx.org](https://spdx.org/licenses/GPL-3.0-or-later.html)

Icons: [Googles Material Design](https://material.io/tools/icons/)
