# DekaDico

<p>
<img src="fastlane/metadata/android/en-US/images/icon.png" height=150px />
</p>

This repository contains the source code for the DekaDico Android app.

### What's DekaDico?

It's a memory training app, which is primarily intended for those interested in improving their recall skills of spoken numbers. 'Spoken Numbers' is a discipline in all memory competitions. The aim is to commit to memory and recall as many Spoken Numbers as possible, which are read out at a pace of 1 digit per second. Getting better at such a skill would not just improve your memory skills, but also enhance your focus and concentration.

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="80">](https://f-droid.org/packages/com.example.spokennumbers/)

### Features

- [New!] Flash Anzan game module
- Minimal, no clutter display
- Customizable time delay between spoken numbers
- No overall time restrictions
- Easy to use recall system
- Increment/Decrement time delays on the fly, to adjust to your current memorizing speed
- User can now choose between male/female voice.
- Choose between binary and decimal numbers to practice.
- Save choices and preferences automatically.
- improved UI
- transition animation between windows
- Evaluation mode
- Store and display Highscore
- Light/Dark mode support

### Running the Program

This program is only available for android devices. It is readily avaiable for installation from [FDroid](https://f-droid.org/packages/com.example.spokennumbers/) Repository or from Github [releases](https://github.com/VivekThazhathattil/dekadico/releases).

### Problems?

For any problems relating to this app, please create a new 'issue' in this GitHub repo. You can also contact me directly at my email, and I will try to help.

### Contact

If you have any questions, bug reports, suggestions or other wishes, feel free to contact me on vivek.thazhathattil@gmail.com. I'll respond to you at the earliest.

### Get Started with Memorization!

* If you are a newbie into the world of mnemonics and memorization, this is probably the best resouce to get you going : [ArtOfMemory](https://artofmemory.com/wiki/Main_Page/)

* Once you have familiarized with the basic memorization techniques, you can move on to more interesting methods used by most memory athletes like Person-Action-Object method, Major system, Dominic system, Ben's system etc. You can pick one as the weapon of your choice or create one on your own, and use apps like this to train and improve your skills.

* Consistency is key to improvement. Practicing daily for as little as 5-10 minutes will help boost your skill level more than an hour of practice once every week.

### License

The DekaDico repository is available under the MIT License.

### ACKNOWLEDGEMENT

* Male voice for spoken numbers: "Counting Numbers Normal Voice 0-12" by dersuperanton from [freesound.org](https://freesound.org/people/dersuperanton/sounds/434733/)
* Female voice for spoken numbers: Amy Gedgaudas - by tim.kahn from [freesound.org](https://freesound.org/people/tim.kahn/packs/4372/)

### Screenshots

<p>
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" width=200px />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" width=200px />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" width=200px />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" width=200px />
</p>
