package com.example.sekreto

import android.content.Intent
import android.content.pm.PackageManager
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import androidx.preference.Preference
import androidx.preference.PreferenceFragmentCompat

class SettingsActivity : AppCompatActivity() {

    private val flagSecure: FlagSecure by lazy { FlagSecure(this) }
    private val theme: Theme by lazy { Theme(this) }
    private val lang: Lang by lazy { Lang(this) }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.settings_activity)
        flagSecure.initFlagSecure()
        theme.initTheme()
        lang.initLang()

        supportActionBar!!.setBackgroundDrawable(ColorDrawable(ContextCompat.getColor(this, R.color.bar)))
        supportActionBar?.elevation = 0f
        setTitle(R.string.settings)

        supportActionBar?.setDisplayHomeAsUpEnabled(true)

        supportFragmentManager.beginTransaction()
            .replace(android.R.id.content, SettingsFragment())
            .commit()

        lang.registerOnSharedPreferenceChangeListener()
    }

    class SettingsFragment : PreferenceFragmentCompat() {
        override fun onCreatePreferences(savedInstanceState: Bundle?, rootKey: String?) {
            setPreferencesFromResource(R.xml.root_preferences, rootKey)
            val versionPreference: Preference? = findPreference("version")
            val versionName = requireActivity()
                .packageManager.getPackageInfo(requireActivity().packageName, PackageManager.GET_ACTIVITIES).versionName
            versionPreference?.summary = versionName
        }
    }

    override fun onSupportNavigateUp(): Boolean {
        finish()
        return true
    }

    @Deprecated("Deprecated in Java")
    override fun onBackPressed() {
        super.onBackPressed()
        val returnIntent = Intent()
        setResult(RESULT_OK, returnIntent)
        finish()
    }
}