package com.example.secreto

import android.annotation.SuppressLint
import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.widget.Button
import android.widget.EditText
import androidx.appcompat.app.AppCompatActivity
import androidx.preference.PreferenceManager
import android.graphics.drawable.ColorDrawable
import androidx.core.content.ContextCompat

class ViewActivity : AppCompatActivity() {

    private val sharedPreferences: SharedPreferences by lazy {
        PreferenceManager.getDefaultSharedPreferences(this)
    }

    private val flagSecure: FlagSecure by lazy { FlagSecure(this) }
    private val theme: Theme by lazy { Theme(this) }
    private val lang: Lang by lazy { Lang(this) }

    private lateinit var result: EditText
    private lateinit var password: EditText
    private lateinit var decryptBtn: Button

    @SuppressLint("ClickableViewAccessibility")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        flagSecure.initFlagSecure()
        theme.initTheme()
        lang.initLang()
        setContentView(R.layout.activity_view)

        supportActionBar!!.setBackgroundDrawable(ColorDrawable(ContextCompat.getColor(this, R.color.bar)))
        supportActionBar?.elevation = 0f
        setTitle(R.string.show)

        result = findViewById(R.id.result)
        password = findViewById(R.id.password)
        decryptBtn = findViewById(R.id.decrypt_btn)

        val passwordVisibility = PasswordVisibility(password)
        password.setOnTouchListener(passwordVisibility)

        decryptBtn.setOnClickListener {
            val result = result.text.toString()
            val password = password.text.toString()

            if (result.isNotEmpty() && password.isNotEmpty()) {
                val extraction = Stegano.hid2hex(result)

                val decrypt = Crypto.decrypt(extraction, password)

                if (decrypt != null) {

                    val dialogFragment = CopyDecryptDialog(decrypt)
                    dialogFragment.show(supportFragmentManager, "copy_decrypt_dialog")
                } else {
                    val errorDialog = ErrorDialog()
                    errorDialog.show(supportFragmentManager, "error_dialog")
                }
            } else {
                val infoDecryptDialog = InfoDecryptDialog()
                infoDecryptDialog.show(supportFragmentManager, "info_decrypt_dialog")
            }
        }
    }

    override fun onResume() {
        super.onResume()
        sharedPreferences.registerOnSharedPreferenceChangeListener(theme)
    }

    override fun onPause() {
        super.onPause()
        sharedPreferences.unregisterOnSharedPreferenceChangeListener(theme)
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        menuInflater.inflate(R.menu.options_menu, menu)
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return when (item.itemId) {
            R.id.action_settings -> {

                val intent = Intent(this, SettingsActivity::class.java)
                startActivity(intent)
                true
            }
            android.R.id.home -> {
                onBackPressed()
                true
            }
            else -> super.onOptionsItemSelected(item)
        }
    }
}