package com.example.secreto

import android.content.Context
import android.content.SharedPreferences
import androidx.appcompat.app.AppCompatDelegate
import androidx.preference.PreferenceManager

class Theme(private val context: Context) : SharedPreferences.OnSharedPreferenceChangeListener {

    private val sharedPreferences: SharedPreferences by lazy {
        PreferenceManager.getDefaultSharedPreferences(context)
    }

    fun initTheme() {
        val isDarkMode = sharedPreferences.getBoolean("switch_preference_1", false)
        applyTheme(isDarkMode)
        sharedPreferences.registerOnSharedPreferenceChangeListener(this)
    }

    override fun onSharedPreferenceChanged(sharedPreferences: SharedPreferences?, key: String?) {
        if (key == "switch_preference_1") {
            val isDarkMode = sharedPreferences?.getBoolean(key, false) ?: false
            applyTheme(isDarkMode)
            sharedPreferences?.edit()?.putBoolean(key, isDarkMode)?.apply()
        }
    }

    private fun applyTheme(isDarkMode: Boolean) {
        if (isDarkMode) {
            AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_YES)
        } else {
            AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO)
        }
    }

    fun cleanup() {
        sharedPreferences.unregisterOnSharedPreferenceChangeListener(this)
    }
}