package com.example.secreto

class Stegano {

    companion object {

        private val zwc = arrayOf(
            "\u2060", "\u200B", "\u200D", "\u200E",
            "\u200F", "\u200C", "\u2061", "\u180E",
            "\u202A", "\u202C", "\u202D", "\u2062",
            "\u2063", "\u2064", "\u2065", "\u2066"
        )

        fun hex2hid(hexString: String): String {
            val hiddenString = StringBuilder()
            for (char in hexString) {
                val index = Character.digit(char, 16)
                if (index in 0..15) {
                    val hidChar = zwc[index]
                    hiddenString.append(hidChar)
                }
            }
            return wrap(hiddenString.toString())
        }

        fun hid2hex(hiddenString: String): String {
            val unwrapped = unwrap(hiddenString)
            val result = StringBuilder()
            for (char in unwrapped) {
                val index = zwc.indexOf(char.toString())
                if (index != -1) {
                    val hexChar = Integer.toHexString(index).uppercase()
                    result.append(hexChar)
                }
            }
            return result.toString()
        }

        private fun wrap(hiddenString: String): String {
            return "\uFEFF$hiddenString\uFEFF"
        }

        private fun unwrap(hiddenString: String): String {
            val startIndex = hiddenString.indexOf("\uFEFF") + 1
            val endIndex = hiddenString.lastIndexOf("\uFEFF")
            if (startIndex >= endIndex || startIndex < 0 || endIndex < 0) {
                return hiddenString
            }
            return hiddenString.substring(startIndex, endIndex)
        }
    }
}