package com.example.secreto

import android.text.method.HideReturnsTransformationMethod
import android.text.method.PasswordTransformationMethod
import android.view.MotionEvent
import android.view.View
import android.widget.EditText

class PasswordVisibility(private val editText: EditText) : View.OnTouchListener {
    private val DRAWABLE_RIGHT = 2
    private var cursorPosition = 0

    override fun onTouch(v: View, event: MotionEvent): Boolean {
        when (event.action) {
            MotionEvent.ACTION_DOWN -> {
                cursorPosition = editText.selectionStart
            }
            MotionEvent.ACTION_UP -> {
                if (event.rawX >= (editText.right - editText.compoundDrawables[DRAWABLE_RIGHT].bounds.width())) {
                    if (editText.transformationMethod == PasswordTransformationMethod.getInstance()) {
                        editText.transformationMethod = HideReturnsTransformationMethod.getInstance()
                        editText.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.ic_key, 0, R.drawable.ic_visibility_on, 0)
                    } else {
                        editText.transformationMethod = PasswordTransformationMethod.getInstance()
                        editText.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.ic_key, 0, R.drawable.ic_visibility_off, 0)
                    }
                    editText.setSelection(cursorPosition)
                    return true
                }
            }
            MotionEvent.ACTION_CANCEL -> {
                editText.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.ic_key, 0, R.drawable.ic_visibility_off, 0)
            }
        }
        return false
    }
}