package com.example.secreto

import android.content.Context
import android.content.SharedPreferences
import android.content.res.Configuration
import android.content.res.Resources
import android.preference.PreferenceManager
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import java.util.*

class Lang(
    private val context: Context
) : SharedPreferences.OnSharedPreferenceChangeListener {

    private val sharedPreferences: SharedPreferences by lazy {
        PreferenceManager.getDefaultSharedPreferences(context)
    }

    fun initLang() {
        val selectedLanguage = sharedPreferences.getString("appLanguage", "eo")
        selectedLanguage?.let { language ->
            setAppLanguage(language)
        }
    }

    private fun setAppLanguage(language: String) {
        val locale = Locale(language)
        Locale.setDefault(locale)
        val resources: Resources = context.resources
        val configuration: Configuration = resources.configuration
        configuration.setLocale(locale)
        resources.updateConfiguration(
            configuration, resources.displayMetrics
        )
        sharedPreferences.edit().putString("appLanguage", language).apply()
    }

    fun registerOnSharedPreferenceChangeListener() {
        PreferenceManager.getDefaultSharedPreferences(context)
            .registerOnSharedPreferenceChangeListener(this)
    }

    fun unregisterOnSharedPreferenceChangeListener() {
        PreferenceManager.getDefaultSharedPreferences(context)
            .unregisterOnSharedPreferenceChangeListener(this)
    }

    override fun onSharedPreferenceChanged(
        sharedPreferences: SharedPreferences?, key: String?) {
        when (key) {"appLanguage" -> {
            val selectedLanguage = sharedPreferences?.getString(key, "eo")
            selectedLanguage?.let { language ->
                setAppLanguage(language)
                (context as AppCompatActivity).recreate()
                Toast.makeText(context, context.getString(R.string.restart_message), Toast.LENGTH_SHORT).show()
            }
        }
        }
    }
}