package com.example.secreto

import android.annotation.SuppressLint
import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.widget.Button
import android.widget.EditText
import androidx.appcompat.app.AppCompatActivity
import androidx.preference.PreferenceManager
import android.graphics.drawable.ColorDrawable
import androidx.core.content.ContextCompat

class HideActivity : AppCompatActivity() {

    private val sharedPreferences: SharedPreferences by lazy {
        PreferenceManager.getDefaultSharedPreferences(this)
    }

    private val flagSecure: FlagSecure by lazy { FlagSecure(this) }
    private val theme: Theme by lazy { Theme(this) }
    private val lang: Lang by lazy { Lang(this) }

    private lateinit var secret: EditText
    private lateinit var password: EditText
    private lateinit var pub_msg: EditText
    private lateinit var encryptBtn: Button

    @SuppressLint("ClickableViewAccessibility")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        flagSecure.initFlagSecure()
        theme.initTheme()
        lang.initLang()
        setContentView(R.layout.activity_hide)

        supportActionBar!!.setBackgroundDrawable(ColorDrawable(ContextCompat.getColor(this, R.color.bar)))
        supportActionBar?.elevation = 0f
        setTitle(R.string.hide)

        secret = findViewById(R.id.secret)
        password = findViewById(R.id.password)
        pub_msg = findViewById(R.id.pub_msg)
        encryptBtn = findViewById(R.id.encrypt_btn)

        val passwordVisibility = PasswordVisibility(password)
        password.setOnTouchListener(passwordVisibility)

        encryptBtn.setOnClickListener {
            val secret = secret.text.toString()
            val password = password.text.toString()
            val pub_msg = pub_msg.text.toString()

            if (secret.isEmpty() || password.isEmpty() || pub_msg.isEmpty()) {
                val dialogFragment = InfoEncryptDialog()
                dialogFragment.show(supportFragmentManager, "info_encrypt_dialog")
            } else if (pub_msg.length < 2) {
                val warningDialog = WarningDialog()
                warningDialog.show(supportFragmentManager, "warning_dialog")
            } else {
                val hex = Crypto.encrypt(secret, password)
                val hiding = Stegano.hex2hid(hex)

                val startIndex = pub_msg.length / 2
                val result = StringBuilder(pub_msg).apply {
                    insert(startIndex, hiding)
                }.toString()

                val dialogFragment = CopyEncryptDialog(result)
                dialogFragment.show(supportFragmentManager, "copy_dialog")
            }
        }
    }

    override fun onResume() {
        super.onResume()
        sharedPreferences.registerOnSharedPreferenceChangeListener(theme)
    }

    override fun onPause() {
        super.onPause()
        sharedPreferences.unregisterOnSharedPreferenceChangeListener(theme)
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        menuInflater.inflate(R.menu.options_menu, menu)
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return when (item.itemId) {
            R.id.action_settings -> {

                val intent = Intent(this, SettingsActivity::class.java)
                startActivity(intent)
                true
            }
            android.R.id.home -> {
                onBackPressed()
                true
            }
            else -> super.onOptionsItemSelected(item)
        }
    }
}