package com.example.secreto

import android.app.Activity
import android.content.Context
import android.content.SharedPreferences
import android.view.WindowManager
import android.widget.Toast

class FlagSecure(private val context: Context) : SharedPreferences.OnSharedPreferenceChangeListener {

    private val sharedPreferences: SharedPreferences by lazy {
        androidx.preference.PreferenceManager.getDefaultSharedPreferences(context)
    }

    fun initFlagSecure() {
        val isFlagSecureEnabled = sharedPreferences.getBoolean("switch_preference_2", false)
        applyFlagSecure(isFlagSecureEnabled)
        sharedPreferences.registerOnSharedPreferenceChangeListener(this)
    }

    override fun onSharedPreferenceChanged(sharedPreferences: SharedPreferences?, key: String?) {
        if (key == "switch_preference_2") {
            val isFlagSecureEnabled = sharedPreferences?.getBoolean(key, false) ?: false
            applyFlagSecure(isFlagSecureEnabled)
            sharedPreferences?.edit()?.putBoolean(key, isFlagSecureEnabled)?.apply()
            showToast(context.getString(R.string.restart_message))
        }
    }

    private fun applyFlagSecure(isFlagSecureEnabled: Boolean) {
        val window = (context as Activity).window
        if (isFlagSecureEnabled) {window.setFlags(WindowManager.LayoutParams.FLAG_SECURE, WindowManager.LayoutParams.FLAG_SECURE)
        } else {
            window.clearFlags(WindowManager.LayoutParams.FLAG_SECURE)
        }
    }

    fun cleanup() {
        sharedPreferences.unregisterOnSharedPreferenceChangeListener(this)
    }

    private fun showToast(message: String) {
        Toast.makeText(context, message, Toast.LENGTH_SHORT).show()
    }
}