Generated Dart libraries for accessing
[Google APIs](https://developers.google.com/api-client-library).

To use these APIs from Flutter, see the
[Flutter Google APIs documentation](https://flutter.dev/docs/development/data-and-backend/google-apis).

For example of using these APIs from a Dart console example see the example in
this package. For an example of usage in a server application,
[see this example](https://github.com/dart-lang/samples/tree/master/server/google_apis).

## Available Google APIs

The following is a list of APIs that are currently available inside this
package.

#### Abusive Experience Report API - `abusiveexperiencereport/v1`

Views Abusive Experience Report data, and gets a list of sites that have a significant number of abusive experiences.

- [Original documentation](https://developers.google.com/abusive-experience-report/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/abusiveexperiencereport_v1/abusiveexperiencereport_v1-library.html)

#### Accelerated Mobile Pages (AMP) URL API - `acceleratedmobilepageurl/v1`

Retrieves the list of AMP URLs (and equivalent AMP Cache URLs) for a given list of public URL(s). 

- [Original documentation](https://developers.google.com/amp/cache/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/acceleratedmobilepageurl_v1/acceleratedmobilepageurl_v1-library.html)

#### Access Approval API - `accessapproval/v1`

An API for controlling access to data by Google personnel.

- [Original documentation](https://cloud.google.com/assured-workloads/access-approval/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/accessapproval_v1/accessapproval_v1-library.html)

#### Access Context Manager API - `accesscontextmanager/v1`

An API for setting attribute based access control to requests to Google Cloud services. *Warning:* Do not mix *v1alpha* and *v1* API usage in the same access policy. The v1alpha API supports new Access Context Manager features, which may have different attributes or behaviors that are not supported by v1. The practice of mixed API usage within a policy may result in the inability to update that policy, including any access levels or service perimeters belonging to it. It is not recommended to use both v1 and v1alpha for modifying policies with critical service perimeters. Modifications using v1alpha should be limited to policies with non-production/non-critical service perimeters.

- [Original documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/accesscontextmanager_v1/accesscontextmanager_v1-library.html)

#### ACME DNS API - `acmedns/v1`

Google Domains ACME DNS API that allows users to complete ACME DNS-01 challenges for a domain.

- [Original documentation](https://developers.google.com/domains/acme-dns/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/acmedns_v1/acmedns_v1-library.html)

#### Address Validation API - `addressvalidation/v1`

The Address Validation API allows developers to verify the accuracy of addresses. Given an address, it returns information about the correctness of the components of the parsed address, a geocode, and a verdict on the deliverability of the parsed address.

- [Original documentation](https://developers.google.com/maps/documentation/addressvalidation)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/addressvalidation_v1/addressvalidation_v1-library.html)

#### Ad Experience Report API - `adexperiencereport/v1`

Views Ad Experience Report data, and gets a list of sites that have a significant number of annoying ads.

- [Original documentation](https://developers.google.com/ad-experience-report/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/adexperiencereport_v1/adexperiencereport_v1-library.html)

#### Admin SDK API - `admin/datatransfer_v1`

Admin SDK lets administrators of enterprise domains to view and manage resources like user, groups etc. It also provides audit and usage reports of domain.

- [Original documentation](https://developers.google.com/admin-sdk/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/admin_datatransfer_v1/admin_datatransfer_v1-library.html)

#### Admin SDK API - `admin/directory_v1`

Admin SDK lets administrators of enterprise domains to view and manage resources like user, groups etc. It also provides audit and usage reports of domain.

- [Original documentation](https://developers.google.com/admin-sdk/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/admin_directory_v1/admin_directory_v1-library.html)

#### Admin SDK API - `admin/reports_v1`

Admin SDK lets administrators of enterprise domains to view and manage resources like user, groups etc. It also provides audit and usage reports of domain.

- [Original documentation](https://developers.google.com/admin-sdk/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/admin_reports_v1/admin_reports_v1-library.html)

#### AdMob API - `admob/v1`

The AdMob API allows publishers to programmatically get information about their AdMob account. 

- [Original documentation](https://developers.google.com/admob/api/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/admob_v1/admob_v1-library.html)

#### AdSense Management API - `adsense/v2`

The AdSense Management API allows publishers to access their inventory and run earnings and performance reports.

- [Original documentation](https://developers.google.com/adsense/management/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/adsense_v2/adsense_v2-library.html)

#### ![Logo](https://www.google.com/images/icons/product/adsense-16.png) AdSense Host API - `adsensehost/v4_1`

Generates performance reports, generates ad codes, and provides publisher management capabilities for AdSense Hosts.

- [Original documentation](https://developers.google.com/adsense/host/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/adsensehost_v4_1/adsensehost_v4_1-library.html)

#### Advisory Notifications API - `advisorynotifications/v1`

An API for accessing Advisory Notifications in Google Cloud

- [Original documentation](https://cloud.google.com/advisory-notifications)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/advisorynotifications_v1/advisorynotifications_v1-library.html)

#### Vertex AI API - `aiplatform/v1`

Train high-quality custom machine learning models with minimal machine learning expertise and effort.

- [Original documentation](https://cloud.google.com/vertex-ai/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/aiplatform_v1/aiplatform_v1-library.html)

#### Air Quality API - `airquality/v1`

The Air Quality API.

- [Original documentation](https://developers.google.com/maps/documentation/air-quality)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/airquality_v1/airquality_v1-library.html)

#### AlloyDB API - `alloydb/v1`

AlloyDB for PostgreSQL is an open source-compatible database service that provides a powerful option for migrating, modernizing, or building commercial-grade applications. It offers full compatibility with standard PostgreSQL, and is more than 4x faster for transactional workloads and up to 100x faster for analytical queries than standard PostgreSQL in our performance tests. AlloyDB for PostgreSQL offers a 99.99 percent availability SLA inclusive of maintenance. AlloyDB is optimized for the most demanding use cases, allowing you to build new applications that require high transaction throughput, large database sizes, or multiple read resources; scale existing PostgreSQL workloads with no application changes; and modernize legacy proprietary databases. 

- [Original documentation](https://cloud.google.com/alloydb/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/alloydb_v1/alloydb_v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/analytics-16.png) Google Analytics API - `analytics/v3`

Views and manages your Google Analytics data.

- [Original documentation](https://developers.google.com/analytics/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/analytics_v3/analytics_v3-library.html)

#### Analytics Hub API - `analyticshub/v1`

Exchange data and analytics assets securely and efficiently.

- [Original documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/analyticshub_v1/analyticshub_v1-library.html)

#### Analytics Reporting API - `analyticsreporting/v4`

Accesses Analytics report data.

- [Original documentation](https://developers.google.com/analytics/devguides/reporting/core/v4/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/analyticsreporting_v4/analyticsreporting_v4-library.html)

#### Android Device Provisioning Partner API - `androiddeviceprovisioning/v1`

Automates Android zero-touch enrollment for device resellers, customers, and EMMs.

- [Original documentation](https://developers.google.com/zero-touch/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/androiddeviceprovisioning_v1/androiddeviceprovisioning_v1-library.html)

#### Google Play EMM API - `androidenterprise/v1`

Manages the deployment of apps to Android Enterprise devices.

- [Original documentation](https://developers.google.com/android/work/play/emm-api)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/androidenterprise_v1/androidenterprise_v1-library.html)

#### Android Management API - `androidmanagement/v1`

The Android Management API provides remote enterprise management of Android devices and apps.

- [Original documentation](https://developers.google.com/android/management)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/androidmanagement_v1/androidmanagement_v1-library.html)

#### Google Play Android Developer API - `androidpublisher/v3`

Lets Android application developers access their Google Play accounts. At a high level, the expected workflow is to "insert" an Edit, make changes as necessary, and then "commit" it. 

- [Original documentation](https://developers.google.com/android-publisher)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/androidpublisher_v3/androidpublisher_v3-library.html)

#### API Gateway API - `apigateway/v1`

- [Original documentation](https://cloud.google.com/api-gateway/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/apigateway_v1/apigateway_v1-library.html)

#### Apigee API - `apigee/v1`

Use the Apigee API to programmatically develop and manage APIs with a set of RESTful operations. Develop and secure API proxies, deploy and undeploy API proxy revisions, monitor APIs, configure environments, manage users, and more. Note: This product is available as a free trial for a time period of 60 days.

- [Original documentation](https://cloud.google.com/apigee-api-management/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/apigee_v1/apigee_v1-library.html)

#### Apigee Registry API - `apigeeregistry/v1`

- [Original documentation](https://cloud.google.com/apigee/docs/api-hub/what-is-api-hub)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/apigeeregistry_v1/apigeeregistry_v1-library.html)

#### API Keys API - `apikeys/v2`

Manages the API keys associated with developer projects.

- [Original documentation](https://cloud.google.com/api-keys/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/apikeys_v2/apikeys_v2-library.html)

#### App Engine Admin API - `appengine/v1`

Provisions and manages developers' App Engine applications.

- [Original documentation](https://cloud.google.com/appengine/docs/admin-api/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/appengine_v1/appengine_v1-library.html)

#### App Hub API - `apphub/v1`

- [Original documentation](https://cloud.google.com/app-hub/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/apphub_v1/apphub_v1-library.html)

#### Artifact Registry API - `artifactregistry/v1`

Store and manage build artifacts in a scalable and integrated service built on Google infrastructure.

- [Original documentation](https://cloud.google.com/artifacts/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/artifactregistry_v1/artifactregistry_v1-library.html)

#### Assured Workloads API - `assuredworkloads/v1`

- [Original documentation](https://cloud.google.com/learnmoreurl)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/assuredworkloads_v1/assuredworkloads_v1-library.html)

#### Authorized Buyers Marketplace API - `authorizedbuyersmarketplace/v1`

The Authorized Buyers Marketplace API lets buyers programmatically discover inventory; propose, retrieve and negotiate deals with publishers.

- [Original documentation](https://developers.google.com/authorized-buyers/apis/marketplace/reference/rest/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/authorizedbuyersmarketplace_v1/authorizedbuyersmarketplace_v1-library.html)

#### Backup and DR Service API - `backupdr/v1`

- [Original documentation](https://cloud.google.com/backup-disaster-recovery)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/backupdr_v1/backupdr_v1-library.html)

#### Bare Metal Solution API - `baremetalsolution/v2`

Provides ways to manage Bare Metal Solution hardware installed in a regional extension located near a Google Cloud data center.

- [Original documentation](https://cloud.google.com/bare-metal)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/baremetalsolution_v2/baremetalsolution_v2-library.html)

#### Batch API - `batch/v1`

An API to manage the running of Batch resources on Google Cloud Platform.

- [Original documentation](https://cloud.google.com/batch/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/batch_v1/batch_v1-library.html)

#### BeyondCorp API - `beyondcorp/v1`

Beyondcorp Enterprise provides identity and context aware access controls for enterprise resources and enables zero-trust access. Using the Beyondcorp Enterprise APIs, enterprises can set up multi-cloud and on-prem connectivity solutions.

- [Original documentation](https://cloud.google.com/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/beyondcorp_v1/beyondcorp_v1-library.html)

#### BigLake API - `biglake/v1`

The BigLake API provides access to BigLake Metastore, a serverless, fully managed, and highly available metastore for open-source data that can be used for querying Apache Iceberg tables in BigQuery.

- [Original documentation](https://cloud.google.com/bigquery/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/biglake_v1/biglake_v1-library.html)

#### BigQuery API - `bigquery/v2`

A data platform for customers to create, manage, share and query data.

- [Original documentation](https://cloud.google.com/bigquery/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/bigquery_v2/bigquery_v2-library.html)

#### BigQuery Connection API - `bigqueryconnection/v1`

Allows users to manage BigQuery connections to external data sources.

- [Original documentation](https://cloud.google.com/bigquery/docs/connections-api-intro)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/bigqueryconnection_v1/bigqueryconnection_v1-library.html)

#### BigQuery Data Policy API - `bigquerydatapolicy/v1`

Allows users to manage BigQuery data policies.

- [Original documentation](https://cloud.google.com/bigquery/docs/column-data-masking)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/bigquerydatapolicy_v1/bigquerydatapolicy_v1-library.html)

#### BigQuery Data Transfer API - `bigquerydatatransfer/v1`

Schedule queries or transfer external data from SaaS applications to Google BigQuery on a regular basis.

- [Original documentation](https://cloud.google.com/bigquery-transfer/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/bigquerydatatransfer_v1/bigquerydatatransfer_v1-library.html)

#### BigQuery Reservation API - `bigqueryreservation/v1`

A service to modify your BigQuery flat-rate reservations.

- [Original documentation](https://cloud.google.com/bigquery/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/bigqueryreservation_v1/bigqueryreservation_v1-library.html)

#### Cloud Bigtable Admin API - `bigtableadmin/v2`

Administer your Cloud Bigtable tables and instances.

- [Original documentation](https://cloud.google.com/bigtable/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/bigtableadmin_v2/bigtableadmin_v2-library.html)

#### Cloud Billing Budget API - `billingbudgets/v1`

The Cloud Billing Budget API stores Cloud Billing budgets, which define a budget plan and the rules to execute as spend is tracked against that plan.

- [Original documentation](https://cloud.google.com/billing/docs/how-to/budget-api-overview)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/billingbudgets_v1/billingbudgets_v1-library.html)

#### Binary Authorization API - `binaryauthorization/v1`

The management interface for Binary Authorization, a service that provides policy-based deployment validation and control for images deployed to Google Kubernetes Engine (GKE), Anthos Service Mesh, Anthos Clusters, and Cloud Run. 

- [Original documentation](https://cloud.google.com/binary-authorization/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/binaryauthorization_v1/binaryauthorization_v1-library.html)

#### Blockchain Node Engine API - `blockchainnodeengine/v1`

- [Original documentation](https://cloud.google.com/blockchain-node-engine)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/blockchainnodeengine_v1/blockchainnodeengine_v1-library.html)

#### Blogger API - `blogger/v3`

The Blogger API provides access to posts, comments and pages of a Blogger blog.

- [Original documentation](https://developers.google.com/blogger/docs/3.0/getting_started)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/blogger_v3/blogger_v3-library.html)

#### Books API - `books/v1`

The Google Books API allows clients to access the Google Books repository.

- [Original documentation](https://code.google.com/apis/books/docs/v1/getting_started.html)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/books_v1/books_v1-library.html)

#### Business Profile Performance API - `businessprofileperformance/v1`

The Business Profile Performance API allows merchants to fetch performance reports about their business profile on Google. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Original documentation](https://developers.google.com/my-business/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/businessprofileperformance_v1/businessprofileperformance_v1-library.html)

#### Calendar API - `calendar/v3`

Manipulates events and other calendar data.

- [Original documentation](https://developers.google.com/google-apps/calendar/firstapp)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/calendar_v3/calendar_v3-library.html)

#### Certificate Manager API - `certificatemanager/v1`

- [Original documentation](https://cloud.google.com/certificate-manager)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/certificatemanager_v1/certificatemanager_v1-library.html)

#### Google Chat API - `chat/v1`

The Google Chat API lets you build Chat apps to integrate your services with Google Chat and manage Chat resources such as spaces, members, and messages.

- [Original documentation](https://developers.google.com/hangouts/chat)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/chat_v1/chat_v1-library.html)

#### Chrome Management API - `chromemanagement/v1`

The Chrome Management API is a suite of services that allows Chrome administrators to view, manage and gain insights on their Chrome OS and Chrome Browser devices.

- [Original documentation](https://developers.google.com/chrome/management/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/chromemanagement_v1/chromemanagement_v1-library.html)

#### Chrome Policy API - `chromepolicy/v1`

The Chrome Policy API is a suite of services that allows Chrome administrators to control the policies applied to their managed Chrome OS devices and Chrome browsers.

- [Original documentation](https://developers.google.com/chrome/policy)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/chromepolicy_v1/chromepolicy_v1-library.html)

#### Chrome UX Report API - `chromeuxreport/v1`

The Chrome UX Report API lets you view real user experience data for millions of websites. 

- [Original documentation](https://developers.google.com/web/tools/chrome-user-experience-report/api/reference)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/chromeuxreport_v1/chromeuxreport_v1-library.html)

#### Google Civic Information API - `civicinfo/v2`

Provides polling places, early vote locations, contest data, election officials, and government representatives for U.S. residential addresses.

- [Original documentation](https://developers.google.com/civic-information/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/civicinfo_v2/civicinfo_v2-library.html)

#### Google Classroom API - `classroom/v1`

Manages classes, rosters, and invitations in Google Classroom.

- [Original documentation](https://developers.google.com/classroom/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/classroom_v1/classroom_v1-library.html)

#### Cloud Asset API - `cloudasset/v1`

The Cloud Asset API manages the history and inventory of Google Cloud resources.

- [Original documentation](https://cloud.google.com/asset-inventory/docs/quickstart)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudasset_v1/cloudasset_v1-library.html)

#### Cloud Billing API - `cloudbilling/v1`

Allows developers to manage billing for their Google Cloud Platform projects programmatically.

- [Original documentation](https://cloud.google.com/billing/docs/apis)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudbilling_v1/cloudbilling_v1-library.html)

#### Cloud Build API - `cloudbuild/v1`

Creates and manages builds on Google Cloud Platform.

- [Original documentation](https://cloud.google.com/cloud-build/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudbuild_v1/cloudbuild_v1-library.html)

#### Cloud Build API - `cloudbuild/v2`

Creates and manages builds on Google Cloud Platform.

- [Original documentation](https://cloud.google.com/cloud-build/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudbuild_v2/cloudbuild_v2-library.html)

#### Cloud Channel API - `cloudchannel/v1`

The Cloud Channel API enables Google Cloud partners to have a single unified resale platform and APIs across all of Google Cloud including GCP, Workspace, Maps and Chrome.

- [Original documentation](https://cloud.google.com/channel)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudchannel_v1/cloudchannel_v1-library.html)

#### Cloud Commerce Partner Procurement API - `cloudcommerceprocurement/v1`

Partner API for the Cloud Commerce Procurement Service.

- [Original documentation](https://cloud.google.com/marketplace/docs/partners/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudcommerceprocurement_v1/cloudcommerceprocurement_v1-library.html)

#### Cloud Controls Partner API - `cloudcontrolspartner/v1`

Provides insights about your customers and their Assured Workloads based on your Sovereign Controls by Partners offering.

- [Original documentation](https://cloud.google.com/sovereign-controls-by-partners/docs/sovereign-partners/reference/rest)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudcontrolspartner_v1/cloudcontrolspartner_v1-library.html)

#### Cloud Deploy API - `clouddeploy/v1`

- [Original documentation](https://cloud.google.com/deploy/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/clouddeploy_v1/clouddeploy_v1-library.html)

#### Cloud Functions API - `cloudfunctions/v1`

Manages lightweight user-provided functions executed in response to events.

- [Original documentation](https://cloud.google.com/functions)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudfunctions_v1/cloudfunctions_v1-library.html)

#### Cloud Functions API - `cloudfunctions/v2`

Manages lightweight user-provided functions executed in response to events.

- [Original documentation](https://cloud.google.com/functions)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudfunctions_v2/cloudfunctions_v2-library.html)

#### Cloud Identity API - `cloudidentity/v1`

API for provisioning and managing identity resources.

- [Original documentation](https://cloud.google.com/identity/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudidentity_v1/cloudidentity_v1-library.html)

#### Cloud Key Management Service (KMS) API - `cloudkms/v1`

Manages keys and performs cryptographic operations in a central cloud service, for direct use by other cloud resources and applications. 

- [Original documentation](https://cloud.google.com/kms/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudkms_v1/cloudkms_v1-library.html)

#### Cloud Profiler API - `cloudprofiler/v2`

Manages continuous profiling information.

- [Original documentation](https://cloud.google.com/profiler/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudprofiler_v2/cloudprofiler_v2-library.html)

#### Cloud Resource Manager API - `cloudresourcemanager/v1`

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

- [Original documentation](https://cloud.google.com/resource-manager)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudresourcemanager_v1/cloudresourcemanager_v1-library.html)

#### Cloud Resource Manager API - `cloudresourcemanager/v2`

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

- [Original documentation](https://cloud.google.com/resource-manager)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudresourcemanager_v2/cloudresourcemanager_v2-library.html)

#### Cloud Resource Manager API - `cloudresourcemanager/v3`

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

- [Original documentation](https://cloud.google.com/resource-manager)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudresourcemanager_v3/cloudresourcemanager_v3-library.html)

#### Cloud Scheduler API - `cloudscheduler/v1`

Creates and manages jobs run on a regular recurring schedule.

- [Original documentation](https://cloud.google.com/scheduler/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudscheduler_v1/cloudscheduler_v1-library.html)

#### Cloud Search API - `cloudsearch/v1`

Cloud Search provides cloud-based search capabilities over Google Workspace data. The Cloud Search API allows indexing of non-Google Workspace data into Cloud Search.

- [Original documentation](https://developers.google.com/cloud-search/docs/guides/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudsearch_v1/cloudsearch_v1-library.html)

#### Cloud Shell API - `cloudshell/v1`

Allows users to start, configure, and connect to interactive shell sessions running in the cloud. 

- [Original documentation](https://cloud.google.com/shell/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudshell_v1/cloudshell_v1-library.html)

#### Google Cloud Support API - `cloudsupport/v2`

Manages Google Cloud technical support cases for Customer Care support offerings. 

- [Original documentation](https://cloud.google.com/support/docs/apis)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudsupport_v2/cloudsupport_v2-library.html)

#### Cloud Tasks API - `cloudtasks/v2`

Manages the execution of large numbers of distributed requests.

- [Original documentation](https://cloud.google.com/tasks/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudtasks_v2/cloudtasks_v2-library.html)

#### Cloud Trace API - `cloudtrace/v2`

Sends application trace data to Cloud Trace for viewing. Trace data is collected for all App Engine applications by default. Trace data from other applications can be provided using this API. This library is used to interact with the Cloud Trace API directly. If you are looking to instrument your application for Cloud Trace, we recommend using OpenTelemetry. 

- [Original documentation](https://cloud.google.com/trace)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/cloudtrace_v2/cloudtrace_v2-library.html)

#### Cloud Composer API - `composer/v1`

Manages Apache Airflow environments on Google Cloud Platform.

- [Original documentation](https://cloud.google.com/composer/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/composer_v1/composer_v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/compute_engine-16.png) Compute Engine API - `compute/v1`

Creates and runs virtual machines on Google Cloud Platform. 

- [Original documentation](https://cloud.google.com/compute/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/compute_v1/compute_v1-library.html)

#### Infrastructure Manager API - `config/v1`

Creates and manages Google Cloud Platform resources and infrastructure.

- [Original documentation](https://cloud.google.com/infrastructure-manager/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/config_v1/config_v1-library.html)

#### Connectors API - `connectors/v1`

Enables users to create and manage connections to Google Cloud services and third-party business applications using the Connectors interface.

- [Original documentation](https://cloud.google.com/apigee/docs/api-platform/connectors/about-connectors)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/connectors_v1/connectors_v1-library.html)

#### Connectors API - `connectors/v2`

Enables users to create and manage connections to Google Cloud services and third-party business applications using the Connectors interface.

- [Original documentation](https://cloud.google.com/apigee/docs/api-platform/connectors/about-connectors)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/connectors_v2/connectors_v2-library.html)

#### Contact Center AI Insights API - `contactcenterinsights/v1`

- [Original documentation](https://cloud.google.com/contact-center/insights/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/contactcenterinsights_v1/contactcenterinsights_v1-library.html)

#### Kubernetes Engine API - `container/v1`

Builds and manages container-based applications, powered by the open source Kubernetes technology.

- [Original documentation](https://cloud.google.com/container-engine/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/container_v1/container_v1-library.html)

#### Container Analysis API - `containeranalysis/v1`

This API is a prerequisite for leveraging Artifact Analysis scanning capabilities in both Artifact Registry and with Advanced Vulnerability Insights (runtime scanning) in GKE. In addition, the Container Analysis API is an implementation of the Grafeas API, which enables storing, querying, and retrieval of critical metadata about all of your software artifacts.

- [Original documentation](https://cloud.google.com/container-analysis/api/reference/rest/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/containeranalysis_v1/containeranalysis_v1-library.html)

#### Content API for Shopping - `content/v2_1`

Manage your product listings and accounts for Google Shopping

- [Original documentation](https://developers.google.com/shopping-content/v2/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/content_v2_1/content_v2_1-library.html)

#### Document AI Warehouse API - `contentwarehouse/v1`

- [Original documentation](https://cloud.google.com/document-warehouse)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/contentwarehouse_v1/contentwarehouse_v1-library.html)

#### Custom Search API - `customsearch/v1`

Searches over a website or collection of websites

- [Original documentation](https://developers.google.com/custom-search/v1/introduction)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/customsearch_v1/customsearch_v1-library.html)

#### Google Cloud Data Catalog API - `datacatalog/v1`

A fully managed and highly scalable data discovery and metadata management service. 

- [Original documentation](https://cloud.google.com/data-catalog/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/datacatalog_v1/datacatalog_v1-library.html)

#### Cloud Data Fusion API - `datafusion/v1`

Cloud Data Fusion is a fully-managed, cloud native, enterprise data integration service for quickly building and managing data pipelines. It provides a graphical interface to increase time efficiency and reduce complexity, and allows business users, developers, and data scientists to easily and reliably build scalable data integration solutions to cleanse, prepare, blend, transfer and transform data without having to wrestle with infrastructure.

- [Original documentation](https://cloud.google.com/data-fusion/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/datafusion_v1/datafusion_v1-library.html)

#### Data Lineage API - `datalineage/v1`

- [Original documentation](https://cloud.google.com/data-catalog)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/datalineage_v1/datalineage_v1-library.html)

#### Database Migration API - `datamigration/v1`

Manage Cloud Database Migration Service resources on Google Cloud Platform.

- [Original documentation](https://cloud.google.com/database-migration/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/datamigration_v1/datamigration_v1-library.html)

#### Data pipelines API - `datapipelines/v1`

Data Pipelines provides an interface for creating, updating, and managing recurring Data Analytics jobs.

- [Original documentation](https://cloud.google.com/dataflow/docs/guides/data-pipelines)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/datapipelines_v1/datapipelines_v1-library.html)

#### Cloud Dataplex API - `dataplex/v1`

Dataplex API is used to manage the lifecycle of data lakes.

- [Original documentation](https://cloud.google.com/dataplex/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/dataplex_v1/dataplex_v1-library.html)

#### Data Portability API - `dataportability/v1`

The Data Portability API lets you build applications that request authorization from a user to move a copy of data from Google services into your application. This enables data portability and facilitates switching services.

- [Original documentation](https://developers.google.com/data-portability)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/dataportability_v1/dataportability_v1-library.html)

#### Cloud Dataproc API - `dataproc/v1`

Manages Hadoop-based clusters and jobs on Google Cloud Platform.

- [Original documentation](https://cloud.google.com/dataproc/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/dataproc_v1/dataproc_v1-library.html)

#### Cloud Datastore API - `datastore/v1`

Accesses the schemaless NoSQL database to provide fully managed, robust, scalable storage for your application. 

- [Original documentation](https://cloud.google.com/datastore/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/datastore_v1/datastore_v1-library.html)

#### Datastream API - `datastream/v1`

- [Original documentation](https://cloud.google.com/datastream/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/datastream_v1/datastream_v1-library.html)

#### Cloud Deployment Manager V2 API - `deploymentmanager/v2`

The Google Cloud Deployment Manager v2 API provides services for configuring, deploying, and viewing Google Cloud services and APIs via templates which specify deployments of Cloud resources.

- [Original documentation](https://cloud.google.com/deployment-manager)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/deploymentmanager_v2/deploymentmanager_v2-library.html)

#### Developer Connect API - `developerconnect/v1`

Connect third-party source code management to Google

- [Original documentation](http://cloud.google.com/developer-connect/docs/overview)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/developerconnect_v1/developerconnect_v1-library.html)

#### Campaign Manager 360 API - `dfareporting/v3_5`

Build applications to efficiently manage large or complex trafficking, reporting, and attribution workflows for Campaign Manager 360.

- [Original documentation](https://developers.google.com/doubleclick-advertisers/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/dfareporting_v3_5/dfareporting_v3_5-library.html)

#### Campaign Manager 360 API - `dfareporting/v4`

Build applications to efficiently manage large or complex trafficking, reporting, and attribution workflows for Campaign Manager 360.

- [Original documentation](https://developers.google.com/doubleclick-advertisers/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/dfareporting_v4/dfareporting_v4-library.html)

#### Dialogflow API - `dialogflow/v2`

Builds conversational interfaces (for example, chatbots, and voice-powered apps and devices).

- [Original documentation](https://cloud.google.com/dialogflow/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/dialogflow_v2/dialogflow_v2-library.html)

#### Dialogflow API - `dialogflow/v3`

Builds conversational interfaces (for example, chatbots, and voice-powered apps and devices).

- [Original documentation](https://cloud.google.com/dialogflow/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/dialogflow_v3/dialogflow_v3-library.html)

#### Digital Asset Links API - `digitalassetlinks/v1`

Discovers relationships between online assets such as websites or mobile apps.

- [Original documentation](https://developers.google.com/digital-asset-links/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/digitalassetlinks_v1/digitalassetlinks_v1-library.html)

#### API Discovery Service - `discovery/v1`

Provides information about other Google APIs, such as what APIs are available, the resource, and method details for each API.

- [Original documentation](https://developers.google.com/discovery/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/discovery_v1/discovery_v1-library.html)

#### Display & Video 360 API - `displayvideo/v2`

Display & Video 360 API allows users to automate complex Display & Video 360 workflows, such as creating insertion orders and setting targeting options for individual line items.

- [Original documentation](https://developers.google.com/display-video/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/displayvideo_v2/displayvideo_v2-library.html)

#### Display & Video 360 API - `displayvideo/v3`

Display & Video 360 API allows users to automate complex Display & Video 360 workflows, such as creating insertion orders and setting targeting options for individual line items.

- [Original documentation](https://developers.google.com/display-video/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/displayvideo_v3/displayvideo_v3-library.html)

#### Sensitive Data Protection (DLP) - `dlp/v2`

Discover and protect your sensitive data. A fully managed service designed to help you discover, classify, and protect your valuable data assets with ease.

- [Original documentation](https://cloud.google.com/sensitive-data-protection/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/dlp_v2/dlp_v2-library.html)

#### Cloud DNS API - `dns/v1`

- [Original documentation](https://cloud.google.com/dns/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/dns_v1/dns_v1-library.html)

#### Google Docs API - `docs/v1`

Reads and writes Google Docs documents.

- [Original documentation](https://developers.google.com/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/docs_v1/docs_v1-library.html)

#### Cloud Document AI API - `documentai/v1`

Service to parse structured information from unstructured or semi-structured documents using state-of-the-art Google AI such as natural language, computer vision, translation, and AutoML.

- [Original documentation](https://cloud.google.com/document-ai/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/documentai_v1/documentai_v1-library.html)

#### Cloud Domains API - `domains/v1`

Enables management and configuration of domain names.

- [Original documentation](https://cloud.google.com/domains/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/domains_v1/domains_v1-library.html)

#### Domains RDAP API - `domainsrdap/v1`

Read-only public API that lets users search for information about domain names.

- [Original documentation](https://developers.google.com/domains/rdap/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/domainsrdap_v1/domainsrdap_v1-library.html)

#### DoubleClick Bid Manager API - `doubleclickbidmanager/v2`

DoubleClick Bid Manager API allows users to manage and create campaigns and reports.

- [Original documentation](https://developers.google.com/bid-manager/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/doubleclickbidmanager_v2/doubleclickbidmanager_v2-library.html)

#### Search Ads 360 API - `doubleclicksearch/v2`

The Search Ads 360 API allows developers to automate uploading conversions and downloading reports from Search Ads 360.

- [Original documentation](https://developers.google.com/search-ads)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/doubleclicksearch_v2/doubleclicksearch_v2-library.html)

#### Google Drive API - `drive/v2`

The Google Drive API allows clients to access resources from Google Drive.

- [Original documentation](https://developers.google.com/drive/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/drive_v2/drive_v2-library.html)

#### Google Drive API - `drive/v3`

The Google Drive API allows clients to access resources from Google Drive.

- [Original documentation](https://developers.google.com/drive/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/drive_v3/drive_v3-library.html)

#### Drive Activity API - `driveactivity/v2`

Provides a historical view of activity in Google Drive.

- [Original documentation](https://developers.google.com/drive/activity/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/driveactivity_v2/driveactivity_v2-library.html)

#### Drive Labels API - `drivelabels/v2`

An API for managing Drive Labels

- [Original documentation](https://developers.google.com/drive/labels)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/drivelabels_v2/drivelabels_v2-library.html)

#### Essential Contacts API - `essentialcontacts/v1`

- [Original documentation](https://cloud.google.com/essentialcontacts/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/essentialcontacts_v1/essentialcontacts_v1-library.html)

#### Eventarc API - `eventarc/v1`

Build event-driven applications on Google Cloud Platform.

- [Original documentation](https://cloud.google.com/eventarc)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/eventarc_v1/eventarc_v1-library.html)

#### Firebase Cloud Messaging API - `fcm/v1`

FCM send API that provides a cross-platform messaging solution to reliably deliver messages at no cost.

- [Original documentation](https://firebase.google.com/docs/cloud-messaging)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/fcm_v1/fcm_v1-library.html)

#### Cloud Filestore API - `file/v1`

The Cloud Filestore API is used for creating and managing cloud file servers.

- [Original documentation](https://cloud.google.com/filestore/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/file_v1/file_v1-library.html)

#### Firebase App Check API - `firebaseappcheck/v1`

Firebase App Check works alongside other Firebase services to help protect your backend resources from abuse, such as billing fraud or phishing.

- [Original documentation](https://firebase.google.com/docs/app-check)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/firebaseappcheck_v1/firebaseappcheck_v1-library.html)

#### Firebase App Distribution API - `firebaseappdistribution/v1`

- [Original documentation](https://firebase.google.com/products/app-distribution)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/firebaseappdistribution_v1/firebaseappdistribution_v1-library.html)

#### Firebase Dynamic Links API - `firebasedynamiclinks/v1`

Programmatically creates and manages Firebase Dynamic Links.

- [Original documentation](https://firebase.google.com/docs/dynamic-links/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/firebasedynamiclinks_v1/firebasedynamiclinks_v1-library.html)

#### Firebase Hosting API - `firebasehosting/v1`

The Firebase Hosting REST API enables programmatic and customizable management and deployments to your Firebase-hosted sites. Use this REST API to create and manage channels and sites as well as to deploy new or updated hosting configurations and content files.

- [Original documentation](https://firebase.google.com/docs/hosting/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/firebasehosting_v1/firebasehosting_v1-library.html)

#### Firebase ML API - `firebaseml/v1`

Access custom machine learning models hosted via Firebase ML.

- [Original documentation](https://firebase.google.com)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/firebaseml_v1/firebaseml_v1-library.html)

#### Firebase Remote Config API - `firebaseremoteconfig/v1`

The Firebase Remote Config API lets developers change the behavior and appearance of their apps without requiring users to download an app update. It is an alternative to, but can be used in tandem with, the Firebase console at https://console.firebase.google.com.

- [Original documentation](https://firebase.google.com/docs/remote-config/use-config-rest)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/firebaseremoteconfig_v1/firebaseremoteconfig_v1-library.html)

#### Firebase Rules API - `firebaserules/v1`

Creates and manages rules that determine when a Firebase Rules-enabled service should permit a request. 

- [Original documentation](https://firebase.google.com/docs/storage/security)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/firebaserules_v1/firebaserules_v1-library.html)

#### Cloud Firestore API - `firestore/v1`

Accesses the NoSQL document database built for automatic scaling, high performance, and ease of application development. 

- [Original documentation](https://cloud.google.com/firestore)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/firestore_v1/firestore_v1-library.html)

#### Fitness API - `fitness/v1`

The Fitness API for managing users' fitness tracking data.

- [Original documentation](https://developers.google.com/fit/rest/v1/get-started)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/fitness_v1/fitness_v1-library.html)

#### Google Forms API - `forms/v1`

Reads and writes Google Forms and responses.

- [Original documentation](https://developers.google.com/forms/api)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/forms_v1/forms_v1-library.html)

#### Google Play Game Services - `games/v1`

The Google Play games service allows developers to enhance games with social leaderboards, achievements, game state, sign-in with Google, and more.

- [Original documentation](https://developers.google.com/games/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/games_v1/games_v1-library.html)

#### Google Play Game Services Publishing API - `gamesConfiguration/v1configuration`

The Google Play Game Services Publishing API allows developers to configure their games in Game Services.

- [Original documentation](https://developers.google.com/games/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/gamesConfiguration_v1configuration/gamesConfiguration_v1configuration-library.html)

#### Google Play Game Management - `gamesManagement/v1management`

The Google Play Game Management API allows developers to manage resources from the Google Play Game service.

- [Original documentation](https://developers.google.com/games/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/gamesManagement_v1management/gamesManagement_v1management-library.html)

#### Backup for GKE API - `gkebackup/v1`

Backup for GKE is a managed Kubernetes workload backup and restore service for GKE clusters.

- [Original documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/gkebackup_v1/gkebackup_v1-library.html)

#### GKE Hub API - `gkehub/v1`

- [Original documentation](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/gkehub_v1/gkehub_v1-library.html)

#### Anthos On-Prem API - `gkeonprem/v1`

- [Original documentation](https://cloud.google.com/anthos/clusters/docs/on-prem/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/gkeonprem_v1/gkeonprem_v1-library.html)

#### Gmail API - `gmail/v1`

The Gmail API lets you view and manage Gmail mailbox data like threads, messages, and labels.

- [Original documentation](https://developers.google.com/gmail/api/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/gmail_v1/gmail_v1-library.html)

#### Gmail Postmaster Tools API - `gmailpostmastertools/v1`

The Postmaster Tools API is a RESTful API that provides programmatic access to email traffic metrics (like spam reports, delivery errors etc) otherwise available through the Gmail Postmaster Tools UI currently.

- [Original documentation](https://developers.google.com/gmail/postmaster)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/gmailpostmastertools_v1/gmailpostmastertools_v1-library.html)

#### Groups Migration API - `groupsmigration/v1`

The Groups Migration API allows domain administrators to archive emails into Google groups.

- [Original documentation](https://developers.google.com/google-apps/groups-migration/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/groupsmigration_v1/groupsmigration_v1-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Groups Settings API - `groupssettings/v1`

Manages permission levels and related settings of a group.

- [Original documentation](https://developers.google.com/google-apps/groups-settings/get_started)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/groupssettings_v1/groupssettings_v1-library.html)

#### Cloud Healthcare API - `healthcare/v1`

Manage, store, and access healthcare data in Google Cloud Platform.

- [Original documentation](https://cloud.google.com/healthcare)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/healthcare_v1/healthcare_v1-library.html)

#### HomeGraph API - `homegraph/v1`

- [Original documentation](https://developers.home.google.com/cloud-to-cloud/get-started)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/homegraph_v1/homegraph_v1-library.html)

#### Identity and Access Management (IAM) API - `iam/v1`

Manages identity and access control for Google Cloud resources, including the creation of service accounts, which you can use to authenticate to Google and make API calls. Enabling this API also enables the IAM Service Account Credentials API (iamcredentials.googleapis.com). However, disabling this API doesn't disable the IAM Service Account Credentials API. 

- [Original documentation](https://cloud.google.com/iam/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/iam_v1/iam_v1-library.html)

#### Identity and Access Management (IAM) API - `iam/v2`

Manages identity and access control for Google Cloud resources, including the creation of service accounts, which you can use to authenticate to Google and make API calls. Enabling this API also enables the IAM Service Account Credentials API (iamcredentials.googleapis.com). However, disabling this API doesn't disable the IAM Service Account Credentials API. 

- [Original documentation](https://cloud.google.com/iam/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/iam_v2/iam_v2-library.html)

#### IAM Service Account Credentials API - `iamcredentials/v1`

Creates short-lived credentials for impersonating IAM service accounts. Disabling this API also disables the IAM API (iam.googleapis.com). However, enabling this API doesn't enable the IAM API. 

- [Original documentation](https://cloud.google.com/iam/docs/creating-short-lived-service-account-credentials)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/iamcredentials_v1/iamcredentials_v1-library.html)

#### Cloud Identity-Aware Proxy API - `iap/v1`

Controls access to cloud applications running on Google Cloud Platform.

- [Original documentation](https://cloud.google.com/iap)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/iap_v1/iap_v1-library.html)

#### Identity Toolkit API - `identitytoolkit/v1`

The Google Identity Toolkit API lets you use open standards to verify a user's identity.

- [Original documentation](https://cloud.google.com/identity-platform)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/identitytoolkit_v1/identitytoolkit_v1-library.html)

#### Identity Toolkit API - `identitytoolkit/v2`

The Google Identity Toolkit API lets you use open standards to verify a user's identity.

- [Original documentation](https://cloud.google.com/identity-platform)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/identitytoolkit_v2/identitytoolkit_v2-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Google Identity Toolkit API - `identitytoolkit/v3`

Help the third party sites to implement federated login.

- [Original documentation](https://developers.google.com/identity-toolkit/v3/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/identitytoolkit_v3/identitytoolkit_v3-library.html)

#### Cloud IDS API - `ids/v1`

Cloud IDS (Cloud Intrusion Detection System) detects malware, spyware, command-and-control attacks, and other network-based threats. Its security efficacy is industry leading, built with Palo Alto Networks technologies. When you use this product, your organization name and consumption levels will be shared with Palo Alto Networks.

- [Original documentation](https://cloud.google.com/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/ids_v1/ids_v1-library.html)

#### Web Search Indexing API - `indexing/v3`

Notifies Google Web Search when your web pages change.

- [Original documentation](https://developers.google.com/search/apis/indexing-api/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/indexing_v3/indexing_v3-library.html)

#### Application Integration API - `integrations/v1`

- [Original documentation](https://cloud.google.com/application-integration)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/integrations_v1/integrations_v1-library.html)

#### Cloud Talent Solution API - `jobs/v3`

Cloud Talent Solution provides the capability to create, read, update, and delete job postings, as well as search jobs based on keywords and filters. 

- [Original documentation](https://cloud.google.com/talent-solution/job-search/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/jobs_v3/jobs_v3-library.html)

#### Cloud Talent Solution API - `jobs/v4`

Cloud Talent Solution provides the capability to create, read, update, and delete job postings, as well as search jobs based on keywords and filters. 

- [Original documentation](https://cloud.google.com/talent-solution/job-search/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/jobs_v4/jobs_v4-library.html)

#### Google Keep API - `keep/v1`

The Google Keep API is used in an enterprise environment to manage Google Keep content and resolve issues identified by cloud security software.

- [Original documentation](https://developers.google.com/keep/api)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/keep_v1/keep_v1-library.html)

#### Knowledge Graph Search API - `kgsearch/v1`

Searches the Google Knowledge Graph for entities.

- [Original documentation](https://developers.google.com/knowledge-graph/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/kgsearch_v1/kgsearch_v1-library.html)

#### KMS Inventory API - `kmsinventory/v1`

- [Original documentation](https://cloud.google.com/kms/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/kmsinventory_v1/kmsinventory_v1-library.html)

#### Cloud Natural Language API - `language/v1`

Provides natural language understanding technologies, such as sentiment analysis, entity recognition, entity sentiment analysis, and other text annotations, to developers.

- [Original documentation](https://cloud.google.com/natural-language/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/language_v1/language_v1-library.html)

#### Cloud Natural Language API - `language/v2`

Provides natural language understanding technologies, such as sentiment analysis, entity recognition, entity sentiment analysis, and other text annotations, to developers.

- [Original documentation](https://cloud.google.com/natural-language/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/language_v2/language_v2-library.html)

#### Library Agent API - `libraryagent/v1`

A simple Google Example Library API.

- [Original documentation](https://cloud.google.com/docs/quota)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/libraryagent_v1/libraryagent_v1-library.html)

#### Enterprise License Manager API - `licensing/v1`

The Google Enterprise License Manager API lets you manage Google Workspace and related licenses for all users of a customer that you manage.

- [Original documentation](https://developers.google.com/admin-sdk/licensing/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/licensing_v1/licensing_v1-library.html)

#### Local Services API - `localservices/v1`

- [Original documentation](https://ads.google.com/local-services-ads/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/localservices_v1/localservices_v1-library.html)

#### Cloud Logging API - `logging/v2`

Writes log entries and manages your Cloud Logging configuration.

- [Original documentation](https://cloud.google.com/logging/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/logging_v2/logging_v2-library.html)

#### Looker (Google Cloud core) API - `looker/v1`

- [Original documentation](https://cloud.google.com/looker/docs/reference/rest/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/looker_v1/looker_v1-library.html)

#### Managed Service for Microsoft Active Directory API - `managedidentities/v1`

The Managed Service for Microsoft Active Directory API is used for managing a highly available, hardened service running Microsoft Active Directory (AD).

- [Original documentation](https://cloud.google.com/managed-microsoft-ad/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/managedidentities_v1/managedidentities_v1-library.html)

#### Manufacturer Center API - `manufacturers/v1`

Public API for managing Manufacturer Center related data.

- [Original documentation](https://developers.google.com/manufacturers/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/manufacturers_v1/manufacturers_v1-library.html)

#### Cloud Memorystore for Memcached API - `memcache/v1`

Google Cloud Memorystore for Memcached API is used for creating and managing Memcached instances in GCP.

- [Original documentation](https://cloud.google.com/memorystore/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/memcache_v1/memcache_v1-library.html)

#### Dataproc Metastore API - `metastore/v1`

The Dataproc Metastore API is used to manage the lifecycle and configuration of metastore services.

- [Original documentation](https://cloud.google.com/dataproc-metastore/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/metastore_v1/metastore_v1-library.html)

#### Migration Center API - `migrationcenter/v1`

A unified platform that helps you accelerate your end-to-end cloud journey from your current on-premises or cloud environments to Google Cloud.

- [Original documentation](https://cloud.google.com/migration-center)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/migrationcenter_v1/migrationcenter_v1-library.html)

#### AI Platform Training & Prediction API - `ml/v1`

An API to enable creating and using machine learning models.

- [Original documentation](https://cloud.google.com/ml/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/ml_v1/ml_v1-library.html)

#### Cloud Monitoring API - `monitoring/v3`

Manages your Cloud Monitoring data and configurations.

- [Original documentation](https://cloud.google.com/monitoring/api/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/monitoring_v3/monitoring_v3-library.html)

#### My Business Account Management API - `mybusinessaccountmanagement/v1`

The My Business Account Management API provides an interface for managing access to a location on Google. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Original documentation](https://developers.google.com/my-business/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/mybusinessaccountmanagement_v1/mybusinessaccountmanagement_v1-library.html)

#### My Business Business Information API - `mybusinessbusinessinformation/v1`

The My Business Business Information API provides an interface for managing business information. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Original documentation](https://developers.google.com/my-business/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/mybusinessbusinessinformation_v1/mybusinessbusinessinformation_v1-library.html)

#### My Business Lodging API - `mybusinesslodging/v1`

The My Business Lodging API enables managing lodging business information on Google. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Original documentation](https://developers.google.com/my-business/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/mybusinesslodging_v1/mybusinesslodging_v1-library.html)

#### My Business Notifications API - `mybusinessnotifications/v1`

The My Business Notification Settings API enables managing notification settings for business accounts. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Original documentation](https://developers.google.com/my-business/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/mybusinessnotifications_v1/mybusinessnotifications_v1-library.html)

#### My Business Place Actions API - `mybusinessplaceactions/v1`

The My Business Place Actions API provides an interface for managing place action links of a location on Google. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Original documentation](https://developers.google.com/my-business/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/mybusinessplaceactions_v1/mybusinessplaceactions_v1-library.html)

#### My Business Q&A API - `mybusinessqanda/v1`

The My Business Q&A API allows questions and answers to be posted for specific listings. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Original documentation](https://developers.google.com/my-business/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/mybusinessqanda_v1/mybusinessqanda_v1-library.html)

#### My Business Verifications API - `mybusinessverifications/v1`

The My Business Verifications API provides an interface for taking verifications related actions for locations.

- [Original documentation](https://developers.google.com/my-business/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/mybusinessverifications_v1/mybusinessverifications_v1-library.html)

#### Network Connectivity API - `networkconnectivity/v1`

This API enables connectivity with and between Google Cloud resources.

- [Original documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/networkconnectivity_v1/networkconnectivity_v1-library.html)

#### Network Management API - `networkmanagement/v1`

The Network Management API provides a collection of network performance monitoring and diagnostic capabilities.

- [Original documentation](https://cloud.google.com/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/networkmanagement_v1/networkmanagement_v1-library.html)

#### Network Security API - `networksecurity/v1`

- [Original documentation](https://cloud.google.com/networking)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/networksecurity_v1/networksecurity_v1-library.html)

#### Network Services API - `networkservices/v1`

- [Original documentation](https://cloud.google.com/networking)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/networkservices_v1/networkservices_v1-library.html)

#### Notebooks API - `notebooks/v1`

Notebooks API is used to manage notebook resources in Google Cloud.

- [Original documentation](https://cloud.google.com/notebooks/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/notebooks_v1/notebooks_v1-library.html)

#### Notebooks API - `notebooks/v2`

Notebooks API is used to manage notebook resources in Google Cloud.

- [Original documentation](https://cloud.google.com/notebooks/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/notebooks_v2/notebooks_v2-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Google OAuth2 API - `oauth2/v2`

Obtains end-user authorization grants for use with other Google APIs.

- [Original documentation](https://developers.google.com/identity/protocols/oauth2/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/oauth2_v2/oauth2_v2-library.html)

#### On-Demand Scanning API - `ondemandscanning/v1`

A service to scan container images for vulnerabilities.

- [Original documentation](https://cloud.google.com/container-analysis/docs/on-demand-scanning/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/ondemandscanning_v1/ondemandscanning_v1-library.html)

#### Organization Policy API - `orgpolicy/v2`

The Organization Policy API allows users to configure governance rules on their Google Cloud resources across the resource hierarchy.

- [Original documentation](https://cloud.google.com/orgpolicy/docs/reference/rest/index.html)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/orgpolicy_v2/orgpolicy_v2-library.html)

#### OS Config API - `osconfig/v1`

OS management tools that can be used for patch management, patch compliance, and configuration management on VM instances.

- [Original documentation](https://cloud.google.com/compute/docs/osconfig/rest)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/osconfig_v1/osconfig_v1-library.html)

#### Cloud OS Login API - `oslogin/v1`

You can use OS Login to manage access to your VM instances using IAM roles.

- [Original documentation](https://cloud.google.com/compute/docs/oslogin/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/oslogin_v1/oslogin_v1-library.html)

#### PageSpeed Insights API - `pagespeedonline/v5`

The PageSpeed Insights API lets you analyze the performance of your website with a simple API. It offers tailored suggestions for how you can optimize your site, and lets you easily integrate PageSpeed Insights analysis into your development tools and workflow. 

- [Original documentation](https://developers.google.com/speed/docs/insights/v5/about)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/pagespeedonline_v5/pagespeedonline_v5-library.html)

#### Payments Reseller Subscription API - `paymentsresellersubscription/v1`

- [Original documentation](https://developers.google.com/payments/reseller/subscription/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/paymentsresellersubscription_v1/paymentsresellersubscription_v1-library.html)

#### People API - `people/v1`

Provides access to information about profiles and contacts.

- [Original documentation](https://developers.google.com/people/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/people_v1/people_v1-library.html)

#### Photos Library API - `photoslibrary/v1`

Manage photos, videos, and albums in Google Photos 

- [Original documentation](https://developers.google.com/photos/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/photoslibrary_v1/photoslibrary_v1-library.html)

#### Places API (New) - `places/v1`

- [Original documentation](https://mapsplatform.google.com/maps-products/#places-section)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/places_v1/places_v1-library.html)

#### Google Play Custom App Publishing API - `playcustomapp/v1`

API to create and publish custom Android apps

- [Original documentation](https://developers.google.com/android/work/play/custom-app-api/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/playcustomapp_v1/playcustomapp_v1-library.html)

#### Google Play Integrity API - `playintegrity/v1`

The Play Integrity API helps you check that you're interacting with your genuine app on a genuine Android device powered by Google Play services. The Play Integrity API has replaced SafetyNet Attestation and Android Device Verification.

- [Original documentation](https://developer.android.com/google/play/integrity)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/playintegrity_v1/playintegrity_v1-library.html)

#### Policy Analyzer API - `policyanalyzer/v1`

- [Original documentation](https://www.google.com)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/policyanalyzer_v1/policyanalyzer_v1-library.html)

#### Policy Simulator API - `policysimulator/v1`

 Policy Simulator is a collection of endpoints for creating, running, and viewing a Replay. A `Replay` is a type of simulation that lets you see how your members' access to resources might change if you changed your IAM policy. During a `Replay`, Policy Simulator re-evaluates, or replays, past access attempts under both the current policy and your proposed policy, and compares those results to determine how your members' access might change under the proposed policy.

- [Original documentation](https://cloud.google.com/iam/docs/simulating-access)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/policysimulator_v1/policysimulator_v1-library.html)

#### Policy Troubleshooter API - `policytroubleshooter/v1`

- [Original documentation](https://cloud.google.com/iam/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/policytroubleshooter_v1/policytroubleshooter_v1-library.html)

#### Pollen API - `pollen/v1`

The Pollen API. 

- [Original documentation](https://developers.google.com/maps/documentation/pollen)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/pollen_v1/pollen_v1-library.html)

#### Certificate Authority API - `privateca/v1`

The Certificate Authority Service API is a highly-available, scalable service that enables you to simplify and automate the management of private certificate authorities (CAs) while staying in control of your private keys. 

- [Original documentation](https://cloud.google.com/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/privateca_v1/privateca_v1-library.html)

#### Public Certificate Authority API - `publicca/v1`

The Public Certificate Authority API may be used to create and manage ACME external account binding keys associated with Google Trust Services' publicly trusted certificate authority. 

- [Original documentation](https://cloud.google.com/public-certificate-authority/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/publicca_v1/publicca_v1-library.html)

#### Cloud Pub/Sub API - `pubsub/v1`

Provides reliable, many-to-many, asynchronous messaging between applications. 

- [Original documentation](https://cloud.google.com/pubsub/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/pubsub_v1/pubsub_v1-library.html)

#### Pub/Sub Lite API - `pubsublite/v1`

- [Original documentation](https://cloud.google.com/pubsub/lite/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/pubsublite_v1/pubsublite_v1-library.html)

#### Rapid Migration Assessment API - `rapidmigrationassessment/v1`

The Rapid Migration Assessment service is our first-party migration assessment and planning tool.

- [Original documentation](https://cloud.google.com/migration-center)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/rapidmigrationassessment_v1/rapidmigrationassessment_v1-library.html)

#### Reader Revenue Subscription Linking API - `readerrevenuesubscriptionlinking/v1`

readerrevenuesubscriptionlinking.googleapis.com API.

- [Original documentation](https://developers.google.com/news/subscribe/subscription-linking/overview)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/readerrevenuesubscriptionlinking_v1/readerrevenuesubscriptionlinking_v1-library.html)

#### Real-time Bidding API - `realtimebidding/v1`

Allows external bidders to manage their RTB integration with Google. This includes managing bidder endpoints, QPS quotas, configuring what ad inventory to receive via pretargeting, submitting creatives for verification, and accessing creative metadata such as approval status.

- [Original documentation](https://developers.google.com/authorized-buyers/apis/realtimebidding/reference/rest/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/realtimebidding_v1/realtimebidding_v1-library.html)

#### reCAPTCHA Enterprise API - `recaptchaenterprise/v1`

Help protect your website from fraudulent activity, spam, and abuse without creating friction.

- [Original documentation](https://cloud.google.com/recaptcha-enterprise/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/recaptchaenterprise_v1/recaptchaenterprise_v1-library.html)

#### Recommender API - `recommender/v1`

- [Original documentation](https://cloud.google.com/recommender/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/recommender_v1/recommender_v1-library.html)

#### Google Cloud Memorystore for Redis API - `redis/v1`

Creates and manages Redis instances on the Google Cloud Platform.

- [Original documentation](https://cloud.google.com/memorystore/docs/redis/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/redis_v1/redis_v1-library.html)

#### Google Workspace Reseller API - `reseller/v1`

Perform common functions that are available on the Channel Services console at scale, like placing orders and viewing customer information

- [Original documentation](https://developers.google.com/google-apps/reseller/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/reseller_v1/reseller_v1-library.html)

#### Resource Settings API - `resourcesettings/v1`

The Resource Settings API allows users to control and modify the behavior of their GCP resources (e.g., VM, firewall, Project, etc.) across the Cloud Resource Hierarchy.

- [Original documentation](https://cloud.google.com/resource-manager/docs/resource-settings/overview)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/resourcesettings_v1/resourcesettings_v1-library.html)

#### Vertex AI Search for Retail API - `retail/v2`

Vertex AI Search for Retail API is made up of Retail Search, Browse and Recommendations. These discovery AI solutions help you implement personalized search, browse and recommendations, based on machine learning models, across your websites and mobile applications.

- [Original documentation](https://cloud.google.com/recommendations)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/retail_v2/retail_v2-library.html)

#### Cloud Run Admin API - `run/v1`

Deploy and manage user provided container images that scale automatically based on incoming requests. The Cloud Run Admin API v1 follows the Knative Serving API specification, while v2 is aligned with Google Cloud AIP-based API standards, as described in https://google.aip.dev/.

- [Original documentation](https://cloud.google.com/run/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/run_v1/run_v1-library.html)

#### Cloud Run Admin API - `run/v2`

Deploy and manage user provided container images that scale automatically based on incoming requests. The Cloud Run Admin API v1 follows the Knative Serving API specification, while v2 is aligned with Google Cloud AIP-based API standards, as described in https://google.aip.dev/.

- [Original documentation](https://cloud.google.com/run/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/run_v2/run_v2-library.html)

#### Cloud Runtime Configuration API - `runtimeconfig/v1`

The Runtime Configurator allows you to dynamically configure and expose variables through Google Cloud Platform. In addition, you can also set Watchers and Waiters that will watch for changes to your data and return based on certain conditions.

- [Original documentation](https://cloud.google.com/deployment-manager/runtime-configurator/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/runtimeconfig_v1/runtimeconfig_v1-library.html)

#### Safe Browsing API - `safebrowsing/v4`

Enables client applications to check web resources (most commonly URLs) against Google-generated lists of unsafe web resources. The Safe Browsing APIs are for non-commercial use only. If you need to use APIs to detect malicious URLs for commercial purposes – meaning “for sale or revenue-generating purposes” – please refer to the Web Risk API.

- [Original documentation](https://developers.google.com/safe-browsing/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/safebrowsing_v4/safebrowsing_v4-library.html)

#### Safe Browsing API - `safebrowsing/v5`

Enables client applications to check web resources (most commonly URLs) against Google-generated lists of unsafe web resources. The Safe Browsing APIs are for non-commercial use only. If you need to use APIs to detect malicious URLs for commercial purposes – meaning “for sale or revenue-generating purposes” – please refer to the Web Risk API.

- [Original documentation](https://developers.google.com/safe-browsing/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/safebrowsing_v5/safebrowsing_v5-library.html)

#### Apps Script API - `script/v1`

Manages and executes Google Apps Script projects. 

- [Original documentation](https://developers.google.com/apps-script/api/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/script_v1/script_v1-library.html)

#### Google Search Console API - `searchconsole/v1`

The Search Console API provides access to both Search Console data (verified users only) and to public information on an URL basis (anyone)

- [Original documentation](https://developers.google.com/webmaster-tools/search-console-api/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/searchconsole_v1/searchconsole_v1-library.html)

#### Secret Manager API - `secretmanager/v1`

Stores sensitive data such as API keys, passwords, and certificates. Provides convenience while improving security. 

- [Original documentation](https://cloud.google.com/secret-manager/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/secretmanager_v1/secretmanager_v1-library.html)

#### Security Command Center API - `securitycenter/v1`

Security Command Center API provides access to temporal views of assets and findings within an organization.

- [Original documentation](https://cloud.google.com/security-command-center)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/securitycenter_v1/securitycenter_v1-library.html)

#### Service Consumer Management API - `serviceconsumermanagement/v1`

Manages the service consumers of a Service Infrastructure service.

- [Original documentation](https://cloud.google.com/service-consumer-management/docs/overview)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/serviceconsumermanagement_v1/serviceconsumermanagement_v1-library.html)

#### Service Control API - `servicecontrol/v1`

Provides admission control and telemetry reporting for services integrated with Service Infrastructure. 

- [Original documentation](https://cloud.google.com/service-control/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/servicecontrol_v1/servicecontrol_v1-library.html)

#### Service Control API - `servicecontrol/v2`

Provides admission control and telemetry reporting for services integrated with Service Infrastructure. 

- [Original documentation](https://cloud.google.com/service-control/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/servicecontrol_v2/servicecontrol_v2-library.html)

#### Service Directory API - `servicedirectory/v1`

Service Directory is a platform for discovering, publishing, and connecting services. 

- [Original documentation](https://cloud.google.com/service-directory)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/servicedirectory_v1/servicedirectory_v1-library.html)

#### Service Management API - `servicemanagement/v1`

Google Service Management allows service producers to publish their services on Google Cloud Platform so that they can be discovered and used by service consumers.

- [Original documentation](https://cloud.google.com/service-management/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/servicemanagement_v1/servicemanagement_v1-library.html)

#### Service Networking API - `servicenetworking/v1`

Provides automatic management of network configurations necessary for certain services.

- [Original documentation](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/servicenetworking_v1/servicenetworking_v1-library.html)

#### Service Usage API - `serviceusage/v1`

Enables services that service consumers want to use on Google Cloud Platform, lists the available or enabled services, or disables services that service consumers no longer use.

- [Original documentation](https://cloud.google.com/service-usage/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/serviceusage_v1/serviceusage_v1-library.html)

#### Google Sheets API - `sheets/v4`

Reads and writes Google Sheets.

- [Original documentation](https://developers.google.com/sheets/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/sheets_v4/sheets_v4-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Google Site Verification API - `siteVerification/v1`

Verifies ownership of websites or domains with Google.

- [Original documentation](https://developers.google.com/site-verification/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/siteVerification_v1/siteVerification_v1-library.html)

#### Google Slides API - `slides/v1`

Reads and writes Google Slides presentations.

- [Original documentation](https://developers.google.com/slides/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/slides_v1/slides_v1-library.html)

#### Smart Device Management API - `smartdevicemanagement/v1`

Allow select enterprise partners to access, control, and manage Google and Nest devices programmatically.

- [Original documentation](https://developers.google.com/nest/device-access)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/smartdevicemanagement_v1/smartdevicemanagement_v1-library.html)

#### Solar API - `solar/v1`

Solar API.

- [Original documentation](https://developers.google.com/maps/documentation/solar)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/solar_v1/solar_v1-library.html)

#### Cloud Source Repositories API - `sourcerepo/v1`

Accesses source code repositories hosted by Google. Important: Cloud Source Repositories is scheduled for end of sales starting June 17, 2024. Customers who have enabled the API prior to this date will not be affected and can continue to use Cloud Source Repositories. Organizations or projects who have not previously enabled the API cannot use Cloud Source Repositories after this date. View Cloud Source Repositories documentation for more info. 

- [Original documentation](https://cloud.google.com/source-repositories/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/sourcerepo_v1/sourcerepo_v1-library.html)

#### Cloud Spanner API - `spanner/v1`

Cloud Spanner is a managed, mission-critical, globally consistent and scalable relational database service.

- [Original documentation](https://cloud.google.com/spanner/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/spanner_v1/spanner_v1-library.html)

#### Cloud Speech-to-Text API - `speech/v1`

Converts audio to text by applying powerful neural network models.

- [Original documentation](https://cloud.google.com/speech-to-text/docs/quickstart-protocol)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/speech_v1/speech_v1-library.html)

#### Cloud Speech-to-Text API - `speech/v2`

Converts audio to text by applying powerful neural network models.

- [Original documentation](https://cloud.google.com/speech-to-text/docs/quickstart-protocol)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/speech_v2/speech_v2-library.html)

#### ![Logo](https://www.google.com/images/icons/product/cloud_storage-16.png) Cloud Storage JSON API - `storage/v1`

Stores and retrieves potentially large, immutable data objects.

- [Original documentation](https://developers.google.com/storage/docs/json_api/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/storage_v1/storage_v1-library.html)

#### Storage Transfer API - `storagetransfer/v1`

Transfers data from external data sources to a Google Cloud Storage bucket or between Google Cloud Storage buckets. 

- [Original documentation](https://cloud.google.com/storage-transfer/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/storagetransfer_v1/storagetransfer_v1-library.html)

#### Street View Publish API - `streetviewpublish/v1`

Publishes 360 photos to Google Maps, along with position, orientation, and connectivity metadata. Apps can offer an interface for positioning, connecting, and uploading user-generated Street View images. 

- [Original documentation](https://developers.google.com/streetview/publish/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/streetviewpublish_v1/streetviewpublish_v1-library.html)

#### Security Token Service API - `sts/v1`

The Security Token Service exchanges Google or third-party credentials for a short-lived access token to Google Cloud resources.

- [Original documentation](https://cloud.google.com/iam/docs/workload-identity-federation)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/sts_v1/sts_v1-library.html)

#### Tag Manager API - `tagmanager/v1`

This API allows clients to access and modify container and tag configuration.

- [Original documentation](https://developers.google.com/tag-manager)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/tagmanager_v1/tagmanager_v1-library.html)

#### Tag Manager API - `tagmanager/v2`

This API allows clients to access and modify container and tag configuration.

- [Original documentation](https://developers.google.com/tag-manager)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/tagmanager_v2/tagmanager_v2-library.html)

#### Google Tasks API - `tasks/v1`

The Google Tasks API lets you manage your tasks and task lists.

- [Original documentation](https://developers.google.com/tasks/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/tasks_v1/tasks_v1-library.html)

#### Cloud Testing API - `testing/v1`

Allows developers to run automated tests for their mobile applications on Google infrastructure.

- [Original documentation](https://firebase.google.com/docs/test-lab/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/testing_v1/testing_v1-library.html)

#### Cloud Text-to-Speech API - `texttospeech/v1`

Synthesizes natural-sounding speech by applying powerful neural network models.

- [Original documentation](https://cloud.google.com/text-to-speech/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/texttospeech_v1/texttospeech_v1-library.html)

#### Cloud TPU API - `tpu/v1`

TPU API provides customers with access to Google TPU technology.

- [Original documentation](https://cloud.google.com/tpu/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/tpu_v1/tpu_v1-library.html)

#### Cloud TPU API - `tpu/v2`

TPU API provides customers with access to Google TPU technology.

- [Original documentation](https://cloud.google.com/tpu/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/tpu_v2/tpu_v2-library.html)

#### Traffic Director API - `trafficdirector/v2`

- [Original documentation](https://cloud.google.com/traffic-director)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/trafficdirector_v2/trafficdirector_v2-library.html)

#### Traffic Director API - `trafficdirector/v3`

- [Original documentation](https://cloud.google.com/traffic-director)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/trafficdirector_v3/trafficdirector_v3-library.html)

#### Transcoder API - `transcoder/v1`

This API converts video files into formats suitable for consumer distribution. For more information, see the Transcoder API overview. 

- [Original documentation](https://cloud.google.com/transcoder/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/transcoder_v1/transcoder_v1-library.html)

#### Cloud Translation API - `translate/v3`

Integrates text translation into your website or application.

- [Original documentation](https://cloud.google.com/translate/docs/quickstarts)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/translate_v3/translate_v3-library.html)

#### Travel Impact Model API - `travelimpactmodel/v1`

Travel Impact Model API lets you query travel carbon emission estimates.

- [Original documentation](https://developers.google.com/travel/impact-model)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/travelimpactmodel_v1/travelimpactmodel_v1-library.html)

#### Google Vault API - `vault/v1`

Retention and eDiscovery for Google Workspace. To work with Vault resources, the account must have the [required Vault privileges](https://support.google.com/vault/answer/2799699) and access to the matter. To access a matter, the account must have created the matter, have the matter shared with them, or have the **View All Matters** privilege. For example, to download an export, an account needs the **Manage Exports** privilege and the matter shared with them. 

- [Original documentation](https://developers.google.com/vault)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/vault_v1/vault_v1-library.html)

#### Chrome Verified Access API - `verifiedaccess/v1`

API for Verified Access chrome extension to provide credential verification for chrome devices connecting to an enterprise network

- [Original documentation](https://developers.google.com/chrome/verified-access)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/verifiedaccess_v1/verifiedaccess_v1-library.html)

#### Chrome Verified Access API - `verifiedaccess/v2`

API for Verified Access chrome extension to provide credential verification for chrome devices connecting to an enterprise network

- [Original documentation](https://developers.google.com/chrome/verified-access)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/verifiedaccess_v2/verifiedaccess_v2-library.html)

#### versionhistory.googleapis.com API - `versionhistory/v1`

Version History API - Prod

- [Original documentation](https://developer.chrome.com/docs/versionhistory/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/versionhistory_v1/versionhistory_v1-library.html)

#### Cloud Video Intelligence API - `videointelligence/v1`

Detects objects, explicit content, and scene changes in videos. It also specifies the region for annotation and transcribes speech to text. Supports both asynchronous API and streaming API.

- [Original documentation](https://cloud.google.com/video-intelligence/docs/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/videointelligence_v1/videointelligence_v1-library.html)

#### Cloud Vision API - `vision/v1`

Integrates Google Vision features, including image labeling, face, logo, and landmark detection, optical character recognition (OCR), and detection of explicit content, into applications.

- [Original documentation](https://cloud.google.com/vision/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/vision_v1/vision_v1-library.html)

#### VM Migration API - `vmmigration/v1`

Use the Migrate to Virtual Machines API to programmatically migrate workloads. 

- [Original documentation](https://cloud.google.com/migrate/virtual-machines)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/vmmigration_v1/vmmigration_v1-library.html)

#### VMware Engine API - `vmwareengine/v1`

The Google VMware Engine API lets you programmatically manage VMware environments.

- [Original documentation](https://cloud.google.com/solutions/vmware-as-a-service)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/vmwareengine_v1/vmwareengine_v1-library.html)

#### Serverless VPC Access API - `vpcaccess/v1`

API for managing VPC access connectors.

- [Original documentation](https://cloud.google.com/vpc/docs/configure-serverless-vpc-access)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/vpcaccess_v1/vpcaccess_v1-library.html)

#### Google Wallet API - `walletobjects/v1`

API for issuers to save and manage Google Wallet Objects.

- [Original documentation](https://developers.google.com/pay/passes)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/walletobjects_v1/walletobjects_v1-library.html)

#### Web Fonts Developer API - `webfonts/v1`

The Google Web Fonts Developer API lets you retrieve information about web fonts served by Google.

- [Original documentation](https://developers.google.com/fonts/docs/developer_api)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/webfonts_v1/webfonts_v1-library.html)

#### Web Risk API - `webrisk/v1`

- [Original documentation](https://cloud.google.com/web-risk/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/webrisk_v1/webrisk_v1-library.html)

#### Web Security Scanner API - `websecurityscanner/v1`

Scans your Compute and App Engine apps for common web vulnerabilities.

- [Original documentation](https://cloud.google.com/security-command-center/docs/concepts-web-security-scanner-overview/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/websecurityscanner_v1/websecurityscanner_v1-library.html)

#### Workflow Executions API - `workflowexecutions/v1`

Execute workflows created with Workflows API.

- [Original documentation](https://cloud.google.com/workflows)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/workflowexecutions_v1/workflowexecutions_v1-library.html)

#### Workflows API - `workflows/v1`

Manage workflow definitions. To execute workflows and manage executions, see the Workflows Executions API.

- [Original documentation](https://cloud.google.com/workflows)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/workflows_v1/workflows_v1-library.html)

#### Workload Manager API - `workloadmanager/v1`

Workload Manager is a service that provides tooling for enterprise workloads to automate the deployment and validation of your workloads against best practices and recommendations.

- [Original documentation](https://cloud.google.com/workload-manager/docs)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/workloadmanager_v1/workloadmanager_v1-library.html)

#### Google Workspace Events API - `workspaceevents/v1`

The Google Workspace Events API lets you subscribe to events and manage change notifications across Google Workspace applications.

- [Original documentation](https://developers.google.com/workspace/events)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/workspaceevents_v1/workspaceevents_v1-library.html)

#### Cloud Workstations API - `workstations/v1`

Allows administrators to create managed developer environments in the cloud. 

- [Original documentation](https://cloud.google.com/workstations)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/workstations_v1/workstations_v1-library.html)

#### YouTube Data API v3 - `youtube/v3`

The YouTube Data API v3 is an API that provides access to YouTube data, such as videos, playlists, and channels.

- [Original documentation](https://developers.google.com/youtube/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/youtube_v3/youtube_v3-library.html)

#### YouTube Analytics API - `youtubeAnalytics/v2`

Retrieves your YouTube Analytics data.

- [Original documentation](https://developers.google.com/youtube/analytics)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/youtubeAnalytics_v2/youtubeAnalytics_v2-library.html)

#### YouTube Reporting API - `youtubereporting/v1`

Schedules reporting jobs containing your YouTube Analytics data and downloads the resulting bulk data reports in the form of CSV files.

- [Original documentation](https://developers.google.com/youtube/reporting/v1/reports/)
- [Dart package details](https://pub.dev/documentation/googleapis/13.2.0/youtubereporting_v1/youtubereporting_v1-library.html)

