package com.example.controldecolonias

import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "tareas_table")
data class Tarea(
    @PrimaryKey(autoGenerate = true)
    val id: Int = 0,
    val texto: String,
    val fechaLimite: Long?, // Usamos Long? para que la fecha sea opcional
    var completada: Boolean = false,
    val fechaCreacion: Long = System.currentTimeMillis(),

    // --- CAMPOS DE RECORDATORIO AÑADIDOS ---
    val recordatorioProximaFecha: Long? = null,
    val recordatorioTipo: String? = null,
    val recordatorioIntervalo: Int? = null,
    val recordatorioHora: Int? = null
)