package com.example.controldecolonias

import android.app.PendingIntent
import android.content.Intent
import android.nfc.NfcAdapter
import android.nfc.Tag
import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.viewModels
import com.example.controldecolonias.ui.navigation.ControlDeColoniasApp
import com.example.controldecolonias.ui.theme.ControlDeColoniasTheme

class MainActivity : ComponentActivity() {

    private var nfcAdapter: NfcAdapter? = null
    private val viewModel: ColoniaViewModel by viewModels {
        ColoniaViewModelFactory((application as ColoniasApplication).database.coloniaDao(),(application as ColoniasApplication).settingsManager)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        nfcAdapter = NfcAdapter.getDefaultAdapter(this)

        setContent {
            ControlDeColoniasTheme {
                ControlDeColoniasApp(viewModel = viewModel)
            }
        }
        handleIntent(intent) // Maneja el intent inicial
    }

    override fun onNewIntent(intent: Intent) {
        super.onNewIntent(intent)
        // Su única responsabilidad es notificar al ViewModel que se detectó una etiqueta.
        val tag: Tag? = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG)
        if (tag != null) {
            viewModel.onTagDetectado(tag)
        }
        handleIntent(intent) // Maneja intents cuando la actividad ya está abierta
    }

    private fun handleIntent(intent: Intent?) {
        val coloniaId = intent?.getStringExtra("NAVIGATE_TO_COLONIA_ID")
        if (coloniaId != null) {
            // Este es un ejemplo de cómo podrías manejar la navegación.
            // La implementación exacta dependerá de cómo esté configurado tu NavController.
            // Por simplicidad, este ejemplo asume que puedes pasar el ID a tu Composable principal.
            // Una mejor aproximación sería usar un SharedViewModel o un canal/flujo para comunicar
            // el evento de navegación de forma segura.

            // Para este ejemplo, simplemente re-lanzamos la app con el ID como un argumento,
            // que luego podrías capturar en tu NavHost.
            // NOTA: Esta es una simplificación.
            println("Se recibió una solicitud para navegar a la colonia: $coloniaId")

            // "Consume" el extra para que no se navegue de nuevo en un cambio de configuración.
            intent.removeExtra("NAVIGATE_TO_COLONIA_ID")
        }
    }


    override fun onResume() {
        super.onResume()
        val intent = Intent(this, javaClass).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP)
        val pendingIntent = PendingIntent.getActivity(this, 0, intent, PendingIntent.FLAG_MUTABLE)
        nfcAdapter?.enableForegroundDispatch(this, pendingIntent, null, null)
    }

    override fun onPause() {
        super.onPause()
        nfcAdapter?.disableForegroundDispatch(this)
    }
}