package com.example.controldecolonias

import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "colonias_table")
data class Colonia(
    @PrimaryKey
    val id: String,
    val nombre: String,
    val especie: String,
    val fecha: Long,
    val latitud: Double? = null,
    val longitud: Double? = null,
    val temperatura: Int? = null,
    val clima: String? = null,

    // --- NUEVOS CAMPOS ---
    val tieneHuevos: Boolean = false,
    val tieneLarvas: Boolean = false,
    val tienePupas: Boolean = false,
    val tieneObreras: Boolean = false,
    val estaEnferma: Boolean = false,
    // --- NUEVO CAMPO ---
    val tipoEtiqueta: String = "Ninguna", // Valores: "Ninguna", "NFC", "QR"

    // --- CAMPOS DE RECORDATORIO ACTUALIZADOS ---
    val recordatorioProximaFecha: Long? = null, // La fecha/hora exacta del próximo aviso
    val recordatorioTipo: String? = null,      // "UNICA_VEZ", "DIARIO", "CADA_X_DIAS"
    val recordatorioIntervalo: Int? = null,    // El número de días para "CADA_X_DIAS"
    val recordatorioHora: Int? = null          // La hora del día, en minutos desde la medianoche (ej. 9:30 AM = 570)
)