# Control de Colonias

Aplicación Android para la gestión y seguimiento de colonias de hormigas, utilizando tecnologías como NFC y códigos QR para la identificación, recordatorios para alimentación/cuidados y registro de datos ambientales.

## Descripción

Esta aplicación está diseñada para ayudar a los aficionados y cuidadores de hormigas a llevar un registro detallado de sus colonias. Permite:

* Registrar colonias con información como especie, fecha, estado de la cría (huevos, larvas, pupas, obreras) y si están enfermas.
* Asociar identificadores únicos a cada colonia mediante etiquetas NFC o códigos QR.
* Escanear etiquetas NFC o códigos QR para acceder rápidamente a la información de una colonia.
* Registrar eventos de alimentación y añadir notas de observación.
* Añadir fotos a la galería de cada colonia.
* Programar recordatorios (únicos, diarios o cada X días) para revisar o alimentar las colonias.
* Registrar nidos encontrados en campo, incluyendo su ubicación GPS (opcionalmente desactivable con el "Modo Ninja").
* Obtener datos del clima (temperatura, descripción) usando la API de OpenWeatherMap basándose en la ubicación (si está activada).
* Gestionar una lista de tareas pendientes.
* Exportar e importar copias de seguridad de los datos.

## Licencia

Este proyecto está licenciado bajo la **Licencia Pública General GNU versión 3.0 (GPLv3.0)**.

Esto significa que el software es **libre y de código abierto**. Eres libre de usar, estudiar, compartir y modificar el software. Sin embargo, cualquier trabajo derivado o modificación que distribuyas **debe ser también licenciado bajo la GPLv3.0 o una licencia compatible**. Esto asegura que el proyecto y sus derivados permanezcan siempre libres y abiertos para la comunidad. **No está permitido crear versiones privadas o de código cerrado basadas en este código.**

Puedes encontrar el texto completo de la licencia en el archivo `LICENSE` o en [gnu.org/licenses/gpl-3.0.html](https://www.gnu.org/licenses/gpl-3.0.html).

## Estado del Proyecto

Versión 1

## Contribuciones

Puedes contactarme a través del grupo mirmecología México preguntando por Lalo.