package com.example.controldecolonias

import com.google.gson.annotations.SerializedName
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.GET
import retrofit2.http.Query

// --- MODELOS DE DATOS PARA LA RESPUESTA DE LA API ---
// Estos data class son el "molde" que le dice a Gson cómo interpretar la respuesta JSON del servidor.
data class WeatherResponse(
    @SerializedName("weather") val weather: List<Weather>,
    @SerializedName("main") val main: Main
)
data class Weather(
    @SerializedName("description") val description: String
)
data class Main(
    @SerializedName("temp") val temp: Double
)

// --- INTERFAZ DE RETROFIT ---
// Aquí definimos las "funciones" que podemos llamar de la API.
interface ApiService {
    @GET("data/2.5/weather")
    suspend fun getCurrentWeather(
        @Query("lat") lat: Double,
        @Query("lon") lon: Double,
        @Query("appid") apiKey: String,
        @Query("units") units: String = "metric", // Para que nos dé la temperatura en Celsius
        @Query("lang") lang: String = "es" // Para que la descripción venga en español
    ): WeatherResponse
}

// --- OBJETO PARA CREAR Y USAR EL SERVICIO ---
object RetrofitClient {
    private const val BASE_URL = "https://api.openweathermap.org/"

    val instance: ApiService by lazy {
        val retrofit = Retrofit.Builder()
            .baseUrl(BASE_URL)
            .addConverterFactory(GsonConverterFactory.create())
            .build()
        retrofit.create(ApiService::class.java)
    }
}