package com.example.controldecolonias

/**
 * Representa la estructura completa de datos para una copia de seguridad.
 * Asignar valores por defecto (emptyList()) asegura la retrocompatibilidad,
 * permitiendo importar backups de versiones antiguas de la app que no contenían
 * todas las tablas.
 */
data class BackupData(
    val colonias: List<Colonia> = emptyList(),
    val notas: List<Nota> = emptyList(),
    val nidos: List<Nido> = emptyList(),
    val alimentacion: List<Alimentacion> = emptyList(),
    val tareas: List<Tarea> = emptyList(),
    val fotos: List<Foto> = emptyList()
)