import * as React from 'react';
import { Text as NativeText, TextStyle, StyleProp } from 'react-native';
import { withTheme } from '../../core/theming';

type Props = React.ComponentProps<typeof NativeText> & {
  style?: StyleProp<TextStyle>;
  /**
   * @optional
   */
  theme: ReactNativePaper.Theme;
};

// @component-group Typography

/**
 * Text component which follows styles from the theme.
 *
 * @extends Text props https://reactnative.dev/docs/text#props
 */
const Text: React.RefForwardingComponent<{}, Props> = (
  { style, theme, ...rest }: Props,
  ref
) => {
  const root = React.useRef<NativeText | null>(null);

  React.useImperativeHandle(ref, () => ({
    setNativeProps: (args: Object) => root.current?.setNativeProps(args),
  }));

  return (
    <NativeText
      {...rest}
      ref={root}
      style={[
        {
          ...theme.fonts.regular,
          color: theme.colors.text,
          textAlign: 'left',
        },
        style,
      ]}
    />
  );
};

export default withTheme(React.forwardRef(Text));
