import * as React from 'react';
import { AccessibilityInfo, Appearance } from 'react-native';
import { ThemeProvider } from './theming';
import { Provider as SettingsProvider } from './settings';
import MaterialCommunityIcon from '../components/MaterialCommunityIcon';
import PortalHost from '../components/Portal/PortalHost';
import DefaultTheme from '../styles/DefaultTheme';
import DarkTheme from '../styles/DarkTheme';

const Provider = ({ ...props
}) => {
  const colorSchemeName = !props.theme && (Appearance === null || Appearance === void 0 ? void 0 : Appearance.getColorScheme()) || 'light';
  const [reduceMotionEnabled, setReduceMotionEnabled] = React.useState(false);
  const [colorScheme, setColorScheme] = React.useState(colorSchemeName);

  const handleAppearanceChange = preferences => {
    const {
      colorScheme
    } = preferences;
    setColorScheme(colorScheme);
  };

  React.useEffect(() => {
    if (!props.theme) {
      AccessibilityInfo.addEventListener('reduceMotionChanged', setReduceMotionEnabled);
    }

    return () => {
      if (!props.theme) {
        AccessibilityInfo.removeEventListener('reduceMotionChanged', setReduceMotionEnabled);
      }
    };
  }, [props.theme]);
  React.useEffect(() => {
    if (!props.theme) Appearance === null || Appearance === void 0 ? void 0 : Appearance.addChangeListener(handleAppearanceChange);
    return () => {
      if (!props.theme) Appearance === null || Appearance === void 0 ? void 0 : Appearance.removeChangeListener(handleAppearanceChange);
    };
  }, [props.theme]);

  const getTheme = () => {
    const {
      theme: providedTheme
    } = props;

    if (providedTheme) {
      return providedTheme;
    } else {
      const theme = colorScheme === 'dark' ? DarkTheme : DefaultTheme;
      return { ...theme,
        animation: { ...theme.animation,
          scale: reduceMotionEnabled ? 0 : 1
        }
      };
    }
  };

  const {
    children,
    settings
  } = props;
  return /*#__PURE__*/React.createElement(PortalHost, null, /*#__PURE__*/React.createElement(SettingsProvider, {
    value: settings || {
      icon: MaterialCommunityIcon
    }
  }, /*#__PURE__*/React.createElement(ThemeProvider, {
    theme: getTheme()
  }, children)));
};

export default Provider;
//# sourceMappingURL=Provider.js.map