import { ConfigPlugin } from '../Config.types';
import { StaticPlugin } from './modulePluginResolver';
/**
 * Resolves static module plugin and potentially falls back on a provided plugin if the module cannot be resolved
 *
 * @param config
 * @param fallback Plugin with `_resolverError` explaining why the module couldn't be used
 * @param projectRoot optional project root, fallback to _internal.projectRoot. Used for testing.
 */
export declare const withStaticPlugin: ConfigPlugin<{
    plugin: StaticPlugin | string;
    fallback?: ConfigPlugin<{
        _resolverError: Error;
    } & any>;
    projectRoot?: string;
}>;
