"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Serialize_1 = require("../Serialize");
const withStaticPlugin_1 = require("./withStaticPlugin");
/**
 * Resolves a list of plugins.
 *
 * @param config
 * @param projectRoot
 */
const withPlugins = (config, plugins) => {
    return plugins.reduce((prev, plugin) => {
        return withStaticPlugin_1.withStaticPlugin(prev, { plugin });
    }, config);
};
/**
 * Resolves static plugins array as config plugin functions.
 *
 * @param config
 * @param projectRoot
 */
exports.withConfigPlugins = config => {
    var _a;
    // @ts-ignore: plugins not on config type yet -- TODO
    if (!Array.isArray(config.plugins) || !((_a = config.plugins) === null || _a === void 0 ? void 0 : _a.length)) {
        return config;
    }
    // Resolve and evaluate plugins
    // @ts-ignore: TODO: add plugins to the config schema
    config = withPlugins(config, config.plugins);
    // plugins aren't serialized by default, serialize the plugins after resolving them.
    return Serialize_1.serializeAfterStaticPlugins(config);
};
//# sourceMappingURL=withConfigPlugins.js.map